/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.datamodel.AlignmentAnnotation;
import jalview.gui.AlignmentPanel;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.io.AnnotationFile;
import jalview.io.FeaturesFile;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AnnotationExporter
extends JPanel {
    JInternalFrame frame;
    AlignmentPanel ap;
    boolean features = true;
    AlignmentAnnotation[] annotations;
    Vector sequenceGroups;
    Hashtable alignmentProperties;
    JPanel jPanel1 = new JPanel();
    JButton toFile = new JButton();
    JButton toTextbox = new JButton();
    JButton close = new JButton();
    ButtonGroup buttonGroup = new ButtonGroup();
    JRadioButton jalviewFormat = new JRadioButton();
    JRadioButton GFFFormat = new JRadioButton();
    JRadioButton CSVFormat = new JRadioButton();
    JLabel jLabel1 = new JLabel();
    JPanel jPanel3 = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();

    public AnnotationExporter() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        this.frame.setLayer(JLayeredPane.PALETTE_LAYER);
        Desktop.addInternalFrame(this.frame, "", 260, 125);
    }

    public void exportFeatures(AlignmentPanel ap) {
        this.ap = ap;
        this.features = true;
        this.CSVFormat.setVisible(false);
        this.frame.setTitle("Export Features");
    }

    public void exportAnnotations(AlignmentPanel ap, AlignmentAnnotation[] annotations, Vector sequenceGroups, Hashtable alProperties) {
        this.ap = ap;
        this.features = false;
        this.GFFFormat.setVisible(false);
        this.CSVFormat.setVisible(true);
        this.annotations = annotations;
        this.sequenceGroups = sequenceGroups;
        this.alignmentProperties = alProperties;
        this.frame.setTitle("Export Annotations");
    }

    public void toFile_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(this.features ? "Save Features to File" : "Save Annotation to File");
        chooser.setToolTipText("Save");
        int value = chooser.showSaveDialog(this);
        if (value == 0) {
            String text = "No features found on alignment";
            text = this.features ? (this.GFFFormat.isSelected() ? new FeaturesFile().printGFFFormat(this.ap.av.alignment.getDataset().getSequencesArray(), this.ap.av.featuresDisplayed) : new FeaturesFile().printJalviewFormat(this.ap.av.alignment.getDataset().getSequencesArray(), this.ap.av.featuresDisplayed)) : (this.CSVFormat.isSelected() ? new AnnotationFile().printCSVAnnotations(this.annotations) : new AnnotationFile().printAnnotations(this.annotations, this.sequenceGroups, this.alignmentProperties));
            try {
                PrintWriter out = new PrintWriter(new FileWriter(chooser.getSelectedFile()));
                out.print(text);
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.close_actionPerformed(null);
    }

    public void toTextbox_actionPerformed(ActionEvent e) {
        String text = "No features found on alignment";
        if (this.features) {
            text = this.GFFFormat.isSelected() ? new FeaturesFile().printGFFFormat(this.ap.av.alignment.getDataset().getSequencesArray(), this.ap.av.featuresDisplayed) : new FeaturesFile().printJalviewFormat(this.ap.av.alignment.getDataset().getSequencesArray(), this.ap.av.featuresDisplayed);
        } else if (!this.features) {
            text = this.CSVFormat.isSelected() ? new AnnotationFile().printCSVAnnotations(this.annotations) : new AnnotationFile().printAnnotations(this.annotations, this.sequenceGroups, this.alignmentProperties);
        }
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        cap.setText(text);
        Desktop.addInternalFrame(cap, (this.features ? "Features for - " : "Annotations for - ") + this.ap.alignFrame.getTitle(), 600, 500);
        this.close_actionPerformed(null);
    }

    public void close_actionPerformed(ActionEvent e) {
        try {
            this.frame.setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.flowLayout1);
        this.toFile.setText("to File");
        this.toFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationExporter.this.toFile_actionPerformed(e);
            }
        });
        this.toTextbox.setText("to Textbox");
        this.toTextbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationExporter.this.toTextbox_actionPerformed(e);
            }
        });
        this.close.setText("Close");
        this.close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationExporter.this.close_actionPerformed(e);
            }
        });
        this.jalviewFormat.setOpaque(false);
        this.jalviewFormat.setSelected(true);
        this.jalviewFormat.setText("Jalview");
        this.GFFFormat.setOpaque(false);
        this.GFFFormat.setText("GFF");
        this.CSVFormat.setOpaque(false);
        this.CSVFormat.setText("CSV(Spreadsheet)");
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Format: ");
        this.setBackground(Color.white);
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setOpaque(false);
        this.jPanel1.setOpaque(false);
        this.jPanel1.add(this.toFile);
        this.jPanel1.add(this.toTextbox);
        this.jPanel1.add(this.close);
        this.jPanel3.add(this.jLabel1);
        this.jPanel3.add(this.jalviewFormat);
        this.jPanel3.add(this.GFFFormat);
        this.jPanel3.add(this.CSVFormat);
        this.buttonGroup.add(this.jalviewFormat);
        this.buttonGroup.add(this.GFFFormat);
        this.buttonGroup.add(this.CSVFormat);
        this.add((Component)this.jPanel3, null);
        this.add((Component)this.jPanel1, null);
    }
}

