/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.ColumnSelection;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.util.Platform;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class AnnotationPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener,
AdjustmentListener {
    final String HELIX = "Helix";
    final String SHEET = "Sheet";
    final String LABEL = "Label";
    final String REMOVE = "Remove Annotation";
    final String COLOUR = "Colour";
    final Color HELIX_COLOUR = Color.red.darker();
    final Color SHEET_COLOUR = Color.green.darker().darker();
    AlignViewport av;
    AlignmentPanel ap;
    int activeRow = -1;
    BufferedImage image;
    BufferedImage fadedImage;
    Graphics2D gg;
    FontMetrics fm;
    int imgWidth = 0;
    boolean fastPaint = false;
    int graphStretch = -1;
    int graphStretchY = -1;
    int min;
    int max;
    boolean mouseDragging = false;
    boolean MAC = false;

    public AnnotationPanel(AlignmentPanel ap) {
        this.MAC = new Platform().isAMac();
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.ap = ap;
        this.av = ap.av;
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        ap.annotationScroller.getVerticalScrollBar().addAdjustmentListener(this);
    }

    public AnnotationPanel(AlignViewport av) {
        this.av = av;
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.ap.alabels.setScrollOffset(-evt.getValue());
    }

    public int adjustPanelHeight() {
        AlignmentAnnotation[] aa = this.av.alignment.getAlignmentAnnotation();
        int height = 0;
        if (aa != null) {
            for (int i = 0; i < aa.length; ++i) {
                if (!aa[i].visible) continue;
                aa[i].height = 0;
                if (aa[i].hasText) {
                    aa[i].height += this.av.charHeight;
                }
                if (aa[i].hasIcons) {
                    aa[i].height += 16;
                }
                if (aa[i].graph > 0) {
                    aa[i].height += aa[i].graphHeight;
                }
                if (aa[i].height == 0) {
                    aa[i].height = 20;
                }
                height += aa[i].height;
            }
        } else {
            height = 20;
        }
        this.setPreferredSize(new Dimension(1, height));
        return height;
    }

    public void actionPerformed(ActionEvent evt) {
        AlignmentAnnotation[] aa = this.av.alignment.getAlignmentAnnotation();
        Annotation[] anot = aa[this.activeRow].annotations;
        if (anot.length < this.av.getColumnSelection().getMax()) {
            Annotation[] temp = new Annotation[this.av.getColumnSelection().getMax() + 2];
            System.arraycopy(anot, 0, temp, 0, anot.length);
            anot = temp;
            aa[this.activeRow].annotations = anot;
        }
        if (evt.getActionCommand().equals("Remove Annotation")) {
            for (int i = 0; i < this.av.getColumnSelection().size(); ++i) {
                anot[this.av.getColumnSelection().columnAt((int)i)] = null;
            }
        } else if (evt.getActionCommand().equals("Label")) {
            String exMesg = this.collectAnnotVals(anot, this.av.getColumnSelection(), "Label");
            String label = JOptionPane.showInputDialog(this, "Enter label", exMesg);
            if (label == null) {
                return;
            }
            if (label.length() > 0 && !aa[this.activeRow].hasText) {
                aa[this.activeRow].hasText = true;
            }
            for (int i = 0; i < this.av.getColumnSelection().size(); ++i) {
                int index = this.av.getColumnSelection().columnAt(i);
                if (!this.av.colSel.isVisible(index)) continue;
                if (anot[index] == null) {
                    anot[index] = new Annotation(label, "", ' ', 0.0f);
                    continue;
                }
                anot[index].displayCharacter = label;
            }
        } else if (evt.getActionCommand().equals("Colour")) {
            Color col = JColorChooser.showDialog(this, "Choose foreground colour", Color.black);
            for (int i = 0; i < this.av.getColumnSelection().size(); ++i) {
                int index = this.av.getColumnSelection().columnAt(i);
                if (!this.av.colSel.isVisible(index)) continue;
                if (anot[index] == null) {
                    anot[index] = new Annotation("", "", ' ', 0.0f);
                }
                anot[index].colour = col;
            }
        } else {
            String label;
            char type = '\u0000';
            String symbol = "\u03b1";
            if (evt.getActionCommand().equals("Helix")) {
                type = 'H';
            } else if (evt.getActionCommand().equals("Sheet")) {
                type = 'E';
                symbol = "\u03b2";
            }
            if (!aa[this.activeRow].hasIcons) {
                aa[this.activeRow].hasIcons = true;
            }
            if ((label = JOptionPane.showInputDialog("Enter a label for the structure?", (Object)symbol)) == null) {
                return;
            }
            if (label.length() > 0 && !aa[this.activeRow].hasText) {
                aa[this.activeRow].hasText = true;
            }
            for (int i = 0; i < this.av.getColumnSelection().size(); ++i) {
                int index = this.av.getColumnSelection().columnAt(i);
                if (!this.av.colSel.isVisible(index)) continue;
                if (anot[index] == null) {
                    anot[index] = new Annotation(label, "", type, 0.0f);
                }
                anot[index].secondaryStructure = type;
                anot[index].displayCharacter = label;
            }
        }
        this.adjustPanelHeight();
        this.repaint();
    }

    private String collectAnnotVals(Annotation[] anot, ColumnSelection columnSelection, String label2) {
        String collatedInput = "";
        String last = "";
        for (int i = 0; i < columnSelection.size(); ++i) {
            int index = columnSelection.columnAt(i);
            if (!this.av.colSel.isVisible(index)) continue;
            String tlabel = null;
            if (anot[index] == null) continue;
            if ((label2.equals("Helix") || label2.equals("Sheet") || label2.equals("Label")) && (tlabel = anot[index].description) == null) {
                tlabel = label2.equals("Helix") || label2.equals("Sheet") ? "" + anot[index].secondaryStructure : "" + anot[index].displayCharacter;
            }
            if (tlabel == null || tlabel.equals(last)) continue;
            if (last.length() > 0) {
                collatedInput = collatedInput + " ";
            }
            collatedInput = collatedInput + tlabel;
        }
        return collatedInput;
    }

    public void mousePressed(MouseEvent evt) {
        AlignmentAnnotation[] aa = this.av.alignment.getAlignmentAnnotation();
        if (aa == null) {
            return;
        }
        int height = 0;
        this.activeRow = -1;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i].visible) {
                height += aa[i].height;
            }
            if (evt.getY() >= height) continue;
            if (aa[i].editable) {
                this.activeRow = i;
                break;
            }
            if (aa[i].graph <= 0) break;
            this.graphStretch = i;
            this.graphStretchY = evt.getY();
            break;
        }
        if (SwingUtilities.isRightMouseButton(evt) && this.activeRow != -1) {
            if (this.av.getColumnSelection() == null) {
                return;
            }
            JPopupMenu pop = new JPopupMenu("Structure type");
            JMenuItem item = new JMenuItem("Helix");
            item.addActionListener(this);
            pop.add(item);
            item = new JMenuItem("Sheet");
            item.addActionListener(this);
            pop.add(item);
            item = new JMenuItem("Label");
            item.addActionListener(this);
            pop.add(item);
            item = new JMenuItem("Colour");
            item.addActionListener(this);
            pop.add(item);
            item = new JMenuItem("Remove Annotation");
            item.addActionListener(this);
            pop.add(item);
            pop.show(this, evt.getX(), evt.getY());
            return;
        }
        if (aa == null) {
            return;
        }
        this.ap.scalePanel.mousePressed(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        this.graphStretch = -1;
        this.graphStretchY = -1;
        this.mouseDragging = false;
        this.ap.scalePanel.mouseReleased(evt);
    }

    public void mouseEntered(MouseEvent evt) {
        this.ap.scalePanel.mouseEntered(evt);
    }

    public void mouseExited(MouseEvent evt) {
        this.ap.scalePanel.mouseExited(evt);
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.graphStretch > -1) {
            this.av.alignment.getAlignmentAnnotation()[this.graphStretch].graphHeight += this.graphStretchY - evt.getY();
            if (this.av.alignment.getAlignmentAnnotation()[this.graphStretch].graphHeight < 0) {
                this.av.alignment.getAlignmentAnnotation()[this.graphStretch].graphHeight = 0;
            }
            this.graphStretchY = evt.getY();
            this.adjustPanelHeight();
            this.ap.paintAlignment(true);
        } else {
            this.ap.scalePanel.mouseDragged(evt);
        }
    }

    public void mouseMoved(MouseEvent evt) {
        AlignmentAnnotation[] aa = this.av.alignment.getAlignmentAnnotation();
        if (aa == null) {
            this.setToolTipText(null);
            return;
        }
        int row = -1;
        int height = 0;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i].visible) {
                height += aa[i].height;
            }
            if (evt.getY() >= height) continue;
            row = i;
            break;
        }
        if (row == -1) {
            this.setToolTipText(null);
            return;
        }
        int res = evt.getX() / this.av.getCharWidth() + this.av.getStartRes();
        if (this.av.hasHiddenColumns) {
            res = this.av.getColumnSelection().adjustForHiddenColumns(res);
        }
        if (row > -1 && aa[row].annotations != null && res < aa[row].annotations.length) {
            if (aa[row].graphGroup > -1) {
                StringBuffer tip = new StringBuffer("<html>");
                for (int gg = 0; gg < aa.length; ++gg) {
                    if (aa[gg].graphGroup != aa[row].graphGroup || aa[gg].annotations[res] == null) continue;
                    tip.append(aa[gg].label + " " + aa[gg].annotations[res].description + "<br>");
                }
                if (tip.length() != 6) {
                    tip.setLength(tip.length() - 4);
                    this.setToolTipText(tip.toString() + "</html>");
                }
            } else if (aa[row].annotations[res] != null && aa[row].annotations[res].description != null) {
                this.setToolTipText(aa[row].annotations[res].description);
            }
            if (aa[row].annotations[res] != null) {
                StringBuffer text = new StringBuffer("Sequence position " + (res + 1));
                if (aa[row].annotations[res].description != null) {
                    text.append("  " + aa[row].annotations[res].description);
                }
                this.ap.alignFrame.statusBar.setText(text.toString());
            }
        } else {
            this.setToolTipText(null);
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void paintComponent(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null && (this.fastPaint || this.getVisibleRect().width != g.getClipBounds().width || this.getVisibleRect().height != g.getClipBounds().height)) {
            g.drawImage(this.image, 0, 0, this);
            this.fastPaint = false;
            return;
        }
        this.imgWidth = (this.av.endRes - this.av.startRes + 1) * this.av.charWidth;
        if (this.imgWidth < 1) {
            return;
        }
        if (this.image == null || this.imgWidth != this.image.getWidth() || this.image.getHeight(this) != this.getHeight()) {
            this.image = new BufferedImage(this.imgWidth, this.ap.annotationPanel.getHeight(), 1);
            this.gg = (Graphics2D)this.image.getGraphics();
            if (this.av.antiAlias) {
                this.gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.gg.setFont(this.av.getFont());
            this.fm = this.gg.getFontMetrics();
            this.gg.setColor(Color.white);
            this.gg.fillRect(0, 0, this.imgWidth, this.image.getHeight());
        }
        this.drawComponent(this.gg, this.av.startRes, this.av.endRes + 1);
        g.drawImage(this.image, 0, 0, this);
    }

    public void fastPaint(int horizontal) {
        if (horizontal == 0 || this.gg == null || this.av.alignment.getAlignmentAnnotation() == null || this.av.alignment.getAlignmentAnnotation().length < 1 || this.av.updatingConsensus || this.av.updatingConservation) {
            this.repaint();
            return;
        }
        this.gg.copyArea(0, 0, this.imgWidth, this.getHeight(), -horizontal * this.av.charWidth, 0);
        int sr = this.av.startRes;
        int er = this.av.endRes + 1;
        int transX = 0;
        if (horizontal > 0) {
            transX = (er - sr - horizontal) * this.av.charWidth;
            sr = er - horizontal;
        } else if (horizontal < 0) {
            er = sr - horizontal;
        }
        this.gg.translate(transX, 0);
        this.drawComponent(this.gg, sr, er);
        this.gg.translate(-transX, 0);
        this.fastPaint = true;
        this.repaint();
    }

    public void drawComponent(Graphics g, int startRes, int endRes) {
        if (this.av.updatingConsensus || this.av.updatingConservation) {
            if (this.image == null) {
                return;
            }
            if (this.fadedImage == null || this.fadedImage.getWidth() != this.imgWidth || this.fadedImage.getHeight() != this.image.getHeight()) {
                this.fadedImage = new BufferedImage(this.imgWidth, this.image.getHeight(), 1);
                Graphics2D fadedG = (Graphics2D)this.fadedImage.getGraphics();
                fadedG.setColor(Color.white);
                fadedG.fillRect(0, 0, this.imgWidth, this.image.getHeight());
                fadedG.setComposite(AlphaComposite.getInstance(3, 0.3f));
                fadedG.drawImage((Image)this.image, 0, 0, this);
            }
        } else {
            this.fadedImage = null;
        }
        g.setColor(Color.white);
        g.fillRect(0, 0, (endRes - startRes) * this.av.charWidth, this.getHeight());
        g.setFont(this.av.getFont());
        if (this.fm == null) {
            this.fm = g.getFontMetrics();
        }
        if (this.av.alignment.getAlignmentAnnotation() == null || this.av.alignment.getAlignmentAnnotation().length < 1) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.black);
            if (this.av.validCharWidth) {
                g.drawString("Alignment has no annotations", 20, 15);
            }
            return;
        }
        AlignmentAnnotation[] aa = this.av.alignment.getAlignmentAnnotation();
        int x = 0;
        int y = 0;
        int column = 0;
        int iconOffset = 0;
        boolean validRes = false;
        boolean validEnd = false;
        boolean[] graphGroupDrawn = new boolean[aa.length];
        for (int i = 0; i < aa.length; ++i) {
            int x2;
            int x1;
            int sCol;
            AlignmentAnnotation row = aa[i];
            if (!row.visible) continue;
            int lastSS = 32;
            int lastSSX = 0;
            if (row.graph > 0) {
                if (row.graphGroup > -1 && graphGroupDrawn[row.graphGroup]) continue;
                y += row.height;
                if (row.hasText) {
                    iconOffset = this.av.charHeight - this.fm.getDescent();
                    y -= this.av.charHeight;
                }
            } else {
                iconOffset = row.hasText ? this.av.charHeight - this.fm.getDescent() : 0;
            }
            if (this.av.updatingConsensus && aa[i] == this.av.consensus) {
                g.drawImage(this.fadedImage, 0, (y += this.av.charHeight) - row.height, this.imgWidth, y, 0, y - row.height, this.imgWidth, y, this);
                g.setColor(Color.black);
                continue;
            }
            if (this.av.updatingConservation && aa[i].label.equals("Conservation")) {
                g.drawImage(this.fadedImage, 0, (y += this.av.charHeight) - row.height, this.imgWidth, y, 0, y - row.height, this.imgWidth, y, this);
                g.setColor(Color.black);
                continue;
            }
            if (this.av.updatingConservation && aa[i].label.equals("Quality")) {
                g.drawImage(this.fadedImage, 0, (y += this.av.charHeight) - row.height, this.imgWidth, y, 0, y - row.height, this.imgWidth, y, this);
                g.setColor(Color.black);
                continue;
            }
            for (x = 0; x < endRes - startRes; ++x) {
                if (this.av.hasHiddenColumns) {
                    column = this.av.getColumnSelection().adjustForHiddenColumns(startRes + x);
                    if (column > row.annotations.length - 1) {
                        break;
                    }
                } else {
                    column = startRes + x;
                }
                validRes = row.annotations != null && row.annotations.length > column && row.annotations[column] != null;
                if (this.activeRow == i) {
                    g.setColor(Color.red);
                    if (this.av.getColumnSelection() != null) {
                        for (int n = 0; n < this.av.getColumnSelection().size(); ++n) {
                            int v = this.av.getColumnSelection().columnAt(n);
                            if (v != column) continue;
                            g.fillRect(x * this.av.charWidth, y, this.av.charWidth, this.av.charHeight);
                        }
                    }
                }
                if (this.av.validCharWidth && validRes && row.annotations[column].displayCharacter != null && row.annotations[column].displayCharacter.length() > 0) {
                    int charOffset;
                    int n = charOffset = this.av.getCentreColumnLabels() ? (this.av.charWidth - this.fm.charsWidth(row.annotations[column].displayCharacter.toCharArray(), 0, row.annotations[column].displayCharacter.length())) / 2 : (this.av.charWidth - this.fm.charWidth(row.annotations[column].displayCharacter.charAt(0))) / 2;
                    if (row.annotations[column].colour == null) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(row.annotations[column].colour);
                    }
                    if (column == 0 || row.graph > 0) {
                        g.drawString(row.annotations[column].displayCharacter, x * this.av.charWidth + charOffset, y + iconOffset);
                    } else if (row.annotations[column - 1] == null || !row.annotations[column].displayCharacter.equals(row.annotations[column - 1].displayCharacter) || row.annotations[column].displayCharacter.length() < 2 && row.annotations[column].secondaryStructure == ' ') {
                        g.drawString(row.annotations[column].displayCharacter, x * this.av.charWidth + charOffset, y + iconOffset);
                    }
                }
                if (row.hasIcons && (!validRes || row.annotations[column].secondaryStructure != lastSS)) {
                    switch (lastSS) {
                        case 72: {
                            g.setColor(this.HELIX_COLOUR);
                            if (this.MAC) {
                                g.fillRoundRect(lastSSX, y + 4 + iconOffset, x * this.av.charWidth - lastSSX, 7, 8, 8);
                                break;
                            }
                            sCol = lastSSX / this.av.charWidth + startRes;
                            x1 = lastSSX;
                            x2 = x * this.av.charWidth;
                            if (sCol == 0 || row.annotations[sCol - 1] == null || row.annotations[sCol - 1].secondaryStructure != 'H') {
                                g.fillArc(lastSSX, y + 4 + iconOffset, this.av.charWidth, 8, 90, 180);
                                x1 += this.av.charWidth / 2;
                            }
                            if (!validRes || row.annotations[column] == null || row.annotations[column].secondaryStructure != 'H') {
                                g.fillArc(x * this.av.charWidth - this.av.charWidth, y + 4 + iconOffset, this.av.charWidth, 8, 270, 180);
                                x2 -= this.av.charWidth / 2;
                            }
                            g.fillRect(x1, y + 4 + iconOffset, x2 - x1, 8);
                            break;
                        }
                        case 69: {
                            g.setColor(this.SHEET_COLOUR);
                            g.fillRect(lastSSX, y + 4 + iconOffset, x * this.av.charWidth - lastSSX - 4, 7);
                            g.fillPolygon(new int[]{x * this.av.charWidth - 4, x * this.av.charWidth - 4, x * this.av.charWidth}, new int[]{y + iconOffset, y + 14 + iconOffset, y + 8 + iconOffset}, 3);
                            break;
                        }
                        default: {
                            g.setColor(Color.gray);
                            g.fillRect(lastSSX, y + 6 + iconOffset, x * this.av.charWidth - lastSSX, 2);
                        }
                    }
                    lastSS = validRes ? (int)row.annotations[column].secondaryStructure : 32;
                    lastSSX = x * this.av.charWidth;
                }
                ++column;
            }
            if (column >= row.annotations.length) {
                column = row.annotations.length - 1;
                validEnd = false;
            } else {
                validEnd = true;
            }
            if (row.hasIcons) {
                switch (lastSS) {
                    case 72: {
                        g.setColor(this.HELIX_COLOUR);
                        if (this.MAC) {
                            g.fillRoundRect(lastSSX, y + 4 + iconOffset, x * this.av.charWidth - lastSSX, 7, 8, 8);
                            break;
                        }
                        sCol = lastSSX / this.av.charWidth + startRes;
                        x1 = lastSSX;
                        x2 = x * this.av.charWidth;
                        if (sCol == 0 || row.annotations[sCol - 1] == null || row.annotations[sCol - 1].secondaryStructure != 'H') {
                            g.fillArc(lastSSX, y + 4 + iconOffset, this.av.charWidth, 8, 90, 180);
                            x1 += this.av.charWidth / 2;
                        }
                        if (row.annotations[column] == null || row.annotations[column].secondaryStructure != 'H') {
                            g.fillArc(x * this.av.charWidth - this.av.charWidth, y + 4 + iconOffset, this.av.charWidth, 8, 270, 180);
                            x2 -= this.av.charWidth / 2;
                        }
                        g.fillRect(x1, y + 4 + iconOffset, x2 - x1, 8);
                        break;
                    }
                    case 69: {
                        g.setColor(this.SHEET_COLOUR);
                        if (!validEnd || row.annotations[endRes] == null || row.annotations[endRes].secondaryStructure != 'E') {
                            g.fillRect(lastSSX, y + 4 + iconOffset, x * this.av.charWidth - lastSSX - 4, 7);
                            g.fillPolygon(new int[]{x * this.av.charWidth - 4, x * this.av.charWidth - 4, x * this.av.charWidth}, new int[]{y + iconOffset, y + 14 + iconOffset, y + 7 + iconOffset}, 3);
                            break;
                        }
                        g.fillRect(lastSSX, y + 4 + iconOffset, (x + 1) * this.av.charWidth - lastSSX, 7);
                        break;
                    }
                    default: {
                        g.setColor(Color.gray);
                        g.fillRect(lastSSX, y + 6 + iconOffset, x * this.av.charWidth - lastSSX, 2);
                    }
                }
            }
            if (row.graph > 0 && row.graphHeight > 0) {
                if (row.graph == 2) {
                    if (row.graphGroup > -1 && !graphGroupDrawn[row.graphGroup]) {
                        int gg;
                        float groupmax = -999999.0f;
                        float groupmin = 9999999.0f;
                        for (gg = 0; gg < aa.length; ++gg) {
                            if (aa[gg].graphGroup != row.graphGroup) continue;
                            if (aa[gg] != row) {
                                aa[gg].visible = false;
                            }
                            if (aa[gg].graphMax > groupmax) {
                                groupmax = aa[gg].graphMax;
                            }
                            if (!(aa[gg].graphMin < groupmin)) continue;
                            groupmin = aa[gg].graphMin;
                        }
                        for (gg = 0; gg < aa.length; ++gg) {
                            if (aa[gg].graphGroup != row.graphGroup) continue;
                            this.drawLineGraph(g, aa[gg], startRes, endRes, y, groupmin, groupmax, row.graphHeight);
                        }
                        graphGroupDrawn[row.graphGroup] = true;
                    } else {
                        this.drawLineGraph(g, row, startRes, endRes, y, row.graphMin, row.graphMax, row.graphHeight);
                    }
                } else if (row.graph == 1) {
                    this.drawBarGraph(g, row, startRes, endRes, row.graphMin, row.graphMax, y);
                }
            }
            if (row.graph > 0 && row.hasText) {
                y += this.av.charHeight;
            }
            if (row.graph != 0) continue;
            y += aa[i].height;
        }
    }

    public void drawLineGraph(Graphics g, AlignmentAnnotation aa, int sRes, int eRes, int y, float min, float max, int graphHeight) {
        if (sRes > aa.annotations.length) {
            return;
        }
        int x = 0;
        if (eRes < this.av.endRes) {
            ++eRes;
        }
        eRes = Math.min(eRes, aa.annotations.length);
        if (sRes == 0) {
            ++x;
        }
        int y1 = y;
        int y2 = y;
        float range = max - min;
        if (min < 0.0f) {
            y2 = y - (int)((0.0f - min / range) * (float)graphHeight);
        }
        g.setColor(Color.gray);
        g.drawLine(x - this.av.charWidth, y2, (eRes - sRes + 1) * this.av.charWidth, y2);
        eRes = Math.min(eRes, aa.annotations.length);
        int aaMax = aa.annotations.length - 1;
        while (x < eRes - sRes) {
            int column = sRes + x;
            if (this.av.hasHiddenColumns) {
                column = this.av.getColumnSelection().adjustForHiddenColumns(column);
            }
            if (column > aaMax) break;
            if (aa.annotations[column] == null || aa.annotations[column - 1] == null) {
                ++x;
                continue;
            }
            if (aa.annotations[column].colour == null) {
                g.setColor(Color.black);
            } else {
                g.setColor(aa.annotations[column].colour);
            }
            y1 = y - (int)((aa.annotations[column - 1].value - min) / range * (float)graphHeight);
            y2 = y - (int)((aa.annotations[column].value - min) / range * (float)graphHeight);
            g.drawLine(x * this.av.charWidth - this.av.charWidth / 2, y1, x * this.av.charWidth + this.av.charWidth / 2, y2);
            ++x;
        }
        if (aa.threshold != null) {
            g.setColor(aa.threshold.colour);
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(1.0f, 2, 1, 3.0f, new float[]{5.0f, 3.0f}, 0.0f));
            y2 = (int)((float)y - (aa.threshold.value - min) / range * (float)graphHeight);
            g.drawLine(0, y2, (eRes - sRes) * this.av.charWidth, y2);
            g2.setStroke(new BasicStroke());
        }
    }

    public void drawBarGraph(Graphics g, AlignmentAnnotation aa, int sRes, int eRes, float min, float max, int y) {
        if (sRes > aa.annotations.length) {
            return;
        }
        eRes = Math.min(eRes, aa.annotations.length);
        int x = 0;
        int y1 = y;
        int y2 = y;
        float range = max - min;
        if (min < 0.0f) {
            y2 = y - (int)((0.0f - min / range) * (float)aa.graphHeight);
        }
        g.setColor(Color.gray);
        g.drawLine(x, y2, (eRes - sRes) * this.av.charWidth, y2);
        int aaMax = aa.annotations.length - 1;
        while (x < eRes - sRes) {
            int column = sRes + x;
            if (this.av.hasHiddenColumns) {
                column = this.av.getColumnSelection().adjustForHiddenColumns(column);
            }
            if (column > aaMax) break;
            if (aa.annotations[column] == null) {
                ++x;
                continue;
            }
            if (aa.annotations[column].colour == null) {
                g.setColor(Color.black);
            } else {
                g.setColor(aa.annotations[column].colour);
            }
            y1 = y - (int)((aa.annotations[column].value - min) / range * (float)aa.graphHeight);
            if (y1 - y2 > 0) {
                g.fillRect(x * this.av.charWidth, y2, this.av.charWidth, y1 - y2);
            } else {
                g.fillRect(x * this.av.charWidth, y1, this.av.charWidth, y2 - y1);
            }
            ++x;
        }
        if (aa.threshold != null) {
            g.setColor(aa.threshold.colour);
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(1.0f, 2, 1, 3.0f, new float[]{5.0f, 3.0f}, 0.0f));
            y2 = (int)((float)y - (aa.threshold.value - min) / range * (float)aa.graphHeight);
            g.drawLine(0, y2, (eRes - sRes) * this.av.charWidth, y2);
            g2.setStroke(new BasicStroke());
        }
    }

    public void drawGraph(Graphics g, AlignmentAnnotation aa, int width, int y, int sRes, int eRes) {
        eRes = Math.min(eRes, aa.annotations.length);
        g.setColor(Color.white);
        g.fillRect(0, 0, width, y);
        g.setColor(new Color(0, 0, 180));
        int x = 0;
        for (int j = sRes; j < eRes; ++j) {
            if (aa.annotations[j] != null) {
                if (aa.annotations[j].colour == null) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(aa.annotations[j].colour);
                }
                int height = (int)(aa.annotations[j].value / aa.graphMax * (float)y);
                if (height > y) {
                    height = y;
                }
                g.fillRect(x, y - height, this.av.charWidth, height);
            }
            x += this.av.charWidth;
        }
    }
}

