/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import MCview.PDBChain;
import MCview.PDBfile;
import jalview.bin.Cache;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignmentPanel;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.FeatureRenderer;
import jalview.gui.OOMWarning;
import jalview.gui.ScriptWindow;
import jalview.gui.SequenceRenderer;
import jalview.gui.UserDefinedColours;
import jalview.io.AppletFormatAdapter;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.jbgui.GStructureViewer;
import jalview.schemes.BuriedColourScheme;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.HelixColourScheme;
import jalview.schemes.HydrophobicColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.schemes.StrandColourScheme;
import jalview.schemes.TaylorColourScheme;
import jalview.schemes.TurnColourScheme;
import jalview.schemes.ZappoColourScheme;
import jalview.structure.StructureListener;
import jalview.structure.StructureMapping;
import jalview.structure.StructureSelectionManager;
import jalview.util.BrowserLauncher;
import jalview.util.Comparison;
import jalview.util.ImageMaker;
import jalview.ws.ebi.EBIFetchClient;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.popup.JmolPopup;

public class AppJmol
extends GStructureViewer
implements StructureListener,
JmolStatusListener,
Runnable {
    JmolViewer viewer;
    JmolPopup jmolpopup;
    ScriptWindow scriptWindow;
    PDBEntry pdbentry;
    SequenceI[] sequence;
    String[] chains;
    StructureSelectionManager ssm;
    JSplitPane splitPane;
    RenderPanel renderPanel;
    AlignmentPanel ap;
    String fileLoadingError;
    boolean colourBySequence = true;
    boolean loadingFromArchive = false;
    Vector atomsPicked = new Vector();
    boolean allChainsSelected = false;
    Pattern pattern = Pattern.compile("\\[(.*)\\]([0-9]+)(:[a-zA-Z]*)?\\.([a-zA-Z]+)(/[0-9]*)?");
    String lastMessage;
    StringBuffer resetLastRes = new StringBuffer();
    StringBuffer eval = new StringBuffer();
    String lastCommand;
    FeatureRenderer fr = null;

    public AppJmol(String file, String id, SequenceI[] seq, AlignmentPanel ap, String loadStatus, Rectangle bounds) {
        this.loadingFromArchive = true;
        this.pdbentry = new PDBEntry();
        this.pdbentry.setFile(file);
        this.pdbentry.setId(id);
        this.chains = this.chains;
        this.sequence = seq;
        this.ap = ap;
        this.setBounds(bounds);
        this.colourBySequence = false;
        this.seqColour.setSelected(false);
        this.initJmol(loadStatus);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                AppJmol.this.closeViewer();
            }
        });
    }

    public synchronized void addSequence(SequenceI[] seq) {
        int i;
        Vector<SequenceI> v = new Vector<SequenceI>();
        for (i = 0; i < this.sequence.length; ++i) {
            v.addElement(this.sequence[i]);
        }
        for (i = 0; i < seq.length; ++i) {
            if (v.contains(seq[i])) continue;
            v.addElement(seq[i]);
        }
        Object[] tmp = new SequenceI[v.size()];
        v.copyInto(tmp);
        this.sequence = tmp;
    }

    public AppJmol(PDBEntry pdbentry, SequenceI[] seq, String[] chains, AlignmentPanel ap) {
        int option;
        String alreadyMapped = StructureSelectionManager.getStructureSelectionManager().alreadyMappedToFile(pdbentry.getId());
        if (alreadyMapped != null && (option = JOptionPane.showInternalConfirmDialog(Desktop.desktop, pdbentry.getId() + " is already displayed." + "\nDo you want to map sequences to the visible structure?", "Map Sequences to Visible Window: " + pdbentry.getId(), 0)) == 0) {
            StructureSelectionManager.getStructureSelectionManager().setMapping(seq, chains, alreadyMapped, AppletFormatAdapter.FILE);
            if (ap.seqPanel.seqCanvas.fr != null) {
                ap.seqPanel.seqCanvas.fr.featuresAdded();
                ap.paintAlignment(true);
            }
            JInternalFrame[] frames = Desktop.instance.getAllFrames();
            for (int i = 0; i < frames.length; ++i) {
                if (!(frames[i] instanceof AppJmol)) continue;
                AppJmol topJmol = (AppJmol)frames[i];
                if (!topJmol.pdbentry.getFile().equals(alreadyMapped)) continue;
                topJmol.addSequence(seq);
                break;
            }
            return;
        }
        this.ap = ap;
        this.pdbentry = pdbentry;
        this.sequence = seq;
        this.setSize(400, 400);
        if (pdbentry.getFile() != null) {
            this.initJmol("load \"" + pdbentry.getFile() + "\"");
        } else {
            Thread worker = new Thread(this);
            worker.start();
        }
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                AppJmol.this.closeViewer();
            }
        });
    }

    void initJmol(String command) {
        this.renderPanel = new RenderPanel();
        this.getContentPane().add((Component)this.renderPanel, "Center");
        StringBuffer title = new StringBuffer(this.sequence[0].getName() + ":" + this.pdbentry.getId());
        if (this.pdbentry.getProperty() != null) {
            if (this.pdbentry.getProperty().get("method") != null) {
                title.append(" Method: ");
                title.append(this.pdbentry.getProperty().get("method"));
            }
            if (this.pdbentry.getProperty().get("chains") != null) {
                title.append(" Chain:");
                title.append(this.pdbentry.getProperty().get("chains"));
            }
        }
        this.setTitle(title.toString());
        Desktop.addInternalFrame(this, title.toString(), this.getBounds().width, this.getBounds().height);
        this.viewer = JmolViewer.allocateViewer((Component)this.renderPanel, (JmolAdapter)new SmarterJmolAdapter());
        this.viewer.setAppletContext("", null, null, "");
        this.viewer.setJmolStatusListener((JmolStatusListener)this);
        this.jmolpopup = JmolPopup.newJmolPopup((JmolViewer)this.viewer);
        this.viewer.evalStringQuiet(command);
    }

    void setChainMenuItems(Vector chains) {
        this.chainMenu.removeAll();
        JMenuItem menuItem = new JMenuItem("All");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AppJmol.this.allChainsSelected = true;
                for (int i = 0; i < AppJmol.this.chainMenu.getItemCount(); ++i) {
                    if (!(AppJmol.this.chainMenu.getItem(i) instanceof JCheckBoxMenuItem)) continue;
                    ((JCheckBoxMenuItem)AppJmol.this.chainMenu.getItem(i)).setSelected(true);
                }
                AppJmol.this.centerViewer();
                AppJmol.this.allChainsSelected = false;
            }
        });
        this.chainMenu.add(menuItem);
        for (int c = 0; c < chains.size(); ++c) {
            menuItem = new JCheckBoxMenuItem(chains.elementAt(c).toString(), true);
            menuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    if (!AppJmol.this.allChainsSelected) {
                        AppJmol.this.centerViewer();
                    }
                }
            });
            this.chainMenu.add(menuItem);
        }
    }

    void centerViewer() {
        StringBuffer cmd = new StringBuffer();
        for (int i = 0; i < this.chainMenu.getItemCount(); ++i) {
            JCheckBoxMenuItem item;
            if (!(this.chainMenu.getItem(i) instanceof JCheckBoxMenuItem) || !(item = (JCheckBoxMenuItem)this.chainMenu.getItem(i)).isSelected()) continue;
            cmd.append(":" + item.getText() + " or ");
        }
        if (cmd.length() > 0) {
            cmd.setLength(cmd.length() - 4);
        }
        this.viewer.evalStringQuiet("select *;restrict " + cmd + ";cartoon;center " + cmd);
    }

    void closeViewer() {
        this.viewer.setModeMouse(-1);
        this.viewer.evalStringQuiet("zap");
        this.viewer.setJmolStatusListener(null);
        this.viewer = null;
        StructureSelectionManager.getStructureSelectionManager().removeStructureViewerListener(this, this.pdbentry.getFile());
    }

    public void run() {
        try {
            EBIFetchClient ebi = new EBIFetchClient();
            String query = "pdb:" + this.pdbentry.getId();
            this.pdbentry.setFile(ebi.fetchDataAsFile(query, "default", "raw").getAbsolutePath());
            this.initJmol("load " + this.pdbentry.getFile());
        }
        catch (OutOfMemoryError oomerror) {
            new OOMWarning("Retrieving PDB id " + this.pdbentry.getId() + " from MSD", oomerror);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void pdbFile_actionPerformed(ActionEvent actionEvent) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Save PDB File");
        chooser.setToolTipText("Save");
        int value = chooser.showSaveDialog(this);
        if (value == 0) {
            try {
                String data;
                BufferedReader in = new BufferedReader(new FileReader(this.pdbentry.getFile()));
                File outFile = chooser.getSelectedFile();
                PrintWriter out = new PrintWriter(new FileOutputStream(outFile));
                while ((data = in.readLine()) != null) {
                    if (data.indexOf("<PRE>") > -1 || data.indexOf("</PRE>") > -1) continue;
                    out.println(data);
                }
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void viewMapping_actionPerformed(ActionEvent actionEvent) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        Desktop.addInternalFrame(cap, "PDB - Sequence Mapping", 550, 600);
        cap.setText(StructureSelectionManager.getStructureSelectionManager().printMapping(this.pdbentry.getFile()));
    }

    public void eps_actionPerformed(ActionEvent e) {
        this.makePDBImage(0);
    }

    public void png_actionPerformed(ActionEvent e) {
        this.makePDBImage(1);
    }

    void makePDBImage(int type) {
        int width = this.getWidth();
        int height = this.getHeight();
        ImageMaker im = type == 1 ? new ImageMaker(this, 1, "Make PNG image from view", width, height, null, null) : new ImageMaker(this, 0, "Make EPS file from view", width, height, null, this.getTitle());
        if (im.getGraphics() != null) {
            Rectangle rect = new Rectangle(width, height);
            this.viewer.renderScreenImage(im.getGraphics(), rect.getSize(), rect);
            im.writeImage();
        }
    }

    public void seqColour_actionPerformed(ActionEvent actionEvent) {
        this.lastCommand = null;
        this.colourBySequence = this.seqColour.isSelected();
        this.colourBySequence(this.ap.alignFrame.alignPanel);
    }

    public void chainColour_actionPerformed(ActionEvent actionEvent) {
        this.colourBySequence = false;
        this.seqColour.setSelected(false);
        this.viewer.evalStringQuiet("select *;color chain");
    }

    public void chargeColour_actionPerformed(ActionEvent actionEvent) {
        this.colourBySequence = false;
        this.seqColour.setSelected(false);
        this.viewer.evalStringQuiet("select *;color white;select ASP,GLU;color red;select LYS,ARG;color blue;select CYS;color yellow");
    }

    public void zappoColour_actionPerformed(ActionEvent actionEvent) {
        this.setJalviewColourScheme(new ZappoColourScheme());
    }

    public void taylorColour_actionPerformed(ActionEvent actionEvent) {
        this.setJalviewColourScheme(new TaylorColourScheme());
    }

    public void hydroColour_actionPerformed(ActionEvent actionEvent) {
        this.setJalviewColourScheme(new HydrophobicColourScheme());
    }

    public void helixColour_actionPerformed(ActionEvent actionEvent) {
        this.setJalviewColourScheme(new HelixColourScheme());
    }

    public void strandColour_actionPerformed(ActionEvent actionEvent) {
        this.setJalviewColourScheme(new StrandColourScheme());
    }

    public void turnColour_actionPerformed(ActionEvent actionEvent) {
        this.setJalviewColourScheme(new TurnColourScheme());
    }

    public void buriedColour_actionPerformed(ActionEvent actionEvent) {
        this.setJalviewColourScheme(new BuriedColourScheme());
    }

    public void setJalviewColourScheme(ColourSchemeI cs) {
        this.colourBySequence = false;
        this.seqColour.setSelected(false);
        if (cs == null) {
            return;
        }
        Enumeration en = ResidueProperties.aa3Hash.keys();
        StringBuffer command = new StringBuffer("select *;color white;");
        while (en.hasMoreElements()) {
            String res = en.nextElement().toString();
            int index = (Integer)ResidueProperties.aa3Hash.get(res);
            if (index > 20) continue;
            Color col = cs.findColour(ResidueProperties.aa[index].charAt(0));
            command.append("select " + res + ";color[" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + "];");
        }
        this.viewer.evalStringQuiet(command.toString());
    }

    public void userColour_actionPerformed(ActionEvent actionEvent) {
        new UserDefinedColours(this, null);
    }

    public void backGround_actionPerformed(ActionEvent actionEvent) {
        Color col = JColorChooser.showDialog(this, "Select Background Colour", null);
        if (col != null) {
            this.viewer.evalStringQuiet("background [" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + "];");
        }
    }

    public void jmolHelp_actionPerformed(ActionEvent actionEvent) {
        try {
            BrowserLauncher.openURL("http://jmol.sourceforge.net/docs/JmolUserGuide/");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPdbFile() {
        return this.pdbentry.getFile();
    }

    public void mouseOverStructure(int atomIndex, String strInfo) {
        Matcher matcher = this.pattern.matcher(strInfo);
        matcher.find();
        matcher.group(1);
        int pdbResNum = Integer.parseInt(matcher.group(2));
        String chainId = matcher.group(3);
        chainId = chainId != null ? chainId.substring(1, chainId.length()) : " ";
        if (this.lastMessage == null || !this.lastMessage.equals(strInfo)) {
            this.ssm.mouseOverStructure(pdbResNum, chainId, this.pdbentry.getFile());
        }
        this.lastMessage = strInfo;
    }

    public void highlightAtom(int atomIndex, int pdbResNum, String chain, String pdbfile) {
        if (!pdbfile.equals(this.pdbentry.getFile())) {
            return;
        }
        if (this.resetLastRes.length() > 0) {
            this.viewer.evalStringQuiet(this.resetLastRes.toString());
        }
        this.eval.setLength(0);
        this.eval.append("select " + pdbResNum);
        this.resetLastRes.setLength(0);
        this.resetLastRes.append("select " + pdbResNum);
        if (!chain.equals(" ")) {
            this.eval.append(":" + chain);
            this.resetLastRes.append(":" + chain);
        }
        this.eval.append(";wireframe 100;" + this.eval.toString() + ".CA;");
        this.resetLastRes.append(";wireframe 0;" + this.resetLastRes.toString() + ".CA;spacefill 0;");
        this.eval.append("spacefill 200;select none");
        this.viewer.evalStringQuiet(this.eval.toString());
    }

    public Color getColour(int atomIndex, int pdbResNum, String chain, String pdbfile) {
        if (!pdbfile.equals(this.pdbentry.getFile())) {
            return null;
        }
        return new Color(this.viewer.getAtomArgb(atomIndex));
    }

    public void updateColours(Object source) {
        this.colourBySequence((AlignmentPanel)source);
    }

    public void colourBySequence(AlignmentPanel sourceap) {
        this.ap = sourceap;
        if (!this.colourBySequence || this.ap.alignFrame.getCurrentView() != this.ap.av) {
            return;
        }
        StructureMapping[] mapping = this.ssm.getMapping(this.pdbentry.getFile());
        if (mapping.length < 1) {
            return;
        }
        SequenceRenderer sr = new SequenceRenderer(this.ap.av);
        boolean showFeatures = false;
        if (this.ap.av.showSequenceFeatures) {
            showFeatures = true;
            if (this.fr == null) {
                this.fr = new FeatureRenderer(this.ap);
            }
            this.fr.transferSettings(this.ap.seqPanel.seqCanvas.getFeatureRenderer());
        }
        StringBuffer command = new StringBuffer();
        int lastPos = -1;
        block0: for (int s = 0; s < this.sequence.length; ++s) {
            for (int m = 0; m < mapping.length; ++m) {
                int sp;
                if (mapping[m].getSequence() != this.sequence[s] || (sp = this.ap.av.alignment.findIndex(this.sequence[s])) <= -1) continue;
                SequenceI asp = this.ap.av.alignment.getSequenceAt(sp);
                for (int r = 0; r < asp.getLength(); ++r) {
                    int pos;
                    if (Comparison.isGap(asp.getCharAt(r)) || (pos = mapping[m].getPDBResNum(asp.findPosition(r))) < 1 || pos == lastPos) continue;
                    lastPos = pos;
                    Color col = sr.getResidueBoxColour(asp, r);
                    if (showFeatures) {
                        col = this.fr.findFeatureColour(col, asp, r);
                    }
                    if (command.toString().endsWith(":" + mapping[m].getChain() + ";color[" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + "]")) {
                        command = this.condenseCommand(command, pos);
                        continue;
                    }
                    command.append(";select " + pos);
                    if (!mapping[m].getChain().equals(" ")) {
                        command.append(":" + mapping[m].getChain());
                    }
                    command.append(";color[" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + "]");
                }
                continue block0;
            }
        }
        if (this.lastCommand == null || !this.lastCommand.equals(command.toString())) {
            this.viewer.evalStringQuiet(command.toString());
        }
        this.lastCommand = command.toString();
    }

    StringBuffer condenseCommand(StringBuffer command, int pos) {
        StringBuffer sb = new StringBuffer(command.substring(0, command.lastIndexOf("select") + 7));
        command.delete(0, sb.length());
        String start = command.indexOf("-") > -1 ? command.substring(0, command.indexOf("-")) : command.substring(0, command.indexOf(":"));
        sb.append(start + "-" + pos + command.substring(command.indexOf(":")));
        return sb;
    }

    public String eval(String strEval) {
        return null;
    }

    public void createImage(String file, String type, int quality) {
        System.out.println("JMOL CREATE IMAGE");
    }

    public void setCallbackFunction(String callbackType, String callbackFunction) {
    }

    public void notifyFileLoaded(String fullPathName, String fileName, String modelName, Object clientFile, String errorMsg) {
        if (errorMsg != null) {
            this.fileLoadingError = errorMsg;
            this.repaint();
            return;
        }
        this.fileLoadingError = null;
        if (fileName != null) {
            this.ssm = StructureSelectionManager.getStructureSelectionManager();
            PDBfile pdbFile = this.ssm.setMapping(this.sequence, this.chains, this.pdbentry.getFile(), AppletFormatAdapter.FILE);
            this.ssm.addStructureViewerListener(this);
            Vector<String> chains = new Vector<String>();
            for (int i = 0; i < pdbFile.chains.size(); ++i) {
                chains.addElement(((PDBChain)pdbFile.chains.elementAt((int)i)).id);
            }
            this.setChainMenuItems(chains);
            this.jmolpopup.updateComputedMenus();
            if (!this.loadingFromArchive) {
                this.viewer.evalStringQuiet("select backbone;restrict;cartoon;wireframe off;spacefill off");
                this.colourBySequence(this.ap);
            }
            if (this.fr != null) {
                this.fr.featuresAdded();
            }
        } else {
            return;
        }
        this.loadingFromArchive = false;
    }

    public void notifyFrameChanged(int frameNo) {
        boolean isAnimationRunning = frameNo <= -2;
    }

    public void notifyScriptStart(String statusMessage, String additionalInfo) {
    }

    public void sendConsoleEcho(String strEcho) {
        if (this.scriptWindow != null) {
            this.scriptWindow.sendConsoleEcho(strEcho);
        }
    }

    public void sendConsoleMessage(String strStatus) {
        if (this.scriptWindow != null) {
            this.scriptWindow.sendConsoleMessage(strStatus);
        }
    }

    public void notifyScriptTermination(String strStatus, int msWalltime) {
        if (this.scriptWindow != null) {
            this.scriptWindow.notifyScriptTermination(strStatus, msWalltime);
        }
    }

    public void handlePopupMenu(int x, int y) {
        this.jmolpopup.show(x, y);
    }

    public void notifyNewPickingModeMeasurement(int iatom, String strMeasure) {
        this.notifyAtomPicked(iatom, strMeasure);
    }

    public void notifyNewDefaultModeMeasurement(int count, String strInfo) {
    }

    public void notifyAtomPicked(int atomIndex, String strInfo) {
        Matcher matcher = this.pattern.matcher(strInfo);
        matcher.find();
        matcher.group(1);
        String resnum = new String(matcher.group(2));
        String chainId = matcher.group(3);
        String picked = resnum;
        if (chainId != null) {
            picked = picked + ":" + chainId.substring(1, chainId.length());
        }
        if (!this.atomsPicked.contains(picked = picked + ".CA")) {
            if (chainId != null) {
                this.viewer.evalString("select " + picked + ";label %n %r:%c");
            } else {
                this.viewer.evalString("select " + picked + ";label %n %r");
            }
            this.atomsPicked.addElement(picked);
        } else {
            this.viewer.evalString("select " + picked + ";label off");
            this.atomsPicked.removeElement(picked);
        }
        if (this.scriptWindow != null) {
            this.scriptWindow.sendConsoleMessage(strInfo);
            this.scriptWindow.sendConsoleMessage("\n");
        }
    }

    public void notifyAtomHovered(int atomIndex, String strInfo) {
        this.mouseOverStructure(atomIndex, strInfo);
    }

    public void sendSyncScript(String script, String appletName) {
    }

    public void showUrl(String url) {
    }

    public void showConsole(boolean showConsole) {
        if (this.scriptWindow == null) {
            this.scriptWindow = new ScriptWindow(this);
        }
        if (showConsole) {
            if (this.splitPane == null) {
                this.splitPane = new JSplitPane(0);
                this.splitPane.setTopComponent(this.renderPanel);
                this.splitPane.setBottomComponent(this.scriptWindow);
                this.getContentPane().add((Component)this.splitPane, "Center");
            }
            this.splitPane.setDividerLocation(this.getHeight() - 200);
            this.splitPane.validate();
        } else {
            if (this.splitPane != null) {
                this.splitPane.setVisible(false);
            }
            this.splitPane = null;
            this.getContentPane().add((Component)this.renderPanel, "Center");
        }
        this.validate();
    }

    public float functionXY(String functionName, int x, int y) {
        return 0.0f;
    }

    class RenderPanel
    extends JPanel {
        final Dimension currentSize = new Dimension();
        final Rectangle rectClip = new Rectangle();

        RenderPanel() {
        }

        public void paintComponent(Graphics g) {
            this.getSize(this.currentSize);
            g.getClipBounds(this.rectClip);
            if (AppJmol.this.viewer == null) {
                g.setColor(Color.black);
                g.fillRect(0, 0, this.currentSize.width, this.currentSize.height);
                g.setColor(Color.white);
                g.setFont(new Font("Verdana", 1, 14));
                g.drawString("Retrieving PDB data....", 20, this.currentSize.height / 2);
            } else if (AppJmol.this.fileLoadingError != null) {
                g.setColor(Color.black);
                g.fillRect(0, 0, this.currentSize.width, this.currentSize.height);
                g.setColor(Color.white);
                g.setFont(new Font("Verdana", 1, 14));
                g.drawString("Error loading file..." + AppJmol.this.pdbentry.getId(), 20, this.currentSize.height / 2);
            } else {
                AppJmol.this.viewer.renderScreenImage(g, this.currentSize, this.rectClip);
            }
        }
    }
}

