/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.binding.Colour;
import jalview.binding.JalviewUserColours;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.ColorEditor;
import jalview.gui.DasSourceBrowser;
import jalview.gui.Desktop;
import jalview.gui.FeatureRenderer;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.util.Format;
import jalview.util.QuickSort;
import jalview.ws.DasSequenceFeatureFetcher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class FeatureSettings
extends JPanel {
    DasSourceBrowser dassourceBrowser;
    DasSequenceFeatureFetcher dasFeatureFetcher;
    JPanel settingsPane = new JPanel();
    JPanel dasSettingsPane = new JPanel();
    final FeatureRenderer fr;
    public final AlignFrame af;
    Object[][] originalData;
    final JInternalFrame frame;
    JScrollPane scrollPane = new JScrollPane();
    JTable table;
    JPanel groupPanel;
    JSlider transparency = new JSlider();
    JPanel transPanel = new JPanel(new FlowLayout());
    private boolean handlingUpdate = false;
    Hashtable typeWidth = null;
    boolean resettingTable = false;
    int selectedRow = -1;
    JTabbedPane tabbedPane = new JTabbedPane();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel bigPanel = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    JButton invert = new JButton();
    JPanel buttonPanel = new JPanel();
    JButton cancel = new JButton();
    JButton ok = new JButton();
    JButton loadColours = new JButton();
    JButton saveColours = new JButton();
    JPanel dasButtonPanel = new JPanel();
    JButton fetchDAS = new JButton();
    JButton saveDAS = new JButton();
    JButton cancelDAS = new JButton();
    JButton optimizeOrder = new JButton();
    JPanel transbuttons = new JPanel(new BorderLayout());

    public FeatureSettings(AlignFrame af) {
        this.af = af;
        this.fr = af.getFeatureRenderer();
        this.transparency.setMaximum(100 - (int)(this.fr.transparency * 100.0f));
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.table = new JTable();
        this.table.getTableHeader().setFont(new Font("Verdana", 0, 12));
        this.table.setFont(new Font("Verdana", 0, 12));
        this.table.setDefaultRenderer(Color.class, new ColorRenderer());
        this.table.setDefaultEditor(Color.class, new ColorEditor());
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                FeatureSettings.this.selectedRow = FeatureSettings.this.table.rowAtPoint(evt.getPoint());
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                int newRow = FeatureSettings.this.table.rowAtPoint(evt.getPoint());
                if (newRow != FeatureSettings.this.selectedRow && FeatureSettings.this.selectedRow != -1 && newRow != -1) {
                    Object[] temp = new Object[]{FeatureSettings.this.table.getValueAt(FeatureSettings.this.selectedRow, 0), FeatureSettings.this.table.getValueAt(FeatureSettings.this.selectedRow, 1), FeatureSettings.this.table.getValueAt(FeatureSettings.this.selectedRow, 2)};
                    FeatureSettings.this.table.setValueAt(FeatureSettings.this.table.getValueAt(newRow, 0), FeatureSettings.this.selectedRow, 0);
                    FeatureSettings.this.table.setValueAt(FeatureSettings.this.table.getValueAt(newRow, 1), FeatureSettings.this.selectedRow, 1);
                    FeatureSettings.this.table.setValueAt(FeatureSettings.this.table.getValueAt(newRow, 2), FeatureSettings.this.selectedRow, 2);
                    FeatureSettings.this.table.setValueAt(temp[0], newRow, 0);
                    FeatureSettings.this.table.setValueAt(temp[1], newRow, 1);
                    FeatureSettings.this.table.setValueAt(temp[2], newRow, 2);
                    FeatureSettings.this.selectedRow = newRow;
                }
            }
        });
        this.scrollPane.setViewportView(this.table);
        this.dassourceBrowser = new DasSourceBrowser();
        this.dasSettingsPane.add((Component)this.dassourceBrowser, "Center");
        if (af.getViewport().featuresDisplayed == null || this.fr.renderOrder == null) {
            this.fr.findAllFeatures(true);
        }
        this.setTableData();
        final FeatureSettings fs = this;
        final PropertyChangeListener change = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (!fs.resettingTable && !fs.handlingUpdate) {
                    fs.handlingUpdate = true;
                    fs.resetTable(null);
                    fs.handlingUpdate = false;
                }
            }
        };
        this.fr.addPropertyChangeListener(change);
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        Desktop.addInternalFrame(this.frame, "Sequence Feature Settings", 400, 450);
        this.frame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed(InternalFrameEvent evt) {
                FeatureSettings.this.fr.removePropertyChangeListener(change);
            }
        });
        this.frame.setLayer(JLayeredPane.PALETTE_LAYER);
    }

    public synchronized void setTableData() {
        if (this.fr.featureGroups == null) {
            this.fr.featureGroups = new Hashtable();
        }
        Vector<String> allFeatures = new Vector<String>();
        Vector<String> allGroups = new Vector<String>();
        for (int i = 0; i < this.af.getViewport().alignment.getHeight(); ++i) {
            if (this.af.getViewport().alignment.getSequenceAt(i).getDatasetSequence().getSequenceFeatures() == null) continue;
            SequenceFeature[] tmpfeatures = this.af.getViewport().alignment.getSequenceAt(i).getDatasetSequence().getSequenceFeatures();
            int index = 0;
            while (index < tmpfeatures.length) {
                String group;
                if (tmpfeatures[index].begin == 0 && tmpfeatures[index].end == 0) {
                    ++index;
                    continue;
                }
                if (tmpfeatures[index].getFeatureGroup() != null && !allGroups.contains(group = tmpfeatures[index].featureGroup)) {
                    allGroups.addElement(group);
                    if (group != null) {
                        this.checkGroupState(group);
                    }
                }
                if (!allFeatures.contains(tmpfeatures[index].getType())) {
                    allFeatures.addElement(tmpfeatures[index].getType());
                }
                ++index;
            }
        }
        this.resetTable(null);
        this.validate();
    }

    private boolean checkGroupState(String group) {
        boolean visible = this.fr.featureGroups.containsKey(group) ? (Boolean)this.fr.featureGroups.get(group) : true;
        if (this.groupPanel == null) {
            this.groupPanel = new JPanel();
        }
        boolean alreadyAdded = false;
        for (int g = 0; g < this.groupPanel.getComponentCount(); ++g) {
            if (!((JCheckBox)this.groupPanel.getComponent(g)).getText().equals(group)) continue;
            alreadyAdded = true;
            ((JCheckBox)this.groupPanel.getComponent(g)).setSelected(visible);
            break;
        }
        if (alreadyAdded) {
            return true;
        }
        this.fr.featureGroups.put(group, new Boolean(visible));
        final String grp = group;
        final JCheckBox check = new JCheckBox(group, visible);
        check.setFont(new Font("Serif", 1, 12));
        check.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FeatureSettings.this.fr.featureGroups.put(check.getText(), new Boolean(check.isSelected()));
                FeatureSettings.this.af.alignPanel.seqPanel.seqCanvas.repaint();
                if (FeatureSettings.this.af.alignPanel.overviewPanel != null) {
                    FeatureSettings.this.af.alignPanel.overviewPanel.updateOverviewImage();
                }
                FeatureSettings.this.resetTable(new String[]{grp});
            }
        });
        this.groupPanel.add(check);
        return false;
    }

    synchronized void resetTable(String[] groupChanged) {
        String type;
        if (this.resettingTable) {
            return;
        }
        this.resettingTable = true;
        this.typeWidth = new Hashtable();
        float[] avWidth = null;
        String group = null;
        Vector<String> visibleChecks = new Vector<String>();
        for (int i = 0; i < this.af.getViewport().alignment.getHeight(); ++i) {
            SequenceFeature[] tmpfeatures = this.af.getViewport().alignment.getSequenceAt(i).getDatasetSequence().getSequenceFeatures();
            if (tmpfeatures == null) continue;
            int index = 0;
            while (index < tmpfeatures.length) {
                group = tmpfeatures[index].featureGroup;
                if (tmpfeatures[index].begin == 0 && tmpfeatures[index].end == 0) {
                    ++index;
                    continue;
                }
                if (group == null || this.fr.featureGroups.get(group) == null || ((Boolean)this.fr.featureGroups.get(group)).booleanValue()) {
                    if (group != null) {
                        this.checkGroupState(group);
                    }
                    if (!visibleChecks.contains(type = tmpfeatures[index].getType())) {
                        visibleChecks.addElement(type);
                    }
                }
                if (!this.typeWidth.containsKey(tmpfeatures[index].getType())) {
                    avWidth = new float[3];
                    this.typeWidth.put(tmpfeatures[index].getType(), avWidth);
                } else {
                    avWidth = (float[])this.typeWidth.get(tmpfeatures[index].getType());
                }
                avWidth[0] = avWidth[0] + 1.0f;
                avWidth[1] = tmpfeatures[index].getBegin() > tmpfeatures[index].getEnd() ? avWidth[1] + (float)(1 + tmpfeatures[index].getBegin() - tmpfeatures[index].getEnd()) : avWidth[1] + (float)(1 + tmpfeatures[index].getEnd() - tmpfeatures[index].getBegin());
                ++index;
            }
        }
        int fSize = visibleChecks.size();
        Object[][] data = new Object[fSize][3];
        int dataIndex = 0;
        if (this.fr.renderOrder != null) {
            if (!this.handlingUpdate) {
                this.fr.findAllFeatures(groupChanged != null);
            }
            for (int ro = this.fr.renderOrder.length - 1; ro > -1; --ro) {
                type = this.fr.renderOrder[ro];
                if (!visibleChecks.contains(type)) continue;
                data[dataIndex][0] = type;
                data[dataIndex][1] = this.fr.getColour(type);
                data[dataIndex][2] = new Boolean(this.af.getViewport().featuresDisplayed.containsKey(type));
                ++dataIndex;
                visibleChecks.removeElement(type);
            }
        }
        fSize = visibleChecks.size();
        for (int i = 0; i < fSize; ++i) {
            type = visibleChecks.elementAt(i).toString();
            data[dataIndex][0] = type;
            data[dataIndex][1] = this.fr.getColour(type);
            if (data[dataIndex][1] == null) {
                this.fr.renderOrder = null;
                return;
            }
            data[dataIndex][2] = new Boolean(true);
            ++dataIndex;
        }
        if (this.originalData == null) {
            this.originalData = new Object[data.length][3];
            System.arraycopy(data, 0, this.originalData, 0, data.length);
        }
        this.table.setModel(new FeatureTableModel(data));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        if (this.groupPanel != null) {
            this.groupPanel.setLayout(new GridLayout(this.fr.featureGroups.size() / 4 + 1, 4));
            this.groupPanel.validate();
            this.bigPanel.add((Component)this.groupPanel, "North");
        }
        this.updateFeatureRenderer(data, groupChanged != null);
        this.resettingTable = false;
    }

    private void ensureOrder(Object[][] data) {
        boolean sort = false;
        float[] order = new float[data.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = this.fr.getOrder(data[i][0].toString());
            if (order[i] < 0.0f) {
                order[i] = this.fr.setOrder(data[i][0].toString(), i / order.length);
            }
            if (i <= 1) continue;
            sort = sort || order[i - 1] > order[i];
        }
        if (sort) {
            QuickSort.sort(order, (Object[])data);
        }
    }

    void load() {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), new String[]{"fc"}, new String[]{"Sequence Feature Colours"}, "Sequence Feature Colours");
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Load Feature Colours");
        chooser.setToolTipText("Load");
        int value = chooser.showOpenDialog(this);
        if (value == 0) {
            File file = chooser.getSelectedFile();
            try {
                InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                JalviewUserColours jucs = new JalviewUserColours();
                jucs = JalviewUserColours.unmarshal(in);
                for (int i = jucs.getColourCount() - 1; i >= 0; --i) {
                    String name = jucs.getColour(i).getName();
                    this.fr.setColour(name, new Color(Integer.parseInt(jucs.getColour(i).getRGB(), 16)));
                    this.fr.setOrder(name, i == 0 ? 0.0f : (float)(i / jucs.getColourCount()));
                }
                if (this.table != null) {
                    this.resetTable(null);
                    Object[][] data = ((FeatureTableModel)this.table.getModel()).getData();
                    this.ensureOrder(data);
                    this.updateFeatureRenderer(data, false);
                    this.table.repaint();
                }
            }
            catch (Exception ex) {
                System.out.println("Error loading User Colour File\n" + ex);
            }
        }
    }

    void save() {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), new String[]{"fc"}, new String[]{"Sequence Feature Colours"}, "Sequence Feature Colours");
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Save Feature Colour Scheme");
        chooser.setToolTipText("Save");
        int value = chooser.showSaveDialog(this);
        if (value == 0) {
            String choice = chooser.getSelectedFile().getPath();
            JalviewUserColours ucs = new JalviewUserColours();
            ucs.setSchemeName("Sequence Features");
            try {
                PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(choice), "UTF-8"));
                Enumeration e = this.fr.featureColours.keys();
                float[] sortOrder = new float[this.fr.featureColours.size()];
                Object[] sortTypes = new String[this.fr.featureColours.size()];
                int i = 0;
                while (e.hasMoreElements()) {
                    sortTypes[i] = e.nextElement().toString();
                    sortOrder[i] = this.fr.getOrder((String)sortTypes[i]);
                    ++i;
                }
                QuickSort.sort(sortOrder, sortTypes);
                sortOrder = null;
                for (i = 0; i < sortTypes.length; ++i) {
                    Colour col = new Colour();
                    col.setName((String)sortTypes[i]);
                    col.setRGB(Format.getHexString(this.fr.getColour(col.getName())));
                    ucs.addColour(col);
                }
                ucs.marshal(out);
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void invertSelection() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            Boolean value = (Boolean)this.table.getValueAt(i, 2);
            this.table.setValueAt(new Boolean(value == false), i, 2);
        }
    }

    public void orderByAvWidth() {
        if (this.table == null || this.table.getModel() == null) {
            return;
        }
        Object[][] data = ((FeatureTableModel)this.table.getModel()).getData();
        float[] width = new float[data.length];
        float max = 0.0f;
        int num = 0;
        for (int i = 0; i < data.length; ++i) {
            float[] awidth = (float[])this.typeWidth.get(data[i][0]);
            if (awidth[0] > 0.0f) {
                width[i] = awidth[1] / awidth[0];
                ++num;
            } else {
                width[i] = 0.0f;
            }
            if (!(max < width[i])) continue;
            max = width[i];
        }
        boolean sort = false;
        for (int i = 0; i < width.length; ++i) {
            if (width[i] == 0.0f) {
                width[i] = this.fr.getOrder(data[i][0].toString());
                if (width[i] < 0.0f) {
                    width[i] = this.fr.setOrder(data[i][0].toString(), i / data.length);
                }
            } else {
                int n = i;
                width[n] = width[n] / max;
                this.fr.setOrder(data[i][0].toString(), width[i]);
            }
            if (i <= 0) continue;
            sort = sort || width[i - 1] > width[i];
        }
        if (sort) {
            QuickSort.sort(width, (Object[])data);
        }
        this.updateFeatureRenderer(data, false);
        this.table.repaint();
    }

    public void close() {
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateFeatureRenderer(Object[][] data) {
        this.updateFeatureRenderer(data, true);
    }

    private void updateFeatureRenderer(Object[][] data, boolean visibleNew) {
        this.fr.setFeaturePriority(data, visibleNew);
        this.af.alignPanel.paintAlignment(true);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.settingsPane.setLayout(this.borderLayout2);
        this.dasSettingsPane.setLayout(this.borderLayout3);
        this.bigPanel.setLayout(this.borderLayout4);
        this.invert.setFont(new Font("Verdana", 0, 11));
        this.invert.setText("Invert Selection");
        this.invert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.invertSelection();
            }
        });
        this.optimizeOrder.setFont(new Font("Verdana", 0, 11));
        this.optimizeOrder.setText("Optimise Order");
        this.optimizeOrder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.orderByAvWidth();
            }
        });
        this.cancel.setFont(new Font("Verdana", 0, 11));
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.updateFeatureRenderer(FeatureSettings.this.originalData);
                FeatureSettings.this.close();
            }
        });
        this.ok.setFont(new Font("Verdana", 0, 11));
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.close();
            }
        });
        this.loadColours.setFont(new Font("Verdana", 0, 11));
        this.loadColours.setText("Load Colours");
        this.loadColours.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.load();
            }
        });
        this.saveColours.setFont(new Font("Verdana", 0, 11));
        this.saveColours.setText("Save Colours");
        this.saveColours.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.save();
            }
        });
        this.transparency.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                FeatureSettings.this.fr.setTransparency((float)(100 - FeatureSettings.this.transparency.getValue()) / 100.0f);
                FeatureSettings.this.af.alignPanel.paintAlignment(true);
            }
        });
        this.transparency.setMaximum(70);
        this.fetchDAS.setText("Fetch DAS Features");
        this.fetchDAS.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.fetchDAS_actionPerformed(e);
            }
        });
        this.saveDAS.setText("Save as default");
        this.saveDAS.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.saveDAS_actionPerformed(e);
            }
        });
        this.dasButtonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.dasSettingsPane.setBorder(null);
        this.cancelDAS.setEnabled(false);
        this.cancelDAS.setText("Cancel Fetch");
        this.cancelDAS.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.cancelDAS_actionPerformed(e);
            }
        });
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addTab("Feature Settings", this.settingsPane);
        this.tabbedPane.addTab("DAS Settings", this.dasSettingsPane);
        this.bigPanel.add((Component)this.transPanel, "South");
        this.transPanel.add(this.transparency);
        this.transbuttons.add((Component)this.invert, "North");
        this.transbuttons.add((Component)this.optimizeOrder, "South");
        this.transPanel.add(this.transbuttons);
        this.buttonPanel.add(this.ok);
        this.buttonPanel.add(this.cancel);
        this.buttonPanel.add(this.loadColours);
        this.buttonPanel.add(this.saveColours);
        this.bigPanel.add((Component)this.scrollPane, "Center");
        this.dasSettingsPane.add((Component)this.dasButtonPanel, "South");
        this.dasButtonPanel.add(this.fetchDAS);
        this.dasButtonPanel.add(this.cancelDAS);
        this.dasButtonPanel.add(this.saveDAS);
        this.settingsPane.add((Component)this.bigPanel, "Center");
        this.settingsPane.add((Component)this.buttonPanel, "South");
    }

    public void fetchDAS_actionPerformed(ActionEvent e) {
        this.fetchDAS.setEnabled(false);
        this.cancelDAS.setEnabled(true);
        Vector selectedSources = this.dassourceBrowser.getSelectedSources();
        this.doDasFeatureFetch(selectedSources, true, true);
    }

    private void doDasFeatureFetch(Vector selectedSources, boolean checkDbRefs, boolean promptFetchDbRefs) {
        SequenceI[] seqs;
        SequenceI[] dataset;
        int iSize;
        AlignViewport vp = this.af.getViewport();
        if (vp.getSelectionGroup() != null && vp.getSelectionGroup().getSize() > 0) {
            iSize = vp.getSelectionGroup().getSize();
            dataset = new SequenceI[iSize];
            seqs = vp.getSelectionGroup().getSequencesInOrder(vp.getAlignment());
        } else {
            iSize = vp.getAlignment().getHeight();
            seqs = vp.getAlignment().getSequencesArray();
        }
        dataset = new SequenceI[iSize];
        for (int i = 0; i < iSize; ++i) {
            dataset[i] = seqs[i].getDatasetSequence();
        }
        this.cancelDAS.setEnabled(true);
        this.dasFeatureFetcher = new DasSequenceFeatureFetcher(dataset, this, selectedSources, checkDbRefs, promptFetchDbRefs);
        this.af.getViewport().setShowSequenceFeatures(true);
        this.af.showSeqFeatures.setSelected(true);
    }

    public void fetchDasFeatures(Vector sources) {
        Thread thr = new Thread(new Runnable(){

            public void run() {
                FeatureSettings.this.dassourceBrowser.paintComponent(null);
            }
        });
        thr.start();
        while (true) {
            if (!this.dassourceBrowser.loadingDasSources) {
                if (DasSourceBrowser.dasSources != null) break;
            }
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {}
        }
        Vector resolved = new Vector();
        if (sources != null) {
            int i = 0;
            while (true) {
                if (i >= DasSourceBrowser.dasSources.length) break;
                if (sources.contains(DasSourceBrowser.dasSources[i].getNickname())) {
                    if (!resolved.contains(DasSourceBrowser.dasSources[i])) {
                        resolved.addElement(DasSourceBrowser.dasSources[i]);
                    }
                }
                ++i;
            }
        }
        if (resolved.size() == 0) {
            resolved = this.dassourceBrowser.getSelectedSources();
        }
        if (resolved.size() > 0) {
            final Vector dassources = resolved;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FeatureSettings.this.fetchDAS.setEnabled(false);
                    FeatureSettings.this.cancelDAS.setEnabled(true);
                    FeatureSettings.this.doDasFeatureFetch(dassources, true, false);
                }
            });
        }
    }

    public void saveDAS_actionPerformed(ActionEvent e) {
        this.dassourceBrowser.saveProperties(Cache.applicationProperties);
    }

    public void complete() {
        this.fetchDAS.setEnabled(true);
        this.cancelDAS.setEnabled(false);
    }

    public void cancelDAS_actionPerformed(ActionEvent e) {
        if (this.dasFeatureFetcher != null) {
            this.dasFeatureFetcher.cancel();
        }
        this.fetchDAS.setEnabled(true);
        this.cancelDAS.setEnabled(false);
    }

    public void noDasSourceActive() {
        this.complete();
        JOptionPane.showInternalConfirmDialog(Desktop.desktop, "No das sources were selected.\nPlease select some sources and\n try again.", "No Sources Selected", -1, 1);
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;

        public ColorRenderer() {
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Color newColor = (Color)color;
            this.setBackground(newColor);
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
            this.setToolTipText("RGB value: " + newColor.getRed() + ", " + newColor.getGreen() + ", " + newColor.getBlue());
            return this;
        }
    }

    class FeatureTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Feature Type", "Colour", "Display"};
        private Object[][] data;

        FeatureTableModel(Object[][] data) {
            this.data = data;
        }

        public Object[][] getData() {
            return this.data;
        }

        public void setData(Object[][] data) {
            this.data = data;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Object[] getRow(int row) {
            return this.data[row];
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
            FeatureSettings.this.updateFeatureRenderer(this.data);
        }
    }
}

