/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.SearchResults;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.jbgui.GFinder;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;

public class Finder
extends GFinder {
    AlignViewport av;
    AlignmentPanel ap;
    JInternalFrame frame = new JInternalFrame();
    int seqIndex = 0;
    int resIndex = 0;
    SearchResults searchResults;

    public Finder() {
        this.frame.setContentPane(this);
        this.frame.setLayer(JLayeredPane.PALETTE_LAYER);
        Desktop.addInternalFrame(this.frame, "Find", 340, 110);
        this.textfield.requestFocus();
    }

    public void findNext_actionPerformed(ActionEvent e) {
        if (this.getFocusedViewport()) {
            this.doSearch(false);
        }
    }

    public void findAll_actionPerformed(ActionEvent e) {
        if (this.getFocusedViewport()) {
            this.resIndex = 0;
            this.seqIndex = 0;
            this.doSearch(true);
        }
    }

    boolean getFocusedViewport() {
        JInternalFrame frame = Desktop.desktop.getAllFrames()[1];
        if (frame != null && frame instanceof AlignFrame) {
            this.av = ((AlignFrame)frame).viewport;
            this.ap = ((AlignFrame)frame).alignPanel;
            return true;
        }
        return false;
    }

    public void createNewGroup_actionPerformed(ActionEvent e) {
        SequenceI[] seqs = new SequenceI[this.searchResults.getSize()];
        SequenceFeature[] features = new SequenceFeature[this.searchResults.getSize()];
        for (int i = 0; i < this.searchResults.getSize(); ++i) {
            seqs[i] = this.searchResults.getResultSequence(i).getDatasetSequence();
            features[i] = new SequenceFeature(this.textfield.getText().trim(), "Search Results", null, this.searchResults.getResultStart(i), this.searchResults.getResultEnd(i), "Search Results");
        }
        if (this.ap.seqPanel.seqCanvas.getFeatureRenderer().amendFeatures(seqs, features, true, this.ap)) {
            this.ap.alignFrame.showSeqFeatures.setSelected(true);
            this.av.setShowSequenceFeatures(true);
            this.ap.highlightSearchResults(null);
        }
    }

    void doSearch(boolean findAll) {
        this.createNewGroup.setEnabled(false);
        String searchString = this.textfield.getText().trim();
        if (searchString.length() < 1) {
            return;
        }
        jalview.analysis.Finder finder = new jalview.analysis.Finder(this.av.alignment, this.av.getSelectionGroup(), this.seqIndex, this.resIndex);
        finder.setCaseSensitive(this.caseSensitive.isSelected());
        finder.setFindAll(findAll);
        finder.find(searchString);
        this.seqIndex = finder.getSeqIndex();
        this.resIndex = finder.getResIndex();
        this.searchResults = finder.getSearchResults();
        Vector idMatch = finder.getIdMatch();
        if (this.searchResults.getSize() == 0 && idMatch.size() > 0) {
            this.ap.idPanel.highlightSearchResults(idMatch);
        }
        int resultSize = this.searchResults.getSize();
        if (this.searchResults.getSize() > 0) {
            this.createNewGroup.setEnabled(true);
        } else {
            this.searchResults = null;
        }
        this.ap.highlightSearchResults(this.searchResults);
        if (!findAll && resultSize == 0) {
            JOptionPane.showInternalMessageDialog(this, "Finished searching", null, 1);
            this.resIndex = 0;
            this.seqIndex = 0;
        }
        if (findAll) {
            String message = resultSize + " matches found.";
            JOptionPane.showInternalMessageDialog(this, message, null, 1);
        }
    }
}

