/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.IdCanvas;
import jalview.gui.PaintRefresher;
import jalview.gui.PopupMenu;
import jalview.gui.Preferences;
import jalview.util.BrowserLauncher;
import jalview.util.UrlLink;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class IdPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected IdCanvas idCanvas;
    protected AlignViewport av;
    protected AlignmentPanel alignPanel;
    ScrollThread scrollThread = null;
    int offy;
    int lastid = -1;
    boolean mouseDragging = false;

    public IdPanel(AlignViewport av, AlignmentPanel parent) {
        this.av = av;
        this.alignPanel = parent;
        this.idCanvas = new IdCanvas(av);
        this.setLayout(new BorderLayout());
        this.add((Component)this.idCanvas, "Center");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void mouseMoved(MouseEvent e) {
        int seq = Math.max(0, this.alignPanel.seqPanel.findSeq(e));
        if (seq > -1 && seq < this.av.alignment.getHeight()) {
            SequenceFeature[] features;
            DBRefEntry[] dbrefs;
            String tmp;
            SequenceI sequence = this.av.alignment.getSequenceAt(seq);
            StringBuffer tip = new StringBuffer();
            tip.append("<i>");
            int maxWidth = 0;
            if (sequence.getDescription() != null) {
                tmp = sequence.getDescription();
                tip.append("<br>" + tmp);
                maxWidth = Math.max(maxWidth, tmp.length());
            }
            if ((dbrefs = sequence.getDatasetSequence().getDBRef()) != null) {
                for (int i = 0; i < dbrefs.length; ++i) {
                    tip.append("<br>");
                    tmp = dbrefs[i].getSource() + " " + dbrefs[i].getAccessionId();
                    tip.append(tmp);
                    maxWidth = Math.max(maxWidth, tmp.length());
                }
            }
            if ((features = sequence.getDatasetSequence().getSequenceFeatures()) != null) {
                for (int i = 0; i < features.length; ++i) {
                    if (features[i].begin != 0 || features[i].end != 0) continue;
                    tmp = features[i].featureGroup + " " + features[i].getType() + " " + features[i].description;
                    tip.append("<br>" + tmp);
                    maxWidth = Math.max(maxWidth, tmp.length());
                }
            }
            if (maxWidth > 60) {
                tip.insert(0, "<table width=350 border=0><tr><td><i>");
                tip.append("</i></td></tr></table>");
            }
            tip.append("</html>");
            this.setToolTipText("<html>" + sequence.getDisplayId(true) + tip.toString());
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseDragging = true;
        int seq = Math.max(0, this.alignPanel.seqPanel.findSeq(e));
        if (seq < this.lastid) {
            this.selectSeqs(this.lastid - 1, seq);
        } else if (seq > this.lastid) {
            this.selectSeqs(this.lastid + 1, seq);
        }
        this.lastid = seq;
        this.alignPanel.paintAlignment(true);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        e.consume();
        if (e.getWheelRotation() > 0) {
            this.alignPanel.scrollUp(false);
        } else {
            this.alignPanel.scrollUp(true);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        Vector links = Preferences.sequenceURLLinks;
        if (links == null || links.size() < 1) {
            return;
        }
        int seq = this.alignPanel.seqPanel.findSeq(e);
        String url = null;
        int i = 0;
        String id = this.av.getAlignment().getSequenceAt(seq).getName();
        while (url == null && i < links.size()) {
            url = links.elementAt(i++).toString();
            UrlLink urlLink = null;
            try {
                urlLink = new UrlLink(url);
            }
            catch (Exception foo) {
                Cache.log.error((Object)("Exception for URLLink '" + url + "'"), (Throwable)foo);
                url = null;
                continue;
            }
            if (!urlLink.isValid()) {
                Cache.log.error((Object)urlLink.getInvalidMessage());
                url = null;
                continue;
            }
            String[] urls = urlLink.makeUrls(id, true);
            if (urls == null || urls[0] == null || urls[0].length() < 4) {
                url = null;
                continue;
            }
            url = urls[1];
        }
        try {
            BrowserLauncher.openURL(url);
        }
        catch (Exception ex) {
            JOptionPane.showInternalMessageDialog(Desktop.desktop, "Unixers: Couldn't find default web browser.\nAdd the full path to your browser in Preferences.", "Web browser not found", 2);
            ex.printStackTrace();
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (this.scrollThread != null) {
            this.scrollThread.running = false;
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.av.getWrapAlignment()) {
            return;
        }
        if (this.mouseDragging && e.getY() < 0 && this.av.getStartSeq() > 0) {
            this.scrollThread = new ScrollThread(true);
        }
        if (this.mouseDragging && e.getY() >= this.getHeight() && this.av.alignment.getHeight() > this.av.getEndSeq()) {
            this.scrollThread = new ScrollThread(false);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() == 2) {
            return;
        }
        int seq = this.alignPanel.seqPanel.findSeq(e);
        if (SwingUtilities.isRightMouseButton(e)) {
            PopupMenu pop = new PopupMenu(this.alignPanel, (Sequence)this.av.getAlignment().getSequenceAt(seq), Preferences.sequenceURLLinks);
            pop.show(this, e.getX(), e.getY());
            return;
        }
        if (this.av.getSelectionGroup() == null || !e.isControlDown() && !e.isShiftDown() && this.av.getSelectionGroup() != null) {
            this.av.setSelectionGroup(new SequenceGroup());
            this.av.getSelectionGroup().setStartRes(0);
            this.av.getSelectionGroup().setEndRes(this.av.alignment.getWidth() - 1);
        }
        if (e.isShiftDown() && this.lastid != -1) {
            this.selectSeqs(this.lastid, seq);
        } else {
            this.selectSeq(seq);
        }
        this.alignPanel.paintAlignment(true);
    }

    void selectSeq(int seq) {
        this.lastid = seq;
        SequenceI pickedSeq = this.av.getAlignment().getSequenceAt(seq);
        this.av.getSelectionGroup().addOrRemove(pickedSeq, true);
    }

    void selectSeqs(int start, int end) {
        if (this.av.getSelectionGroup() == null) {
            return;
        }
        if (end >= this.av.getAlignment().getHeight()) {
            end = this.av.getAlignment().getHeight() - 1;
        }
        this.lastid = start;
        if (end < start) {
            int tmp = start;
            start = end;
            this.lastid = end = tmp;
        }
        for (int i = start; i <= end; ++i) {
            this.av.getSelectionGroup().addSequence(this.av.getAlignment().getSequenceAt(i), true);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.scrollThread != null) {
            this.scrollThread.running = false;
        }
        this.mouseDragging = false;
        PaintRefresher.Refresh(this, this.av.getSequenceSetId());
    }

    public void highlightSearchResults(Vector found) {
        this.idCanvas.setHighlighted(found);
        if (found == null) {
            return;
        }
        int index = this.av.alignment.findIndex((SequenceI)found.get(0));
        if (this.av.getStartSeq() > index || this.av.getEndSeq() < index) {
            this.alignPanel.setScrollValues(this.av.getStartRes(), index);
        }
    }

    class ScrollThread
    extends Thread {
        boolean running = false;
        boolean up = true;

        public ScrollThread(boolean up) {
            this.up = up;
            this.start();
        }

        public void stopScrolling() {
            this.running = false;
        }

        public void run() {
            this.running = true;
            while (this.running) {
                if (IdPanel.this.alignPanel.scrollUp(this.up)) {
                    int seq = IdPanel.this.av.getStartSeq();
                    if (!this.up) {
                        seq = IdPanel.this.av.getEndSeq();
                    }
                    if (seq < IdPanel.this.lastid) {
                        IdPanel.this.selectSeqs(IdPanel.this.lastid - 1, seq);
                    } else if (seq > IdPanel.this.lastid) {
                        IdPanel.this.selectSeqs(IdPanel.this.lastid + 1, seq);
                    }
                    IdPanel.this.lastid = seq;
                } else {
                    this.running = false;
                }
                IdPanel.this.alignPanel.paintAlignment(false);
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

