/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import MCview.PDBfile;
import jalview.analysis.AAFrequency;
import jalview.analysis.Conservation;
import jalview.bin.Cache;
import jalview.commands.ChangeCaseCommand;
import jalview.commands.EditCommand;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignmentPanel;
import jalview.gui.AppJmol;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.EditNameDialog;
import jalview.gui.PaintRefresher;
import jalview.gui.SliderPanel;
import jalview.gui.TextColourChooser;
import jalview.gui.UserDefinedColours;
import jalview.io.AppletFormatAdapter;
import jalview.io.FormatAdapter;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.schemes.AnnotationColourGradient;
import jalview.schemes.Blosum62ColourScheme;
import jalview.schemes.BuriedColourScheme;
import jalview.schemes.ClustalxColourScheme;
import jalview.schemes.HelixColourScheme;
import jalview.schemes.HydrophobicColourScheme;
import jalview.schemes.NucleotideColourScheme;
import jalview.schemes.PIDColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.schemes.StrandColourScheme;
import jalview.schemes.TaylorColourScheme;
import jalview.schemes.TurnColourScheme;
import jalview.schemes.UserColourScheme;
import jalview.schemes.ZappoColourScheme;
import jalview.structure.StructureSelectionManager;
import jalview.util.BrowserLauncher;
import jalview.util.DBRefUtils;
import jalview.util.UrlLink;
import jalview.ws.DBRefFetcher;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class PopupMenu
extends JPopupMenu {
    JMenu groupMenu = new JMenu();
    JMenuItem groupName = new JMenuItem();
    protected JRadioButtonMenuItem clustalColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem zappoColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem taylorColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem hydrophobicityColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem helixColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem strandColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem turnColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem buriedColour = new JRadioButtonMenuItem();
    protected JCheckBoxMenuItem abovePIDColour = new JCheckBoxMenuItem();
    protected JRadioButtonMenuItem userDefinedColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem PIDColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem BLOSUM62Colour = new JRadioButtonMenuItem();
    JRadioButtonMenuItem noColourmenuItem = new JRadioButtonMenuItem();
    protected JCheckBoxMenuItem conservationMenuItem = new JCheckBoxMenuItem();
    AlignmentPanel ap;
    JMenu sequenceMenu = new JMenu();
    JMenuItem sequenceName = new JMenuItem();
    Sequence sequence;
    JMenuItem unGroupMenuItem = new JMenuItem();
    JMenuItem outline = new JMenuItem();
    JRadioButtonMenuItem nucleotideMenuItem = new JRadioButtonMenuItem();
    JMenu colourMenu = new JMenu();
    JCheckBoxMenuItem showBoxes = new JCheckBoxMenuItem();
    JCheckBoxMenuItem showText = new JCheckBoxMenuItem();
    JCheckBoxMenuItem showColourText = new JCheckBoxMenuItem();
    JMenu editMenu = new JMenu();
    JMenuItem cut = new JMenuItem();
    JMenuItem copy = new JMenuItem();
    JMenuItem upperCase = new JMenuItem();
    JMenuItem lowerCase = new JMenuItem();
    JMenuItem toggle = new JMenuItem();
    JMenu pdbMenu = new JMenu();
    JMenuItem pdbFromFile = new JMenuItem();
    JMenuItem enterPDB = new JMenuItem();
    JMenuItem discoverPDB = new JMenuItem();
    JMenu outputMenu = new JMenu();
    JMenuItem sequenceFeature = new JMenuItem();
    JMenuItem textColour = new JMenuItem();
    JMenu jMenu1 = new JMenu();
    JMenu structureMenu = new JMenu();
    JMenu viewStructureMenu = new JMenu();
    JMenuItem editSequence = new JMenuItem();

    public PopupMenu(final AlignmentPanel ap, Sequence seq, Vector links) {
        SequenceGroup sg;
        this.ap = ap;
        this.sequence = seq;
        ButtonGroup colours = new ButtonGroup();
        colours.add(this.noColourmenuItem);
        colours.add(this.clustalColour);
        colours.add(this.zappoColour);
        colours.add(this.taylorColour);
        colours.add(this.hydrophobicityColour);
        colours.add(this.helixColour);
        colours.add(this.strandColour);
        colours.add(this.turnColour);
        colours.add(this.buriedColour);
        colours.add(this.abovePIDColour);
        colours.add(this.userDefinedColour);
        colours.add(this.PIDColour);
        colours.add(this.BLOSUM62Colour);
        for (int i = 0; i < FormatAdapter.WRITEABLE_FORMATS.length; ++i) {
            JMenuItem item = new JMenuItem(FormatAdapter.WRITEABLE_FORMATS[i]);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PopupMenu.this.outputText_actionPerformed(e);
                }
            });
            this.outputMenu.add(item);
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (seq != null) {
            this.sequenceMenu.setText(this.sequence.getName());
            if (seq.getDatasetSequence().getPDBId() != null && seq.getDatasetSequence().getPDBId().size() > 0) {
                Enumeration e = seq.getDatasetSequence().getPDBId().elements();
                while (e.hasMoreElements()) {
                    final PDBEntry pdb = (PDBEntry)e.nextElement();
                    JMenuItem menuItem = new JMenuItem();
                    menuItem.setText(pdb.getId());
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Vector<SequenceI> seqs = new Vector<SequenceI>();
                            for (int i = 0; i < ap.av.alignment.getHeight(); ++i) {
                                Vector pdbs = ap.av.alignment.getSequenceAt(i).getDatasetSequence().getPDBId();
                                if (pdbs == null) continue;
                                for (int p = 0; p < pdbs.size(); ++p) {
                                    PDBEntry p1 = (PDBEntry)pdbs.elementAt(p);
                                    if (!p1.getId().equals(pdb.getId()) || seqs.contains(ap.av.alignment.getSequenceAt(i))) continue;
                                    seqs.addElement(ap.av.alignment.getSequenceAt(i));
                                }
                            }
                            SequenceI[] seqs2 = new SequenceI[seqs.size()];
                            seqs.toArray(seqs2);
                            new AppJmol(pdb, seqs2, null, ap);
                        }
                    });
                    this.viewStructureMenu.add(menuItem);
                }
            } else {
                this.structureMenu.remove(this.viewStructureMenu);
            }
            JMenuItem menuItem = new JMenuItem("Hide Sequences");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PopupMenu.this.hideSequences(false);
                }
            });
            this.add(menuItem);
            if (ap.av.getSelectionGroup() != null && ap.av.getSelectionGroup().getSize() > 1) {
                menuItem = new JMenuItem("Represent Group with " + seq.getName());
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PopupMenu.this.hideSequences(true);
                    }
                });
                this.sequenceMenu.add(menuItem);
            }
            if (ap.av.hasHiddenRows) {
                final int index = ap.av.alignment.findIndex(seq);
                if (ap.av.adjustForHiddenSeqs(index) - ap.av.adjustForHiddenSeqs(index - 1) > 1) {
                    menuItem = new JMenuItem("Reveal Sequences");
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            ap.av.showSequence(index);
                            if (ap.overviewPanel != null) {
                                ap.overviewPanel.updateOverviewImage();
                            }
                        }
                    });
                    this.add(menuItem);
                }
                menuItem = new JMenuItem("Reveal All");
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ap.av.showAllHiddenSeqs();
                        if (ap.overviewPanel != null) {
                            ap.overviewPanel.updateOverviewImage();
                        }
                    }
                });
                this.add(menuItem);
            }
        }
        if ((sg = ap.av.getSelectionGroup()) != null) {
            this.groupName.setText(sg.getName());
            if (sg.cs instanceof ZappoColourScheme) {
                this.zappoColour.setSelected(true);
            } else if (sg.cs instanceof TaylorColourScheme) {
                this.taylorColour.setSelected(true);
            } else if (sg.cs instanceof PIDColourScheme) {
                this.PIDColour.setSelected(true);
            } else if (sg.cs instanceof Blosum62ColourScheme) {
                this.BLOSUM62Colour.setSelected(true);
            } else if (sg.cs instanceof UserColourScheme) {
                this.userDefinedColour.setSelected(true);
            } else if (sg.cs instanceof HydrophobicColourScheme) {
                this.hydrophobicityColour.setSelected(true);
            } else if (sg.cs instanceof HelixColourScheme) {
                this.helixColour.setSelected(true);
            } else if (sg.cs instanceof StrandColourScheme) {
                this.strandColour.setSelected(true);
            } else if (sg.cs instanceof TurnColourScheme) {
                this.turnColour.setSelected(true);
            } else if (sg.cs instanceof BuriedColourScheme) {
                this.buriedColour.setSelected(true);
            } else if (sg.cs instanceof ClustalxColourScheme) {
                this.clustalColour.setSelected(true);
            } else {
                this.noColourmenuItem.setSelected(true);
            }
            if (sg.cs != null && sg.cs.conservationApplied()) {
                this.conservationMenuItem.setSelected(true);
            }
            this.showText.setSelected(sg.getDisplayText());
            this.showColourText.setSelected(sg.getColourText());
            this.showBoxes.setSelected(sg.getDisplayBoxes());
        } else {
            this.groupMenu.setVisible(false);
            this.editMenu.setVisible(false);
        }
        if (!ap.av.alignment.getGroups().contains(sg)) {
            this.unGroupMenuItem.setVisible(false);
        }
        if (seq == null) {
            this.sequenceMenu.setVisible(false);
            this.structureMenu.setVisible(false);
        }
        if (links != null && links.size() > 0) {
            JMenu linkMenu = new JMenu("Link");
            for (int i = 0; i < links.size(); ++i) {
                String link = links.elementAt(i).toString();
                UrlLink urlLink = null;
                try {
                    urlLink = new UrlLink(link);
                }
                catch (Exception foo) {
                    Cache.log.error((Object)("Exception for URLLink '" + link + "'"), (Throwable)foo);
                    continue;
                }
                if (!urlLink.isValid()) {
                    Cache.log.error((Object)urlLink.getInvalidMessage());
                    continue;
                }
                String label = urlLink.getLabel();
                if (urlLink.isDynamic()) {
                    String[] urls;
                    DBRefEntry[] dbr = DBRefUtils.selectRefs(seq.getDBRef(), new String[]{urlLink.getTarget()});
                    String id = seq.getName();
                    if (dbr != null) {
                        for (int r = 0; r < dbr.length; ++r) {
                            String[] urls2;
                            if (id != null && dbr[r].getAccessionId().equals(id)) {
                                id = null;
                            }
                            if ((urls2 = urlLink.makeUrls(dbr[r].getAccessionId(), true)) == null) continue;
                            for (int u = 0; u < urls2.length; u += 2) {
                                this.addshowLink(linkMenu, label + "|" + urls2[u], urls2[u + 1]);
                            }
                        }
                    }
                    if (id == null || (urls = urlLink.makeUrls(id, true)) == null) continue;
                    for (int u = 0; u < urls.length; u += 2) {
                        this.addshowLink(linkMenu, label, urls[u + 1]);
                    }
                    continue;
                }
                this.addshowLink(linkMenu, label, urlLink.getUrl_prefix());
            }
            if (this.sequence != null) {
                this.sequenceMenu.add(linkMenu);
            } else {
                this.add(linkMenu);
            }
        }
    }

    private void addshowLink(JMenu linkMenu, String label, final String url) {
        JMenuItem item = new JMenuItem(label);
        item.setToolTipText("open URL: " + url);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    public void run() {
                        PopupMenu.this.showLink(url);
                    }
                }).start();
            }
        });
        linkMenu.add(item);
    }

    private void jbInit() throws Exception {
        this.groupMenu.setText("Group");
        this.groupMenu.setText("Selection");
        this.groupName.setText("Name");
        this.groupName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.groupName_actionPerformed();
            }
        });
        this.sequenceMenu.setText("Sequence");
        this.sequenceName.setText("Edit Name/Description");
        this.sequenceName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.sequenceName_actionPerformed();
            }
        });
        this.PIDColour.setFocusPainted(false);
        this.unGroupMenuItem.setText("Remove Group");
        this.unGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.unGroupMenuItem_actionPerformed();
            }
        });
        this.outline.setText("Border colour");
        this.outline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.outline_actionPerformed();
            }
        });
        this.nucleotideMenuItem.setText("Nucleotide");
        this.nucleotideMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.nucleotideMenuItem_actionPerformed();
            }
        });
        this.colourMenu.setText("Group Colour");
        this.showBoxes.setText("Boxes");
        this.showBoxes.setState(true);
        this.showBoxes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.showBoxes_actionPerformed();
            }
        });
        this.showText.setText("Text");
        this.showText.setState(true);
        this.showText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.showText_actionPerformed();
            }
        });
        this.showColourText.setText("Colour Text");
        this.showColourText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.showColourText_actionPerformed();
            }
        });
        this.editMenu.setText("Edit");
        this.cut.setText("Cut");
        this.cut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.cut_actionPerformed();
            }
        });
        this.upperCase.setText("To Upper Case");
        this.upperCase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.changeCase(e);
            }
        });
        this.copy.setText("Copy");
        this.copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.copy_actionPerformed();
            }
        });
        this.lowerCase.setText("To Lower Case");
        this.lowerCase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.changeCase(e);
            }
        });
        this.toggle.setText("Toggle Case");
        this.toggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.changeCase(e);
            }
        });
        this.pdbMenu.setText("Associate Structure with Sequence");
        this.pdbFromFile.setText("From File");
        this.pdbFromFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.pdbFromFile_actionPerformed();
            }
        });
        this.enterPDB.setText("Enter PDB Id");
        this.enterPDB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.enterPDB_actionPerformed();
            }
        });
        this.discoverPDB.setText("Discover PDB ids");
        this.discoverPDB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.discoverPDB_actionPerformed();
            }
        });
        this.outputMenu.setText("Output to Textbox...");
        this.sequenceFeature.setText("Create Sequence Feature");
        this.sequenceFeature.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.sequenceFeature_actionPerformed();
            }
        });
        this.textColour.setText("Text Colour");
        this.textColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.textColour_actionPerformed();
            }
        });
        this.jMenu1.setText("Group");
        this.structureMenu.setText("Structure");
        this.viewStructureMenu.setText("View Structure");
        this.editSequence.setText("Edit Sequence...");
        this.editSequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PopupMenu.this.editSequence_actionPerformed(actionEvent);
            }
        });
        this.add(this.groupMenu);
        this.add(this.sequenceMenu);
        this.add(this.structureMenu);
        this.groupMenu.add(this.editMenu);
        this.groupMenu.add(this.outputMenu);
        this.groupMenu.add(this.sequenceFeature);
        this.groupMenu.add(this.jMenu1);
        this.sequenceMenu.add(this.sequenceName);
        this.colourMenu.add(this.textColour);
        this.colourMenu.add(this.noColourmenuItem);
        this.colourMenu.add(this.clustalColour);
        this.colourMenu.add(this.BLOSUM62Colour);
        this.colourMenu.add(this.PIDColour);
        this.colourMenu.add(this.zappoColour);
        this.colourMenu.add(this.taylorColour);
        this.colourMenu.add(this.hydrophobicityColour);
        this.colourMenu.add(this.helixColour);
        this.colourMenu.add(this.strandColour);
        this.colourMenu.add(this.turnColour);
        this.colourMenu.add(this.buriedColour);
        this.colourMenu.add(this.nucleotideMenuItem);
        this.colourMenu.add(this.userDefinedColour);
        if (UserDefinedColours.getUserColourSchemes() != null) {
            Enumeration userColours = UserDefinedColours.getUserColourSchemes().keys();
            while (userColours.hasMoreElements()) {
                JMenuItem item = new JMenuItem(userColours.nextElement().toString());
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        PopupMenu.this.userDefinedColour_actionPerformed(evt);
                    }
                });
                this.colourMenu.add(item);
            }
        }
        this.colourMenu.addSeparator();
        this.colourMenu.add(this.abovePIDColour);
        this.colourMenu.add(this.conservationMenuItem);
        this.editMenu.add(this.copy);
        this.editMenu.add(this.cut);
        this.editMenu.add(this.editSequence);
        this.editMenu.add(this.upperCase);
        this.editMenu.add(this.lowerCase);
        this.editMenu.add(this.toggle);
        this.pdbMenu.add(this.pdbFromFile);
        this.pdbMenu.add(this.enterPDB);
        this.pdbMenu.add(this.discoverPDB);
        this.jMenu1.add(this.groupName);
        this.jMenu1.add(this.unGroupMenuItem);
        this.jMenu1.add(this.colourMenu);
        this.jMenu1.add(this.showBoxes);
        this.jMenu1.add(this.showText);
        this.jMenu1.add(this.showColourText);
        this.jMenu1.add(this.outline);
        this.structureMenu.add(this.pdbMenu);
        this.structureMenu.add(this.viewStructureMenu);
        this.noColourmenuItem.setText("None");
        this.noColourmenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.noColourmenuItem_actionPerformed();
            }
        });
        this.clustalColour.setText("Clustalx colours");
        this.clustalColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.clustalColour_actionPerformed();
            }
        });
        this.zappoColour.setText("Zappo");
        this.zappoColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.zappoColour_actionPerformed();
            }
        });
        this.taylorColour.setText("Taylor");
        this.taylorColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.taylorColour_actionPerformed();
            }
        });
        this.hydrophobicityColour.setText("Hydrophobicity");
        this.hydrophobicityColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.hydrophobicityColour_actionPerformed();
            }
        });
        this.helixColour.setText("Helix propensity");
        this.helixColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.helixColour_actionPerformed();
            }
        });
        this.strandColour.setText("Strand propensity");
        this.strandColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.strandColour_actionPerformed();
            }
        });
        this.turnColour.setText("Turn propensity");
        this.turnColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.turnColour_actionPerformed();
            }
        });
        this.buriedColour.setText("Buried Index");
        this.buriedColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.buriedColour_actionPerformed();
            }
        });
        this.abovePIDColour.setText("Above % Identity");
        this.abovePIDColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.abovePIDColour_actionPerformed();
            }
        });
        this.userDefinedColour.setText("User Defined...");
        this.userDefinedColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.userDefinedColour_actionPerformed(e);
            }
        });
        this.PIDColour.setText("Percentage Identity");
        this.PIDColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.PIDColour_actionPerformed();
            }
        });
        this.BLOSUM62Colour.setText("BLOSUM62");
        this.BLOSUM62Colour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.BLOSUM62Colour_actionPerformed();
            }
        });
        this.conservationMenuItem.setText("Conservation");
        this.conservationMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.conservationMenuItem_actionPerformed();
            }
        });
    }

    void refresh() {
        this.ap.paintAlignment(true);
        PaintRefresher.Refresh(this, this.ap.av.getSequenceSetId());
    }

    protected void clustalColour_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        sg.cs = new ClustalxColourScheme(sg.getSequences(this.ap.av.hiddenRepSequences), this.ap.av.alignment.getWidth());
        this.refresh();
    }

    protected void zappoColour_actionPerformed() {
        this.getGroup().cs = new ZappoColourScheme();
        this.refresh();
    }

    protected void taylorColour_actionPerformed() {
        this.getGroup().cs = new TaylorColourScheme();
        this.refresh();
    }

    protected void hydrophobicityColour_actionPerformed() {
        this.getGroup().cs = new HydrophobicColourScheme();
        this.refresh();
    }

    protected void helixColour_actionPerformed() {
        this.getGroup().cs = new HelixColourScheme();
        this.refresh();
    }

    protected void strandColour_actionPerformed() {
        this.getGroup().cs = new StrandColourScheme();
        this.refresh();
    }

    protected void turnColour_actionPerformed() {
        this.getGroup().cs = new TurnColourScheme();
        this.refresh();
    }

    protected void buriedColour_actionPerformed() {
        this.getGroup().cs = new BuriedColourScheme();
        this.refresh();
    }

    public void nucleotideMenuItem_actionPerformed() {
        this.getGroup().cs = new NucleotideColourScheme();
        this.refresh();
    }

    protected void abovePIDColour_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        if (sg.cs == null) {
            return;
        }
        if (this.abovePIDColour.isSelected()) {
            sg.cs.setConsensus(AAFrequency.calculate(sg.getSequences(this.ap.av.hiddenRepSequences), sg.getStartRes(), sg.getEndRes() + 1));
            int threshold = SliderPanel.setPIDSliderSource(this.ap, sg.cs, this.getGroup().getName());
            sg.cs.setThreshold(threshold, this.ap.av.getIgnoreGapsConsensus());
            SliderPanel.showPIDSlider();
        } else {
            sg.cs.setThreshold(0, this.ap.av.getIgnoreGapsConsensus());
        }
        this.refresh();
    }

    protected void userDefinedColour_actionPerformed(ActionEvent e) {
        SequenceGroup sg = this.getGroup();
        if (e.getActionCommand().equals("User Defined...")) {
            new UserDefinedColours(this.ap, sg);
        } else {
            UserColourScheme udc = (UserColourScheme)UserDefinedColours.getUserColourSchemes().get(e.getActionCommand());
            sg.cs = udc;
        }
        this.refresh();
    }

    protected void PIDColour_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        sg.cs = new PIDColourScheme();
        sg.cs.setConsensus(AAFrequency.calculate(sg.getSequences(this.ap.av.hiddenRepSequences), sg.getStartRes(), sg.getEndRes() + 1));
        this.refresh();
    }

    protected void BLOSUM62Colour_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        sg.cs = new Blosum62ColourScheme();
        sg.cs.setConsensus(AAFrequency.calculate(sg.getSequences(this.ap.av.hiddenRepSequences), sg.getStartRes(), sg.getEndRes() + 1));
        this.refresh();
    }

    protected void noColourmenuItem_actionPerformed() {
        this.getGroup().cs = null;
        this.refresh();
    }

    protected void conservationMenuItem_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        if (sg.cs == null) {
            return;
        }
        if (this.conservationMenuItem.isSelected()) {
            Conservation c = new Conservation("Group", ResidueProperties.propHash, 3, sg.getSequences(this.ap.av.hiddenRepSequences), sg.getStartRes(), sg.getEndRes() + 1);
            c.calculate();
            c.verdict(false, this.ap.av.ConsPercGaps);
            sg.cs.setConservation(c);
            SliderPanel.setConservationSlider(this.ap, sg.cs, sg.getName());
            SliderPanel.showConservationSlider();
        } else {
            sg.cs.setConservation(null);
        }
        this.refresh();
    }

    public void annotationMenuItem_actionPerformed(ActionEvent actionEvent) {
        SequenceGroup sg = this.getGroup();
        if (sg == null) {
            return;
        }
        AnnotationColourGradient acg = new AnnotationColourGradient(this.sequence.getAnnotation()[0], null, AnnotationColourGradient.NO_THRESHOLD);
        acg.predefinedColours = true;
        sg.cs = acg;
        this.refresh();
    }

    protected void groupName_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        EditNameDialog dialog = new EditNameDialog(sg.getName(), sg.getDescription(), "       Group Name ", "Group Description ", "Edit Group Name/Description");
        if (!dialog.accept) {
            return;
        }
        sg.setName(dialog.getName());
        sg.setDescription(dialog.getDescription());
    }

    SequenceGroup getGroup() {
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg != null) {
            this.ap.av.alignment.addGroup(sg);
        }
        return sg;
    }

    void sequenceName_actionPerformed() {
        EditNameDialog dialog = new EditNameDialog(this.sequence.getName(), this.sequence.getDescription(), "       Sequence Name ", "Sequence Description ", "Edit Sequence Name/Description");
        if (!dialog.accept) {
            return;
        }
        if (dialog.getName() != null) {
            if (dialog.getName().indexOf(" ") > -1) {
                JOptionPane.showMessageDialog(this.ap, "Spaces have been converted to \"_\"", "No spaces allowed in Sequence Name", 2);
            }
            this.sequence.setName(dialog.getName().replace(' ', '_'));
            this.ap.paintAlignment(false);
        }
        this.sequence.setDescription(dialog.getDescription());
        this.ap.av.firePropertyChange("alignment", null, this.ap.av.getAlignment().getSequences());
    }

    void unGroupMenuItem_actionPerformed() {
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        this.ap.av.alignment.deleteGroup(sg);
        this.ap.av.setSelectionGroup(null);
        this.refresh();
    }

    protected void outline_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        Color col = JColorChooser.showDialog(this, "Select Outline Colour", Color.BLUE);
        if (col != null) {
            sg.setOutlineColour(col);
        }
        this.refresh();
    }

    public void showBoxes_actionPerformed() {
        this.getGroup().setDisplayBoxes(this.showBoxes.isSelected());
        this.refresh();
    }

    public void showText_actionPerformed() {
        this.getGroup().setDisplayText(this.showText.isSelected());
        this.refresh();
    }

    public void showColourText_actionPerformed() {
        this.getGroup().setColourText(this.showColourText.isSelected());
        this.refresh();
    }

    public void showLink(String url) {
        try {
            BrowserLauncher.openURL(url);
        }
        catch (Exception ex) {
            JOptionPane.showInternalMessageDialog(Desktop.desktop, "Unixers: Couldn't find default web browser.\nAdd the full path to your browser in Preferences.", "Web browser not found", 2);
            ex.printStackTrace();
        }
    }

    void hideSequences(boolean representGroup) {
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg == null || sg.getSize() < 1) {
            this.ap.av.hideSequence(new SequenceI[]{this.sequence});
            return;
        }
        this.ap.av.setSelectionGroup(null);
        if (representGroup) {
            this.ap.av.hideRepSequences(this.sequence, sg);
            return;
        }
        int gsize = sg.getSize();
        SequenceI[] hseqs = new SequenceI[gsize];
        int index = 0;
        for (int i = 0; i < gsize; ++i) {
            hseqs[index++] = sg.getSequenceAt(i);
        }
        this.ap.av.hideSequence(hseqs);
    }

    public void copy_actionPerformed() {
        this.ap.alignFrame.copy_actionPerformed(null);
    }

    public void cut_actionPerformed() {
        this.ap.alignFrame.cut_actionPerformed(null);
    }

    void changeCase(ActionEvent e) {
        Object source = e.getSource();
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg != null) {
            int caseChange;
            String description;
            int[][] startEnd = this.ap.av.getVisibleRegionBoundaries(sg.getStartRes(), sg.getEndRes() + 1);
            if (source == this.toggle) {
                description = "Toggle Case";
                caseChange = ChangeCaseCommand.TOGGLE_CASE;
            } else if (source == this.upperCase) {
                description = "To Upper Case";
                caseChange = ChangeCaseCommand.TO_UPPER;
            } else {
                description = "To Lower Case";
                caseChange = ChangeCaseCommand.TO_LOWER;
            }
            ChangeCaseCommand caseCommand = new ChangeCaseCommand(description, sg.getSequencesAsArray(this.ap.av.hiddenRepSequences), startEnd, caseChange);
            this.ap.alignFrame.addHistoryItem(caseCommand);
            this.ap.av.firePropertyChange("alignment", null, this.ap.av.getAlignment().getSequences());
        }
    }

    public void outputText_actionPerformed(ActionEvent e) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        cap.setForInput(null);
        Desktop.addInternalFrame(cap, "Alignment output - " + e.getActionCommand(), 600, 500);
        String[] omitHidden = null;
        System.out.println("PROMPT USER HERE");
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        ColumnSelection csel = new ColumnSelection(this.ap.av.getColumnSelection());
        omitHidden = this.ap.av.getViewAsString(true);
        Alignment oal = new Alignment(this.ap.av.getSequenceSelection());
        AlignmentAnnotation[] nala = this.ap.av.alignment.getAlignmentAnnotation();
        for (int i = 0; i < nala.length; ++i) {
            AlignmentAnnotation na = nala[i];
            oal.addAnnotation(na);
        }
        cap.setText(new FormatAdapter().formatSequences(e.getActionCommand(), (AlignmentI)oal, omitHidden, csel, sg));
        oal = null;
    }

    public void pdbFromFile_actionPerformed() {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Select a PDB file");
        chooser.setToolTipText("Load a PDB file");
        int value = chooser.showOpenDialog(null);
        if (value == 0) {
            PDBEntry entry = new PDBEntry();
            String choice = chooser.getSelectedFile().getPath();
            Cache.setProperty("LAST_DIRECTORY", choice);
            try {
                PDBfile pdbfile = new PDBfile(choice, AppletFormatAdapter.FILE);
                if (pdbfile.id == null) {
                    String reply = JOptionPane.showInternalInputDialog(Desktop.desktop, "Couldn't find a PDB id in the file supplied.Please enter an Id to identify this structure.", "No PDB Id in File", 3);
                    if (reply == null) {
                        return;
                    }
                    entry.setId(reply);
                } else {
                    entry.setId(pdbfile.id);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            entry.setFile(choice);
            this.sequence.getDatasetSequence().addPDBId(entry);
        }
    }

    public void enterPDB_actionPerformed() {
        String id = JOptionPane.showInternalInputDialog(Desktop.desktop, "Enter PDB Id", "Enter PDB Id", 3);
        if (id != null && id.length() > 0) {
            PDBEntry entry = new PDBEntry();
            entry.setId(id.toUpperCase());
            this.sequence.getDatasetSequence().addPDBId(entry);
        }
    }

    public void discoverPDB_actionPerformed() {
        SequenceI[] sequenceIArray;
        if (this.ap.av.selectionGroup == null) {
            SequenceI[] sequenceIArray2 = new Sequence[1];
            sequenceIArray = sequenceIArray2;
            sequenceIArray2[0] = this.sequence;
        } else {
            sequenceIArray = this.ap.av.selectionGroup.getSequencesInOrder(this.ap.av.alignment);
        }
        final SequenceI[] sequences = sequenceIArray;
        Thread discpdb = new Thread(new Runnable(){

            public void run() {
                new DBRefFetcher(sequences, PopupMenu.this.ap.alignFrame).fetchDBRefs(false);
            }
        });
        discpdb.start();
    }

    public void sequenceFeature_actionPerformed() {
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg == null) {
            return;
        }
        int rsize = 0;
        int gSize = sg.getSize();
        SequenceI[] seqs = new SequenceI[gSize];
        SequenceFeature[] features = new SequenceFeature[gSize];
        for (int i = 0; i < gSize; ++i) {
            int end;
            int start = sg.getSequenceAt(i).findPosition(sg.getStartRes());
            if (start > (end = sg.findEndRes(sg.getSequenceAt(i)))) continue;
            seqs[rsize] = sg.getSequenceAt(i).getDatasetSequence();
            features[rsize] = new SequenceFeature(null, null, null, start, end, "Jalview");
            ++rsize;
        }
        SequenceI[] rseqs = new SequenceI[rsize];
        SequenceFeature[] tfeatures = new SequenceFeature[rsize];
        System.arraycopy(seqs, 0, rseqs, 0, rsize);
        System.arraycopy(features, 0, tfeatures, 0, rsize);
        features = tfeatures;
        seqs = rseqs;
        if (this.ap.seqPanel.seqCanvas.getFeatureRenderer().amendFeatures(seqs, features, true, this.ap)) {
            this.ap.alignFrame.showSeqFeatures.setSelected(true);
            this.ap.av.setShowSequenceFeatures(true);
            this.ap.highlightSearchResults(null);
        }
    }

    public void textColour_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        if (sg != null) {
            new TextColourChooser().chooseColour(this.ap, sg);
        }
    }

    public void colourByStructure(String pdbid) {
        Annotation[] anots = StructureSelectionManager.getStructureSelectionManager().colourSequenceFromStructure(this.sequence, pdbid);
        AlignmentAnnotation an = new AlignmentAnnotation("Structure", "Coloured by " + pdbid, anots);
        this.ap.av.alignment.addAnnotation(an);
        an.createSequenceMapping(this.sequence, 0, true);
        this.ap.av.alignment.setAnnotationIndex(an, 0);
        this.ap.adjustAnnotationHeight();
        this.sequence.addAlignmentAnnotation(an);
    }

    public void editSequence_actionPerformed(ActionEvent actionEvent) {
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg != null) {
            if (this.sequence == null) {
                this.sequence = (Sequence)sg.getSequenceAt(0);
            }
            EditNameDialog dialog = new EditNameDialog(this.sequence.getSequenceAsString(sg.getStartRes(), sg.getEndRes() + 1), null, "Edit Sequence ", null, "Edit Sequence");
            if (dialog.accept) {
                EditCommand editCommand = new EditCommand("Edit Sequences", 4, dialog.getName().replace(' ', this.ap.av.getGapCharacter()), sg.getSequencesAsArray(this.ap.av.hiddenRepSequences), sg.getStartRes(), sg.getEndRes() + 1, this.ap.av.alignment);
                this.ap.alignFrame.addHistoryItem(editCommand);
                this.ap.av.firePropertyChange("alignment", null, this.ap.av.getAlignment().getSequences());
            }
        }
    }
}

