/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.DasSourceBrowser;
import jalview.gui.Desktop;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.io.PIRFile;
import jalview.jbgui.GPreferences;
import jalview.jbgui.GSequenceLink;
import jalview.schemes.ColourSchemeProperty;
import jalview.util.BrowserLauncher;
import jalview.util.Platform;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Preferences
extends GPreferences {
    public static Vector sequenceURLLinks;
    Vector nameLinks;
    Vector urlLinks;
    JInternalFrame frame = new JInternalFrame();
    DasSourceBrowser dasSource;

    public Preferences() {
        int i;
        this.frame.setContentPane(this);
        this.dasSource = new DasSourceBrowser();
        this.dasPanel.add((Component)this.dasSource, "Center");
        int width = 500;
        int height = 420;
        if (new Platform().isAMac()) {
            width = 570;
            height = 460;
        }
        Desktop.addInternalFrame(this.frame, "Preferences", width, height);
        this.frame.setMinimumSize(new Dimension(width, height));
        this.seqLimit.setSelected(Cache.getDefault("SHOW_JVSUFFIX", true));
        this.rightAlign.setSelected(Cache.getDefault("RIGHT_ALIGN_IDS", false));
        this.fullScreen.setSelected(Cache.getDefault("SHOW_FULLSCREEN", false));
        this.annotations.setSelected(Cache.getDefault("SHOW_ANNOTATIONS", true));
        this.conservation.setEnabled(Cache.getDefault("SHOW_ANNOTATIONS", true));
        this.quality.setEnabled(Cache.getDefault("SHOW_ANNOTATIONS", true));
        this.identity.setEnabled(Cache.getDefault("SHOW_ANNOTATIONS", true));
        this.conservation.setSelected(Cache.getDefault("SHOW_CONSERVATION", true));
        this.quality.setSelected(Cache.getDefault("SHOW_QUALITY", true));
        this.identity.setSelected(Cache.getDefault("SHOW_IDENTITY", true));
        this.openoverv.setSelected(Cache.getDefault("SHOW_OVERVIEW", false));
        for (int i2 = 0; i2 < 13; ++i2) {
            this.colour.addItem(ColourSchemeProperty.getColourName(i2));
        }
        String string = Cache.getDefault("DEFAULT_COLOUR", "None");
        this.colour.setSelectedItem(string);
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (i = 0; i < fonts.length; ++i) {
            this.fontNameCB.addItem(fonts[i]);
        }
        for (i = 1; i < 31; ++i) {
            this.fontSizeCB.addItem(i + "");
        }
        this.fontStyleCB.addItem("plain");
        this.fontStyleCB.addItem("bold");
        this.fontStyleCB.addItem("italic");
        this.fontNameCB.setSelectedItem(Cache.getDefault("FONT_NAME", "SansSerif"));
        this.fontSizeCB.setSelectedItem(Cache.getDefault("FONT_SIZE", "10"));
        this.fontStyleCB.setSelectedItem(Cache.getDefault("FONT_STYLE", "0"));
        this.smoothFont.setSelected(Cache.getDefault("ANTI_ALIAS", false));
        this.idItalics.setSelected(Cache.getDefault("ID_ITALICS", true));
        this.wrap.setSelected(Cache.getDefault("WRAP_ALIGNMENT", false));
        this.gapSymbolCB.addItem("-");
        this.gapSymbolCB.addItem(".");
        this.gapSymbolCB.setSelectedItem(Cache.getDefault("GAP_SYMBOL", "-"));
        this.startupCheckbox.setSelected(Cache.getDefault("SHOW_STARTUP_FILE", true));
        this.startupFileTextfield.setText(Cache.getDefault("STARTUP_FILE", "http://www.jalview.org/examples/exampleFile_2_3.jar"));
        this.sortby.addItem("No sort");
        this.sortby.addItem("Id");
        this.sortby.addItem("Pairwise Identity");
        this.sortby.setSelectedItem(Cache.getDefault("SORT_ALIGNMENT", "No sort"));
        this.epsRendering.addItem("Prompt each time");
        this.epsRendering.addItem("Lineart");
        this.epsRendering.addItem("Text");
        this.epsRendering.setSelectedItem(Cache.getDefault("EPS_RENDERING", "Prompt each time"));
        this.blcjv.setSelected(Cache.getDefault("BLC_JVSUFFIX", true));
        this.clustaljv.setSelected(Cache.getDefault("CLUSTAL_JVSUFFIX", true));
        this.fastajv.setSelected(Cache.getDefault("FASTA_JVSUFFIX", true));
        this.msfjv.setSelected(Cache.getDefault("MSF_JVSUFFIX", true));
        this.pfamjv.setSelected(Cache.getDefault("PFAM_JVSUFFIX", true));
        this.pileupjv.setSelected(Cache.getDefault("PILEUP_JVSUFFIX", true));
        this.pirjv.setSelected(Cache.getDefault("PIR_JVSUFFIX", true));
        this.modellerOutput.setSelected(Cache.getDefault("PIR_MODELLER", false));
        this.autoCalculateConsCheck.setSelected(Cache.getDefault("AUTO_CALC_CONSENSUS", true));
        this.padGaps.setSelected(Cache.getDefault("PAD_GAPS", false));
        this.nameLinks = new Vector();
        this.urlLinks = new Vector();
        for (i = 0; i < sequenceURLLinks.size(); ++i) {
            String link = sequenceURLLinks.elementAt(i).toString();
            this.nameLinks.addElement(link.substring(0, link.indexOf("|")));
            this.urlLinks.addElement(link.substring(link.indexOf("|") + 1));
        }
        this.updateLinkData();
        this.useProxy.setSelected(Cache.getDefault("USE_PROXY", false));
        this.proxyServerTB.setEnabled(this.useProxy.isSelected());
        this.proxyPortTB.setEnabled(this.useProxy.isSelected());
        this.proxyServerTB.setText(Cache.getDefault("PROXY_SERVER", ""));
        this.proxyPortTB.setText(Cache.getDefault("PROXY_PORT", ""));
        this.defaultBrowser.setText(Cache.getDefault("DEFAULT_BROWSER", ""));
        this.usagestats.setSelected(Cache.getDefault("USAGESTATS", false));
        this.questionnaire.setSelected(Cache.getProperty("NOQUESTIONNAIRES") == null);
        this.versioncheck.setSelected(Cache.getDefault("VERSION_CHECK", true));
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void ok_actionPerformed(ActionEvent e) {
        Cache.applicationProperties.setProperty("SHOW_JVSUFFIX", Boolean.toString(this.seqLimit.isSelected()));
        Cache.applicationProperties.setProperty("RIGHT_ALIGN_IDS", Boolean.toString(this.rightAlign.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_FULLSCREEN", Boolean.toString(this.fullScreen.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_OVERVIEW", Boolean.toString(this.openoverv.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_ANNOTATIONS", Boolean.toString(this.annotations.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_CONSERVATION", Boolean.toString(this.conservation.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_QUALITY", Boolean.toString(this.quality.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_IDENTITY", Boolean.toString(this.identity.isSelected()));
        Cache.applicationProperties.setProperty("DEFAULT_COLOUR", this.colour.getSelectedItem().toString());
        Cache.applicationProperties.setProperty("GAP_SYMBOL", this.gapSymbolCB.getSelectedItem().toString());
        Cache.applicationProperties.setProperty("FONT_NAME", this.fontNameCB.getSelectedItem().toString());
        Cache.applicationProperties.setProperty("FONT_STYLE", this.fontStyleCB.getSelectedItem().toString());
        Cache.applicationProperties.setProperty("FONT_SIZE", this.fontSizeCB.getSelectedItem().toString());
        Cache.applicationProperties.setProperty("ID_ITALICS", Boolean.toString(this.idItalics.isSelected()));
        Cache.applicationProperties.setProperty("ANTI_ALIAS", Boolean.toString(this.smoothFont.isSelected()));
        Cache.applicationProperties.setProperty("WRAP_ALIGNMENT", Boolean.toString(this.wrap.isSelected()));
        Cache.applicationProperties.setProperty("STARTUP_FILE", this.startupFileTextfield.getText());
        Cache.applicationProperties.setProperty("SHOW_STARTUP_FILE", Boolean.toString(this.startupCheckbox.isSelected()));
        Cache.applicationProperties.setProperty("SORT_ALIGNMENT", this.sortby.getSelectedItem().toString());
        if (this.epsRendering.getSelectedItem().equals("Prompt each time")) {
            Cache.applicationProperties.remove("EPS_RENDERING");
        } else {
            Cache.applicationProperties.setProperty("EPS_RENDERING", this.epsRendering.getSelectedItem().toString());
        }
        if (this.defaultBrowser.getText().trim().length() < 1) {
            Cache.applicationProperties.remove("DEFAULT_BROWSER");
        } else {
            Cache.applicationProperties.setProperty("DEFAULT_BROWSER", this.defaultBrowser.getText());
        }
        BrowserLauncher.resetBrowser();
        if (this.nameLinks.size() > 0) {
            StringBuffer links = new StringBuffer();
            sequenceURLLinks = new Vector();
            for (int i = 0; i < this.nameLinks.size(); ++i) {
                sequenceURLLinks.addElement(this.nameLinks.elementAt(i) + "|" + this.urlLinks.elementAt(i));
                links.append(sequenceURLLinks.elementAt(i).toString());
                links.append("|");
            }
            links.setLength(links.length() - 1);
            Cache.applicationProperties.setProperty("SEQUENCE_LINKS", links.toString());
        } else {
            Cache.applicationProperties.remove("SEQUENCE_LINKS");
        }
        Cache.applicationProperties.setProperty("USE_PROXY", Boolean.toString(this.useProxy.isSelected()));
        if (this.proxyServerTB.getText().trim().length() < 1) {
            Cache.applicationProperties.remove("PROXY_SERVER");
        } else {
            Cache.applicationProperties.setProperty("PROXY_SERVER", this.proxyServerTB.getText());
        }
        if (this.proxyPortTB.getText().trim().length() < 1) {
            Cache.applicationProperties.remove("PROXY_PORT");
        } else {
            Cache.applicationProperties.setProperty("PROXY_PORT", this.proxyPortTB.getText());
        }
        if (this.useProxy.isSelected()) {
            System.setProperty("http.proxyHost", this.proxyServerTB.getText());
            System.setProperty("http.proxyPort", this.proxyPortTB.getText());
        } else {
            System.setProperty("http.proxyHost", "");
            System.setProperty("http.proxyPort", "");
        }
        Cache.setProperty("VERSION_CHECK", Boolean.toString(this.versioncheck.isSelected()));
        if (Cache.getProperty("USAGESTATS") != null || this.usagestats.isSelected()) {
            Cache.setProperty("USAGESTATS", Boolean.toString(this.usagestats.isSelected()));
        }
        if (!this.questionnaire.isSelected()) {
            Cache.setProperty("NOQUESTIONNAIRES", "true");
        } else {
            Cache.removeProperty("NOQUESTIONNAIRES");
        }
        Cache.applicationProperties.setProperty("BLC_JVSUFFIX", Boolean.toString(this.blcjv.isSelected()));
        Cache.applicationProperties.setProperty("CLUSTAL_JVSUFFIX", Boolean.toString(this.clustaljv.isSelected()));
        Cache.applicationProperties.setProperty("FASTA_JVSUFFIX", Boolean.toString(this.fastajv.isSelected()));
        Cache.applicationProperties.setProperty("MSF_JVSUFFIX", Boolean.toString(this.msfjv.isSelected()));
        Cache.applicationProperties.setProperty("PFAM_JVSUFFIX", Boolean.toString(this.pfamjv.isSelected()));
        Cache.applicationProperties.setProperty("PILEUP_JVSUFFIX", Boolean.toString(this.pileupjv.isSelected()));
        Cache.applicationProperties.setProperty("PIR_JVSUFFIX", Boolean.toString(this.pirjv.isSelected()));
        Cache.applicationProperties.setProperty("PIR_MODELLER", Boolean.toString(this.modellerOutput.isSelected()));
        PIRFile.useModellerOutput = this.modellerOutput.isSelected();
        Cache.applicationProperties.setProperty("AUTO_CALC_CONSENSUS", Boolean.toString(this.autoCalculateConsCheck.isSelected()));
        Cache.applicationProperties.setProperty("PAD_GAPS", Boolean.toString(this.padGaps.isSelected()));
        this.dasSource.saveProperties(Cache.applicationProperties);
        Cache.saveProperties();
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startupFileTextfield_mouseClicked() {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), new String[]{"fa, fasta, fastq", "aln", "pfam", "msf", "pir", "blc", "jar"}, new String[]{"Fasta", "Clustal", "PFAM", "MSF", "PIR", "BLC", "Jalview"}, Cache.getProperty("DEFAULT_FILE_FORMAT"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Select startup file");
        int value = chooser.showOpenDialog(this);
        if (value == 0) {
            Cache.applicationProperties.setProperty("DEFAULT_FILE_FORMAT", chooser.getSelectedFormat());
            this.startupFileTextfield.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void cancel_actionPerformed(ActionEvent e) {
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void annotations_actionPerformed(ActionEvent e) {
        this.conservation.setEnabled(this.annotations.isSelected());
        this.quality.setEnabled(this.annotations.isSelected());
        this.identity.setEnabled(this.annotations.isSelected());
    }

    public void newLink_actionPerformed(ActionEvent e) {
        GSequenceLink link = new GSequenceLink();
        boolean valid = false;
        while (!valid && JOptionPane.showInternalConfirmDialog(Desktop.desktop, link, "New sequence URL link", 2, -1, null) == 0) {
            if (!link.checkValid()) continue;
            this.nameLinks.addElement(link.getName());
            this.urlLinks.addElement(link.getURL());
            this.updateLinkData();
            valid = true;
        }
    }

    public void editLink_actionPerformed(ActionEvent e) {
        GSequenceLink link = new GSequenceLink();
        int index = this.linkNameList.getSelectedIndex();
        if (index == -1) {
            JOptionPane.showInternalMessageDialog(Desktop.desktop, "No link selected!", "No link selected", 2);
            return;
        }
        link.setName(this.nameLinks.elementAt(index).toString());
        link.setURL(this.urlLinks.elementAt(index).toString());
        boolean valid = false;
        while (!valid && JOptionPane.showInternalConfirmDialog(Desktop.desktop, link, "New sequence URL link", 2, -1, null) == 0) {
            if (!link.checkValid()) continue;
            this.nameLinks.setElementAt(link.getName(), index);
            this.urlLinks.setElementAt(link.getURL(), index);
            this.updateLinkData();
            valid = true;
        }
    }

    public void deleteLink_actionPerformed(ActionEvent e) {
        int index = this.linkNameList.getSelectedIndex();
        if (index == -1) {
            JOptionPane.showInternalMessageDialog(Desktop.desktop, "No link selected!", "No link selected", 2);
            return;
        }
        this.nameLinks.removeElementAt(index);
        this.urlLinks.removeElementAt(index);
        this.updateLinkData();
    }

    void updateLinkData() {
        this.linkNameList.setListData(this.nameLinks);
        this.linkURLList.setListData(this.urlLinks);
    }

    public void defaultBrowser_mouseClicked(MouseEvent e) {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle("Select default web browser");
        int value = chooser.showOpenDialog(this);
        if (value == 0) {
            this.defaultBrowser.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void jbInit() throws Exception {
    }

    static {
        String string = Cache.getDefault("SEQUENCE_LINKS", "SRS|http://srs.ebi.ac.uk/srsbin/cgi-bin/wgetz?-newId+(([uniprot-all:$SEQUENCE_ID$]))+-view+SwissEntry");
        sequenceURLLinks = new Vector();
        try {
            StringTokenizer st = new StringTokenizer(string, "|");
            while (st.hasMoreElements()) {
                String name = st.nextToken();
                String url = st.nextToken();
                int rxstart = url.indexOf("$SEQUENCE_ID$");
                while (rxstart == -1 && url.indexOf("/=$") == -1) {
                    url = url + "|" + st.nextToken();
                }
                sequenceURLLinks.addElement(name + "|" + url);
            }
        }
        catch (Exception ex) {
            System.out.println(ex + "\nError parsing sequence links");
        }
    }
}

