/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.commands.CommandI;
import jalview.commands.EditCommand;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.PaintRefresher;
import jalview.jbgui.GSliderPanel;
import jalview.util.Comparison;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class RedundancyPanel
extends GSliderPanel
implements Runnable {
    AlignFrame af;
    AlignmentPanel ap;
    Stack historyList = new Stack();
    float[] redundancy;
    SequenceI[] originalSequences;
    JInternalFrame frame;
    Vector redundantSeqs;

    public RedundancyPanel(final AlignmentPanel ap, AlignFrame af) {
        this.ap = ap;
        this.af = af;
        this.redundantSeqs = new Vector();
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RedundancyPanel.this.valueField.setText(RedundancyPanel.this.slider.getValue() + "");
                RedundancyPanel.this.sliderValueChanged();
            }
        });
        this.applyButton.setText("Remove");
        this.allGroupsCheck.setVisible(false);
        this.slider.setMinimum(0);
        this.slider.setMaximum(100);
        this.slider.setValue(100);
        Thread worker = new Thread(this);
        worker.start();
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        Desktop.addInternalFrame(this.frame, "Redundancy threshold selection", 400, 100, false);
        this.frame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent evt) {
                ap.idPanel.idCanvas.setHighlighted(null);
            }
        });
    }

    public void run() {
        int end;
        int start;
        JProgressBar progress = new JProgressBar();
        progress.setIndeterminate(true);
        this.southPanel.add((Component)progress, "South");
        this.label.setText("Calculating....");
        this.slider.setVisible(false);
        this.applyButton.setEnabled(false);
        this.valueField.setVisible(false);
        this.validate();
        String[] omitHidden = null;
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg != null && sg.getSize() >= 1) {
            this.originalSequences = sg.getSequencesInOrder(this.ap.av.alignment);
            start = sg.getStartRes();
            end = sg.getEndRes();
        } else {
            this.originalSequences = this.ap.av.alignment.getSequencesArray();
            start = 0;
            end = this.ap.av.alignment.getWidth();
        }
        int height = this.originalSequences.length;
        this.redundancy = new float[height];
        for (int i = 0; i < height; ++i) {
            this.redundancy[i] = 0.0f;
        }
        if (this.ap.av.hasHiddenColumns) {
            omitHidden = this.ap.av.getViewAsString(sg != null);
        }
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < i; ++j) {
                String seqj;
                String seqi;
                if (i == j) continue;
                if (omitHidden == null) {
                    seqi = this.originalSequences[i].getSequenceAsString(start, end);
                    seqj = this.originalSequences[j].getSequenceAsString(start, end);
                } else {
                    seqi = omitHidden[i];
                    seqj = omitHidden[j];
                }
                float pid = Comparison.PID(seqi, seqj);
                if (seqj.length() < seqi.length()) {
                    this.redundancy[j] = Math.max(pid, this.redundancy[j]);
                    continue;
                }
                this.redundancy[i] = Math.max(pid, this.redundancy[i]);
            }
        }
        progress.setIndeterminate(false);
        progress.setVisible(false);
        progress = null;
        this.label.setText("Enter the redundancy threshold");
        this.slider.setVisible(true);
        this.applyButton.setEnabled(true);
        this.valueField.setVisible(true);
        this.validate();
    }

    void sliderValueChanged() {
        if (this.redundancy == null) {
            return;
        }
        float value = this.slider.getValue();
        for (int i = 0; i < this.redundancy.length; ++i) {
            if (value > this.redundancy[i]) {
                this.redundantSeqs.remove(this.originalSequences[i]);
                continue;
            }
            if (this.redundantSeqs.contains(this.originalSequences[i])) continue;
            this.redundantSeqs.add(this.originalSequences[i]);
        }
        this.ap.idPanel.idCanvas.setHighlighted(this.redundantSeqs);
    }

    public void applyButton_actionPerformed(ActionEvent e) {
        Vector<SequenceI> del = new Vector<SequenceI>();
        this.undoButton.setEnabled(true);
        float value = this.slider.getValue();
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        for (int i = 0; i < this.redundancy.length; ++i) {
            if (!(value <= this.redundancy[i])) continue;
            del.addElement(this.originalSequences[i]);
        }
        if (del.size() > 0) {
            SequenceI[] deleted = new SequenceI[del.size()];
            int width = 0;
            for (int i = 0; i < del.size(); ++i) {
                deleted[i] = (SequenceI)del.elementAt(i);
                if (deleted[i].getLength() <= width) continue;
                width = deleted[i].getLength();
            }
            EditCommand cut = new EditCommand("Remove Redundancy", 2, deleted, 0, width, this.ap.av.alignment);
            for (int i = 0; i < del.size(); ++i) {
                this.ap.av.alignment.deleteSequence(deleted[i]);
                PaintRefresher.Refresh(this, this.ap.av.getSequenceSetId(), true, true);
                if (sg == null) continue;
                sg.deleteSequence(deleted[i], false);
            }
            this.historyList.push(cut);
            this.ap.alignFrame.addHistoryItem(cut);
            this.ap.av.firePropertyChange("alignment", null, this.ap.av.getAlignment().getSequences());
        }
    }

    public void undoButton_actionPerformed(ActionEvent e) {
        CommandI command = (CommandI)this.historyList.pop();
        command.undoCommand(this.af.getViewAlignments());
        if (this.ap.av.historyList.contains(command)) {
            this.ap.av.historyList.remove(command);
            this.af.updateEditMenuBar();
        }
        this.ap.paintAlignment(true);
        if (this.historyList.size() == 0) {
            this.undoButton.setEnabled(false);
        }
    }

    public void valueField_actionPerformed(ActionEvent e) {
        try {
            int i = Integer.parseInt(this.valueField.getText());
            this.slider.setValue(i);
        }
        catch (Exception ex) {
            this.valueField.setText(this.slider.getValue() + "");
        }
    }
}

