/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.commands.EditCommand;
import jalview.datamodel.SearchResults;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.PaintRefresher;
import jalview.gui.PopupMenu;
import jalview.gui.SeqCanvas;
import jalview.gui.SliderPanel;
import jalview.schemes.Blosum62ColourScheme;
import jalview.schemes.ClustalxColourScheme;
import jalview.schemes.PIDColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.structure.SequenceListener;
import jalview.structure.StructureSelectionManager;
import jalview.util.Comparison;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class SeqPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
SequenceListener {
    public SeqCanvas seqCanvas;
    public AlignmentPanel ap;
    protected int lastres;
    protected int startseq;
    protected AlignViewport av;
    ScrollThread scrollThread = null;
    boolean mouseDragging = false;
    boolean editingSeqs = false;
    boolean groupEditing = false;
    int oldSeq = -1;
    boolean changeEndSeq = false;
    boolean changeStartSeq = false;
    boolean changeEndRes = false;
    boolean changeStartRes = false;
    SequenceGroup stretchGroup = null;
    boolean remove = false;
    Point lastMousePress;
    boolean mouseWheelPressed = false;
    StringBuffer keyboardNo1;
    StringBuffer keyboardNo2;
    URL linkImageURL;
    StringBuffer tooltipText = new StringBuffer("<html>");
    String tmpString;
    EditCommand editCommand;
    StructureSelectionManager ssm;
    int startWrapBlock = -1;
    int wrappedBlock = -1;
    String lastMessage;
    String lastTooltip;

    public SeqPanel(AlignViewport av, AlignmentPanel ap) {
        this.linkImageURL = this.getClass().getResource("/images/link.gif");
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.av = av;
        this.setBackground(Color.white);
        this.seqCanvas = new SeqCanvas(ap);
        this.setLayout(new BorderLayout());
        this.add((Component)this.seqCanvas, "Center");
        this.ap = ap;
        if (!av.isDataset()) {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.addMouseWheelListener(this);
            this.ssm = StructureSelectionManager.getStructureSelectionManager();
            this.ssm.addStructureViewerListener(this);
        }
    }

    int findRes(MouseEvent evt) {
        int res = 0;
        int x = evt.getX();
        if (this.av.wrapAlignment) {
            int hgap = this.av.charHeight;
            if (this.av.scaleAboveWrapped) {
                hgap += this.av.charHeight;
            }
            int cHeight = this.av.getAlignment().getHeight() * this.av.charHeight + hgap + this.seqCanvas.getAnnotationHeight();
            int y = evt.getY();
            y -= hgap;
            x -= this.seqCanvas.LABEL_WEST;
            int cwidth = this.seqCanvas.getWrappedCanvasWidth(this.getWidth());
            if (cwidth < 1) {
                return 0;
            }
            this.wrappedBlock = y / cHeight;
            this.wrappedBlock += this.av.getStartRes() / cwidth;
            res = this.wrappedBlock * cwidth + x / this.av.getCharWidth();
        } else {
            res = x / this.av.getCharWidth() + this.av.getStartRes();
        }
        if (this.av.hasHiddenColumns) {
            res = this.av.getColumnSelection().adjustForHiddenColumns(res);
        }
        return res;
    }

    int findSeq(MouseEvent evt) {
        int seq = 0;
        int y = evt.getY();
        if (this.av.wrapAlignment) {
            int hgap = this.av.charHeight;
            if (this.av.scaleAboveWrapped) {
                hgap += this.av.charHeight;
            }
            int cHeight = this.av.getAlignment().getHeight() * this.av.charHeight + hgap + this.seqCanvas.getAnnotationHeight();
            seq = Math.min((y -= hgap) % cHeight / this.av.getCharHeight(), this.av.alignment.getHeight() - 1);
        } else {
            seq = Math.min(y / this.av.getCharHeight() + this.av.getStartSeq(), this.av.alignment.getHeight() - 1);
        }
        return seq;
    }

    SequenceFeature[] findFeaturesAtRes(SequenceI sequence, int res) {
        Vector<Object> tmp = new Vector<Object>();
        Object[] features = sequence.getSequenceFeatures();
        if (features != null) {
            for (int i = 0; i < features.length; ++i) {
                if (this.av.featuresDisplayed == null || !this.av.featuresDisplayed.containsKey(((SequenceFeature)features[i]).getType()) || ((SequenceFeature)features[i]).featureGroup != null && this.seqCanvas.fr.featureGroups != null && this.seqCanvas.fr.featureGroups.containsKey(((SequenceFeature)features[i]).featureGroup) && !((Boolean)this.seqCanvas.fr.featureGroups.get(((SequenceFeature)features[i]).featureGroup)).booleanValue() || ((SequenceFeature)features[i]).getBegin() > res || ((SequenceFeature)features[i]).getEnd() < res) continue;
                tmp.addElement(features[i]);
            }
        }
        features = new SequenceFeature[tmp.size()];
        tmp.copyInto(features);
        return features;
    }

    void endEditing() {
        if (this.editCommand != null && this.editCommand.getSize() > 0) {
            this.ap.alignFrame.addHistoryItem(this.editCommand);
            this.av.firePropertyChange("alignment", null, this.av.getAlignment().getSequences());
        }
        this.startseq = -1;
        this.lastres = -1;
        this.editingSeqs = false;
        this.groupEditing = false;
        this.keyboardNo1 = null;
        this.keyboardNo2 = null;
        this.editCommand = null;
    }

    void setCursorRow() {
        this.seqCanvas.cursorY = this.getKeyboardNo1() - 1;
        this.scrollToVisible();
    }

    void setCursorColumn() {
        this.seqCanvas.cursorX = this.getKeyboardNo1() - 1;
        this.scrollToVisible();
    }

    void setCursorRowAndColumn() {
        if (this.keyboardNo2 == null) {
            this.keyboardNo2 = new StringBuffer();
        } else {
            this.seqCanvas.cursorX = this.getKeyboardNo1() - 1;
            this.seqCanvas.cursorY = this.getKeyboardNo2() - 1;
            this.scrollToVisible();
        }
    }

    void setCursorPosition() {
        Sequence sequence = (Sequence)this.av.getAlignment().getSequenceAt(this.seqCanvas.cursorY);
        this.seqCanvas.cursorX = sequence.findIndex(this.getKeyboardNo1() - 1);
        this.scrollToVisible();
    }

    void moveCursor(int dx, int dy) {
        this.seqCanvas.cursorX += dx;
        this.seqCanvas.cursorY += dy;
        if (this.av.hasHiddenColumns && !this.av.colSel.isVisible(this.seqCanvas.cursorX)) {
            int original = this.seqCanvas.cursorX - dx;
            int maxWidth = this.av.alignment.getWidth();
            while (!this.av.colSel.isVisible(this.seqCanvas.cursorX) && this.seqCanvas.cursorX < maxWidth && this.seqCanvas.cursorX > 0) {
                this.seqCanvas.cursorX += dx;
            }
            if (this.seqCanvas.cursorX >= maxWidth || !this.av.colSel.isVisible(this.seqCanvas.cursorX)) {
                this.seqCanvas.cursorX = original;
            }
        }
        this.scrollToVisible();
    }

    void scrollToVisible() {
        if (this.seqCanvas.cursorX < 0) {
            this.seqCanvas.cursorX = 0;
        } else if (this.seqCanvas.cursorX > this.av.alignment.getWidth() - 1) {
            this.seqCanvas.cursorX = this.av.alignment.getWidth() - 1;
        }
        if (this.seqCanvas.cursorY < 0) {
            this.seqCanvas.cursorY = 0;
        } else if (this.seqCanvas.cursorY > this.av.alignment.getHeight() - 1) {
            this.seqCanvas.cursorY = this.av.alignment.getHeight() - 1;
        }
        this.endEditing();
        if (this.av.wrapAlignment) {
            this.ap.scrollToWrappedVisible(this.seqCanvas.cursorX);
        } else {
            while (this.seqCanvas.cursorY < this.av.startSeq) {
                this.ap.scrollUp(true);
            }
            while (this.seqCanvas.cursorY + 1 > this.av.endSeq) {
                this.ap.scrollUp(false);
            }
            if (!this.av.wrapAlignment) {
                while (this.seqCanvas.cursorX < this.av.colSel.adjustForHiddenColumns(this.av.startRes) && this.ap.scrollRight(false)) {
                }
                while (this.seqCanvas.cursorX > this.av.colSel.adjustForHiddenColumns(this.av.endRes) && this.ap.scrollRight(true)) {
                }
            }
        }
        this.setStatusMessage(this.av.alignment.getSequenceAt(this.seqCanvas.cursorY), this.seqCanvas.cursorX, this.seqCanvas.cursorY);
        this.seqCanvas.repaint();
    }

    void setSelectionAreaAtCursor(boolean topLeft) {
        SequenceGroup sg;
        Sequence sequence = (Sequence)this.av.getAlignment().getSequenceAt(this.seqCanvas.cursorY);
        if (this.av.getSelectionGroup() != null) {
            int i;
            sg = this.av.selectionGroup;
            int min = this.av.alignment.getHeight();
            int max = 0;
            for (i = 0; i < sg.getSize(); ++i) {
                int index = this.av.alignment.findIndex(sg.getSequenceAt(i));
                if (index > max) {
                    max = index;
                }
                if (index >= min) continue;
                min = index;
            }
            ++max;
            if (topLeft) {
                sg.setStartRes(this.seqCanvas.cursorX);
                if (sg.getEndRes() < this.seqCanvas.cursorX) {
                    sg.setEndRes(this.seqCanvas.cursorX);
                }
                min = this.seqCanvas.cursorY;
            } else {
                sg.setEndRes(this.seqCanvas.cursorX);
                if (sg.getStartRes() > this.seqCanvas.cursorX) {
                    sg.setStartRes(this.seqCanvas.cursorX);
                }
                max = this.seqCanvas.cursorY + 1;
            }
            if (min > max) {
                this.av.setSelectionGroup(null);
            } else {
                sg.getSequences(null).clear();
                for (i = min; i < max; ++i) {
                    sg.addSequence(this.av.alignment.getSequenceAt(i), false);
                }
            }
        }
        if (this.av.getSelectionGroup() == null) {
            sg = new SequenceGroup();
            sg.setStartRes(this.seqCanvas.cursorX);
            sg.setEndRes(this.seqCanvas.cursorX);
            sg.addSequence(sequence, false);
            this.av.setSelectionGroup(sg);
        }
        this.ap.paintAlignment(false);
    }

    void insertGapAtCursor(boolean group) {
        this.groupEditing = group;
        this.startseq = this.seqCanvas.cursorY;
        this.lastres = this.seqCanvas.cursorX;
        this.editSequence(true, this.seqCanvas.cursorX + this.getKeyboardNo1());
        this.endEditing();
    }

    void deleteGapAtCursor(boolean group) {
        this.groupEditing = group;
        this.startseq = this.seqCanvas.cursorY;
        this.lastres = this.seqCanvas.cursorX + this.getKeyboardNo1();
        this.editSequence(false, this.seqCanvas.cursorX);
        this.endEditing();
    }

    void numberPressed(char value) {
        if (this.keyboardNo1 == null) {
            this.keyboardNo1 = new StringBuffer();
        }
        if (this.keyboardNo2 != null) {
            this.keyboardNo2.append(value);
        } else {
            this.keyboardNo1.append(value);
        }
    }

    int getKeyboardNo1() {
        if (this.keyboardNo1 == null) {
            return 1;
        }
        int value = Integer.parseInt(this.keyboardNo1.toString());
        this.keyboardNo1 = null;
        return value;
    }

    int getKeyboardNo2() {
        if (this.keyboardNo2 == null) {
            return 1;
        }
        int value = Integer.parseInt(this.keyboardNo2.toString());
        this.keyboardNo2 = null;
        return value;
    }

    public void mouseReleased(MouseEvent evt) {
        this.mouseDragging = false;
        this.mouseWheelPressed = false;
        if (!this.editingSeqs) {
            this.doMouseReleasedDefineMode(evt);
            return;
        }
        this.endEditing();
    }

    public void mousePressed(MouseEvent evt) {
        this.lastMousePress = evt.getPoint();
        if (SwingUtilities.isMiddleMouseButton(evt)) {
            this.mouseWheelPressed = true;
            return;
        }
        if (evt.isShiftDown() || evt.isAltDown() || evt.isControlDown()) {
            if (evt.isAltDown() || evt.isControlDown()) {
                this.groupEditing = true;
            }
        } else {
            this.doMousePressedDefineMode(evt);
            return;
        }
        this.editingSeqs = true;
        int seq = this.findSeq(evt);
        int res = this.findRes(evt);
        if (seq < 0 || res < 0) {
            return;
        }
        if (seq < this.av.getAlignment().getHeight() && res < this.av.getAlignment().getSequenceAt(seq).getLength()) {
            this.startseq = seq;
            this.lastres = res;
        } else {
            this.startseq = -1;
            this.lastres = -1;
        }
    }

    public void mouseOverSequence(SequenceI sequence, int index, int pos) {
        String tmp = sequence.hashCode() + " " + index + " " + pos;
        if (this.lastMessage == null || !this.lastMessage.equals(tmp)) {
            this.ssm.mouseOverSequence(sequence, index, pos);
        }
        this.lastMessage = tmp;
    }

    public void highlightSequence(SearchResults results) {
        this.seqCanvas.highlightSearchResults(results);
    }

    public void updateColours(SequenceI seq, int index) {
        System.out.println("update the seqPanel colours");
    }

    public void mouseMoved(MouseEvent evt) {
        SequenceFeature[] features;
        if (this.editingSeqs) {
            this.mouseDragged(evt);
        }
        int res = this.findRes(evt);
        int seq = this.findSeq(evt);
        if (res < 0 || seq < 0 || seq >= this.av.getAlignment().getHeight()) {
            return;
        }
        SequenceI sequence = this.av.getAlignment().getSequenceAt(seq);
        if (res >= sequence.getLength()) {
            return;
        }
        int pos = this.setStatusMessage(sequence, res, seq);
        if (this.ssm != null && pos > -1) {
            this.mouseOverSequence(sequence, res, pos);
        }
        this.tooltipText.setLength(6);
        SequenceGroup[] groups = this.av.alignment.findAllGroups(sequence);
        if (groups != null) {
            for (int g = 0; g < groups.length; ++g) {
                if (groups[g].getStartRes() > res || groups[g].getEndRes() < res) continue;
                if (this.tooltipText.length() > 6) {
                    this.tooltipText.append("<br>");
                }
                if (!groups[g].getName().startsWith("JTreeGroup") && !groups[g].getName().startsWith("JGroup")) {
                    this.tooltipText.append(groups[g].getName());
                }
                if (groups[g].getDescription() == null) continue;
                this.tooltipText.append(": " + groups[g].getDescription());
            }
        }
        if (this.av.showSequenceFeatures && (features = this.findFeaturesAtRes(sequence.getDatasetSequence(), sequence.findPosition(res))) != null) {
            for (int i = 0; i < features.length; ++i) {
                String status;
                if (features[i].getType().equals("disulfide bond")) {
                    if (features[i].getBegin() != sequence.findPosition(res) && features[i].getEnd() != sequence.findPosition(res)) continue;
                    if (this.tooltipText.length() > 6) {
                        this.tooltipText.append("<br>");
                    }
                    this.tooltipText.append("disulfide bond " + features[i].getBegin() + ":" + features[i].getEnd());
                    if (features[i].links == null) continue;
                    this.tooltipText.append(" <img src=\"" + this.linkImageURL + "\">");
                    continue;
                }
                if (this.tooltipText.length() > 6) {
                    this.tooltipText.append("<br>");
                }
                this.tooltipText.append(features[i].getType() + " " + features[i].begin);
                if (features[i].begin != features[i].end) {
                    this.tooltipText.append(" " + features[i].end);
                }
                if (features[i].getDescription() != null && !features[i].description.equals(features[i].getType())) {
                    int endTag;
                    this.tmpString = features[i].getDescription();
                    int startTag = this.tmpString.toUpperCase().indexOf("<HTML>");
                    if (startTag > -1) {
                        this.tmpString = this.tmpString.substring(startTag + 6);
                    }
                    if ((endTag = this.tmpString.toUpperCase().indexOf("</BODY>")) > -1) {
                        this.tmpString = this.tmpString.substring(0, endTag);
                    }
                    if ((endTag = this.tmpString.toUpperCase().indexOf("</HTML>")) > -1) {
                        this.tmpString = this.tmpString.substring(0, endTag);
                    }
                    if (startTag > -1) {
                        this.tooltipText.append("; " + this.tmpString);
                    } else if (this.tmpString.indexOf("<") > -1 || this.tmpString.indexOf(">") > -1) {
                        this.tmpString = this.tmpString.replaceAll("<", "&lt;");
                        this.tmpString = this.tmpString.replaceAll(">", "&gt;");
                        this.tooltipText.append("; ");
                        this.tooltipText.append(this.tmpString);
                    } else {
                        this.tooltipText.append("; " + this.tmpString);
                    }
                }
                if (features[i].getValue("status") != null && (status = features[i].getValue("status").toString()).length() > 0) {
                    this.tooltipText.append("; (" + features[i].getValue("status") + ")");
                }
                if (features[i].links == null) continue;
                this.tooltipText.append(" <img src=\"" + this.linkImageURL + "\">");
            }
        }
        if (this.tooltipText.length() == 6) {
            this.setToolTipText(null);
        } else {
            this.tooltipText.append("</html>");
            if (this.lastTooltip == null || !this.lastTooltip.equals(this.tooltipText.toString())) {
                this.setToolTipText(this.tooltipText.toString());
            }
            this.lastTooltip = this.tooltipText.toString();
        }
    }

    int setStatusMessage(SequenceI sequence, int res, int seq) {
        int pos = -1;
        StringBuffer text = new StringBuffer("Sequence " + (seq + 1) + " ID: " + sequence.getName());
        Object obj = null;
        if (this.av.alignment.isNucleotide()) {
            obj = ResidueProperties.nucleotideName.get(sequence.getCharAt(res) + "");
            if (obj != null) {
                text.append(" Nucleotide: ");
            }
        } else {
            obj = ResidueProperties.aa2Triplet.get(sequence.getCharAt(res) + "");
            if (obj != null) {
                text.append("  Residue: ");
            }
        }
        if (obj != null) {
            pos = sequence.findPosition(res);
            if (obj != "") {
                text.append(obj + " (" + pos + ")");
            }
        }
        this.ap.alignFrame.statusBar.setText(text.toString());
        return pos;
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.mouseWheelPressed) {
            int oldWidth = this.av.charWidth;
            if (Math.abs((double)evt.getY() - this.lastMousePress.getY()) > Math.abs((double)evt.getX() - this.lastMousePress.getX())) {
                int fontSize = this.av.font.getSize();
                if ((double)evt.getY() < this.lastMousePress.getY()) {
                    --fontSize;
                } else if ((double)evt.getY() > this.lastMousePress.getY()) {
                    ++fontSize;
                }
                if (fontSize < 1) {
                    fontSize = 1;
                }
                this.av.setFont(new Font(this.av.font.getName(), this.av.font.getStyle(), fontSize));
                this.av.charWidth = oldWidth;
                this.ap.fontChanged();
            } else {
                if ((double)evt.getX() < this.lastMousePress.getX() && this.av.charWidth > 1) {
                    --this.av.charWidth;
                } else if ((double)evt.getX() > this.lastMousePress.getX()) {
                    ++this.av.charWidth;
                }
                this.ap.paintAlignment(false);
            }
            FontMetrics fm = this.getFontMetrics(this.av.getFont());
            this.av.validCharWidth = fm.charWidth('M') <= this.av.charWidth;
            this.lastMousePress = evt.getPoint();
            return;
        }
        if (!this.editingSeqs) {
            this.doMouseDraggedDefineMode(evt);
            return;
        }
        int res = this.findRes(evt);
        if (res < 0) {
            res = 0;
        }
        if (this.lastres == -1 || this.lastres == res) {
            return;
        }
        if (res < this.av.getAlignment().getWidth() && res < this.lastres) {
            this.editSequence(false, res);
        } else {
            this.editSequence(true, res);
        }
        this.mouseDragging = true;
        if (this.scrollThread != null) {
            this.scrollThread.setEvent(evt);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    synchronized void editSequence(boolean insertGap, int startres) {
        block48: {
            int max;
            SequenceI seq;
            block57: {
                int fixedRight;
                block56: {
                    int j;
                    SequenceI[] groupSeqs;
                    boolean fixedColumns;
                    block49: {
                        int g;
                        int groupSize;
                        block53: {
                            boolean blank;
                            SequenceGroup sg;
                            block52: {
                                block55: {
                                    block54: {
                                        block50: {
                                            block51: {
                                                int fixedLeft = -1;
                                                fixedRight = -1;
                                                fixedColumns = false;
                                                sg = this.av.getSelectionGroup();
                                                seq = this.av.alignment.getSequenceAt(this.startseq);
                                                if (!this.groupEditing && this.av.hasHiddenRows && this.av.hiddenRepSequences != null && this.av.hiddenRepSequences.containsKey(seq)) {
                                                    sg = (SequenceGroup)this.av.hiddenRepSequences.get(seq);
                                                    this.groupEditing = true;
                                                }
                                                StringBuffer message = new StringBuffer();
                                                if (this.groupEditing) {
                                                    message.append("Edit group:");
                                                    if (this.editCommand == null) {
                                                        this.editCommand = new EditCommand("Edit Group");
                                                    }
                                                } else {
                                                    message.append("Edit sequence: " + seq.getName());
                                                    String label = seq.getName();
                                                    if (label.length() > 10) {
                                                        label = label.substring(0, 10);
                                                    }
                                                    if (this.editCommand == null) {
                                                        this.editCommand = new EditCommand("Edit " + label);
                                                    }
                                                }
                                                if (insertGap) {
                                                    message.append(" insert ");
                                                } else {
                                                    message.append(" delete ");
                                                }
                                                message.append(Math.abs(startres - this.lastres) + " gaps.");
                                                this.ap.alignFrame.statusBar.setText(message.toString());
                                                if (this.groupEditing || sg != null && sg.getSequences(this.av.hiddenRepSequences).contains(seq)) {
                                                    fixedColumns = true;
                                                    if (sg == null) {
                                                        if (this.av.hiddenRepSequences == null || !this.av.hiddenRepSequences.containsKey(seq)) {
                                                            this.endEditing();
                                                            return;
                                                        }
                                                        sg = (SequenceGroup)this.av.hiddenRepSequences.get(seq);
                                                    }
                                                    fixedLeft = sg.getStartRes();
                                                    fixedRight = sg.getEndRes();
                                                    if (startres < fixedLeft && this.lastres >= fixedLeft || startres >= fixedLeft && this.lastres < fixedLeft || startres > fixedRight && this.lastres <= fixedRight || startres <= fixedRight && this.lastres > fixedRight) {
                                                        this.endEditing();
                                                        return;
                                                    }
                                                    if (fixedLeft > startres) {
                                                        fixedRight = fixedLeft - 1;
                                                        fixedLeft = 0;
                                                    } else if (fixedRight < startres) {
                                                        fixedLeft = fixedRight;
                                                        fixedRight = -1;
                                                    }
                                                }
                                                if (this.av.hasHiddenColumns) {
                                                    fixedColumns = true;
                                                    int y1 = this.av.getColumnSelection().getHiddenBoundaryLeft(startres);
                                                    int y2 = this.av.getColumnSelection().getHiddenBoundaryRight(startres);
                                                    if (insertGap && startres > y1 && this.lastres < y1 || !insertGap && startres < y2 && this.lastres > y2) {
                                                        this.endEditing();
                                                        return;
                                                    }
                                                    if (fixedLeft < y1 && (fixedRight > y2 || fixedRight == -1)) {
                                                        if (startres >= y2) {
                                                            fixedLeft = y2;
                                                        } else {
                                                            fixedRight = y2 - 1;
                                                        }
                                                    }
                                                }
                                                if (!this.groupEditing) break block50;
                                                Vector vseqs = sg.getSequences(this.av.hiddenRepSequences);
                                                groupSize = vseqs.size();
                                                groupSeqs = new SequenceI[groupSize];
                                                for (g = 0; g < groupSeqs.length; ++g) {
                                                    groupSeqs[g] = (SequenceI)vseqs.elementAt(g);
                                                }
                                                if (!insertGap) break block51;
                                                if (sg.getStartRes() == 0 && sg.getEndRes() == fixedRight && sg.getEndRes() == this.av.alignment.getWidth() - 1) {
                                                    sg.setEndRes(this.av.alignment.getWidth() + startres - this.lastres);
                                                    fixedRight = sg.getEndRes();
                                                }
                                                blank = false;
                                                break block52;
                                            }
                                            if (insertGap) break block49;
                                            break block53;
                                        }
                                        if (!insertGap) break block54;
                                        if (fixedColumns && fixedRight != -1) {
                                            for (int j2 = this.lastres; j2 < startres; ++j2) {
                                                this.insertChar(j2, new SequenceI[]{seq}, fixedRight);
                                            }
                                            break block48;
                                        } else {
                                            this.editCommand.appendEdit(0, new SequenceI[]{seq}, this.lastres, startres - this.lastres, this.av.alignment, true);
                                        }
                                        break block48;
                                    }
                                    if (!fixedColumns || fixedRight == -1) break block55;
                                    break block56;
                                }
                                max = 0;
                                break block57;
                            }
                            block2: while (fixedRight > this.lastres) {
                                blank = true;
                                g = 0;
                                while (true) {
                                    if (g < groupSize) {
                                    } else {
                                        int hwidth;
                                        if (!blank) {
                                            --fixedRight;
                                            continue block2;
                                        }
                                        if (blank) break block49;
                                        if (sg.getSize() != this.av.alignment.getHeight()) {
                                            this.endEditing();
                                            return;
                                        }
                                        if (this.av.hasHiddenColumns && startres < this.av.getColumnSelection().getHiddenBoundaryRight(startres)) {
                                            this.endEditing();
                                            return;
                                        }
                                        int alWidth = this.av.alignment.getWidth();
                                        if (this.av.hasHiddenRows && (hwidth = this.av.alignment.getHiddenSequences().getWidth()) > alWidth) {
                                            alWidth = hwidth;
                                        }
                                        sg.setEndRes(sg.getEndRes() + startres - this.lastres);
                                        fixedRight = alWidth + startres - this.lastres;
                                        break block49;
                                    }
                                    for (int j3 = 0; j3 < startres - this.lastres; ++j3) {
                                        if (Comparison.isGap(groupSeqs[g].getCharAt(fixedRight - j3))) continue;
                                        blank = false;
                                        break;
                                    }
                                    ++g;
                                }
                            }
                        }
                        for (g = 0; g < groupSize; ++g) {
                            for (j = startres; j < this.lastres; ++j) {
                                if (groupSeqs[g].getLength() <= j || Comparison.isGap(groupSeqs[g].getCharAt(j))) continue;
                                this.endEditing();
                                return;
                            }
                        }
                    }
                    if (insertGap) {
                        if (fixedColumns && fixedRight != -1) {
                            for (j = this.lastres; j < startres; ++j) {
                                this.insertChar(j, groupSeqs, fixedRight);
                            }
                            break block48;
                        } else {
                            this.editCommand.appendEdit(0, groupSeqs, startres, startres - this.lastres, this.av.alignment, true);
                        }
                        break block48;
                    } else if (fixedColumns && fixedRight != -1) {
                        for (j = this.lastres; j > startres; --j) {
                            this.deleteChar(startres, groupSeqs, fixedRight);
                        }
                        break block48;
                    } else {
                        this.editCommand.appendEdit(1, groupSeqs, startres, this.lastres - startres, this.av.alignment, true);
                    }
                    break block48;
                }
                for (int j = this.lastres; j > startres; --j) {
                    if (!Comparison.isGap(seq.getCharAt(startres))) {
                        this.endEditing();
                        break block48;
                    }
                    this.deleteChar(startres, new SequenceI[]{seq}, fixedRight);
                }
                break block48;
            }
            for (int m = startres; m < this.lastres && Comparison.isGap(seq.getCharAt(m)); ++max, ++m) {
            }
            if (max > 0) {
                this.editCommand.appendEdit(1, new SequenceI[]{seq}, startres, max, this.av.alignment, true);
            }
        }
        this.lastres = startres;
        this.seqCanvas.repaint();
    }

    void insertChar(int j, SequenceI[] seq, int fixedColumn) {
        int blankColumn = fixedColumn;
        for (int s = 0; s < seq.length; ++s) {
            for (blankColumn = fixedColumn; blankColumn > j && !Comparison.isGap(seq[s].getCharAt(blankColumn)); --blankColumn) {
            }
            if (blankColumn > j) continue;
            blankColumn = fixedColumn;
            this.endEditing();
            return;
        }
        this.editCommand.appendEdit(1, seq, blankColumn, 1, this.av.alignment, true);
        this.editCommand.appendEdit(0, seq, j, 1, this.av.alignment, true);
    }

    void deleteChar(int j, SequenceI[] seq, int fixedColumn) {
        this.editCommand.appendEdit(1, seq, j, 1, this.av.alignment, true);
        this.editCommand.appendEdit(0, seq, fixedColumn, 1, this.av.alignment, true);
    }

    public void mouseEntered(MouseEvent e) {
        if (this.oldSeq < 0) {
            this.oldSeq = 0;
        }
        if (this.scrollThread != null) {
            this.scrollThread.running = false;
            this.scrollThread = null;
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.av.getWrapAlignment()) {
            return;
        }
        if (this.mouseDragging) {
            this.scrollThread = new ScrollThread();
        }
    }

    public void mouseClicked(MouseEvent evt) {
        SequenceI sequence = this.av.alignment.getSequenceAt(this.findSeq(evt));
        if (evt.getClickCount() > 1) {
            SequenceFeature[] features;
            if (this.av.getSelectionGroup().getSize() == 1 && this.av.getSelectionGroup().getEndRes() - this.av.getSelectionGroup().getStartRes() < 2) {
                this.av.setSelectionGroup(null);
            }
            if ((features = this.findFeaturesAtRes(sequence.getDatasetSequence(), sequence.findPosition(this.findRes(evt)))) != null && features.length > 0) {
                SearchResults highlight = new SearchResults();
                highlight.addResult(sequence, features[0].getBegin(), features[0].getEnd());
                this.seqCanvas.highlightSearchResults(highlight);
            }
            if (features != null && features.length > 0) {
                this.seqCanvas.getFeatureRenderer().amendFeatures(new SequenceI[]{sequence}, features, false, this.ap);
                this.seqCanvas.highlightSearchResults(null);
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        e.consume();
        if (e.getWheelRotation() > 0) {
            this.ap.scrollUp(false);
        } else {
            this.ap.scrollUp(true);
        }
    }

    public void doMousePressedDefineMode(MouseEvent evt) {
        int seq;
        int res = this.findRes(evt);
        this.oldSeq = seq = this.findSeq(evt);
        this.startWrapBlock = this.wrappedBlock;
        if (this.av.wrapAlignment && seq > this.av.alignment.getHeight()) {
            JOptionPane.showInternalMessageDialog(Desktop.desktop, "Cannot edit annotations in wrapped view.", "Wrapped view - no edit", 2);
            return;
        }
        if (seq < 0 || res < 0) {
            return;
        }
        Sequence sequence = (Sequence)this.av.getAlignment().getSequenceAt(seq);
        if (sequence == null || res > sequence.getLength()) {
            return;
        }
        this.stretchGroup = this.av.getSelectionGroup();
        if (this.stretchGroup == null) {
            this.stretchGroup = this.av.alignment.findGroup(sequence);
            if (this.stretchGroup != null && res > this.stretchGroup.getStartRes() && res < this.stretchGroup.getEndRes()) {
                this.av.setSelectionGroup(this.stretchGroup);
            } else {
                this.stretchGroup = null;
            }
        } else if (!this.stretchGroup.getSequences(null).contains(sequence) || this.stretchGroup.getStartRes() > res || this.stretchGroup.getEndRes() < res) {
            this.stretchGroup = null;
            SequenceGroup[] allGroups = this.av.alignment.findAllGroups(sequence);
            if (allGroups != null) {
                for (int i = 0; i < allGroups.length; ++i) {
                    if (allGroups[i].getStartRes() > res || allGroups[i].getEndRes() < res) continue;
                    this.stretchGroup = allGroups[i];
                    break;
                }
            }
            this.av.setSelectionGroup(this.stretchGroup);
        }
        if (SwingUtilities.isRightMouseButton(evt)) {
            SequenceFeature[] allFeatures = this.findFeaturesAtRes(sequence.getDatasetSequence(), sequence.findPosition(res));
            Vector links = new Vector();
            for (int i = 0; i < allFeatures.length; ++i) {
                if (allFeatures[i].links == null) continue;
                for (int j = 0; j < allFeatures[i].links.size(); ++j) {
                    links.addElement(allFeatures[i].links.elementAt(j));
                }
            }
            PopupMenu pop = new PopupMenu(this.ap, null, links);
            pop.show(this, evt.getX(), evt.getY());
            return;
        }
        if (this.av.cursorMode) {
            this.seqCanvas.cursorX = this.findRes(evt);
            this.seqCanvas.cursorY = this.findSeq(evt);
            this.seqCanvas.repaint();
            return;
        }
        if (this.stretchGroup == null) {
            SequenceGroup sg = new SequenceGroup();
            sg.setStartRes(res);
            sg.setEndRes(res);
            sg.addSequence(sequence, false);
            this.av.setSelectionGroup(sg);
            this.stretchGroup = sg;
            if (this.av.getConservationSelected()) {
                SliderPanel.setConservationSlider(this.ap, this.av.getGlobalColourScheme(), "Background");
            }
            if (this.av.getAbovePIDThreshold()) {
                SliderPanel.setPIDSliderSource(this.ap, this.av.getGlobalColourScheme(), "Background");
            }
            if (this.stretchGroup != null && this.stretchGroup.getEndRes() == res) {
                this.changeEndRes = true;
            } else if (this.stretchGroup != null && this.stretchGroup.getStartRes() == res) {
                this.changeStartRes = true;
            }
            this.stretchGroup.getWidth();
        }
        this.seqCanvas.repaint();
    }

    public void doMouseReleasedDefineMode(MouseEvent evt) {
        if (this.stretchGroup == null) {
            return;
        }
        if (this.stretchGroup.cs != null) {
            if (this.stretchGroup.cs instanceof ClustalxColourScheme) {
                ((ClustalxColourScheme)this.stretchGroup.cs).resetClustalX(this.stretchGroup.getSequences(this.av.hiddenRepSequences), this.stretchGroup.getWidth());
            }
            if (this.stretchGroup.cs instanceof Blosum62ColourScheme || this.stretchGroup.cs instanceof PIDColourScheme || this.stretchGroup.cs.conservationApplied() || this.stretchGroup.cs.getThreshold() > 0) {
                this.stretchGroup.recalcConservation();
            }
            if (this.stretchGroup.cs.conservationApplied()) {
                SliderPanel.setConservationSlider(this.ap, this.stretchGroup.cs, this.stretchGroup.getName());
            } else {
                SliderPanel.setPIDSliderSource(this.ap, this.stretchGroup.cs, this.stretchGroup.getName());
            }
            PaintRefresher.Refresh(this, this.av.getSequenceSetId());
            this.ap.paintAlignment(true);
        }
        this.changeEndRes = false;
        this.changeStartRes = false;
        this.stretchGroup = null;
    }

    public void doMouseDraggedDefineMode(MouseEvent evt) {
        int res = this.findRes(evt);
        int y = this.findSeq(evt);
        if (this.wrappedBlock != this.startWrapBlock) {
            return;
        }
        if (this.stretchGroup == null) {
            return;
        }
        if (res >= this.av.alignment.getWidth()) {
            res = this.av.alignment.getWidth() - 1;
        }
        if (this.stretchGroup.getEndRes() == res) {
            this.changeEndRes = true;
        } else if (this.stretchGroup.getStartRes() == res) {
            this.changeStartRes = true;
        }
        if (res < this.av.getStartRes()) {
            res = this.av.getStartRes();
        }
        if (this.changeEndRes) {
            if (res > this.stretchGroup.getStartRes() - 1) {
                this.stretchGroup.setEndRes(res);
            }
        } else if (this.changeStartRes && res < this.stretchGroup.getEndRes() + 1) {
            this.stretchGroup.setStartRes(res);
        }
        int dragDirection = 0;
        if (y > this.oldSeq) {
            dragDirection = 1;
        } else if (y < this.oldSeq) {
            dragDirection = -1;
        }
        while (y != this.oldSeq && this.oldSeq > -1 && y < this.av.alignment.getHeight()) {
            Sequence seq = (Sequence)this.av.getAlignment().getSequenceAt(this.oldSeq);
            this.oldSeq += dragDirection;
            if (this.oldSeq < 0) break;
            Sequence nextSeq = (Sequence)this.av.getAlignment().getSequenceAt(this.oldSeq);
            if (this.stretchGroup.getSequences(null).contains(nextSeq)) {
                this.stretchGroup.deleteSequence(seq, false);
                continue;
            }
            if (seq != null) {
                this.stretchGroup.addSequence(seq, false);
            }
            this.stretchGroup.addSequence(nextSeq, false);
        }
        if (this.oldSeq < 0) {
            this.oldSeq = -1;
        }
        this.mouseDragging = true;
        if (this.scrollThread != null) {
            this.scrollThread.setEvent(evt);
        }
        this.seqCanvas.repaint();
    }

    void scrollCanvas(MouseEvent evt) {
        if (evt == null) {
            if (this.scrollThread != null) {
                this.scrollThread.running = false;
                this.scrollThread = null;
            }
            this.mouseDragging = false;
        } else {
            if (this.scrollThread == null) {
                this.scrollThread = new ScrollThread();
            }
            this.mouseDragging = true;
            this.scrollThread.setEvent(evt);
        }
    }

    class ScrollThread
    extends Thread {
        MouseEvent evt;
        boolean running = false;

        public ScrollThread() {
            this.start();
        }

        public void setEvent(MouseEvent e) {
            this.evt = e;
        }

        public void stopScrolling() {
            this.running = false;
        }

        public void run() {
            this.running = true;
            while (this.running) {
                if (this.evt != null) {
                    if (SeqPanel.this.mouseDragging && this.evt.getY() < 0 && SeqPanel.this.av.getStartSeq() > 0) {
                        this.running = SeqPanel.this.ap.scrollUp(true);
                    }
                    if (SeqPanel.this.mouseDragging && this.evt.getY() >= SeqPanel.this.getHeight() && SeqPanel.this.av.alignment.getHeight() > SeqPanel.this.av.getEndSeq()) {
                        this.running = SeqPanel.this.ap.scrollUp(false);
                    }
                    if (SeqPanel.this.mouseDragging && this.evt.getX() < 0) {
                        this.running = SeqPanel.this.ap.scrollRight(false);
                    } else if (SeqPanel.this.mouseDragging && this.evt.getX() >= SeqPanel.this.getWidth()) {
                        this.running = SeqPanel.this.ap.scrollRight(true);
                    }
                }
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

