/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.Conservation;
import jalview.analysis.NJTree;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequenceNode;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.PaintRefresher;
import jalview.gui.TreePanel;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.ResidueProperties;
import jalview.schemes.UserColourScheme;
import jalview.util.Format;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class TreeCanvas
extends JPanel
implements MouseListener,
Runnable,
Printable,
MouseMotionListener {
    public static final String PLACEHOLDER = " * ";
    NJTree tree;
    JScrollPane scrollPane;
    TreePanel tp;
    AlignViewport av;
    AlignmentPanel ap;
    Font font;
    FontMetrics fm;
    boolean fitToWindow = true;
    boolean showDistances = false;
    boolean showBootstrap = false;
    boolean markPlaceholders = false;
    int offx = 20;
    int offy;
    float threshold;
    String longestName;
    int labelLength = -1;
    Hashtable nameHash = new Hashtable();
    Hashtable nodeHash = new Hashtable();
    SequenceNode highlightNode;
    boolean applyToAllViews = false;

    public TreeCanvas(TreePanel tp, AlignmentPanel ap, JScrollPane scroller) {
        this.tp = tp;
        this.av = ap.av;
        this.ap = ap;
        this.font = this.av.getFont();
        this.scrollPane = scroller;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void treeSelectionChanged(SequenceI sequence) {
        AlignmentPanel[] aps = this.getAssociatedPanels();
        for (int a = 0; a < aps.length; ++a) {
            SequenceGroup selected = aps[a].av.getSelectionGroup();
            if (selected == null) {
                selected = new SequenceGroup();
                aps[a].av.setSelectionGroup(selected);
            }
            selected.setEndRes(aps[a].av.alignment.getWidth() - 1);
            selected.addOrRemove(sequence, true);
        }
    }

    public void setTree(NJTree tree) {
        this.tree = tree;
        tree.findHeight(tree.getTopNode());
        Vector leaves = tree.findLeaves(tree.getTopNode(), new Vector());
        boolean has_placeholders = false;
        this.longestName = "";
        for (int i = 0; i < leaves.size(); ++i) {
            SequenceNode lf = (SequenceNode)leaves.elementAt(i);
            if (lf.isPlaceholder()) {
                has_placeholders = true;
            }
            if (this.longestName.length() >= ((Sequence)lf.element()).getName().length()) continue;
            this.longestName = PLACEHOLDER + ((Sequence)lf.element()).getName();
        }
        this.setMarkPlaceholders(has_placeholders);
    }

    public void drawNode(Graphics g, SequenceNode node, float chunk, float scale, int width, int offx, int offy) {
        if (node == null) {
            return;
        }
        if (node.left() == null && node.right() == null) {
            float height = node.height;
            float dist = node.dist;
            int xstart = (int)((height - dist) * scale) + offx;
            int xend = (int)(height * scale) + offx;
            int ypos = (int)(node.ycount * chunk) + offy;
            if (node.element() instanceof SequenceI) {
                SequenceI seq = (SequenceI)node.element();
                if (this.av.getSequenceColour(seq) == Color.white) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(this.av.getSequenceColour(seq).darker());
                }
            } else {
                g.setColor(Color.black);
            }
            g.drawLine(xstart, ypos, xend, ypos);
            String nodeLabel = "";
            if (this.showDistances && node.dist > 0.0f) {
                nodeLabel = new Format("%-.2f").form(node.dist);
            }
            if (this.showBootstrap && node.bootstrap > -1) {
                if (this.showDistances) {
                    nodeLabel = nodeLabel + " : ";
                }
                nodeLabel = nodeLabel + String.valueOf(node.bootstrap);
            }
            if (!nodeLabel.equals("")) {
                g.drawString(nodeLabel, xstart + 2, ypos - 2);
            }
            String name = this.markPlaceholders && node.isPlaceholder() ? PLACEHOLDER + node.getName() : node.getName();
            int charWidth = this.fm.stringWidth(name) + 3;
            int charHeight = this.font.getSize();
            Rectangle rect = new Rectangle(xend + 10, ypos - charHeight / 2, charWidth, charHeight);
            this.nameHash.put((SequenceI)node.element(), rect);
            SequenceGroup selected = this.av.getSelectionGroup();
            if (selected != null && selected.getSequences(null).contains((SequenceI)node.element())) {
                g.setColor(Color.gray);
                g.fillRect(xend + 10, ypos - charHeight / 2, charWidth, charHeight);
                g.setColor(Color.white);
            }
            g.drawString(name, xend + 10, ypos + this.fm.getDescent());
            g.setColor(Color.black);
        } else {
            this.drawNode(g, (SequenceNode)node.left(), chunk, scale, width, offx, offy);
            this.drawNode(g, (SequenceNode)node.right(), chunk, scale, width, offx, offy);
            float height = node.height;
            float dist = node.dist;
            int xstart = (int)((height - dist) * scale) + offx;
            int xend = (int)(height * scale) + offx;
            int ypos = (int)(node.ycount * chunk) + offy;
            g.setColor(node.color.darker());
            g.drawLine(xstart, ypos, xend, ypos);
            if (node == this.highlightNode) {
                g.fillRect(xend - 3, ypos - 3, 6, 6);
            } else {
                g.fillRect(xend - 2, ypos - 2, 4, 4);
            }
            int ystart = (int)(((SequenceNode)node.left()).ycount * chunk) + offy;
            int yend = (int)(((SequenceNode)node.right()).ycount * chunk) + offy;
            Rectangle pos = new Rectangle(xend - 2, ypos - 2, 5, 5);
            this.nodeHash.put(node, pos);
            g.drawLine((int)(height * scale) + offx, ystart, (int)(height * scale) + offx, yend);
            String nodeLabel = "";
            if (this.showDistances && node.dist > 0.0f) {
                nodeLabel = new Format("%-.2f").form(node.dist);
            }
            if (this.showBootstrap && node.bootstrap > -1) {
                if (this.showDistances) {
                    nodeLabel = nodeLabel + " : ";
                }
                nodeLabel = nodeLabel + String.valueOf(node.bootstrap);
            }
            if (!nodeLabel.equals("")) {
                g.drawString(nodeLabel, xstart + 2, ypos - 2);
            }
        }
    }

    public Object findElement(int x, int y) {
        Rectangle rect;
        Object ob;
        Enumeration keys = this.nameHash.keys();
        while (keys.hasMoreElements()) {
            ob = keys.nextElement();
            rect = (Rectangle)this.nameHash.get(ob);
            if (x < rect.x || x > rect.x + rect.width || y < rect.y || y > rect.y + rect.height) continue;
            return ob;
        }
        keys = this.nodeHash.keys();
        while (keys.hasMoreElements()) {
            ob = keys.nextElement();
            rect = (Rectangle)this.nodeHash.get(ob);
            if (x < rect.x || x > rect.x + rect.width || y < rect.y || y > rect.y + rect.height) continue;
            return ob;
        }
        return null;
    }

    public void pickNodes(Rectangle pickBox) {
        int width = this.getWidth();
        int height = this.getHeight();
        SequenceNode top = this.tree.getTopNode();
        float wscale = (float)((double)width * 0.8 - (double)(this.offx * 2)) / this.tree.getMaxHeight();
        if (top.count == 0) {
            top.count = ((SequenceNode)top.left()).count + ((SequenceNode)top.right()).count;
        }
        float chunk = (float)(height - this.offy) / (float)top.count;
        this.pickNode(pickBox, top, chunk, wscale, width, this.offx, this.offy);
    }

    public void pickNode(Rectangle pickBox, SequenceNode node, float chunk, float scale, int width, int offx, int offy) {
        if (node == null) {
            return;
        }
        if (node.left() == null && node.right() == null) {
            float height = node.height;
            float dist = node.dist;
            int xstart = (int)((height - dist) * scale) + offx;
            int xend = (int)(height * scale) + offx;
            int ypos = (int)(node.ycount * chunk) + offy;
            if (pickBox.contains(new Point(xend, ypos)) && node.element() instanceof SequenceI) {
                SequenceI seq = (SequenceI)node.element();
                SequenceGroup sg = this.av.getSelectionGroup();
                if (sg != null) {
                    sg.addOrRemove(seq, true);
                }
            }
        } else {
            this.pickNode(pickBox, (SequenceNode)node.left(), chunk, scale, width, offx, offy);
            this.pickNode(pickBox, (SequenceNode)node.right(), chunk, scale, width, offx, offy);
        }
    }

    public void setColor(SequenceNode node, Color c) {
        if (node == null) {
            return;
        }
        if (node.left() == null && node.right() == null) {
            node.color = c;
            if (node.element() instanceof SequenceI) {
                AlignmentPanel[] aps = this.getAssociatedPanels();
                for (int a = 0; a < aps.length; ++a) {
                    aps[a].av.setSequenceColour((SequenceI)node.element(), c);
                }
            }
        } else {
            node.color = c;
            this.setColor((SequenceNode)node.left(), c);
            this.setColor((SequenceNode)node.right(), c);
        }
    }

    void startPrinting() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pf = printJob.pageDialog(printJob.defaultPage());
        printJob.setPrintable(this, pf);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception PrintException) {
                PrintException.printStackTrace();
            }
        }
    }

    public int print(Graphics pg, PageFormat pf, int pi) throws PrinterException {
        pg.setFont(this.font);
        pg.translate((int)pf.getImageableX(), (int)pf.getImageableY());
        int pwidth = (int)pf.getImageableWidth();
        int pheight = (int)pf.getImageableHeight();
        int noPages = this.getHeight() / pheight;
        if (pi > noPages) {
            return 1;
        }
        if (pwidth > this.getWidth()) {
            pwidth = this.getWidth();
        }
        if (this.fitToWindow) {
            if (pheight > this.getHeight()) {
                pheight = this.getHeight();
            }
            noPages = 0;
        } else {
            FontMetrics fm = pg.getFontMetrics(this.font);
            int height = fm.getHeight() * this.nameHash.size();
            pg.translate(0, -pi * pheight);
            pg.setClip(0, pi * pheight, pwidth, pi * pheight + pheight);
            pheight = height;
        }
        this.draw(pg, pwidth, pheight);
        return 0;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(this.font);
        if (this.tree == null) {
            g.drawString("Calculating tree....", 20, this.getHeight() / 2);
        } else {
            this.fm = g.getFontMetrics(this.font);
            if (this.nameHash.size() == 0) {
                this.repaint();
            }
            if (this.fitToWindow || !this.fitToWindow && this.scrollPane.getHeight() > this.fm.getHeight() * this.nameHash.size() + this.offy) {
                this.draw(g, this.scrollPane.getWidth(), this.scrollPane.getHeight());
                this.setPreferredSize(null);
            } else {
                this.setPreferredSize(new Dimension(this.scrollPane.getWidth(), this.fm.getHeight() * this.nameHash.size()));
                this.draw(g, this.scrollPane.getWidth(), this.fm.getHeight() * this.nameHash.size());
            }
            this.scrollPane.revalidate();
        }
    }

    public void setFont(Font font) {
        this.font = font;
        this.repaint();
    }

    public void draw(Graphics g1, int width, int height) {
        Graphics2D g2 = (Graphics2D)g1;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.white);
        g2.fillRect(0, 0, width, height);
        g2.setFont(this.font);
        this.offy = this.font.getSize() + 10;
        this.fm = g2.getFontMetrics(this.font);
        this.labelLength = this.fm.stringWidth(this.longestName) + 20;
        float wscale = (float)(width - this.labelLength - this.offx * 2) / this.tree.getMaxHeight();
        SequenceNode top = this.tree.getTopNode();
        if (top.count == 0) {
            top.count = ((SequenceNode)top.left()).count + ((SequenceNode)top.right()).count;
        }
        float chunk = (float)(height - this.offy) / (float)top.count;
        this.drawNode(g2, this.tree.getTopNode(), chunk, wscale, width, this.offx, this.offy);
        if (this.threshold != 0.0f) {
            if (this.av.getCurrentTree() == this.tree) {
                g2.setColor(Color.red);
            } else {
                g2.setColor(Color.gray);
            }
            int x = (int)(this.threshold * (float)(this.getWidth() - this.labelLength - 2 * this.offx) + (float)this.offx);
            g2.drawLine(x, 0, x, this.getHeight());
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent evt) {
        if (this.highlightNode != null) {
            if (SwingUtilities.isRightMouseButton(evt)) {
                Color col = JColorChooser.showDialog(this, "Select Sub-Tree Colour", this.highlightNode.color);
                if (col != null) {
                    this.setColor(this.highlightNode, col);
                }
            } else if (evt.getClickCount() > 1) {
                this.tree.swapNodes(this.highlightNode);
                this.tree.reCount(this.tree.getTopNode());
                this.tree.findHeight(this.tree.getTopNode());
            } else {
                Vector leaves = new Vector();
                this.tree.findLeaves(this.highlightNode, leaves);
                for (int i = 0; i < leaves.size(); ++i) {
                    SequenceI seq = (SequenceI)((SequenceNode)leaves.elementAt(i)).element();
                    this.treeSelectionChanged(seq);
                }
            }
            PaintRefresher.Refresh(this.tp, this.av.getSequenceSetId());
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent evt) {
        this.av.setCurrentTree(this.tree);
        Object ob = this.findElement(evt.getX(), evt.getY());
        if (ob instanceof SequenceNode) {
            this.highlightNode = (SequenceNode)ob;
            this.setToolTipText("<html>Left click to select leaves<br>Double-click to invert leaves<br>Right click to change colour");
            this.repaint();
        } else if (this.highlightNode != null) {
            this.highlightNode = null;
            this.setToolTipText(null);
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent ect) {
    }

    public void mousePressed(MouseEvent e) {
        this.av.setCurrentTree(this.tree);
        int x = e.getX();
        int y = e.getY();
        Object ob = this.findElement(x, y);
        if (ob instanceof SequenceI) {
            this.treeSelectionChanged((Sequence)ob);
            PaintRefresher.Refresh(this.tp, this.ap.av.getSequenceSetId());
            this.repaint();
            return;
        }
        if (!(ob instanceof SequenceNode)) {
            if (this.tree.getMaxHeight() != 0.0f) {
                this.threshold = (float)(x - this.offx) / (float)(this.getWidth() - this.labelLength - 2 * this.offx);
                this.tree.getGroups().removeAllElements();
                this.tree.groupNodes(this.tree.getTopNode(), this.threshold);
                this.setColor(this.tree.getTopNode(), Color.black);
                AlignmentPanel[] aps = this.getAssociatedPanels();
                for (int a = 0; a < aps.length; ++a) {
                    aps[a].av.setSelectionGroup(null);
                    aps[a].av.alignment.deleteAllGroups();
                    aps[a].av.sequenceColours = null;
                }
                this.colourGroups();
            }
            PaintRefresher.Refresh(this.tp, this.ap.av.getSequenceSetId());
            this.repaint();
        }
    }

    void colourGroups() {
        for (int i = 0; i < this.tree.getGroups().size(); ++i) {
            Color col = new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
            this.setColor((SequenceNode)this.tree.getGroups().elementAt(i), col.brighter());
            Vector l = this.tree.findLeaves((SequenceNode)this.tree.getGroups().elementAt(i), new Vector());
            Vector<SequenceI> sequences = new Vector<SequenceI>();
            for (int j = 0; j < l.size(); ++j) {
                SequenceI s1 = (SequenceI)((SequenceNode)l.elementAt(j)).element();
                if (sequences.contains(s1)) continue;
                sequences.addElement(s1);
            }
            ColourSchemeI cs = null;
            if (this.av.getGlobalColourScheme() != null) {
                cs = this.av.getGlobalColourScheme() instanceof UserColourScheme ? new UserColourScheme(((UserColourScheme)this.av.getGlobalColourScheme()).getColours()) : ColourSchemeProperty.getColour(sequences, this.av.alignment.getWidth(), ColourSchemeProperty.getColourName(this.av.getGlobalColourScheme()));
                cs.setThreshold(this.av.getGlobalColourScheme().getThreshold(), this.av.getIgnoreGapsConsensus());
            }
            SequenceGroup sg = new SequenceGroup(sequences, null, cs, true, true, false, 0, this.av.alignment.getWidth() - 1);
            sg.setName("JTreeGroup:" + sg.hashCode());
            sg.setIdColour(col);
            AlignmentPanel[] aps = this.getAssociatedPanels();
            for (int a = 0; a < aps.length; ++a) {
                if (aps[a].av.getGlobalColourScheme() != null && aps[a].av.getGlobalColourScheme().conservationApplied()) {
                    Conservation c = new Conservation("Group", ResidueProperties.propHash, 3, sg.getSequences(null), sg.getStartRes(), sg.getEndRes());
                    c.calculate();
                    c.verdict(false, aps[a].av.ConsPercGaps);
                    sg.cs.setConservation(c);
                }
                aps[a].av.alignment.addGroup(sg);
            }
        }
    }

    public void setShowDistances(boolean state) {
        this.showDistances = state;
        this.repaint();
    }

    public void setShowBootstrap(boolean state) {
        this.showBootstrap = state;
        this.repaint();
    }

    public void setMarkPlaceholders(boolean state) {
        this.markPlaceholders = state;
        this.repaint();
    }

    AlignmentPanel[] getAssociatedPanels() {
        if (this.applyToAllViews) {
            return PaintRefresher.getAssociatedPanels(this.av.getSequenceSetId());
        }
        return new AlignmentPanel[]{this.ap};
    }
}

