/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.NJTree;
import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.EPSOptions;
import jalview.gui.FontChooser;
import jalview.gui.PaintRefresher;
import jalview.gui.TreeCanvas;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.io.NewickFile;
import jalview.jbgui.GTreePanel;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.jibble.epsgraphics.EpsGraphics2D;

public class TreePanel
extends GTreePanel {
    String type;
    String pwtype;
    TreeCanvas treeCanvas;
    NJTree tree;
    AlignViewport av;

    public TreePanel(AlignmentPanel ap, String type, String pwtype) {
        this.initTreePanel(ap, type, pwtype, null, null);
    }

    public TreePanel(AlignmentPanel ap, String type, String pwtype, NewickFile newtree) {
        this.initTreePanel(ap, type, pwtype, newtree, null);
    }

    public TreePanel(AlignmentPanel av, String type, String pwtype, NewickFile newtree, AlignmentView inputData) {
        this.initTreePanel(av, type, pwtype, newtree, inputData);
    }

    public AlignmentI getAlignment() {
        return this.treeCanvas.av.getAlignment();
    }

    public AlignViewport getViewPort() {
        return this.treeCanvas.av;
    }

    void initTreePanel(AlignmentPanel ap, String type, String pwtype, NewickFile newTree, AlignmentView inputData) {
        this.av = ap.av;
        this.type = type;
        this.pwtype = pwtype;
        this.treeCanvas = new TreeCanvas(this, ap, this.scrollPane);
        this.scrollPane.setViewportView(this.treeCanvas);
        PaintRefresher.Register(this, ap.av.getSequenceSetId());
        this.buildAssociatedViewMenu();
        this.av.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("alignment")) {
                    if (TreePanel.this.tree == null) {
                        System.out.println("tree is null");
                    }
                    if (evt.getNewValue() == null) {
                        System.out.println("new alignment sequences vector value is null");
                    }
                    TreePanel.this.tree.UpdatePlaceHolders((Vector)evt.getNewValue());
                    TreePanel.this.treeCanvas.nameHash.clear();
                    TreePanel.this.repaint();
                }
            }
        });
        TreeLoader tl = new TreeLoader(newTree);
        if (inputData != null) {
            tl.odata = inputData;
        }
        tl.start();
    }

    public void viewMenu_menuSelected() {
        this.buildAssociatedViewMenu();
    }

    void buildAssociatedViewMenu() {
        AlignmentPanel[] aps = PaintRefresher.getAssociatedPanels(this.av.getSequenceSetId());
        if (aps.length == 1 && this.treeCanvas.ap == aps[0]) {
            this.associateLeavesMenu.setVisible(false);
            return;
        }
        this.associateLeavesMenu.setVisible(true);
        if (this.viewMenu.getItem(this.viewMenu.getItemCount() - 2) instanceof JMenuItem) {
            this.viewMenu.insertSeparator(this.viewMenu.getItemCount() - 1);
        }
        this.associateLeavesMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        int iSize = aps.length;
        final TreePanel thisTreePanel = this;
        for (int i = 0; i < iSize; ++i) {
            final AlignmentPanel ap = aps[i];
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(ap.av.viewName, ap == this.treeCanvas.ap);
            buttonGroup.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TreePanel.this.treeCanvas.applyToAllViews = false;
                    TreePanel.this.treeCanvas.ap = ap;
                    TreePanel.this.treeCanvas.av = ap.av;
                    PaintRefresher.Register(thisTreePanel, ap.av.getSequenceSetId());
                }
            });
            this.associateLeavesMenu.add(item);
        }
        final JRadioButtonMenuItem itemf = new JRadioButtonMenuItem("All Views");
        buttonGroup.add(itemf);
        itemf.setSelected(this.treeCanvas.applyToAllViews);
        itemf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreePanel.this.treeCanvas.applyToAllViews = itemf.isSelected();
            }
        });
        this.associateLeavesMenu.add(itemf);
    }

    public void showDistances(boolean b) {
        this.treeCanvas.setShowDistances(b);
        this.distanceMenu.setSelected(b);
    }

    public void showBootstrap(boolean b) {
        this.treeCanvas.setShowBootstrap(b);
        this.bootstrapMenu.setSelected(b);
    }

    public void showPlaceholders(boolean b) {
        this.placeholdersMenu.setState(b);
        this.treeCanvas.setMarkPlaceholders(b);
    }

    private void allowOriginalSeqData(boolean b) {
        this.originalSeqData.setVisible(b);
    }

    public NJTree getTree() {
        return this.tree;
    }

    public void textbox_actionPerformed(ActionEvent e) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        StringBuffer buffer = new StringBuffer();
        if (this.type.equals("AV")) {
            buffer.append("Average distance tree using ");
        } else {
            buffer.append("Neighbour joining tree using ");
        }
        if (this.pwtype.equals("BL")) {
            buffer.append("BLOSUM62");
        } else {
            buffer.append("PID");
        }
        Desktop.addInternalFrame(cap, buffer.toString(), 500, 100);
        NewickFile fout = new NewickFile(this.tree.getTopNode());
        cap.setText(fout.print(this.tree.isHasBootstrap(), this.tree.isHasDistances(), this.tree.isHasRootDistance()));
    }

    public void saveAsNewick_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Save tree as newick file");
        chooser.setToolTipText("Save");
        int value = chooser.showSaveDialog(null);
        if (value == 0) {
            String choice = chooser.getSelectedFile().getPath();
            Cache.setProperty("LAST_DIRECTORY", chooser.getSelectedFile().getParent());
            try {
                NewickFile fout = new NewickFile(this.tree.getTopNode());
                String output = fout.print(this.tree.isHasBootstrap(), this.tree.isHasDistances(), this.tree.isHasRootDistance());
                PrintWriter out = new PrintWriter(new FileWriter(choice));
                out.println(output);
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void printMenu_actionPerformed(ActionEvent e) {
        this.treeCanvas.startPrinting();
    }

    public void originalSeqData_actionPerformed(ActionEvent e) {
        if (!this.tree.hasOriginalSequenceData()) {
            Cache.log.info((Object)"Unexpected call to originalSeqData_actionPerformed - should have hidden this menu action.");
            return;
        }
        char gc = '-';
        try {
            gc = this.av.getGapCharacter();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Object[] alAndColsel = this.tree.seqData.getAlignmentAndColumnSelection(gc);
        if (alAndColsel != null && alAndColsel[0] != null) {
            Alignment dataset;
            Alignment al = new Alignment((SequenceI[])alAndColsel[0]);
            Alignment alignment = dataset = this.av != null && this.av.getAlignment() != null ? this.av.getAlignment().getDataset() : null;
            if (dataset != null) {
                al.setDataset(dataset);
            }
            AlignFrame af = new AlignFrame(al, (ColumnSelection)alAndColsel[1], 700, 500);
            Desktop.addInternalFrame(af, "Original Data for " + this.title, 700, 500);
        }
    }

    public void fitToWindow_actionPerformed(ActionEvent e) {
        this.treeCanvas.fitToWindow = this.fitToWindow.isSelected();
        this.repaint();
    }

    public void font_actionPerformed(ActionEvent e) {
        if (this.treeCanvas == null) {
            return;
        }
        new FontChooser(this);
    }

    public Font getTreeFont() {
        return this.treeCanvas.font;
    }

    public void setTreeFont(Font font) {
        if (this.treeCanvas != null) {
            this.treeCanvas.setFont(font);
        }
    }

    public void distanceMenu_actionPerformed(ActionEvent e) {
        this.treeCanvas.setShowDistances(this.distanceMenu.isSelected());
    }

    public void bootstrapMenu_actionPerformed(ActionEvent e) {
        this.treeCanvas.setShowBootstrap(this.bootstrapMenu.isSelected());
    }

    public void placeholdersMenu_actionPerformed(ActionEvent e) {
        this.treeCanvas.setMarkPlaceholders(this.placeholdersMenu.isSelected());
    }

    public void epsTree_actionPerformed(ActionEvent e) {
        EPSOptions eps;
        boolean accurateText = true;
        String renderStyle = Cache.getDefault("EPS_RENDERING", "Prompt each time");
        if (!(!renderStyle.equalsIgnoreCase("Prompt each time") || System.getProperty("java.awt.headless") != null && System.getProperty("java.awt.headless").equals("true") || (renderStyle = (eps = new EPSOptions()).getValue()) != null && !eps.cancelled)) {
            return;
        }
        if (renderStyle.equalsIgnoreCase("text")) {
            accurateText = false;
        }
        int width = this.treeCanvas.getWidth();
        int height = this.treeCanvas.getHeight();
        try {
            JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), new String[]{"eps"}, new String[]{"Encapsulated Postscript"}, "Encapsulated Postscript");
            chooser.setFileView(new JalviewFileView());
            chooser.setDialogTitle("Create EPS file from tree");
            chooser.setToolTipText("Save");
            int value = chooser.showSaveDialog(this);
            if (value != 0) {
                return;
            }
            Cache.setProperty("LAST_DIRECTORY", chooser.getSelectedFile().getParent());
            FileOutputStream out = new FileOutputStream(chooser.getSelectedFile());
            EpsGraphics2D pg = new EpsGraphics2D("Tree", out, 0, 0, width, height);
            pg.setAccurateTextMode(accurateText);
            this.treeCanvas.draw(pg, width, height);
            pg.flush();
            pg.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void pngTree_actionPerformed(ActionEvent e) {
        int width = this.treeCanvas.getWidth();
        int height = this.treeCanvas.getHeight();
        try {
            JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), new String[]{"png"}, new String[]{"Portable network graphics"}, "Portable network graphics");
            chooser.setFileView(new JalviewFileView());
            chooser.setDialogTitle("Create PNG image from tree");
            chooser.setToolTipText("Save");
            int value = chooser.showSaveDialog(this);
            if (value != 0) {
                return;
            }
            Cache.setProperty("LAST_DIRECTORY", chooser.getSelectedFile().getParent());
            FileOutputStream out = new FileOutputStream(chooser.getSelectedFile());
            BufferedImage bi = new BufferedImage(width, height, 1);
            Graphics png = bi.getGraphics();
            this.treeCanvas.draw(png, width, height);
            ImageIO.write((RenderedImage)bi, "png", out);
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class TreeLoader
    extends Thread {
        NewickFile newtree;
        AlignmentView odata = null;

        public TreeLoader(NewickFile newtree) {
            this.newtree = newtree;
            if (newtree != null) {
                TreePanel.this.showBootstrap(newtree.HasBootstrap());
                TreePanel.this.showDistances(newtree.HasDistances());
            }
        }

        public void run() {
            if (this.newtree != null) {
                TreePanel.this.tree = this.odata == null ? new NJTree(TreePanel.this.av.alignment.getSequencesArray(), this.newtree) : new NJTree(TreePanel.this.av.alignment.getSequencesArray(), this.odata, this.newtree);
                if (!TreePanel.this.tree.hasOriginalSequenceData()) {
                    TreePanel.this.allowOriginalSeqData(false);
                }
            } else {
                SequenceI[] seqs;
                int end;
                int start;
                AlignmentView seqStrings = TreePanel.this.av.getAlignmentView(TreePanel.this.av.getSelectionGroup() != null);
                if (TreePanel.this.av.getSelectionGroup() == null) {
                    start = 0;
                    end = TreePanel.this.av.alignment.getWidth();
                    seqs = TreePanel.this.av.alignment.getSequencesArray();
                } else {
                    start = TreePanel.this.av.getSelectionGroup().getStartRes();
                    end = TreePanel.this.av.getSelectionGroup().getEndRes() + 1;
                    seqs = TreePanel.this.av.getSelectionGroup().getSequencesInOrder(TreePanel.this.av.alignment);
                }
                TreePanel.this.tree = new NJTree(seqs, seqStrings, TreePanel.this.type, TreePanel.this.pwtype, start, end);
                TreePanel.this.showDistances(true);
            }
            TreePanel.this.tree.reCount(TreePanel.this.tree.getTopNode());
            TreePanel.this.tree.findHeight(TreePanel.this.tree.getTopNode());
            TreePanel.this.treeCanvas.setTree(TreePanel.this.tree);
            TreePanel.this.treeCanvas.repaint();
            TreePanel.this.av.setCurrentTree(TreePanel.this.tree);
        }
    }
}

