/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.binding.JalviewUserColours;
import jalview.datamodel.SequenceGroup;
import jalview.gui.AlignmentPanel;
import jalview.gui.AppJmol;
import jalview.gui.Desktop;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.jbgui.GUserDefinedColours;
import jalview.schemabinding.version2.Colour;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ResidueProperties;
import jalview.schemes.UserColourScheme;
import jalview.util.Format;
import jalview.util.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.exolab.castor.xml.Unmarshaller;

public class UserDefinedColours
extends GUserDefinedColours
implements ChangeListener {
    AlignmentPanel ap;
    SequenceGroup seqGroup;
    Vector selectedButtons;
    ColourSchemeI oldColourScheme;
    JInternalFrame frame;
    AppJmol jmol;
    Vector upperCaseButtons;
    Vector lowerCaseButtons;
    static Hashtable userColourSchemes;

    public UserDefinedColours(AlignmentPanel ap, SequenceGroup sg) {
        this.lcaseColour.setEnabled(false);
        this.ap = ap;
        this.seqGroup = sg;
        this.oldColourScheme = this.seqGroup != null ? this.seqGroup.cs : ap.av.getGlobalColourScheme();
        if (this.oldColourScheme instanceof UserColourScheme) {
            this.schemeName.setText(((UserColourScheme)this.oldColourScheme).getName());
            if (((UserColourScheme)this.oldColourScheme).getLowerCaseColours() != null) {
                this.caseSensitive.setSelected(true);
                this.lcaseColour.setEnabled(true);
                this.resetButtonPanel(true);
            } else {
                this.resetButtonPanel(false);
            }
        } else {
            this.resetButtonPanel(false);
        }
        this.showFrame();
    }

    public UserDefinedColours(AppJmol jmol, ColourSchemeI oldcs) {
        this.jmol = jmol;
        this.colorChooser.getSelectionModel().addChangeListener(this);
        this.oldColourScheme = oldcs;
        if (this.oldColourScheme instanceof UserColourScheme) {
            this.schemeName.setText(((UserColourScheme)this.oldColourScheme).getName());
        }
        this.resetButtonPanel(false);
        this.showFrame();
    }

    void showFrame() {
        this.colorChooser.getSelectionModel().addChangeListener(this);
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        Desktop.addInternalFrame(this.frame, "User Defined Colours", 720, 370, true);
        if (this.seqGroup != null) {
            this.frame.setTitle(this.frame.getTitle() + " (" + this.seqGroup.getName() + ")");
        }
        if (new Platform().isAMac()) {
            this.frame.setSize(760, 370);
        }
    }

    void resetButtonPanel(boolean caseSensitive) {
        JButton button;
        this.buttonPanel.removeAll();
        if (this.upperCaseButtons == null) {
            this.upperCaseButtons = new Vector();
        }
        for (int i = 0; i < 20; ++i) {
            String label = caseSensitive ? ResidueProperties.aa[i] : ResidueProperties.aa2Triplet.get(ResidueProperties.aa[i]).toString();
            button = this.makeButton(label, ResidueProperties.aa[i], this.upperCaseButtons, i);
            this.buttonPanel.add(button);
        }
        this.buttonPanel.add(this.makeButton("B", "B", this.upperCaseButtons, 20));
        this.buttonPanel.add(this.makeButton("Z", "Z", this.upperCaseButtons, 21));
        this.buttonPanel.add(this.makeButton("X", "X", this.upperCaseButtons, 22));
        this.buttonPanel.add(this.makeButton("Gap", "-", this.upperCaseButtons, 23));
        if (!caseSensitive) {
            this.gridLayout.setRows(6);
            this.gridLayout.setColumns(4);
        } else {
            this.gridLayout.setRows(7);
            int cols = 7;
            this.gridLayout.setColumns(cols + 1);
            if (this.lowerCaseButtons == null) {
                this.lowerCaseButtons = new Vector();
            }
            for (int i = 0; i < 20; ++i) {
                int row = i / cols + 1;
                int index = row * cols + i;
                button = this.makeButton(ResidueProperties.aa[i].toLowerCase(), ResidueProperties.aa[i].toLowerCase(), this.lowerCaseButtons, i);
                this.buttonPanel.add((Component)button, index);
            }
        }
        if (caseSensitive) {
            this.buttonPanel.add(this.makeButton("b", "b", this.lowerCaseButtons, 20));
            this.buttonPanel.add(this.makeButton("z", "z", this.lowerCaseButtons, 21));
            this.buttonPanel.add(this.makeButton("x", "x", this.lowerCaseButtons, 22));
        }
        this.buttonPanel.validate();
        this.validate();
    }

    public void stateChanged(ChangeEvent evt) {
        if (this.selectedButtons != null) {
            int i;
            JButton button = null;
            for (i = 0; i < this.selectedButtons.size(); ++i) {
                button = (JButton)this.selectedButtons.elementAt(i);
                button.setBackground(this.colorChooser.getColor());
                button.setForeground(button.getBackground().brighter().brighter().brighter());
            }
            if (button == this.lcaseColour) {
                for (i = 0; i < this.lowerCaseButtons.size(); ++i) {
                    button = (JButton)this.lowerCaseButtons.elementAt(i);
                    button.setBackground(this.colorChooser.getColor());
                    button.setForeground(button.getBackground().brighter().brighter().brighter());
                }
            }
        }
    }

    public void colourButtonPressed(MouseEvent e) {
        if (this.selectedButtons == null) {
            this.selectedButtons = new Vector();
        }
        JButton pressed = (JButton)e.getSource();
        if (e.isShiftDown()) {
            int b;
            JButton end = (JButton)e.getSource();
            JButton start = this.selectedButtons.size() > 0 ? (JButton)this.selectedButtons.elementAt(this.selectedButtons.size() - 1) : (JButton)e.getSource();
            int startIndex = 0;
            int endIndex = 0;
            for (b = 0; b < this.buttonPanel.getComponentCount(); ++b) {
                if (this.buttonPanel.getComponent(b) == start) {
                    startIndex = b;
                }
                if (this.buttonPanel.getComponent(b) != end) continue;
                endIndex = b;
            }
            if (startIndex > endIndex) {
                int temp = startIndex;
                startIndex = endIndex;
                endIndex = temp;
            }
            for (b = startIndex; b <= endIndex; ++b) {
                JButton button = (JButton)this.buttonPanel.getComponent(b);
                if (this.selectedButtons.contains(button)) continue;
                button.setForeground(button.getBackground().brighter().brighter());
                this.selectedButtons.add(button);
            }
        } else if (!e.isControlDown()) {
            for (int b = 0; b < this.selectedButtons.size(); ++b) {
                JButton button = (JButton)this.selectedButtons.elementAt(b);
                button.setForeground(button.getBackground().darker().darker());
            }
            this.selectedButtons.clear();
            pressed.setForeground(pressed.getBackground().brighter().brighter());
            this.selectedButtons.addElement(pressed);
        } else if (e.isControlDown()) {
            if (this.selectedButtons.contains(pressed)) {
                pressed.setForeground(pressed.getBackground().darker().darker());
                this.selectedButtons.remove(pressed);
            } else {
                pressed.setForeground(pressed.getBackground().brighter().brighter());
                this.selectedButtons.addElement(pressed);
            }
        }
        if (this.selectedButtons.size() > 0) {
            this.colorChooser.setColor(((JButton)this.selectedButtons.elementAt(0)).getBackground());
        }
    }

    JButton makeButton(String label, String aa, Vector caseSensitiveButtons, int buttonIndex) {
        Color col;
        JButton button;
        if (buttonIndex < caseSensitiveButtons.size()) {
            button = (JButton)caseSensitiveButtons.elementAt(buttonIndex);
            col = button.getBackground();
        } else {
            button = new JButton();
            button.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    UserDefinedColours.this.colourButtonPressed(e);
                }
            });
            caseSensitiveButtons.addElement(button);
            col = Color.white;
            try {
                col = this.oldColourScheme.findColour(aa.charAt(0), -1);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.caseSensitive.isSelected()) {
            button.setMargin(new Insets(2, 2, 2, 2));
        } else {
            button.setMargin(new Insets(2, 14, 2, 14));
        }
        button.setBackground(col);
        button.setText(label);
        button.setForeground(col.darker().darker().darker());
        button.setFont(new Font("Verdana", 1, 10));
        return button;
    }

    protected void okButton_actionPerformed(ActionEvent e) {
        this.applyButton_actionPerformed(null);
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void applyButton_actionPerformed(ActionEvent e) {
        UserColourScheme ucs = this.getSchemeFromButtons();
        ucs.setName(this.schemeName.getText());
        if (this.seqGroup != null) {
            this.seqGroup.cs = ucs;
            this.ap.paintAlignment(true);
        } else if (this.ap != null) {
            this.ap.alignFrame.changeColour(ucs);
        } else if (this.jmol != null) {
            this.jmol.setJalviewColourScheme(ucs);
        }
    }

    UserColourScheme getSchemeFromButtons() {
        Color[] newColours = new Color[24];
        for (int i = 0; i < 24; ++i) {
            JButton button = (JButton)this.upperCaseButtons.elementAt(i);
            newColours[i] = button.getBackground();
        }
        UserColourScheme ucs = new UserColourScheme(newColours);
        if (this.caseSensitive.isSelected()) {
            newColours = new Color[23];
            for (int i = 0; i < 23; ++i) {
                JButton button = (JButton)this.lowerCaseButtons.elementAt(i);
                newColours[i] = button.getBackground();
            }
            ucs.setLowerCaseColours(newColours);
        }
        if (this.ap != null) {
            ucs.setThreshold(0, this.ap.av.getIgnoreGapsConsensus());
        }
        return ucs;
    }

    protected void loadbutton_actionPerformed(ActionEvent e) {
        this.upperCaseButtons = new Vector();
        this.lowerCaseButtons = new Vector();
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), new String[]{"jc"}, new String[]{"Jalview User Colours"}, "Jalview User Colours");
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Load colour scheme");
        chooser.setToolTipText("Load");
        int value = chooser.showOpenDialog(this);
        if (value == 0) {
            JButton button;
            int i;
            File choice = chooser.getSelectedFile();
            Cache.setProperty("LAST_DIRECTORY", choice.getParent());
            String defaultColours = Cache.getDefault("USER_DEFINED_COLOURS", choice.getPath());
            if (defaultColours.indexOf(choice.getPath()) == -1) {
                defaultColours = defaultColours.concat("|").concat(choice.getPath());
            }
            Cache.setProperty("USER_DEFINED_COLOURS", defaultColours);
            UserColourScheme ucs = UserDefinedColours.loadColours(choice.getAbsolutePath());
            Color[] colors = ucs.getColours();
            this.schemeName.setText(ucs.getName());
            if (ucs.getLowerCaseColours() != null) {
                this.caseSensitive.setSelected(true);
                this.lcaseColour.setEnabled(true);
                this.resetButtonPanel(true);
                for (i = 0; i < this.lowerCaseButtons.size(); ++i) {
                    button = (JButton)this.lowerCaseButtons.elementAt(i);
                    button.setBackground(ucs.getLowerCaseColours()[i]);
                }
            } else {
                this.caseSensitive.setSelected(false);
                this.lcaseColour.setEnabled(false);
                this.resetButtonPanel(false);
            }
            for (i = 0; i < this.upperCaseButtons.size(); ++i) {
                button = (JButton)this.upperCaseButtons.elementAt(i);
                button.setBackground(colors[i]);
            }
        }
    }

    public static UserColourScheme loadDefaultColours() {
        UserColourScheme ret = null;
        String colours = Cache.getProperty("USER_DEFINED_COLOURS");
        if (colours != null) {
            if (colours.indexOf("|") > -1) {
                colours = colours.substring(0, colours.indexOf("|"));
            }
            ret = UserDefinedColours.loadColours(colours);
        }
        if (ret == null) {
            Color[] newColours = new Color[24];
            for (int i = 0; i < 24; ++i) {
                newColours[i] = Color.white;
            }
            ret = new UserColourScheme(newColours);
        }
        return ret;
    }

    static UserColourScheme loadColours(String file) {
        UserColourScheme ucs;
        block11: {
            ucs = null;
            Color[] newColours = null;
            try {
                InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                jalview.schemabinding.version2.JalviewUserColours jucs = new jalview.schemabinding.version2.JalviewUserColours();
                Unmarshaller unmar = new Unmarshaller((Object)jucs);
                jucs = (jalview.schemabinding.version2.JalviewUserColours)unmar.unmarshal((Reader)in);
                newColours = new Color[24];
                Color[] lowerCase = null;
                boolean caseSensitive = false;
                for (int i = 0; i < jucs.getColourCount(); ++i) {
                    String name = jucs.getColour(i).getName();
                    int index = ResidueProperties.aa3Hash.containsKey(name) ? (Integer)ResidueProperties.aa3Hash.get(name) : ResidueProperties.aaIndex[name.charAt(0)];
                    if (index == -1) continue;
                    if (name.toLowerCase().equals(name)) {
                        if (lowerCase == null) {
                            lowerCase = new Color[23];
                        }
                        caseSensitive = true;
                        lowerCase[index] = new Color(Integer.parseInt(jucs.getColour(i).getRGB(), 16));
                        continue;
                    }
                    newColours[index] = new Color(Integer.parseInt(jucs.getColour(i).getRGB(), 16));
                }
                if (newColours != null) {
                    ucs = new UserColourScheme(newColours);
                    ucs.setName(jucs.getSchemeName());
                    if (caseSensitive) {
                        ucs.setLowerCaseColours(lowerCase);
                    }
                }
            }
            catch (Exception ex) {
                try {
                    InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    JalviewUserColours jucs = new JalviewUserColours();
                    jucs = JalviewUserColours.unmarshal(in);
                    newColours = new Color[jucs.getColourCount()];
                    for (int i = 0; i < 24; ++i) {
                        newColours[i] = new Color(Integer.parseInt(jucs.getColour(i).getRGB(), 16));
                    }
                    if (newColours != null) {
                        ucs = new UserColourScheme(newColours);
                        ucs.setName(jucs.getSchemeName());
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                if (newColours != null) break block11;
                System.out.println("Error loading User ColourFile\n" + ex);
            }
        }
        return ucs;
    }

    protected void savebutton_actionPerformed(ActionEvent e) {
        if (this.schemeName.getText().trim().length() < 1) {
            JOptionPane.showInternalMessageDialog(Desktop.desktop, "User colour scheme must have a name!", "No name for colour scheme", 2);
            return;
        }
        if (userColourSchemes != null && userColourSchemes.containsKey(this.schemeName.getText())) {
            int reply = JOptionPane.showInternalConfirmDialog(Desktop.desktop, "Colour scheme " + this.schemeName.getText() + " exists." + "\nContinue saving colour scheme as " + this.schemeName.getText() + "?", "Duplicate scheme name", 0);
            if (reply != 0) {
                return;
            }
            userColourSchemes.remove(this.schemeName.getText());
        }
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), new String[]{"jc"}, new String[]{"Jalview User Colours"}, "Jalview User Colours");
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Save colour scheme");
        chooser.setToolTipText("Save");
        int value = chooser.showSaveDialog(this);
        if (value == 0) {
            String choice = chooser.getSelectedFile().getPath();
            String defaultColours = Cache.getDefault("USER_DEFINED_COLOURS", choice);
            if (defaultColours.indexOf(choice) == -1) {
                if (defaultColours.length() > 0) {
                    defaultColours = defaultColours.concat("|");
                }
                defaultColours = defaultColours.concat(choice);
            }
            userColourSchemes.put(this.schemeName.getText(), this.getSchemeFromButtons());
            this.ap.alignFrame.updateUserColourMenu();
            Cache.setProperty("USER_DEFINED_COLOURS", defaultColours);
            jalview.schemabinding.version2.JalviewUserColours ucs = new jalview.schemabinding.version2.JalviewUserColours();
            ucs.setSchemeName(this.schemeName.getText());
            try {
                PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(choice), "UTF-8"));
                for (int i = 0; i < this.buttonPanel.getComponentCount(); ++i) {
                    JButton button = (JButton)this.buttonPanel.getComponent(i);
                    Colour col = new Colour();
                    col.setName(button.getText());
                    col.setRGB(Format.getHexString(button.getBackground()));
                    ucs.addColour(col);
                }
                ucs.marshal(out);
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void cancelButton_actionPerformed(ActionEvent e) {
        if (this.ap != null) {
            if (this.seqGroup != null) {
                this.seqGroup.cs = this.oldColourScheme;
            } else if (this.ap != null) {
                this.ap.av.setGlobalColourScheme(this.oldColourScheme);
            }
            this.ap.paintAlignment(true);
        }
        if (this.jmol != null) {
            this.jmol.setJalviewColourScheme(this.oldColourScheme);
        }
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Hashtable getUserColourSchemes() {
        return userColourSchemes;
    }

    public static void initUserColourSchemes(String files) {
        userColourSchemes = new Hashtable();
        if (files == null || files.length() == 0) {
            return;
        }
        StringBuffer coloursFound = new StringBuffer();
        StringTokenizer st = new StringTokenizer(files, "|");
        while (st.hasMoreElements()) {
            String file = st.nextToken();
            try {
                UserColourScheme ucs = UserDefinedColours.loadColours(file);
                if (ucs == null) continue;
                if (coloursFound.length() > 0) {
                    coloursFound.append("|");
                }
                coloursFound.append(file);
                userColourSchemes.put(ucs.getName(), ucs);
            }
            catch (Exception ex) {
                System.out.println("Error loading User ColourFile\n" + ex);
            }
        }
        if (!files.equals(coloursFound.toString())) {
            if (coloursFound.toString().length() > 1) {
                Cache.setProperty("USER_DEFINED_COLOURS", coloursFound.toString());
            } else {
                Cache.applicationProperties.remove("USER_DEFINED_COLOURS");
            }
        }
    }

    public static void removeColourFromDefaults(String target) {
        userColourSchemes = new Hashtable();
        StringBuffer coloursFound = new StringBuffer();
        StringTokenizer st = new StringTokenizer(Cache.getProperty("USER_DEFINED_COLOURS"), "|");
        while (st.hasMoreElements()) {
            String file = st.nextToken();
            try {
                UserColourScheme ucs = UserDefinedColours.loadColours(file);
                if (ucs == null || ucs.getName().equals(target)) continue;
                if (coloursFound.length() > 0) {
                    coloursFound.append("|");
                }
                coloursFound.append(file);
                userColourSchemes.put(ucs.getName(), ucs);
            }
            catch (Exception ex) {
                System.out.println("Error loading User ColourFile\n" + ex);
            }
        }
        if (coloursFound.toString().length() > 1) {
            Cache.setProperty("USER_DEFINED_COLOURS", coloursFound.toString());
        } else {
            Cache.applicationProperties.remove("USER_DEFINED_COLOURS");
        }
    }

    public void caseSensitive_actionPerformed(ActionEvent e) {
        this.resetButtonPanel(this.caseSensitive.isSelected());
        this.lcaseColour.setEnabled(this.caseSensitive.isSelected());
    }

    public void lcaseColour_actionPerformed(ActionEvent e) {
        if (this.selectedButtons == null) {
            this.selectedButtons = new Vector();
        } else {
            this.selectedButtons.clear();
        }
        this.selectedButtons.add(this.lcaseColour);
    }
}

