/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.io.VamsasAppDatastore;
import jalview.structure.StructureSelectionManager;
import jalview.structure.VamsasListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import uk.ac.vamsas.client.ClientHandle;
import uk.ac.vamsas.client.IClient;
import uk.ac.vamsas.client.IClientDocument;
import uk.ac.vamsas.client.IClientFactory;
import uk.ac.vamsas.client.InvalidSessionDocumentException;
import uk.ac.vamsas.client.UserHandle;
import uk.ac.vamsas.client.VorbaId;
import uk.ac.vamsas.client.picking.IMessageHandler;
import uk.ac.vamsas.client.picking.IPickManager;
import uk.ac.vamsas.client.picking.Message;
import uk.ac.vamsas.client.picking.MouseOverMessage;
import uk.ac.vamsas.client.picking.SelectionMessage;
import uk.ac.vamsas.client.simpleclient.SimpleClient;
import uk.ac.vamsas.client.simpleclient.SimpleClientConfig;
import uk.ac.vamsas.client.simpleclient.SimpleClientFactory;
import uk.ac.vamsas.objects.core.Entry;

public class VamsasApplication {
    IClient vclient = null;
    ClientHandle app = null;
    UserHandle user = null;
    Desktop jdesktop = null;
    IdentityHashMap jv2vobj = null;
    Hashtable vobj2jv = null;
    Hashtable alRedoState = null;
    private boolean joinedSession = false;
    private VamsasListener picker = null;
    static /* synthetic */ Class class$jalview$datamodel$Alignment;
    static /* synthetic */ Class class$jalview$datamodel$Sequence;

    public VamsasApplication(Desktop jdesktop, File sessionPath) {
        this.jdesktop = jdesktop;
        this.initClientSession(null, sessionPath);
    }

    private static IClientFactory getClientFactory() throws IOException {
        return new SimpleClientFactory();
    }

    public VamsasApplication(Desktop jdesktop) {
        this.jdesktop = jdesktop;
        this.initClientSession(null, null);
    }

    public VamsasApplication(Desktop jdesktop, String sessionUrl) {
        this.jdesktop = jdesktop;
        this.initClientSession(sessionUrl, null);
    }

    public static String[] getSessionList() throws Exception {
        return VamsasApplication.getClientFactory().getCurrentSessions();
    }

    private boolean initClientSession(String sess, File vamsasDocument) {
        try {
            this.app = this.getJalviewHandle();
            IClientFactory clientfactory = VamsasApplication.getClientFactory();
            if (vamsasDocument != null) {
                if (sess != null) {
                    throw new Error("Implementation Error - cannot import existing vamsas document into an existing session, Yet!");
                }
                try {
                    this.vclient = clientfactory.openAsNewSessionIClient(this.app, vamsasDocument);
                }
                catch (InvalidSessionDocumentException e) {
                    JOptionPane.showInternalMessageDialog(Desktop.desktop, "VAMSAS Document could not be opened as a new session - please choose another", "VAMSAS Document Import Failed", 0);
                }
            } else {
                this.vclient = sess == null ? clientfactory.getNewSessionIClient(this.app) : clientfactory.getIClient(this.app, sess);
            }
            this.setVclientConfig();
            this.user = this.vclient.getUserHandle();
        }
        catch (Exception e) {
            Cache.log.error((Object)"Couldn't instantiate vamsas client !", (Throwable)e);
            return false;
        }
        return true;
    }

    private void setVclientConfig() {
        if (this.vclient == null) {
            return;
        }
        try {
            if (this.vclient instanceof SimpleClient) {
                SimpleClientConfig cfg = ((SimpleClient)this.vclient).getSimpleClientConfig();
                cfg._validatemergedroots = false;
                cfg._validateupdatedroots = true;
            }
        }
        catch (Error e) {
            Cache.log.warn((Object)"Probable SERIOUS VAMSAS client incompatibility - carrying on regardless", (Throwable)e);
        }
        catch (Exception e) {
            Cache.log.warn((Object)"Probable VAMSAS client incompatibility - carrying on regardless", (Throwable)e);
        }
    }

    private ClientHandle getJalviewHandle() {
        return new ClientHandle("jalview.bin.Jalview", Cache.getProperty("VERSION"));
    }

    public boolean inSession() {
        return this.vclient != null;
    }

    public void initial_update() {
        if (!this.inSession()) {
            throw new Error("Impementation error! Vamsas Operations when client not initialised and connected.");
        }
        this.addDocumentUpdateHandler();
        this.addStoreDocumentHandler();
        this.startSession();
        Cache.log.debug((Object)"Jalview loading the Vamsas Session for the first time.");
        this.dealWithDocumentUpdate(false);
        Cache.log.debug((Object)"... finished update for the first time.");
    }

    protected void updateJalviewGui() {
        JInternalFrame[] frames = this.jdesktop.getAllFrames();
        if (frames == null) {
            return;
        }
        try {
            for (int i = frames.length - 1; i > -1; --i) {
                if (!(frames[i] instanceof AlignFrame)) continue;
                AlignFrame af = (AlignFrame)frames[i];
                af.alignPanel.alignmentChanged();
            }
        }
        catch (Exception e) {
            Cache.log.warn((Object)"Exception whilst refreshing jalview windows after a vamsas document update.", (Throwable)e);
        }
    }

    public void push_update() {
        Thread udthread = new Thread(new Runnable(){

            public void run() {
                Cache.log.info((Object)"Jalview updating to the Vamsas Session.");
                VamsasApplication.this.dealWithDocumentUpdate(true);
                Cache.log.info((Object)"Jalview finished updating to the Vamsas Session.");
            }
        });
        udthread.start();
    }

    public void end_session() {
        if (!this.inSession()) {
            throw new Error("Jalview not connected to Vamsas session.");
        }
        Cache.log.info((Object)"Jalview disconnecting from the Vamsas Session.");
        try {
            if (this.joinedSession) {
                this.vclient.finalizeClient();
                Cache.log.info((Object)"Jalview has left the session.");
            } else {
                Cache.log.warn((Object)"JV Client leaving a session that's its not joined yet.");
            }
            this.joinedSession = false;
            this.vclient = null;
            this.app = null;
            this.user = null;
            this.jv2vobj = null;
            this.vobj2jv = null;
        }
        catch (Exception e) {
            Cache.log.error((Object)"Vamsas Session finalization threw exceptions!", (Throwable)e);
        }
    }

    public void updateJalview(IClientDocument cdoc) {
        Cache.log.debug((Object)"Jalview updating from sesion document ..");
        this.ensureJvVamsas();
        VamsasAppDatastore vds = new VamsasAppDatastore(cdoc, this.vobj2jv, this.jv2vobj, this.baseProvEntry(), this.alRedoState);
        vds.updateToJalview();
        Cache.log.debug((Object)".. finished updating from sesion document.");
    }

    private void ensureJvVamsas() {
        if (this.jv2vobj == null) {
            this.jv2vobj = new IdentityHashMap();
            this.vobj2jv = new Hashtable();
            this.alRedoState = new Hashtable();
        }
    }

    public void updateVamsasDocument(IClientDocument doc) {
        this.ensureJvVamsas();
        VamsasAppDatastore vds = new VamsasAppDatastore(doc, this.vobj2jv, this.jv2vobj, this.baseProvEntry(), this.alRedoState);
        JInternalFrame[] frames = Desktop.desktop.getAllFrames();
        if (frames == null) {
            return;
        }
        try {
            AlignFrame af;
            int i;
            for (i = frames.length - 1; i > -1; --i) {
                if (!(frames[i] instanceof AlignFrame)) continue;
                af = (AlignFrame)frames[i];
                vds.storeVAMSAS(af.getViewport(), af.getTitle());
            }
            for (i = frames.length - 1; i > -1; --i) {
                if (!(frames[i] instanceof AlignFrame)) continue;
                af = (AlignFrame)frames[i];
                vds.storeSequenceMappings(af.getViewport(), af.getTitle());
            }
        }
        catch (Exception e) {
            Cache.log.error((Object)"Vamsas Document store exception", (Throwable)e);
        }
    }

    private Entry baseProvEntry() {
        Entry pentry = new Entry();
        pentry.setUser(this.user.getFullName());
        pentry.setApp(this.app.getClientUrn());
        pentry.setDate(new Date());
        pentry.setAction("created");
        return pentry;
    }

    protected void dealWithDocumentUpdate(boolean fromJalview) {
        Cache.log.debug((Object)"Updating jalview from changed vamsas document.");
        this.disableGui(true);
        try {
            long time = System.currentTimeMillis();
            IClientDocument cdoc = this.vclient.getClientDocument();
            if (Cache.log.isDebugEnabled()) {
                Cache.log.debug((Object)("Time taken to get ClientDocument = " + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
            if (fromJalview) {
                this.updateVamsasDocument(cdoc);
                if (Cache.log.isDebugEnabled()) {
                    Cache.log.debug((Object)("Time taken to update Vamsas Document from jalview\t= " + (System.currentTimeMillis() - time)));
                    time = System.currentTimeMillis();
                }
                cdoc.setVamsasRoots(cdoc.getVamsasRoots());
                if (Cache.log.isDebugEnabled()) {
                    Cache.log.debug((Object)("Time taken to set Document Roots\t\t= " + (System.currentTimeMillis() - time)));
                    time = System.currentTimeMillis();
                }
            } else {
                this.updateJalview(cdoc);
                if (Cache.log.isDebugEnabled()) {
                    Cache.log.debug((Object)("Time taken to update Jalview from vamsas document Roots\t= " + (System.currentTimeMillis() - time)));
                    time = System.currentTimeMillis();
                }
            }
            this.vclient.updateDocument(cdoc);
            if (Cache.log.isDebugEnabled()) {
                Cache.log.debug((Object)("Time taken to update Session Document\t= " + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
            cdoc = null;
        }
        catch (Exception ee) {
            System.err.println("Exception whilst updating :");
            ee.printStackTrace(System.err);
        }
        Cache.log.debug((Object)"Finished updating from document change.");
        this.disableGui(false);
    }

    private void addDocumentUpdateHandler() {
        final VamsasApplication client = this;
        this.vclient.addDocumentUpdateHandler(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Cache.log.debug((Object)"Dealing with document update event.");
                client.dealWithDocumentUpdate(false);
                Cache.log.debug((Object)"finished dealing with event.");
            }
        });
        Cache.log.debug((Object)"Added Jalview handler for vamsas document updates.");
    }

    private void addStoreDocumentHandler() {
        VamsasApplication client = this;
        this.vclient.addVorbaEventHandler("uk.ac.vamas.client.DocumentRequestToCloseEvent", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Cache.log.debug((Object)"Asking user if the vamsas session should be stored.");
                int reply = JOptionPane.showInternalConfirmDialog(Desktop.desktop, "The current VAMSAS session has unsaved data - do you want to save it ?", "VAMSAS Session Shutdown", 0, 3);
                if (reply == 0) {
                    Cache.log.debug((Object)"Prompting for vamsas store filename.");
                    Desktop.instance.vamsasSave_actionPerformed(null);
                    Cache.log.debug((Object)"Finished attempt at storing document.");
                }
                Cache.log.debug((Object)"finished dealing with REQUESTTOCLOSE event.");
            }
        });
        Cache.log.debug((Object)"Added Jalview handler for vamsas document updates.");
    }

    public void disableGui(boolean b) {
        Desktop.instance.setVamsasUpdate(b);
    }

    private void startSession() {
        if (this.inSession()) {
            try {
                this.vclient.joinSession();
                this.joinedSession = true;
            }
            catch (Exception e) {
                Cache.log.error((Object)"Failed to join vamsas session.", (Throwable)e);
                this.vclient = null;
            }
            try {
                final IPickManager pm = this.vclient.getPickManager();
                final StructureSelectionManager ssm = StructureSelectionManager.getStructureSelectionManager();
                pm.registerMessageHandler(new IMessageHandler(){
                    String last = null;

                    public void handleMessage(Message message) {
                        if (VamsasApplication.this.vobj2jv == null) {
                            return;
                        }
                        if (message instanceof MouseOverMessage) {
                            MouseOverMessage mm = (MouseOverMessage)message;
                            String mstring = mm.getVorbaID() + " " + mm.getPosition();
                            if (this.last != null && mstring.equals(this.last)) {
                                return;
                            }
                            Object jvobj = VamsasApplication.this.vobj2jv.get(mm.getVorbaID());
                            if (jvobj != null && jvobj instanceof SequenceI) {
                                this.last = mstring;
                                ssm.mouseOverVamsasSequence((SequenceI)jvobj, mm.getPosition());
                            }
                        }
                        if (message instanceof SelectionMessage) {
                            SelectionMessage sm = (SelectionMessage)message;
                            Object[] jvobjs = new Object[sm.getVorbaIDs().length];
                            Class<?> type = null;
                            for (int o = 0; o < jvobjs.length; ++o) {
                                jvobjs[o] = VamsasApplication.this.vobj2jv.get(sm.getVorbaIDs()[o]);
                                if (jvobjs[o] == null) continue;
                                if (type == null) {
                                    type = jvobjs[o].getClass();
                                }
                                if (type == jvobjs[o].getClass()) continue;
                            }
                            if (type != (class$jalview$datamodel$Alignment == null ? (class$jalview$datamodel$Alignment = VamsasApplication.class$("jalview.datamodel.Alignment")) : class$jalview$datamodel$Alignment) || jvobjs.length == 1) {
                                // empty if block
                            }
                            if (type == (class$jalview$datamodel$Sequence == null ? (class$jalview$datamodel$Sequence = VamsasApplication.class$("jalview.datamodel.Sequence")) : class$jalview$datamodel$Sequence)) {
                                boolean aligned = ((Sequence)jvobjs[0]).getDatasetSequence() == null;
                                for (int c = 0; jvobjs.length > 1 && c < jvobjs.length; ++c) {
                                    if (((Sequence)jvobjs[c]).getDatasetSequence() != null) continue;
                                    aligned = false;
                                }
                                if (aligned || jvobjs.length == 1) {
                                    // empty if block
                                }
                            }
                            for (int c = 0; c < jvobjs.length; ++c) {
                                jvobjs[c] = null;
                            }
                            jvobjs = null;
                            return;
                        }
                    }
                });
                this.picker = new VamsasListener(){
                    SequenceI last = null;
                    int i = -1;

                    public void mouseOver(SequenceI seq, int index) {
                        VorbaId v;
                        if (VamsasApplication.this.jv2vobj == null) {
                            return;
                        }
                        if ((seq != this.last || this.i != index) && (v = (VorbaId)VamsasApplication.this.jv2vobj.get(seq)) != null) {
                            this.last = seq;
                            this.i = index;
                            MouseOverMessage message = new MouseOverMessage(v.getId(), index);
                            pm.sendMessage((Message)message);
                        }
                    }
                };
                ssm.addStructureViewerListener(this.picker);
            }
            catch (Exception e) {
                Cache.log.error((Object)"Failed to init Vamsas Picking", (Throwable)e);
            }
        }
    }
}

