/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.Desktop;
import jalview.gui.Jalview2XML;
import jalview.io.AppletFormatAdapter;
import jalview.io.FileParse;
import jalview.io.FormatAdapter;
import jalview.io.IdentifyFile;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class FileLoader
implements Runnable {
    String file;
    String protocol;
    String format;
    FileParse source = null;
    AlignViewport viewport;
    AlignFrame alignFrame;
    long loadtime;
    long memused;
    boolean raiseGUI = true;

    public FileLoader() {
        this(true);
    }

    public FileLoader(boolean raiseGUI) {
        this.raiseGUI = raiseGUI;
    }

    public void LoadFile(AlignViewport viewport, String file, String protocol, String format) {
        this.viewport = viewport;
        this.LoadFile(file, protocol, format);
    }

    public void LoadFile(String file, String protocol, String format) {
        this.file = file;
        this.protocol = protocol;
        this.format = format;
        final Thread loader = new Thread(this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                loader.start();
            }
        });
    }

    public void LoadFile(String file, String protocol) {
        this.LoadFile(file, protocol, null);
    }

    public AlignFrame LoadFileWaitTillLoaded(String file, String protocol) {
        return this.LoadFileWaitTillLoaded(file, protocol, null);
    }

    public AlignFrame LoadFileWaitTillLoaded(String file, String protocol, String format) {
        this.file = file;
        this.protocol = protocol;
        this.format = format;
        return this._LoadFileWaitTillLoaded();
    }

    public AlignFrame LoadFileWaitTillLoaded(FileParse source, String format) {
        this.source = source;
        this.file = source.getInFile();
        this.protocol = source.type;
        this.format = format;
        return this._LoadFileWaitTillLoaded();
    }

    protected AlignFrame _LoadFileWaitTillLoaded() {
        Thread loader = new Thread(this);
        loader.start();
        while (loader.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        return this.alignFrame;
    }

    public void updateRecentlyOpened() {
        Vector<String> recent = new Vector<String>();
        if (this.protocol.equals(FormatAdapter.PASTE)) {
            return;
        }
        String type = this.protocol.equals(FormatAdapter.FILE) ? "RECENT_FILE" : "RECENT_URL";
        String historyItems = Cache.getProperty(type);
        if (historyItems != null) {
            StringTokenizer st = new StringTokenizer(historyItems, "\t");
            while (st.hasMoreTokens()) {
                recent.addElement(st.nextElement().toString().trim());
            }
        }
        if (recent.contains(this.file)) {
            recent.remove(this.file);
        }
        StringBuffer newHistory = new StringBuffer(this.file);
        for (int i = 0; i < recent.size() && i < 10; ++i) {
            newHistory.append("\t");
            newHistory.append(recent.elementAt(i));
        }
        Cache.setProperty(type, newHistory.toString());
        if (this.protocol.equals(FormatAdapter.FILE)) {
            Cache.setProperty("DEFAULT_FILE_FORMAT", this.format);
        }
    }

    public void run() {
        AlignmentI al;
        String title = this.protocol.equals(AppletFormatAdapter.PASTE) ? "Copied From Clipboard" : this.file;
        Runtime rt = Runtime.getRuntime();
        try {
            if (Desktop.instance != null) {
                Desktop.instance.startLoading(this.file);
            }
            if (this.format == null) {
                this.format = this.source != null ? new IdentifyFile().Identify(this.source, false) : new IdentifyFile().Identify(this.file, this.protocol);
            }
            if (Desktop.desktop != null && Desktop.desktop.isShowMemoryUsage()) {
                System.gc();
                this.memused = rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
            }
            this.loadtime = -System.currentTimeMillis();
            al = null;
            if (this.format.equalsIgnoreCase("Jalview")) {
                if (this.source != null) {
                    System.err.println("IMPLEMENTATION ERROR: Cannot read consecutive Jalview XML projects from a stream.");
                }
                this.alignFrame = new Jalview2XML(this.raiseGUI).LoadJalviewAlign(this.file);
            } else {
                String error;
                block32: {
                    error = AppletFormatAdapter.SUPPORTED_FORMATS;
                    if (FormatAdapter.isValidFormat(this.format)) {
                        try {
                            if (this.source != null) {
                                al = new FormatAdapter().readFromFile(this.source, this.format);
                                break block32;
                            }
                            FormatAdapter fa = new FormatAdapter();
                            al = fa.readFile(this.file, this.protocol, this.format);
                            this.source = fa.afile;
                        }
                        catch (IOException ex) {
                            error = ex.getMessage();
                        }
                    } else if (this.format != null && this.format.length() > 7) {
                        error = this.format + "\n" + error;
                    }
                }
                if (al != null && ((Alignment)al).getHeight() > 0) {
                    if (this.viewport != null) {
                        for (int i = 0; i < ((Alignment)al).getHeight(); ++i) {
                            this.viewport.getAlignment().addSequence(((Alignment)al).getSequenceAt(i));
                        }
                        this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
                    } else {
                        this.alignFrame = new AlignFrame(al, 700, 500);
                        this.alignFrame.statusBar.setText("Successfully loaded file " + title);
                        if (!this.protocol.equals(AppletFormatAdapter.PASTE)) {
                            this.alignFrame.setFileName(this.file, this.format);
                        }
                        Desktop.addInternalFrame(this.alignFrame, title, 700, 500);
                        try {
                            this.alignFrame.setMaximum(Cache.getDefault("SHOW_FULLSCREEN", false));
                        }
                        catch (PropertyVetoException ex) {}
                    }
                } else {
                    if (Desktop.instance != null) {
                        Desktop.instance.stopLoading();
                    }
                    final String errorMessage = "Couldn't load file " + title + "\n" + error;
                    if (this.raiseGUI) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                JOptionPane.showInternalMessageDialog(Desktop.desktop, errorMessage, "Error loading file", 2);
                            }
                        });
                    } else {
                        System.err.println(errorMessage);
                    }
                }
            }
            this.updateRecentlyOpened();
        }
        catch (Exception er) {
            System.err.println("Exception whilst opening file '" + this.file);
            er.printStackTrace();
            if (this.raiseGUI) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showInternalMessageDialog(Desktop.desktop, "Encountered problems opening " + FileLoader.this.file + "!!", "File open error", 2);
                    }
                });
            }
            this.alignFrame = null;
        }
        catch (OutOfMemoryError er) {
            er.printStackTrace();
            this.alignFrame = null;
            if (this.raiseGUI) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showInternalMessageDialog(Desktop.desktop, "Out of memory loading file " + FileLoader.this.file + "!!" + "\nSee help files for increasing Java Virtual Machine memory.", "Out of memory", 2);
                    }
                });
            }
            System.err.println("Out of memory loading file " + this.file + "!!");
        }
        this.loadtime += System.currentTimeMillis();
        this.memused -= rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
        if (Desktop.desktop != null && Desktop.desktop.isShowMemoryUsage()) {
            if (this.alignFrame != null) {
                al = this.alignFrame.getViewport().getAlignment();
                System.out.println("Loaded '" + title + "' in " + (double)this.loadtime / 1000.0 + "s, took an additional " + 1.0 * (double)this.memused / 1048576.0 + " MB (" + al.getHeight() + " seqs by " + al.getWidth() + " cols)");
            } else {
                System.out.println("Failed to load '" + title + "' in " + (double)this.loadtime / 1000.0 + "s, took an additional " + 1.0 * (double)this.memused / 1048576.0 + " MB (alignment is null)");
            }
        }
        if (Desktop.instance != null) {
            Desktop.instance.stopLoading();
        }
    }

    protected void finalize() throws Throwable {
        this.source = null;
        this.alignFrame = null;
        this.viewport = null;
        super.finalize();
    }
}

