/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

public class JalviewFileFilter
extends FileFilter {
    public static Hashtable suffixHash = new Hashtable();
    private Hashtable filters = null;
    private String description = "no description";
    private String fullDescription = "full description";
    private boolean useExtensionsInDescription = true;

    public JalviewFileFilter(String extension, String description) {
        StringTokenizer st = new StringTokenizer(extension, ",");
        while (st.hasMoreElements()) {
            this.addExtension(st.nextToken().trim());
        }
        this.setDescription(description);
    }

    public JalviewFileFilter(String[] filts) {
        this(filts, null);
    }

    public JalviewFileFilter(String[] filts, String description) {
        for (int i = 0; i < filts.length; ++i) {
            this.addExtension(filts[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public String getAcceptableExtension() {
        return this.filters.keys().nextElement().toString();
    }

    public boolean accept(File f) {
        if (f != null) {
            String extension = this.getExtension(f);
            if (f.isDirectory()) {
                return true;
            }
            if (extension != null && this.filters.get(this.getExtension(f)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return "";
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Enumeration extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = this.fullDescription + "." + (String)extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", " + (String)extensions.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }
}

