/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.analysis.AlignSeq;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.Sequence;
import jalview.gui.AlignmentPanel;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import uk.ac.ebi.www.Data;
import uk.ac.ebi.www.InputParams;
import uk.ac.ebi.www.WSFile;
import uk.ac.ebi.www.WSWUBlast;
import uk.ac.ebi.www.WSWUBlastServiceLocator;

public class WSWUBlastClient {
    AlignmentPanel ap;
    AlignmentI al;
    CutAndPasteTransfer output = new CutAndPasteTransfer();
    int jobsRunning = 0;
    Vector suggestedIds = new Vector();

    public WSWUBlastClient(AlignmentPanel ap, AlignmentI al, ArrayList ids) {
        this.ap = ap;
        this.al = al;
        this.output.setText("To display sequence features an exact Uniprot id with 100% sequence identity match must be entered.\nIn order to display these features, try changing the names of your sequences to the ids suggested below.\n\nRunning WSWUBlast at EBI.\nPlease quote Pillai S., Silventoinen V., Kallio K., Senger M., Sobhany S., Tate J., Velankar S., Golovin A., Henrick K., Rice P., Stoehr P., Lopez R.\nSOAP-based services provided by the European Bioinformatics Institute.\nNucleic Acids Res. 33(1):W25-W28 (2005));");
        Desktop.addInternalFrame(this.output, "BLASTing for unidentified sequences ", 800, 300);
        for (int i = 0; i < ids.size(); ++i) {
            Sequence sequence = (Sequence)ids.get(i);
            System.out.println(sequence.getName());
            BlastThread thread = new BlastThread(sequence);
            thread.start();
            ++this.jobsRunning;
        }
        ImageTwirler thread = new ImageTwirler();
        thread.start();
    }

    void parseResult(Sequence seq, String res) {
        StringTokenizer st = new StringTokenizer(res, "\n");
        int maxFound = 90;
        StringBuffer buffer = new StringBuffer("\n\n" + seq.getName() + " :");
        while (st.hasMoreTokens()) {
            String data = st.nextToken();
            if (data.indexOf(">UNIPROT") <= -1) continue;
            int index = data.indexOf(">UNIPROT") + 9;
            String id2 = data.substring(index, data.indexOf(" ", index));
            boolean identitiesFound = false;
            while (!identitiesFound) {
                data = st.nextToken();
                if (data.indexOf("Identities") <= -1) continue;
                identitiesFound = true;
                int value = Integer.parseInt(data.substring(data.indexOf("(") + 1, data.indexOf("%")));
                if (value < maxFound) continue;
                maxFound = value;
                buffer.append(" " + id2 + " " + value + "%; ");
                this.suggestedIds.addElement(new Object[]{seq, id2});
            }
        }
        this.output.appendText(buffer.toString());
    }

    void updateIds() {
        int reply = JOptionPane.showConfirmDialog(Desktop.desktop, "Automatically update suggested ids?", "Auto replace sequence ids", 0);
        if (reply == 0) {
            Enumeration keys = this.suggestedIds.elements();
            while (keys.hasMoreElements()) {
                DBRefEntry[] entries;
                Object[] object = (Object[])keys.nextElement();
                Sequence oldseq = (Sequence)object[0];
                oldseq.setName(object[1].toString());
                for (int i = 0; i < this.al.getHeight(); ++i) {
                    if (this.al.getSequenceAt(i).getDatasetSequence() != oldseq) continue;
                    this.al.getSequenceAt(i).setName(oldseq.getName());
                    break;
                }
                if ((entries = oldseq.getDBRef()) == null) continue;
                oldseq.addDBRef(new DBRefEntry(DBRefSource.UNIPROT, "0", entries[0].getAccessionId()));
            }
        }
        this.ap.paintAlignment(true);
    }

    class BlastThread
    extends Thread {
        Sequence sequence;
        String jobid;
        boolean jobComplete = false;

        BlastThread(Sequence sequence) {
            System.out.println("blasting for: " + sequence.getName());
            this.sequence = sequence;
        }

        public void run() {
            this.StartJob();
            while (!this.jobComplete) {
                try {
                    WSWUBlastServiceLocator service = new WSWUBlastServiceLocator();
                    WSWUBlast wublast = service.getWSWUBlast();
                    WSFile[] results = wublast.getResults(this.jobid);
                    if (results != null) {
                        String result = new String(wublast.poll(this.jobid, "tooloutput"));
                        WSWUBlastClient.this.parseResult(this.sequence, result);
                        this.jobComplete = true;
                        --WSWUBlastClient.this.jobsRunning;
                        continue;
                    }
                    Thread.sleep(10000L);
                    System.out.println("WSWuBlastClient: I'm alive " + this.sequence.getName() + " " + this.jobid);
                }
                catch (Exception exception) {}
            }
        }

        void StartJob() {
            InputParams params = new InputParams();
            params.setProgram("blastp");
            params.setDatabase("uniprot");
            params.setMatrix("pam10");
            params.setNumal(5);
            params.setSensitivity("low");
            params.setSort("totalscore");
            params.setOutformat("txt");
            params.setAsync(true);
            try {
                Data[] inputs = new Data[1];
                Data input = new Data();
                input.setType("sequence");
                input.setContent(AlignSeq.extractGaps("-. ", this.sequence.getSequenceAsString()));
                inputs[0] = input;
                WSWUBlastServiceLocator service = new WSWUBlastServiceLocator();
                WSWUBlast wublast = service.getWSWUBlast();
                this.jobid = wublast.runWUBlast(params, inputs);
            }
            catch (Exception exp) {
                this.jobComplete = true;
                --WSWUBlastClient.this.jobsRunning;
                System.err.println("WSWUBlastClient error:\n" + exp.toString());
                exp.printStackTrace();
            }
        }
    }

    class ImageTwirler
    extends Thread {
        ImageIcon[] imageIcon = new ImageIcon[9];
        int imageIndex = 0;

        public ImageTwirler() {
            for (int i = 0; i < 9; ++i) {
                URL url = this.getClass().getResource("/images/dna" + (i + 1) + ".gif");
                if (url == null) continue;
                this.imageIcon[i] = new ImageIcon(url);
            }
        }

        public void run() {
            while (WSWUBlastClient.this.jobsRunning > 0) {
                try {
                    Thread.sleep(100L);
                    ++this.imageIndex;
                    this.imageIndex %= 9;
                    WSWUBlastClient.this.output.setFrameIcon(this.imageIcon[this.imageIndex]);
                    WSWUBlastClient.this.output.setTitle("BLASTing for unidentified sequences - " + WSWUBlastClient.this.jobsRunning + " jobs running.");
                }
                catch (Exception exception) {}
            }
            if (WSWUBlastClient.this.jobsRunning == 0) {
                WSWUBlastClient.this.updateIds();
            }
        }
    }
}

