/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.vamsas;

import jalview.bin.Cache;
import jalview.io.VamsasAppDatastore;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Vector;
import uk.ac.vamsas.client.IClientDocument;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.client.VorbaId;
import uk.ac.vamsas.objects.core.Entry;
import uk.ac.vamsas.objects.core.Provenance;
import uk.ac.vamsas.objects.core.Seg;

public class DatastoreItem {
    Entry provEntry = null;
    IClientDocument cdoc;
    Hashtable vobj2jv;
    IdentityHashMap jv2vobj;
    VamsasAppDatastore datastore = null;

    protected Vobject getjv2vObj(Object jvobj) {
        if (this.jv2vobj.containsKey(jvobj)) {
            return this.cdoc.getObject((VorbaId)this.jv2vobj.get(jvobj));
        }
        if (Cache.log.isDebugEnabled()) {
            Cache.log.debug((Object)("Returning null VorbaID binding for jalview object " + jvobj));
        }
        return null;
    }

    protected Object getvObj2jv(Vobject vobj) {
        if (this.vobj2jv == null) {
            return null;
        }
        VorbaId id = vobj.getVorbaId();
        if (id == null) {
            id = this.cdoc.registerObject(vobj);
            Cache.log.debug((Object)"Registering new object and returning null for getvObj2jv");
            return null;
        }
        if (this.vobj2jv.containsKey(vobj.getVorbaId())) {
            return this.vobj2jv.get(vobj.getVorbaId());
        }
        return null;
    }

    protected void bindjvvobj(Object jvobj, Vobject vobj) {
        VorbaId id = vobj.getVorbaId();
        if (id == null && ((id = this.cdoc.registerObject(vobj)) == null || vobj.getVorbaId() == null || this.cdoc.getObject(id) != vobj)) {
            Cache.log.error((Object)("Failed to get id for " + (vobj.isRegisterable() ? "registerable" : "unregisterable") + " object " + vobj));
        }
        if (this.vobj2jv.containsKey(vobj.getVorbaId()) && !((VorbaId)this.vobj2jv.get(vobj.getVorbaId())).equals(jvobj)) {
            Cache.log.debug((Object)("Warning? Overwriting existing vamsas id binding for " + vobj.getVorbaId()), (Throwable)new Exception("Overwriting vamsas id binding."));
        } else if (this.jv2vobj.containsKey(jvobj) && !((VorbaId)this.jv2vobj.get(jvobj)).equals((Object)vobj.getVorbaId())) {
            Cache.log.debug((Object)("Warning? Overwriting existing jalview object binding for " + jvobj), (Throwable)new Exception("Overwriting jalview object binding."));
        }
        Cache.log.debug((Object)("Binding " + vobj.getVorbaId() + " to " + jvobj));
        this.vobj2jv.put(vobj.getVorbaId(), jvobj);
        this.jv2vobj.put(jvobj, vobj.getVorbaId());
    }

    public DatastoreItem() {
    }

    public DatastoreItem(VamsasAppDatastore datastore) {
        this();
        this.initDatastoreItem(datastore);
    }

    public void initDatastoreItem(VamsasAppDatastore ds) {
        this.datastore = ds;
        this.initDatastoreItem(ds.getProvEntry(), ds.getClientDocument(), ds.getVamsasObjectBinding(), ds.getJvObjectBinding());
    }

    public void initDatastoreItem(Entry provEntry, IClientDocument cdoc, Hashtable vobj2jv, IdentityHashMap jv2vobj) {
        this.provEntry = provEntry;
        this.cdoc = cdoc;
        this.vobj2jv = vobj2jv;
        this.jv2vobj = jv2vobj;
    }

    protected boolean isModifiable(String modifiable) {
        return modifiable == null;
    }

    protected Vector getjv2vObjs(Vector alsq) {
        Vector<Vobject> vObjs = new Vector<Vobject>();
        Enumeration elm = alsq.elements();
        while (elm.hasMoreElements()) {
            vObjs.addElement(this.getjv2vObj(elm.nextElement()));
        }
        return vObjs;
    }

    public int[] getSegRange(Seg visSeg, boolean ensureDirection) {
        boolean incl = visSeg.getInclusive();
        int pol = visSeg.getStart() <= visSeg.getEnd() ? 1 : -1;
        int start = visSeg.getStart() + (incl ? 0 : pol);
        int end = visSeg.getEnd() + (incl ? 0 : -pol);
        if (ensureDirection && pol == -1) {
            int t = end;
            end = start;
            start = t;
        }
        return new int[]{start, end, pol < 0 ? 1 : 0};
    }

    protected jalview.datamodel.Provenance getJalviewProvenance(Provenance prov) {
        jalview.datamodel.Provenance jprov = new jalview.datamodel.Provenance();
        for (int i = 0; i < prov.getEntryCount(); ++i) {
            jprov.addEntry(prov.getEntry(i).getUser(), prov.getEntry(i).getAction(), prov.getEntry(i).getDate(), prov.getEntry(i).getId());
        }
        return jprov;
    }

    Provenance dummyProvenance() {
        return this.dummyProvenance(null);
    }

    protected Entry dummyPEntry(String action) {
        Entry entry = new Entry();
        entry.setApp(this.provEntry.getApp());
        if (action != null) {
            entry.setAction(action);
        } else {
            entry.setAction("created.");
        }
        entry.setDate(new Date());
        entry.setUser(this.provEntry.getUser());
        return entry;
    }

    protected Provenance dummyProvenance(String action) {
        Provenance prov = new Provenance();
        prov.addEntry(this.dummyPEntry(action));
        return prov;
    }

    protected void addProvenance(Provenance p, String action) {
        p.addEntry(this.dummyPEntry(action));
    }
}

