/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.vamsas;

import jalview.bin.Cache;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.Mapping;
import jalview.datamodel.SequenceI;
import jalview.io.VamsasAppDatastore;
import jalview.io.vamsas.Rangetype;
import jalview.structure.StructureSelectionManager;
import jalview.util.MapList;
import java.util.Vector;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.objects.core.AlignmentSequence;
import uk.ac.vamsas.objects.core.DataSet;
import uk.ac.vamsas.objects.core.MapType;
import uk.ac.vamsas.objects.core.Sequence;
import uk.ac.vamsas.objects.core.SequenceMapping;
import uk.ac.vamsas.objects.core.SequenceType;

public class Sequencemapping
extends Rangetype {
    public Sequencemapping(VamsasAppDatastore datastore, SequenceMapping sequenceMapping) {
        super(datastore);
        Object mjvmapping = this.getvObj2jv((Vobject)sequenceMapping);
        if (mjvmapping == null) {
            this.add(sequenceMapping);
        } else if (sequenceMapping.isUpdated()) {
            this.update((MapList)mjvmapping, sequenceMapping);
        }
    }

    public Sequencemapping(VamsasAppDatastore datastore, Mapping mjvmapping, SequenceType from, DataSet ds) {
        super(datastore);
        SequenceMapping sequenceMapping = (SequenceMapping)this.getjv2vObj(mjvmapping);
        if (sequenceMapping == null) {
            this.add(mjvmapping, from, ds);
        } else {
            if (from != null && sequenceMapping.getLoc() != from) {
                Cache.log.warn((Object)("Probable IMPLEMENTATION ERROR: " + from + " doesn't match the local mapping sequence."));
            }
            if (ds != null && sequenceMapping.is__stored_in_document() && sequenceMapping.getV_parent() != ds) {
                Cache.log.warn((Object)("Probable IMPLEMENTATION ERROR: " + ds + " doesn't match the parent of the bound sequence mapping object."));
            }
            if (sequenceMapping.isUpdated()) {
                this.conflict(mjvmapping, sequenceMapping);
            } else {
                this.update(mjvmapping, sequenceMapping);
            }
        }
    }

    private void conflict(Mapping mjvmapping, SequenceMapping sequenceMapping) {
        System.err.println("Conflict in update of sequenceMapping " + sequenceMapping.getVorbaId());
    }

    private void add(Mapping mjvmapping, SequenceType from, DataSet ds) {
        SequenceI jvto = mjvmapping.getTo();
        while (jvto.getDatasetSequence() != null) {
            jvto = jvto.getDatasetSequence();
        }
        SequenceType to = (SequenceType)this.getjv2vObj(jvto);
        if (to == null) {
            Cache.log.warn((Object)"NONFATAL - do a second update: Ignoring Forward Reference to seuqence not yet bound to vamsas seuqence object");
            return;
        }
        SequenceMapping sequenceMapping = new SequenceMapping();
        sequenceMapping.setLoc((Object)from);
        sequenceMapping.setMap((Object)to);
        boolean dnaToProt = false;
        boolean sense = false;
        if (((Sequence)sequenceMapping.getLoc()).getDictionary().equals("info:iubmb.org/nucleosides")) {
            if (((Sequence)sequenceMapping.getMap()).getDictionary().equals("info:iubmb.org/aminoacids")) {
                dnaToProt = true;
                sense = true;
            }
        } else if (((Sequence)sequenceMapping.getMap()).getDictionary().equals("info:iubmb.org/nucleosides")) {
            dnaToProt = true;
            sense = false;
        }
        if (!dnaToProt) {
            Cache.log.warn((Object)"Ignoring Mapping - don't support protein to protein mapping in vamsas document yet.");
            return;
        }
        if (ds == null) {
            ds = sense ? (DataSet)((Vobject)sequenceMapping.getLoc()).getV_parent() : (DataSet)((Vobject)sequenceMapping.getMap()).getV_parent();
        }
        if (sense) {
            this.initMapType((MapType)sequenceMapping, mjvmapping.getMap(), true);
        } else {
            this.initMapType((MapType)sequenceMapping, mjvmapping.getMap().getInverse(), true);
        }
        ds.addSequenceMapping(sequenceMapping);
        sequenceMapping.setProvenance(this.dummyProvenance("user defined coding region translation"));
        this.bindjvvobj(mjvmapping.getMap(), (Vobject)sequenceMapping);
        Cache.log.debug((Object)("Successfully created mapping " + sequenceMapping.getVorbaId()));
    }

    private void update(MapList mjvmapping, SequenceMapping sequenceMapping) {
        Cache.log.error((Object)"Not implemented: Jalview Update Alcodon Mapping:TODO!");
    }

    private void update(Mapping mjvmapping, SequenceMapping sequenceMapping) {
        Cache.log.error((Object)"Not implemented: Jalview Update Sequence DBRef Mapping");
    }

    private void add(SequenceMapping sequenceMapping) {
        SequenceI from = null;
        SequenceI to = null;
        boolean dnaToProt = false;
        boolean sense = false;
        Sequence sdloc = null;
        Sequence sdmap = null;
        sdloc = sequenceMapping.getLoc() instanceof AlignmentSequence ? (Sequence)((AlignmentSequence)sequenceMapping.getLoc()).getRefid() : (Sequence)sequenceMapping.getLoc();
        sdmap = sequenceMapping.getMap() instanceof AlignmentSequence ? (Sequence)((AlignmentSequence)sequenceMapping.getMap()).getRefid() : (Sequence)sequenceMapping.getMap();
        if (sdloc == null || sdmap == null) {
            Cache.log.info((Object)"Ignoring non sequence-sequence mapping");
            return;
        }
        Object mobj = this.getvObj2jv((Vobject)sdloc);
        if (mobj instanceof SequenceI) {
            from = (SequenceI)mobj;
        }
        if ((mobj = this.getvObj2jv((Vobject)sdmap)) instanceof SequenceI) {
            to = (SequenceI)mobj;
        }
        if (from == null || to == null) {
            Cache.log.error((Object)"Probable Vamsas implementation error : unbound dataset sequences involved in a mapping are being parsed!");
            return;
        }
        if (sdloc.getDictionary().equals("info:iubmb.org/nucleosides")) {
            if (sdmap.getDictionary().equals("info:iubmb.org/aminoacids")) {
                dnaToProt = true;
                sense = true;
            }
        } else if (sdmap.getDictionary().equals("info:iubmb.org/nucleosides")) {
            dnaToProt = true;
            sense = false;
        }
        AlignmentI dsLoc = (AlignmentI)this.getvObj2jv(sdloc.getV_parent());
        AlignmentI dsMap = (AlignmentI)this.getvObj2jv(sdmap.getV_parent());
        AlignedCodonFrame afc = new AlignedCodonFrame(0);
        if (dsLoc != null && dsLoc != dsMap) {
            dsLoc.addCodonFrame(afc);
        }
        if (dsMap != null) {
            dsMap.addCodonFrame(afc);
        }
        MapList mapping = null;
        if (!sense) {
            mapping = this.parsemapType((MapType)sequenceMapping, 1, 3);
            mapping = new MapList(mapping.getToRanges(), mapping.getFromRanges(), mapping.getToRatio(), mapping.getFromRatio());
            afc.addMap(to, from, mapping);
        } else {
            mapping = this.parsemapType((MapType)sequenceMapping, 3, 1);
            afc.addMap(from, to, mapping);
        }
        this.bindjvvobj(mapping, (Vobject)sequenceMapping);
        StructureSelectionManager.getStructureSelectionManager().addMappings(new AlignedCodonFrame[]{afc});
    }

    private void matchConjugateDBRefs(SequenceI from, SequenceI to, MapList smap) {
        if (from.getDBRef() == null && to.getDBRef() == null) {
            if (Cache.log.isDebugEnabled()) {
                Cache.log.debug((Object)("Not matching conjugate refs for " + from.getName() + " and " + to.getName()));
            }
            return;
        }
        if (Cache.log.isDebugEnabled()) {
            Cache.log.debug((Object)("Matching conjugate refs for " + from.getName() + " and " + to.getName()));
        }
        DBRefEntry[] fdb = from.getDBRef();
        DBRefEntry[] tdb = new DBRefEntry[to.getDBRef().length];
        int tdblen = to.getDBRef().length;
        System.arraycopy(to.getDBRef(), 0, tdb, 0, tdblen);
        Vector matched = new Vector();
        MapList smapI = smap.getInverse();
        for (int f = 0; f < fdb.length; ++f) {
            DBRefEntry fe = fdb[f];
            Mapping fmp = fe.getMap();
            boolean fmpnnl = fmp != null;
            boolean smapfromlocal2fe = fmpnnl ? smap.equals(fmp.getMap()) : false;
            boolean smapfromfemap2local = fmpnnl ? smapI.equals(fmp.getMap()) : false;
            for (int t = 0; t < tdblen; ++t) {
                boolean smaptotemap2local;
                boolean tmpnnl;
                DBRefEntry te = tdb[t];
                if (te == null || !fe.getSource().equals(te.getSource()) || !fe.getAccessionId().equals(te.getAccessionId())) continue;
                Mapping tmp = te.getMap();
                boolean bl = tmpnnl = tmp != null;
                if (!tmpnnl || tmp.getTo() != null) {
                    // empty if block
                }
                boolean smaptolocal2tm = tmpnnl ? smap.equals(tmp.getMap()) : false;
                boolean bl2 = smaptotemap2local = tmpnnl ? smapI.equals(fmp.getMap()) : false;
                if (smapfromlocal2fe && smaptotemap2local) {
                    fmp.setTo(to);
                    tmp.setTo(from);
                    continue;
                }
                if (!smapfromfemap2local || !smaptolocal2tm) continue;
                fmp.setTo(to);
            }
        }
    }
}

