/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import jalview.analysis.AlignSeq;
import jalview.bin.Cache;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.Mapping;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.OOMWarning;
import jalview.util.DBRefUtils;
import jalview.ws.SequenceFetcher;
import jalview.ws.seqfetcher.DbSourceProxy;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class DBRefFetcher
implements Runnable {
    SequenceI[] dataset;
    IProgressIndicator af;
    CutAndPasteTransfer output = new CutAndPasteTransfer();
    StringBuffer sbuffer = new StringBuffer();
    boolean running = false;
    Hashtable seqRefs;
    String[] dbSources;
    SequenceFetcher sfetcher;

    public DBRefFetcher() {
    }

    public DBRefFetcher(SequenceI[] seqs, AlignFrame af) {
        this.af = af;
        SequenceI[] ds = new SequenceI[seqs.length];
        for (int i = 0; i < seqs.length; ++i) {
            ds[i] = seqs[i].getDatasetSequence() != null ? seqs[i].getDatasetSequence() : seqs[i];
        }
        this.dataset = ds;
        this.sfetcher = jalview.gui.SequenceFetcher.getSequenceFetcherSingleton(af);
        this.dbSources = af.getViewport().getAlignment().isNucleotide() ? DBRefSource.DNACODINGDBS : DBRefSource.PROTEINDBS;
    }

    public void fetchDBRefs(boolean waitTillFinished) {
        Thread thread = new Thread(this);
        thread.start();
        this.running = true;
        if (waitTillFinished) {
            while (this.running) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
        }
    }

    void addSeqId(SequenceI seq, String key) {
        Vector<SequenceI> seqs;
        if (this.seqRefs.containsKey(key = key.toUpperCase())) {
            seqs = (Vector<SequenceI>)this.seqRefs.get(key);
            if (seqs != null && !seqs.contains(seq)) {
                seqs.addElement(seq);
            } else if (seqs == null) {
                seqs = new Vector<SequenceI>();
                seqs.addElement(seq);
            }
        } else {
            seqs = new Vector<SequenceI>();
            seqs.addElement(seq);
        }
        this.seqRefs.put(key, seqs);
    }

    public void run() {
        if (this.dbSources == null) {
            throw new Error("Implementation error. Must initialise dbSources");
        }
        long startTime = System.currentTimeMillis();
        this.af.setProgressBar("Fetching db refs", startTime);
        this.running = true;
        int db = 0;
        Vector<SequenceI> sdataset = new Vector<SequenceI>();
        for (int s = 0; s < this.dataset.length; ++s) {
            sdataset.addElement(this.dataset[s]);
        }
        while (sdataset.size() > 0 && db < this.dbSources.length) {
            int maxqlen = 1;
            System.err.println("Verifying against " + this.dbSources[db]);
            DbSourceProxy dbsource = this.sfetcher.getSourceProxy(this.dbSources[db]);
            if (dbsource == null) {
                System.err.println("No proxy for " + this.dbSources[db]);
                ++db;
                continue;
            }
            maxqlen = dbsource.getDbSourceProperties().containsKey(DBRefSource.MULTIACC) ? (Integer)dbsource.getDbSourceProperties().get(DBRefSource.MULTIACC) : 1;
            Object[] currSeqs = new SequenceI[sdataset.size()];
            sdataset.copyInto(currSeqs);
            Vector<String> queries = new Vector<String>();
            this.seqRefs = new Hashtable();
            int seqIndex = 0;
            while (queries.size() > 0 || seqIndex < currSeqs.length) {
                if (queries.size() > 0) {
                    int nqSize;
                    StringBuffer queryString = new StringBuffer("");
                    int numq = 0;
                    int n = nqSize = maxqlen > queries.size() ? queries.size() : maxqlen;
                    while (queries.size() > 0 && numq < nqSize) {
                        String query = (String)queries.elementAt(0);
                        if (dbsource.isValidReference(query)) {
                            queryString.append(numq == 0 ? "" : dbsource.getAccessionSeparator());
                            queryString.append(query);
                            ++numq;
                        }
                        queries.removeElementAt(0);
                    }
                    AlignmentI retrieved = null;
                    try {
                        if (Cache.log.isDebugEnabled()) {
                            Cache.log.debug((Object)("Querying " + dbsource.getDbName() + " with : '" + queryString.toString() + "'"));
                        }
                        retrieved = dbsource.getSequenceRecords(queryString.toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    catch (OutOfMemoryError err) {
                        new OOMWarning("retrieving database references (" + queryString.toString() + ")", err);
                    }
                    if (retrieved == null) continue;
                    this.transferReferences(sdataset, this.dbSources[db], retrieved);
                    continue;
                }
                for (int i = 0; seqIndex < this.dataset.length && i < 50; ++seqIndex, ++i) {
                    SequenceI sequence = this.dataset[seqIndex];
                    DBRefEntry[] uprefs = DBRefUtils.selectRefs(sequence.getDBRef(), new String[]{this.dbSources[db]});
                    if (uprefs != null && uprefs.length > 0) {
                        for (int j = 0; j < uprefs.length; ++j) {
                            this.addSeqId(sequence, uprefs[j].getAccessionId());
                            queries.addElement(uprefs[j].getAccessionId().toUpperCase());
                        }
                        continue;
                    }
                    StringTokenizer st = new StringTokenizer(sequence.getName(), "|");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        this.addSeqId(sequence, token);
                        queries.addElement(token.toUpperCase());
                    }
                }
            }
            ++db;
        }
        if (this.sbuffer.length() > 0) {
            this.output.setText("Your sequences have been verified against known sequence databases. Some of the ids have been\naltered, most likely the start/end residue will have been updated.\nSave your alignment to maintain the updated id.\n\n" + this.sbuffer.toString());
            Desktop.addInternalFrame(this.output, "Sequence names updated ", 600, 300);
        }
        this.af.setProgressBar("DBRef search completed", startTime);
        this.running = false;
    }

    void transferReferences(Vector sdataset, String dbSource, AlignmentI retrievedAl) {
        if (retrievedAl == null || retrievedAl.getHeight() == 0) {
            return;
        }
        SequenceI[] retrieved = retrievedAl.getSequencesArray();
        SequenceI sequence = null;
        int iSize = retrieved.length;
        for (int i = 0; i < iSize; ++i) {
            SequenceI entry = retrieved[i];
            Vector<SequenceI> sequenceMatches = new Vector<SequenceI>();
            DBRefEntry[] entryRefs = DBRefUtils.selectRefs(entry.getDBRef(), new String[]{dbSource});
            for (int j = 0; j < entryRefs.length; ++j) {
                String accessionId = entryRefs[j].getAccessionId();
                if (!this.seqRefs.containsKey(accessionId.toUpperCase())) continue;
                Vector seqs = (Vector)this.seqRefs.get(accessionId);
                for (int jj = 0; jj < seqs.size(); ++jj) {
                    sequence = (SequenceI)seqs.elementAt(jj);
                    if (sequenceMatches.contains(sequence)) continue;
                    sequenceMatches.addElement(sequence);
                }
            }
            if (sequenceMatches.size() == 0) {
                Enumeration e = this.seqRefs.keys();
                while (e.hasMoreElements()) {
                    Vector sqs = (Vector)this.seqRefs.get(e.nextElement());
                    if (sqs == null || sqs.size() <= 0) continue;
                    Enumeration sqe = sqs.elements();
                    while (sqe.hasMoreElements()) {
                        sequenceMatches.addElement((SequenceI)sqe.nextElement());
                    }
                }
            }
            String entrySeq = entry.getSequenceAsString().toUpperCase();
            for (int m = 0; m < sequenceMatches.size(); ++m) {
                Mapping mp;
                sequence = (SequenceI)sequenceMatches.elementAt(m);
                boolean updateRefFrame = sequence.getDBRef() == null || sequence.getDBRef().length == 0;
                String nonGapped = AlignSeq.extractGaps("-. ", sequence.getSequenceAsString()).toUpperCase();
                int absStart = entrySeq.indexOf(nonGapped);
                int mapStart = entry.getStart();
                if (absStart == -1) {
                    absStart = nonGapped.indexOf(entrySeq);
                    if (absStart == -1) {
                        this.sbuffer.append(sequence.getName() + " SEQUENCE NOT %100 MATCH \n");
                        continue;
                    }
                    this.sbuffer.append(sequence.getName() + " HAS " + absStart + " PREFIXED RESIDUES COMPARED TO " + dbSource + "\n");
                    mp = new Mapping(null, new int[]{sequence.getStart() + absStart, sequence.getStart() + absStart + entrySeq.length() - 1}, new int[]{entry.getStart(), entry.getStart() + entrySeq.length() - 1}, 1, 1);
                    updateRefFrame = false;
                } else {
                    mp = null;
                    if (updateRefFrame && sequence.getSequenceFeatures() != null) {
                        SequenceFeature[] sf = sequence.getSequenceFeatures();
                        int start = sequence.getStart();
                        int end = sequence.getEnd();
                        int startShift = 1 - absStart - start;
                        for (int sfi = 0; sfi < sf.length; ++sfi) {
                            if (sf[sfi].getBegin() < start || sf[sfi].getEnd() > end) continue;
                            sf[sfi].setBegin(sf[sfi].getBegin() + startShift);
                            sf[sfi].setEnd(sf[sfi].getEnd() + startShift);
                        }
                    }
                }
                System.out.println("Adding dbrefs to " + sequence.getName() + " from " + dbSource + " sequence : " + entry.getName());
                sequence.transferAnnotation(entry, mp);
                int absEnd = absStart + nonGapped.length();
                ++absStart;
                if (updateRefFrame) {
                    sequence.setStart(absStart);
                    sequence.setEnd(absEnd);
                }
                sdataset.remove(sequence);
            }
        }
    }
}

