/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import ext.vamsas.ServiceHandle;
import jalview.gui.AlignFrame;
import jalview.gui.WebserviceInfo;
import java.util.Hashtable;
import javax.swing.JMenu;

public abstract class WSClient {
    protected String WebServiceName;
    protected String WebServiceJobTitle;
    protected String WebServiceReference;
    protected String WsURL;
    protected WebserviceInfo wsInfo;
    int jobsRunning = 0;
    protected Hashtable ServiceActions = new Hashtable();
    ServiceHandle serviceHandle;

    public WSClient() {
        this.ServiceActions.put("MsaWS", "Multiple Sequence Alignment");
        this.ServiceActions.put("SecStrPred", "Secondary Structure Prediction");
        this.serviceHandle = null;
    }

    protected WebserviceInfo setWebService(ServiceHandle sh) {
        return this.setWebService(sh, false);
    }

    protected WebserviceInfo setWebService(ServiceHandle sh, boolean headless) {
        this.WebServiceName = sh.getName();
        this.WebServiceJobTitle = this.ServiceActions.containsKey(sh.getAbstractName()) ? sh.getName() : sh.getAbstractName() + " using " + sh.getName();
        this.WebServiceReference = sh.getDescription();
        this.WsURL = sh.getEndpointURL();
        WebserviceInfo wsInfo = null;
        if (!headless) {
            wsInfo = new WebserviceInfo(this.WebServiceJobTitle, this.WebServiceReference);
        }
        return wsInfo;
    }

    public void attachWSMenuEntry(JMenu wsmenu, AlignFrame alignFrame) {
        if (this.serviceHandle == null) {
            throw new Error("IMPLEMENTATION ERROR: cannot attach WS Menu Entry without service handle reference!");
        }
        this.attachWSMenuEntry(wsmenu, this.serviceHandle, alignFrame);
    }

    public abstract void attachWSMenuEntry(JMenu var1, ServiceHandle var2, AlignFrame var3);
}

