/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.dbsources;

import com.stevesoft.pat.Regex;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefSource;
import jalview.ws.dbsources.EmblXmlSource;
import jalview.ws.seqfetcher.DbSourceProxy;

public class EmblSource
extends EmblXmlSource
implements DbSourceProxy {
    public EmblSource() {
        this.addDbSourceProperty(DBRefSource.DNASEQDB);
        this.addDbSourceProperty(DBRefSource.CODINGSEQDB);
    }

    public String getAccessionSeparator() {
        return null;
    }

    public Regex getAccessionValidator() {
        return null;
    }

    public String getDbSource() {
        return DBRefSource.EMBL;
    }

    public String getDbVersion() {
        return "0";
    }

    public AlignmentI getSequenceRecords(String queries) throws Exception {
        return this.getEmblSequenceRecords(DBRefSource.EMBL, queries);
    }

    public boolean isValidReference(String accession) {
        return accession == null || accession.length() < 2 ? false : new Regex("^[A-Z]+[0-9]+$").search(accession);
    }

    public String getTestQuery() {
        return "X53828";
    }

    public String getDbName() {
        return "EMBL";
    }
}

