/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.dbsources;

import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.datamodel.xdb.embl.EmblEntry;
import jalview.datamodel.xdb.embl.EmblFile;
import jalview.ws.dbsources.EbiFileRetrievedProxy;
import jalview.ws.ebi.EBIFetchClient;
import java.io.File;
import java.util.Iterator;

public abstract class EmblXmlSource
extends EbiFileRetrievedProxy {
    public EmblFile efile = null;

    public AlignmentI getEmblSequenceRecords(String emprefx, String query) throws Exception {
        File reply;
        this.startQuery();
        EBIFetchClient dbFetch = new EBIFetchClient();
        try {
            reply = dbFetch.fetchDataAsFile(emprefx.toLowerCase() + ":" + query.trim(), "emblxml", null);
        }
        catch (Exception e) {
            this.stopQuery();
            throw new Exception("EBI EMBL XML retrieval failed on " + emprefx.toLowerCase() + ":" + query.trim(), e);
        }
        return this.getEmblSequenceRecords(emprefx, query, reply);
    }

    public AlignmentI getEmblSequenceRecords(String emprefx, String query, File reply) throws Exception {
        SequenceI[] seqs = null;
        StringBuffer result = new StringBuffer();
        if (reply != null && reply.exists()) {
            this.efile = null;
            this.file = reply.getAbsolutePath();
            if (reply.length() > 25L) {
                this.efile = EmblFile.getEmblFile(reply);
            } else {
                result.append("# No EMBL record retrieved for " + emprefx.toLowerCase() + ":" + query.trim());
            }
        }
        if (this.efile != null) {
            Iterator i = this.efile.getEntries().iterator();
            while (i.hasNext()) {
                int si;
                EmblEntry entry = (EmblEntry)i.next();
                SequenceI[] seqparts = entry.getSequences(false, true, emprefx);
                if (seqparts == null) continue;
                SequenceI[] newseqs = null;
                if (seqs == null) {
                    newseqs = new SequenceI[seqparts.length];
                } else {
                    newseqs = new SequenceI[seqs.length + seqparts.length];
                    for (si = 0; si < seqs.length; ++si) {
                        newseqs[si] = seqs[si];
                        seqs[si] = null;
                    }
                }
                for (int j = 0; j < seqparts.length; ++j) {
                    newseqs[si] = seqparts[j].deriveSequence();
                    ++si;
                }
                seqs = newseqs;
            }
        } else {
            result = null;
        }
        Alignment al = null;
        if (seqs != null && seqs.length > 0) {
            al = new Alignment(seqs);
            result.append("# Successfully parsed the " + emprefx + " queries into an Alignment");
            this.results = result;
        }
        this.stopQuery();
        return al;
    }
}

