/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.dbsources;

import MCview.PDBChain;
import MCview.PDBfile;
import com.stevesoft.pat.Regex;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AppletFormatAdapter;
import jalview.ws.dbsources.EbiFileRetrievedProxy;
import jalview.ws.ebi.EBIFetchClient;
import jalview.ws.seqfetcher.DbSourceProxy;
import java.util.Vector;

public class Pdb
extends EbiFileRetrievedProxy
implements DbSourceProxy {
    public Pdb() {
        this.addDbSourceProperty(DBRefSource.PROTSEQDB);
    }

    public String getAccessionSeparator() {
        return null;
    }

    public Regex getAccessionValidator() {
        return new Regex("([1-9][0-9A-Za-z]{3}):?([ _A-Za-z0-9]?)");
    }

    public String getDbSource() {
        return DBRefSource.PDB;
    }

    public String getDbVersion() {
        return "0";
    }

    public AlignmentI getSequenceRecords(String queries) throws Exception {
        int i;
        Vector<SequenceI> result = new Vector<SequenceI>();
        String chain = null;
        String id = null;
        if (queries.indexOf(":") > -1) {
            chain = queries.substring(queries.indexOf(":") + 1);
            id = queries.substring(0, queries.indexOf(":"));
        } else {
            id = queries;
        }
        if (queries.length() > 4 && chain == null) {
            chain = queries.substring(4, 5);
            id = queries.substring(0, 4);
        }
        if (!this.isValidReference(id)) {
            System.err.println("Ignoring invalid pdb query: '" + id + "'");
            this.stopQuery();
            return null;
        }
        EBIFetchClient ebi = new EBIFetchClient();
        this.file = ebi.fetchDataAsFile("pdb:" + id, "pdb", "raw").getAbsolutePath();
        this.stopQuery();
        if (this.file == null) {
            return null;
        }
        try {
            PDBfile pdbfile = new PDBfile(this.file, AppletFormatAdapter.FILE);
            for (i = 0; i < pdbfile.chains.size(); ++i) {
                if (chain != null && !((PDBChain)pdbfile.chains.elementAt((int)i)).id.toUpperCase().equals(chain)) continue;
                PDBChain pdbchain = (PDBChain)pdbfile.chains.elementAt(i);
                Sequence sq = pdbchain.sequence;
                sq.setName(DBRefSource.PDB + "|" + id + "|" + sq.getName());
                DBRefEntry dbentry = new DBRefEntry(this.getDbSource(), this.getDbVersion(), id + pdbchain.id);
                sq.addDBRef(dbentry);
                result.addElement(sq.deriveSequence());
            }
            if (result.size() < 1) {
                throw new Exception("No PDB Records for " + id + " chain " + (chain == null ? "' '" : chain));
            }
        }
        catch (Exception ex) {
            this.stopQuery();
            throw ex;
        }
        SequenceI[] results = new SequenceI[result.size()];
        int j = result.size();
        for (i = 0; i < j; ++i) {
            results[i] = (SequenceI)result.elementAt(i);
            result.setElementAt(null, i);
        }
        return new Alignment(results);
    }

    public boolean isValidReference(String accession) {
        Regex r = this.getAccessionValidator();
        return r.search(accession.trim());
    }

    public String getTestQuery() {
        return "1QIPA";
    }

    public String getDbName() {
        return "PDB";
    }
}

