/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.dbsources;

import com.stevesoft.pat.Regex;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.io.FormatAdapter;
import jalview.ws.seqfetcher.DbSourceProxy;
import jalview.ws.seqfetcher.DbSourceProxyImpl;

public abstract class Pfam
extends DbSourceProxyImpl
implements DbSourceProxy {
    public Pfam() {
        this.addDbSourceProperty(DBRefSource.DOMAINDB);
    }

    public String getAccessionSeparator() {
        return null;
    }

    public Regex getAccessionValidator() {
        return null;
    }

    public String getDbVersion() {
        return null;
    }

    protected abstract String getPFAMURL();

    public AlignmentI getSequenceRecords(String queries) throws Exception {
        this.startQuery();
        Alignment rcds = new FormatAdapter().readFile(this.getPFAMURL() + queries.trim().toUpperCase(), FormatAdapter.URL, "STH");
        int sNum = rcds.getHeight();
        for (int s = 0; s < sNum; ++s) {
            rcds.getSequenceAt(s).addDBRef(new DBRefEntry(DBRefSource.PFAM, this.getDbVersion(), queries.trim().toUpperCase()));
            if (this.getDbSource().equals(DBRefSource.PFAM)) continue;
            rcds.getSequenceAt(s).addDBRef(new DBRefEntry(this.getDbSource(), this.getDbVersion(), queries.trim().toUpperCase()));
        }
        this.stopQuery();
        return rcds;
    }

    public boolean isValidReference(String accession) {
        return accession.indexOf("PF") == 0;
    }
}

