/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.dbsources;

import com.stevesoft.pat.Regex;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.datamodel.UniprotEntry;
import jalview.datamodel.UniprotFile;
import jalview.ws.ebi.EBIFetchClient;
import jalview.ws.seqfetcher.DbSourceProxy;
import jalview.ws.seqfetcher.DbSourceProxyImpl;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;

public class Uniprot
extends DbSourceProxyImpl
implements DbSourceProxy {
    private EBIFetchClient ebi = null;

    public Uniprot() {
        this.addDbSourceProperty(DBRefSource.SEQDB, DBRefSource.SEQDB);
        this.addDbSourceProperty(DBRefSource.PROTSEQDB);
    }

    public String getAccessionSeparator() {
        return null;
    }

    public Regex getAccessionValidator() {
        return null;
    }

    public String getDbSource() {
        return DBRefSource.UNIPROT;
    }

    public String getDbVersion() {
        return "0";
    }

    public Vector getUniprotEntries(File file) {
        UniprotFile uni = new UniprotFile();
        try {
            Mapping map = new Mapping(uni.getClass().getClassLoader());
            URL url = this.getClass().getResource("/uniprot_mapping.xml");
            map.loadMapping(url);
            Unmarshaller unmar = new Unmarshaller((Object)uni);
            unmar.setIgnoreExtraElements(true);
            unmar.setMapping(map);
            uni = (UniprotFile)unmar.unmarshal((Reader)new FileReader(file));
        }
        catch (Exception e) {
            System.out.println("Error getUniprotEntries() " + e);
        }
        return uni.getUniprotEntries();
    }

    public AlignmentI getSequenceRecords(String queries) throws Exception {
        this.startQuery();
        try {
            Alignment al = null;
            this.ebi = new EBIFetchClient();
            StringBuffer result = new StringBuffer();
            File file = this.ebi.fetchDataAsFile("uniprot:" + queries, "uniprotxml", null);
            Vector entries = this.getUniprotEntries(file);
            if (entries != null) {
                Enumeration en = entries.elements();
                while (en.hasMoreElements()) {
                    UniprotEntry entry = (UniprotEntry)en.nextElement();
                    StringBuffer name = new StringBuffer(">UniProt/Swiss-Prot");
                    Enumeration en2 = entry.getAccession().elements();
                    while (en2.hasMoreElements()) {
                        name.append("|");
                        name.append(en2.nextElement());
                    }
                    en2 = entry.getName().elements();
                    while (en2.hasMoreElements()) {
                        name.append("|");
                        name.append(en2.nextElement());
                    }
                    if (entry.getProtein() != null && entry.getProtein().getName() != null) {
                        int nmSize = entry.getProtein().getName().size();
                        for (int nm = 0; nm < nmSize; ++nm) {
                            name.append(" " + entry.getProtein().getName().elementAt(nm));
                        }
                    }
                    result.append(name + "\n" + entry.getUniprotSequence().getContent() + "\n");
                }
                al = this.parseResult(result.toString());
                if (al != null) {
                    this.addUniprotXrefs(al, entries);
                } else {
                    this.results = result;
                }
            }
            this.stopQuery();
            return al;
        }
        catch (Exception e) {
            this.stopQuery();
            throw e;
        }
    }

    public void addUniprotXrefs(Alignment al, Vector entries) {
        for (int i = 0; i < entries.size(); ++i) {
            UniprotEntry entry = (UniprotEntry)entries.elementAt(i);
            Enumeration e = entry.getDbReference().elements();
            Vector<PDBEntry> onlyPdbEntries = new Vector<PDBEntry>();
            Vector<DBRefEntry> dbxrefs = new Vector<DBRefEntry>();
            while (e.hasMoreElements()) {
                PDBEntry pdb = (PDBEntry)e.nextElement();
                DBRefEntry dbr = new DBRefEntry();
                dbr.setSource(pdb.getType());
                dbr.setAccessionId(pdb.getId());
                dbr.setVersion(DBRefSource.UNIPROT + ":" + this.getDbVersion());
                dbxrefs.addElement(dbr);
                if (!pdb.getType().equals("PDB")) continue;
                onlyPdbEntries.addElement(pdb);
            }
            SequenceI sq = al.getSequenceAt(i);
            while (sq.getDatasetSequence() != null) {
                sq = sq.getDatasetSequence();
            }
            Enumeration en2 = entry.getAccession().elements();
            while (en2.hasMoreElements()) {
                sq.addDBRef(new DBRefEntry(DBRefSource.UNIPROT, this.getDbVersion(), en2.nextElement().toString()));
            }
            en2 = dbxrefs.elements();
            while (en2.hasMoreElements()) {
                sq.addDBRef((DBRefEntry)en2.nextElement());
            }
            sq.setPDBId(onlyPdbEntries);
            if (entry.getFeature() == null) continue;
            e = entry.getFeature().elements();
            while (e.hasMoreElements()) {
                SequenceFeature sf = (SequenceFeature)e.nextElement();
                sf.setFeatureGroup("Uniprot");
                sq.addSequenceFeature(sf);
            }
        }
    }

    public boolean isValidReference(String accession) {
        return true;
    }

    public String getTestQuery() {
        return "P00340";
    }

    public String getDbName() {
        return "Uniprot";
    }
}

