/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.dbsources.das;

import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.ws.DasSequenceFeatureFetcher;
import jalview.ws.dbsources.DasSequenceSource;
import java.util.Vector;
import org.biojava.dasobert.dasregistry.Das1Source;
import org.biojava.dasobert.eventmodel.SequenceEvent;
import org.biojava.dasobert.eventmodel.SequenceListener;

public class DasSequenceSourceListener
implements SequenceListener {
    String ourAccession = null;
    DasSequenceSource oursource = null;
    Vector seqs = null;
    boolean noSequences = false;
    boolean called = false;

    public DasSequenceSourceListener(DasSequenceSource source, String query) {
        this.oursource = source;
        this.ourAccession = query;
    }

    public void clearSelection() {
    }

    public void newSequence(SequenceEvent e) {
        if (!e.getAccessionCode().equals(this.ourAccession)) {
            System.err.println("Warning - received sequence event for strange accession code (" + e.getAccessionCode() + ") - we expected " + this.ourAccession);
            return;
        }
        if (this.seqs == null) {
            if (e.getSequence().length() == 0) {
                System.err.println("Empty sequence returned for accession code (" + e.getAccessionCode() + ") from " + this.oursource.getDbName());
                this.called = true;
                this.noSequences = true;
                return;
            }
            this.seqs = new Vector();
        }
        Sequence sq = new Sequence(e.getAccessionCode(), e.getSequence());
        sq.addDBRef(new DBRefEntry(this.oursource.getDbSource(), this.oursource.getDbVersion() + ":" + e.getVersion(), e.getAccessionCode()));
        this.seqs.addElement(sq);
        this.called = true;
    }

    public void selectedSeqPosition(int position) {
    }

    public void selectedSeqRange(int start, int end) {
    }

    public void selectionLocked(boolean flag) {
    }

    public void newObjectRequested(String accessionCode) {
    }

    public void noObjectFound(String accessionCode) {
        if (accessionCode.equals(this.ourAccession)) {
            this.noSequences = true;
            this.called = true;
        }
    }

    public boolean hasNoSequences() {
        return this.noSequences;
    }

    public boolean isNotCalled() {
        return !this.called;
    }

    public AlignmentI getSequences() {
        if (this.noSequences || this.seqs != null && this.seqs.size() == 0) {
            return null;
        }
        SequenceI[] sqs = new SequenceI[this.seqs.size()];
        int iSize = this.seqs.size();
        for (int i = 0; i < iSize; ++i) {
            sqs[i] = (SequenceI)this.seqs.elementAt(i);
        }
        Alignment al = new Alignment(sqs);
        if (this.oursource.getSource().hasCapability("features")) {
            Vector<Das1Source> src = new Vector<Das1Source>();
            src.addElement(this.oursource.getSource());
            new DasSequenceFeatureFetcher(sqs, null, src, false, false);
        }
        return al;
    }
}

