/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.ebi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;

public class EBIFetchClient {
    Call call;
    String format = "default";
    String style = "raw";

    public EBIFetchClient() {
        try {
            this.call = (Call)new Service().createCall();
            this.call.setTargetEndpointAddress(new URL("http://www.ebi.ac.uk/ws/services/Dbfetch"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getSupportedDBs() {
        try {
            this.call.setOperationName(new QName("urn:Dbfetch", "getSupportedDBs"));
            this.call.setReturnType(XMLType.SOAP_ARRAY);
            return (String[])this.call.invoke(new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String[] getSupportedFormats() {
        try {
            this.call.setOperationName(new QName("urn:Dbfetch", "getSupportedFormats"));
            this.call.setReturnType(XMLType.SOAP_ARRAY);
            return (String[])this.call.invoke(new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String[] getSupportedStyles() {
        try {
            this.call.setOperationName(new QName("urn:Dbfetch", "getSupportedStyles"));
            this.call.setReturnType(XMLType.SOAP_ARRAY);
            return (String[])this.call.invoke(new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public File fetchDataAsFile(String ids, String f, String s) throws OutOfMemoryError {
        String[] data = this.fetchData(ids, f, s);
        File outFile = null;
        try {
            outFile = File.createTempFile("jalview", ".xml");
            outFile.deleteOnExit();
            PrintWriter out = new PrintWriter(new FileOutputStream(outFile));
            for (int index = 0; index < data.length; ++index) {
                out.println(data[index]);
            }
            out.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return outFile;
    }

    public String[] fetchData(String ids, String f, String s) throws OutOfMemoryError {
        StringTokenizer queries = new StringTokenizer(ids, ";");
        String db = null;
        StringBuffer querystring = null;
        while (queries.hasMoreTokens()) {
            String query = queries.nextToken();
            int p = query.indexOf(58);
            if (p > -1) {
                db = query.substring(0, p);
                query = query.substring(p + 1);
            }
            if (querystring == null) {
                querystring = new StringBuffer(query);
                continue;
            }
            querystring.append("," + query);
        }
        if (db == null) {
            System.err.println("Invalid Query string : '" + ids + "'\nShould be of form 'dbname:q1;q2;q3;q4'");
        }
        return this.fetchBatch(querystring.toString(), db, f, s);
    }

    public String[] fetchBatch(String ids, String db, String f, String s) throws OutOfMemoryError {
        try {
            this.call.setOperationName(new QName("urn:Dbfetch", "fetchBatch"));
            this.call.addParameter("ids", XMLType.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("db", XMLType.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("format", XMLType.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("style", XMLType.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(XMLType.SOAP_ARRAY);
            if (f != null) {
                this.format = f;
            }
            if (s != null) {
                this.style = s;
            }
            try {
                return (String[])this.call.invoke(new Object[]{ids.toLowerCase(), db.toLowerCase(), this.format, this.style});
            }
            catch (OutOfMemoryError er) {
                System.out.println("OUT OF MEMORY DOWNLOADING QUERY FROM " + db + ":\n" + ids);
                throw er;
            }
        }
        catch (Exception ex) {
            if (ex.getMessage().startsWith("uk.ac.ebi.jdbfetch.exceptions.DbfNoEntryFoundException")) {
                return null;
            }
            System.err.println("Unexpected exception when retrieving from " + db + "\nQuery was : '" + ids + "'");
            ex.printStackTrace(System.err);
            return null;
        }
    }
}

