/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.seqfetcher;

import jalview.bin.Cache;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.SequenceI;
import jalview.ws.seqfetcher.DbSourceProxy;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ASequenceFetcher {
    protected Hashtable FETCHABLEDBS;

    public String[] getSupportedDb() {
        if (this.FETCHABLEDBS == null) {
            return null;
        }
        String[] sf = new String[this.FETCHABLEDBS.size()];
        Enumeration e = this.FETCHABLEDBS.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            sf[i++] = (String)e.nextElement();
        }
        return sf;
    }

    public boolean isFetchable(String source) {
        Enumeration e = this.FETCHABLEDBS.keys();
        while (e.hasMoreElements()) {
            String db = (String)e.nextElement();
            if (source.compareToIgnoreCase(db) != 0) continue;
            return true;
        }
        Cache.log.warn((Object)("isFetchable doesn't know about '" + source + "'"));
        return false;
    }

    public SequenceI[] getSequences(DBRefEntry[] refs) {
        SequenceI[] ret = null;
        Vector<SequenceI> rseqs = new Vector<SequenceI>();
        Hashtable queries = new Hashtable();
        for (int r = 0; r < refs.length; ++r) {
            Vector qset;
            if (!queries.containsKey(refs[r].getSource())) {
                queries.put(refs[r].getSource(), new Vector());
            }
            if ((qset = (Vector)queries.get(refs[r].getSource())).contains(refs[r].getAccessionId())) continue;
            qset.addElement(refs[r].getAccessionId());
        }
        Enumeration e = queries.keys();
        while (e.hasMoreElements()) {
            Vector query = null;
            String db = null;
            try {
                db = (String)e.nextElement();
                query = (Vector)queries.get(db);
                if (!this.isFetchable(db)) {
                    throw new Exception("Don't know how to fetch from this database :" + db);
                }
                DbSourceProxy fetcher = this.getSourceProxy(db);
                boolean doMultiple = fetcher.getAccessionSeparator() != null;
                Enumeration qs = query.elements();
                while (qs.hasMoreElements()) {
                    StringBuffer qsb = new StringBuffer();
                    do {
                        qsb.append((String)qs.nextElement());
                        if (!qs.hasMoreElements() || !doMultiple) continue;
                        qsb.append(fetcher.getAccessionSeparator());
                    } while (doMultiple && qs.hasMoreElements());
                    AlignmentI seqset = null;
                    try {
                        seqset = fetcher.getSequenceRecords(qsb.toString());
                    }
                    catch (Exception ex) {
                        System.err.println("Failed to retrieve the following from " + db);
                        System.err.println(qsb);
                        ex.printStackTrace(System.err);
                    }
                    if (seqset == null) continue;
                    SequenceI[] seqs = seqset.getSequencesArray();
                    if (seqs != null) {
                        for (int is = 0; is < seqs.length; ++is) {
                            rseqs.addElement(seqs[is]);
                            seqs[is] = null;
                        }
                        continue;
                    }
                    if (fetcher.getRawRecords() == null) continue;
                    System.out.println("# Retrieved from " + db + ":" + qs.toString());
                    StringBuffer rrb = fetcher.getRawRecords();
                    String hdr = "# " + db + ":" + qsb.toString();
                    System.out.println(hdr);
                    if (rrb != null) {
                        System.out.println(rrb);
                    }
                    System.out.println("# end of " + hdr);
                }
            }
            catch (Exception ex) {
                System.err.println("Failed to retrieve the following references from " + db);
                Enumeration qv = query.elements();
                int n = 0;
                while (qv.hasMoreElements()) {
                    System.err.print(" " + qv.nextElement() + ";");
                    if (n++ <= 10) continue;
                    System.err.println();
                    n = 0;
                }
                System.err.println();
                ex.printStackTrace();
            }
        }
        if (rseqs.size() > 0) {
            ret = new SequenceI[rseqs.size()];
            Enumeration sqs = rseqs.elements();
            int si = 0;
            while (sqs.hasMoreElements()) {
                SequenceI s = (SequenceI)sqs.nextElement();
                ret[si++] = s;
                s.updatePDBIds();
            }
        }
        return ret;
    }

    public DbSourceProxy getSourceProxy(String db) {
        DbSourceProxy dbs = (DbSourceProxy)this.FETCHABLEDBS.get(db);
        return dbs;
    }

    protected void addDBRefSourceImpl(Class dbSourceProxy) throws IllegalArgumentException {
        DbSourceProxy proxy = null;
        try {
            Object proxyObj = dbSourceProxy.getConstructor(null).newInstance(null);
            if (!DbSourceProxy.class.isInstance(proxyObj)) {
                throw new IllegalArgumentException(dbSourceProxy.toString() + " does not implement the jalview.ws.seqfetcher.DbSourceProxy");
            }
            proxy = (DbSourceProxy)proxyObj;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Error("DBRefSource Implementation Exception", e);
        }
        this.addDbRefSourceImpl(proxy);
    }

    protected void addDbRefSourceImpl(DbSourceProxy proxy) {
        if (proxy != null) {
            if (this.FETCHABLEDBS == null) {
                this.FETCHABLEDBS = new Hashtable();
            }
            this.FETCHABLEDBS.put(proxy.getDbSource(), proxy);
        }
    }

    public boolean hasDbSourceProperty(String dbName, String dbProperty) {
        DbSourceProxy proxy = this.getSourceProxy(dbName);
        if (proxy != null && proxy.getDbSourceProperties() != null) {
            return proxy.getDbSourceProperties().containsKey(dbProperty);
        }
        return false;
    }
}

