/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.dasobert.das2;

import org.biojava.dasobert.das2.Das2Capability;
import org.biojava.dasobert.das2.Das2CapabilityImpl;
import org.biojava.dasobert.das2.Das2Source;
import org.biojava.dasobert.dasregistry.Das1Source;

public class DasSourceConverter {
    public static Das1Source toDas1Source(Das2Source das2source) throws Exception {
        if (!das2source.hasDas1Capabilities()) {
            throw new Exception("this das source does not have das1 capabilitites");
        }
        Das1Source ds = new Das1Source();
        ds.setAdminemail(das2source.getAdminemail());
        ds.setDescription(das2source.getDescription());
        ds.setHelperurl(das2source.getHelperurl());
        ds.setRegisterDate(das2source.getRegisterDate());
        ds.setLeaseDate(das2source.getLeaseDate());
        ds.setLabels(das2source.getLabels());
        ds.setCoordinateSystem(das2source.getCoordinateSystem());
        ds.setNickname(das2source.getNickname());
        ds.setId(das2source.getId());
        ds.setLabels(das2source.getLabels());
        Das2Capability[] caps = das2source.getDas2Capabilities();
        String[] das1capabilitites = new String[caps.length];
        int DASPREFIXLENGTH = Das2CapabilityImpl.DAS1_CAPABILITY_PREFIX.length();
        for (int i = 0; i < caps.length; ++i) {
            Das2Capability cap = caps[i];
            String c = cap.getCapability();
            das1capabilitites[i] = c.substring(DASPREFIXLENGTH, c.length());
            String query_uri = cap.getQueryUri();
            String url = query_uri.substring(0, query_uri.length() - c.length() + DASPREFIXLENGTH);
            ds.setUrl(url);
        }
        ds.setCapabilities(das1capabilitites);
        return ds;
    }
}

