/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.dasobert.das2.io;

import java.util.ArrayList;
import java.util.List;
import org.biojava.dasobert.das2.Das2Capability;
import org.biojava.dasobert.das2.Das2CapabilityImpl;
import org.biojava.dasobert.das2.Das2Source;
import org.biojava.dasobert.das2.Das2SourceImpl;
import org.biojava.dasobert.dasregistry.DasCoordinateSystem;
import org.biojava.dasobert.dasregistry.DasSource;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class DAS2SourceHandler
extends DefaultHandler {
    List sources = new ArrayList();
    Das2Source currentSource = new Das2SourceImpl();
    List coordinates = new ArrayList();
    List capabilities = new ArrayList();
    List labels = new ArrayList();
    public static final String LABELPROPERTY = "label";

    private void startSource(String uri, String name, String qName, Attributes atts) {
        String id = atts.getValue("uri");
        String title = atts.getValue("title");
        String doc_ref = atts.getValue("doc_href");
        String description = atts.getValue("description");
        this.currentSource.setId(id);
        this.currentSource.setNickname(title);
        this.currentSource.setHelperurl(doc_ref);
        this.currentSource.setDescription(description);
    }

    private DasCoordinateSystem getCoordinateSystem(String uri, String name, String qname, Attributes atts) {
        DasCoordinateSystem dcs = new DasCoordinateSystem();
        String id = atts.getValue("uri");
        dcs.setUniqueId(id);
        String source = atts.getValue("source");
        dcs.setCategory(source);
        String authority = atts.getValue("authority");
        dcs.setName(authority);
        String test_range = atts.getValue("test_range");
        dcs.setTestCode(test_range);
        try {
            String taxidstr = atts.getValue("taxid");
            int taxid = Integer.parseInt(taxidstr);
            dcs.setNCBITaxId(taxid);
        }
        catch (Exception e) {
            // empty catch block
        }
        String version = atts.getValue("version");
        if (version != null) {
            dcs.setVersion(version);
        }
        return dcs;
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (qName.equals("SOURCE")) {
            this.currentSource = new Das2SourceImpl();
            this.coordinates = new ArrayList();
            this.capabilities = new ArrayList();
            this.startSource(uri, name, qName, atts);
        } else if (qName.equals("MAINTAINER")) {
            String email = atts.getValue("email");
            this.currentSource.setAdminemail(email);
        } else if (qName.equals("COORDINATES")) {
            DasCoordinateSystem dcs = this.getCoordinateSystem(uri, name, qName, atts);
            this.coordinates.add(dcs);
        } else if (qName.equals("CAPABILITY")) {
            Das2Capability cap = this.getCapability(uri, name, qName, atts);
            this.capabilities.add(cap);
        } else if (qName.equals("PROPERTY")) {
            this.addProperty(uri, name, qName, atts);
        }
    }

    private Das2Capability getCapability(String uri, String name, String qName, Attributes atts) {
        Das2CapabilityImpl cap = new Das2CapabilityImpl();
        String type = atts.getValue("type");
        cap.setCapability(type);
        String query_uri = atts.getValue("query_uri");
        cap.setQueryUri(query_uri);
        return cap;
    }

    private void addProperty(String uri, String name, String qName, Attributes atts) {
        String pname = atts.getValue("name");
        String label = atts.getValue("value");
        if (pname.equals(LABELPROPERTY)) {
            this.labels.add(label);
        }
    }

    public void startDocument() {
        this.sources = new ArrayList();
        this.coordinates = new ArrayList();
        this.capabilities = new ArrayList();
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("SOURCE")) {
            this.currentSource.setDas2Capabilities(this.capabilities.toArray(new Das2Capability[this.capabilities.size()]));
            this.currentSource.setCoordinateSystem(this.coordinates.toArray(new DasCoordinateSystem[this.coordinates.size()]));
            this.currentSource.setLabels(this.labels.toArray(new String[this.labels.size()]));
            this.labels.clear();
            this.sources.add(this.currentSource);
            this.currentSource = new Das2SourceImpl();
        }
    }

    public DasSource[] getSources() {
        return this.sources.toArray(new DasSource[this.sources.size()]);
    }
}

