/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.dasobert.dasregistry;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.biojava.dasobert.dasregistry.DasCoordinateSystem;

public abstract class DasCoordSysComparator
implements Comparator {
    private final String name;
    private static final Map COMPS_BY_NAME;
    public static final Comparator BY_NAME;
    public static final Comparator BY_ID;
    public static final Comparator BY_CATEGORY;
    public static final Comparator BY_ORGANISM;
    public static final Comparator BY_TAXID;

    public DasCoordSysComparator(String str) {
        this.name = str;
    }

    public static Comparator fromString(String name) {
        if (COMPS_BY_NAME.containsKey(name)) {
            return (Comparator)COMPS_BY_NAME.get(name);
        }
        throw new IllegalArgumentException("Can't compare by key " + name);
    }

    protected abstract Comparable getField(DasCoordinateSystem var1);

    public int compare(Object a, Object b) {
        DasCoordinateSystem x = (DasCoordinateSystem)a;
        DasCoordinateSystem y = (DasCoordinateSystem)b;
        return this.getField(x).compareTo(this.getField(y));
    }

    public String toString() {
        return this.name;
    }

    static {
        BY_NAME = new DasCoordSysComparator("name"){

            protected Comparable getField(DasCoordinateSystem ds) {
                return ds.getName();
            }
        };
        BY_ID = new DasCoordSysComparator("id"){

            protected Comparable getField(DasCoordinateSystem ds) {
                return ds.getUniqueId();
            }
        };
        BY_CATEGORY = new DasCoordSysComparator("category"){

            protected Comparable getField(DasCoordinateSystem ds) {
                return ds.getCategory();
            }
        };
        BY_ORGANISM = new DasCoordSysComparator("organism"){

            protected Comparable getField(DasCoordinateSystem ds) {
                return ds.getOrganismName();
            }
        };
        BY_TAXID = new DasCoordSysComparator("taxid"){

            protected Comparable getField(DasCoordinateSystem ds) {
                return ds.getNCBITaxId() + "";
            }
        };
        COMPS_BY_NAME = new HashMap();
        COMPS_BY_NAME.put(BY_ID.toString(), BY_ID);
        COMPS_BY_NAME.put(BY_NAME.toString(), BY_NAME);
        COMPS_BY_NAME.put(BY_CATEGORY.toString(), BY_CATEGORY);
        COMPS_BY_NAME.put(BY_ORGANISM.toString(), BY_ORGANISM);
        COMPS_BY_NAME.put(BY_TAXID.toString(), BY_TAXID);
    }
}

