/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.dasobert.dasregistry;

public class DasCoordinateSystem {
    String name = "";
    String category = "";
    String organism_name = "";
    int ncbi_tax_id = 0;
    String uniqueId = "";
    String version = "";
    String testCode = "";

    public boolean equals(DasCoordinateSystem other) {
        boolean match = true;
        System.out.println("comparing " + this.toString() + " to " + other.toString());
        if (!this.uniqueId.equals("") && this.uniqueId.equals(other.getUniqueId())) {
            return true;
        }
        if (this.ncbi_tax_id != other.getNCBITaxId()) {
            System.out.println("mismatch in ncbi tax id " + this.ncbi_tax_id + " != " + other.getNCBITaxId());
            match = false;
        }
        if (!this.version.equals(other.getVersion())) {
            System.out.println("mismatch in version");
            match = false;
        }
        if (!this.category.equals(other.getCategory())) {
            System.out.println("mismatch in category");
            match = false;
        }
        if (!this.name.equals(other.getName())) {
            System.out.println("mismatch in name");
            match = false;
        }
        System.out.println(" match: " + match);
        return match;
    }

    public int hashCode() {
        int h = 7;
        h = 31 * h + (null == this.name ? 0 : this.name.hashCode());
        h = 31 * h + (null == this.category ? 0 : this.category.hashCode());
        return h;
    }

    public Object clone() {
        DasCoordinateSystem d = new DasCoordinateSystem();
        d.setTestCode(this.testCode);
        d.setCategory(this.category);
        d.setName(this.name);
        d.setNCBITaxId(this.ncbi_tax_id);
        d.setUniqueId(this.getUniqueId());
        d.setOrganismName(this.getOrganismName());
        d.setVersion(this.getVersion());
        return d;
    }

    public String getTestCode() {
        return this.testCode;
    }

    public void setTestCode(String testCode) {
        if (testCode == null) {
            testCode = "";
        }
        this.testCode = testCode;
    }

    public void setUniqueId(String id) {
        this.uniqueId = id;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setCategory(String c) {
        this.category = c;
    }

    public String getCategory() {
        return this.category;
    }

    public void setOrganismName(String t) {
        this.organism_name = t;
    }

    public String getOrganismName() {
        return this.organism_name;
    }

    public void setNCBITaxId(int id) {
        this.ncbi_tax_id = id;
    }

    public int getNCBITaxId() {
        return this.ncbi_tax_id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (version == null) {
            version = "";
        }
        this.version = version;
    }

    public String toString() {
        String nam = this.name;
        if (!this.version.equals("")) {
            nam = nam + "_" + this.version;
        }
        if (this.organism_name.equals("")) {
            return nam + "," + this.category;
        }
        return nam + "," + this.category + "," + this.organism_name;
    }

    public static DasCoordinateSystem fromString(String rawString) {
        String[] spl = rawString.split(",");
        DasCoordinateSystem dcs = new DasCoordinateSystem();
        if (spl.length == 2) {
            dcs.setName(spl[0]);
            dcs.setCategory(spl[1]);
        }
        if (spl.length == 3) {
            dcs.setName(spl[0]);
            dcs.setCategory(spl[1]);
            dcs.setOrganismName(spl[2]);
        }
        return dcs;
    }
}

