/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.dasobert.feature;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.dasobert.feature.FeatureTrack;
import org.biojava.dasobert.feature.FeatureTrackImpl;
import org.biojava.dasobert.feature.HistogramFeature;
import org.biojava.dasobert.feature.HistogramSegment;
import org.biojava.dasobert.feature.Segment;
import org.biojava.dasobert.feature.SegmentImpl;

public class FeatureTrackConverter {
    public static final Color HELIX_COLOR = new Color(255, 51, 51);
    public static final Color STRAND_COLOR = new Color(255, 204, 51);
    public static final Color TURN_COLOR = new Color(204, 204, 204);
    public static final String DISULFID_TYPE = "DISULFID";
    public static final String SECSTRUC_TYPE = "SECSTRUC";
    public static final String METAL_TYPE = "METAL";
    public static final String MSD_SITE_TYPE = "MSD_SITE";
    String type;
    public static final String TYPE_HISTOGRAM = "histogram";
    public static final String TYPE_DEFAULT = "default";
    public static final Color[] entColors = new Color[]{new Color(51, 51, 255), new Color(102, 255, 255), new Color(153, 255, 153), new Color(153, 255, 153), new Color(255, 153, 153), new Color(255, 51, 51), new Color(255, 51, 255)};
    public static final String[] txtColors = new String[]{"blue", "pink", "green", "yellow", "red", "cyan", "pink"};
    Map[] stylesheet;
    boolean isHistogram = false;

    public FeatureTrackConverter() {
        this.type = TYPE_DEFAULT;
        this.stylesheet = new Map[0];
    }

    public FeatureTrackConverter(Map[] stylesheet) {
        if (stylesheet == null) {
            stylesheet = new Map[]{};
        }
        this.stylesheet = stylesheet;
    }

    public FeatureTrackConverter(Map[] stylesheet, boolean isHistogram) {
        this(stylesheet);
        this.isHistogram = isHistogram;
        if (isHistogram) {
            this.type = TYPE_HISTOGRAM;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type.equals(TYPE_HISTOGRAM)) {
            this.isHistogram = true;
        }
        this.type = type;
    }

    public boolean isHistogram() {
        return this.isHistogram;
    }

    public void setHistogram(boolean isHistogram) {
        this.isHistogram = isHistogram;
    }

    public FeatureTrack[] convertMap2Features(Map[] mapfeatures) {
        List features = new ArrayList();
        boolean first = true;
        boolean secstruc = false;
        boolean isGroup = false;
        FeatureTrack feat = null;
        Segment segment = null;
        int featuresCounter = 0;
        String prevGroup = null;
        for (int i = 0; i < mapfeatures.length; ++i) {
            Map currentFeatureMap = mapfeatures[i];
            String type = (String)currentFeatureMap.get("TYPE");
            String group = (String)currentFeatureMap.get("GROUP");
            if (group != null) {
                if (prevGroup != null) {
                    if (group.equals(prevGroup)) {
                        feat.setName(group);
                        isGroup = true;
                    } else {
                        isGroup = false;
                    }
                } else {
                    isGroup = false;
                }
            } else {
                isGroup = false;
            }
            if (type.equals("reference") || type.equals("GOA")) continue;
            if (!first) {
                if (!secstruc && !isGroup) {
                    features = this.testAddFeatures(features, feat);
                } else if (!(type.equals("HELIX") || type.equals("STRAND") || type.equals("TURN"))) {
                    secstruc = false;
                    if (feat != null && !isGroup) {
                        features = this.testAddFeatures(features, feat);
                    }
                }
            }
            first = false;
            if (!secstruc && !isGroup) {
                ++featuresCounter;
                feat = this.getNewFeat(currentFeatureMap);
            }
            if (type.equals("STRAND")) {
                secstruc = true;
                currentFeatureMap.put("colorTxt", "yellow");
                feat.setName(SECSTRUC_TYPE);
                feat.setType(SECSTRUC_TYPE);
            } else if (type.equals("HELIX")) {
                secstruc = true;
                currentFeatureMap.put("colorTxt", "red");
                feat.setName(SECSTRUC_TYPE);
                feat.setType(SECSTRUC_TYPE);
            } else if (type.equals("TURN")) {
                secstruc = true;
                currentFeatureMap.put("colorTxt", "white");
                feat.setName(SECSTRUC_TYPE);
                feat.setType(SECSTRUC_TYPE);
            } else {
                secstruc = false;
                currentFeatureMap.put("colorTxt", txtColors[featuresCounter % txtColors.length]);
                if (!isGroup) {
                    try {
                        feat.setName(type);
                    }
                    catch (NullPointerException e) {
                        feat.setName("null");
                    }
                }
            }
            segment = this.getNewSegment(currentFeatureMap);
            feat.addSegment(segment);
            prevGroup = group;
        }
        if (feat != null) {
            features = this.testAddFeatures(features, feat);
        }
        return features.toArray(new FeatureTrack[features.size()]);
    }

    protected List testAddFeatures(List features, FeatureTrack newFeature) {
        Iterator iter = features.iterator();
        if (this.isHistogramFeatureType(newFeature)) {
            this.type = TYPE_HISTOGRAM;
            HistogramSegment seg = this.getHistogramSegmentFromFeature(newFeature);
            while (iter.hasNext()) {
                FeatureTrack knownFeature = (FeatureTrack)iter.next();
                String knownType = knownFeature.getType();
                if (!knownType.equals(newFeature.getType())) continue;
                knownFeature.addSegment(seg);
                return features;
            }
            HistogramFeature hfeat = new HistogramFeature();
            hfeat.setLink(newFeature.getLink());
            hfeat.setMethod(newFeature.getMethod());
            hfeat.setName(newFeature.getName());
            hfeat.setNote(newFeature.getNote());
            hfeat.setScore("0");
            hfeat.setSource(newFeature.getSource());
            hfeat.addSegment(seg);
            hfeat.setType(newFeature.getType());
            newFeature = hfeat;
            features.add(newFeature);
            return features;
        }
        while (iter.hasNext()) {
            Segment newseg;
            FeatureTrack knownFeature = (FeatureTrack)iter.next();
            boolean sameFeat = false;
            if (knownFeature.equals(newFeature)) {
                sameFeat = true;
            }
            if (knownFeature.getSource().equals(newFeature.getSource()) && knownFeature.getMethod().equals(newFeature.getMethod()) && knownFeature.getNote().equals(newFeature.getNote()) && this.isSecondaryStructureFeat(knownFeature) && this.isSecondaryStructureFeat(newFeature)) {
                sameFeat = true;
            }
            if (!sameFeat) continue;
            List tmpsegs = knownFeature.getSegments();
            Iterator segiter = tmpsegs.iterator();
            List newsegs = newFeature.getSegments();
            Iterator newsegsiter = newsegs.iterator();
            boolean overlap = false;
            while (newsegsiter.hasNext()) {
                newseg = (Segment)newsegsiter.next();
                while (segiter.hasNext()) {
                    Segment tmpseg = (Segment)segiter.next();
                    if (!tmpseg.overlaps(newseg)) continue;
                    overlap = true;
                }
            }
            if (overlap) continue;
            newsegsiter = newsegs.iterator();
            while (newsegsiter.hasNext()) {
                newseg = (Segment)newsegsiter.next();
                knownFeature.addSegment(newseg);
            }
            return features;
        }
        features.add(newFeature);
        return features;
    }

    private FeatureTrack getNewFeat(Map currentFeatureMap) {
        FeatureTrackImpl feat = new FeatureTrackImpl();
        feat.setSource((String)currentFeatureMap.get("dassource"));
        feat.setName((String)currentFeatureMap.get("NAME"));
        feat.setType((String)currentFeatureMap.get("TYPE"));
        feat.setLink((String)currentFeatureMap.get("LINK"));
        feat.setNote((String)currentFeatureMap.get("NOTE"));
        String typeID = (String)currentFeatureMap.get("TYPE_ID");
        String typeCategory = (String)currentFeatureMap.get("TYPE_CATEGORY");
        feat.setTypeID(typeID);
        feat.setTypeCategory(typeCategory);
        String method = (String)currentFeatureMap.get("METHOD");
        if (method == null) {
            method = "";
        }
        feat.setMethod(method);
        feat.setScore((String)currentFeatureMap.get("SCORE"));
        return feat;
    }

    private Segment getNewSegment(Map featureMap) {
        SegmentImpl s = new SegmentImpl();
        String sstart = (String)featureMap.get("START");
        String send = (String)featureMap.get("END");
        int start = Integer.parseInt(sstart);
        int end = Integer.parseInt(send);
        s.setStart(start);
        s.setEnd(end);
        s.setName((String)featureMap.get("TYPE"));
        s.setTxtColor((String)featureMap.get("colorTxt"));
        s.setColor((Color)featureMap.get("color"));
        s.setNote((String)featureMap.get("NOTE"));
        return s;
    }

    private boolean isSecondaryStructureFeat(FeatureTrack feat) {
        String type = feat.getType();
        return type.equals("HELIX") || type.equals("STRAND") || type.equals("TURN");
    }

    private boolean isHistogramFeatureType(FeatureTrack feat) {
        String ftype = feat.getType();
        Map[] style = this.stylesheet;
        if (ftype.equals("hydrophobicity")) {
            return true;
        }
        if (this.getType().equals(TYPE_HISTOGRAM)) {
            return true;
        }
        if (style != null) {
            for (int i = 0; i < style.length; ++i) {
                String type;
                Map m = style[i];
                String styleType = (String)m.get("type");
                if (styleType == null || !styleType.equals(ftype) || (type = (String)m.get("style")) == null || !type.equals("gradient") && !type.equals("lineplot") && !type.equals(TYPE_HISTOGRAM)) continue;
                return true;
            }
        }
        return false;
    }

    private HistogramSegment getHistogramSegmentFromFeature(FeatureTrack feat) {
        HistogramSegment s = new HistogramSegment();
        double score = 0.0;
        try {
            score = Double.parseDouble(feat.getScore());
        }
        catch (Exception e) {
            // empty catch block
        }
        s.setScore(score);
        List segments = feat.getSegments();
        if (segments.size() > 0) {
            Segment seg = (Segment)segments.get(0);
            s.setName(seg.getName());
            s.setStart(seg.getStart());
            s.setEnd(seg.getEnd());
            s.setNote(seg.getNote());
            s.setColor(seg.getColor());
            s.setTxtColor(seg.getTxtColor());
        }
        return s;
    }
}

