/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.data.seqdoc;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biolegato.core.data.seqdoc.SeqDoc;
import org.biolegato.core.data.sequence.Sequence;

public class SeqDocTest
extends TestCase {
    final Sequence abc = new Sequence("ABC");
    final Sequence def = new Sequence("DEF");
    final Sequence ghi = new Sequence("GHI");
    final Sequence jkl = new Sequence("JKL");
    final Sequence mnopqr = new Sequence("MNOPQR");
    final Sequence stuvwxyz = new Sequence("STUVWXYZ");

    public SeqDocTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SeqDocTest.class);
        return testSuite;
    }

    public void testEmptyStringInsert() {
        SeqDoc seqDoc = new SeqDoc();
        SeqDocTest.assertTrue((boolean)seqDoc.insert(0, 0, ""));
        SeqDocTest.assertTrue((boolean)seqDoc.insert(0, 0, (String)null));
        SeqDocTest.assertFalse((boolean)seqDoc.insert(0, 0, "ABC"));
        SeqDocTest.assertFalse((boolean)seqDoc.insert(1, 1, "ABC"));
        SeqDocTest.assertFalse((boolean)seqDoc.insert(-1, -1, "ABC"));
    }

    public void testInsertSequence() {
        SeqDoc seqDoc = new SeqDoc();
        SeqDocTest.assertFalse((boolean)seqDoc.insert(0, -1, new Sequence[]{this.abc}));
        SeqDocTest.assertEquals((int)0, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertTrue((boolean)seqDoc.insert(0, 0, new Sequence[]{this.def, this.ghi}));
        SeqDocTest.assertEquals((int)2, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertNull((Object)seqDoc.getLine(2));
        SeqDocTest.assertEquals((Object)this.def, (Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((Object)this.ghi, (Object)seqDoc.getLine(1));
        SeqDocTest.assertTrue((boolean)seqDoc.insert(2, 0, new Sequence[]{this.jkl}));
        SeqDocTest.assertEquals((int)2, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertNull((Object)seqDoc.getLine(2));
        SeqDocTest.assertEquals((Object)"DEJKLF", (Object)seqDoc.getLine(0).get((Object)"sequence"));
        SeqDocTest.assertEquals((Object)this.ghi, (Object)seqDoc.getLine(1));
        SeqDocTest.assertTrue((boolean)seqDoc.insert(2, 1, new Sequence[]{this.mnopqr, this.abc}));
        SeqDocTest.assertEquals((int)3, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(2));
        SeqDocTest.assertNull((Object)seqDoc.getLine(3));
        SeqDocTest.assertEquals((Object)"DEJKLF", (Object)seqDoc.getLine(0).get((Object)"sequence"));
        SeqDocTest.assertEquals((Object)"GHMNOPQRI", (Object)seqDoc.getLine(1).get((Object)"sequence"));
        SeqDocTest.assertEquals((Object)"ABC", (Object)seqDoc.getLine(2).get((Object)"sequence"));
    }

    public void testSingleLineNormalInsertString() {
        SeqDoc seqDoc = new SeqDoc(new Sequence[]{new Sequence("def")});
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((int)1, (int)seqDoc.getLineCount());
        SeqDocTest.assertTrue((boolean)seqDoc.insert(0, 0, "123"));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((int)1, (int)seqDoc.getLineCount());
        SeqDocTest.assertEquals((Object)"123def", (Object)seqDoc.getLine(0).get((Object)"sequence"));
        SeqDocTest.assertTrue((boolean)seqDoc.insert(2, 0, "ABC"));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((int)1, (int)seqDoc.getLineCount());
        SeqDocTest.assertEquals((Object)"12ABC3def", (Object)seqDoc.getLine(0).get((Object)"sequence"));
        SeqDocTest.assertFalse((boolean)seqDoc.insert(0, 2, "XYZ"));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((int)1, (int)seqDoc.getLineCount());
        SeqDocTest.assertEquals((Object)"12ABC3def", (Object)seqDoc.getLine(0).get((Object)"sequence"));
        SeqDocTest.assertFalse((boolean)seqDoc.insert(100, 0, "XYZ"));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((int)1, (int)seqDoc.getLineCount());
        SeqDocTest.assertEquals((Object)"12ABC3def", (Object)seqDoc.getLine(0).get((Object)"sequence"));
        SeqDocTest.assertFalse((boolean)seqDoc.insert(100, 0, "XYZ"));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((int)1, (int)seqDoc.getLineCount());
        SeqDocTest.assertEquals((Object)"12ABC3def", (Object)seqDoc.getLine(0).get((Object)"sequence"));
        SeqDocTest.assertFalse((boolean)seqDoc.insert(-1, 0, "PQR"));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((int)1, (int)seqDoc.getLineCount());
        SeqDocTest.assertEquals((Object)"12ABC3def", (Object)seqDoc.getLine(0).get((Object)"sequence"));
        SeqDocTest.assertFalse((boolean)seqDoc.insert(0, -1, "456"));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((int)1, (int)seqDoc.getLineCount());
        SeqDocTest.assertEquals((Object)"12ABC3def", (Object)seqDoc.getLine(0).get((Object)"sequence"));
    }

    public void testDoubleLineNormalInsertString() {
        SeqDoc seqDoc = new SeqDoc(new Sequence[]{this.abc, this.def});
        SeqDocTest.assertTrue((boolean)seqDoc.insert(0, 0, "123"));
        SeqDocTest.assertEquals((int)2, (int)seqDoc.getLineCount());
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertEquals((Object)"123ABC", (Object)seqDoc.getLine(0).get((Object)"sequence"));
        SeqDocTest.assertEquals((Object)"DEF", (Object)seqDoc.getLine(1).get((Object)"sequence"));
        SeqDocTest.assertTrue((boolean)seqDoc.insert(2, 0, "pqr"));
        SeqDocTest.assertEquals((int)2, (int)seqDoc.getLineCount());
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertEquals((Object)"12pqr3ABC", (Object)seqDoc.getLine(0).get((Object)"sequence"));
        SeqDocTest.assertEquals((Object)"DEF", (Object)seqDoc.getLine(1).get((Object)"sequence"));
        SeqDocTest.assertTrue((boolean)seqDoc.insert(0, 1, "XYZ"));
        SeqDocTest.assertEquals((int)2, (int)seqDoc.getLineCount());
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertEquals((Object)"12pqr3ABC", (Object)seqDoc.getLine(0).get((Object)"sequence"));
        SeqDocTest.assertEquals((Object)"XYZDEF", (Object)seqDoc.getLine(1).get((Object)"sequence"));
        SeqDocTest.assertFalse((boolean)seqDoc.insert(0, -1, "PQR"));
        SeqDocTest.assertEquals((int)2, (int)seqDoc.getLineCount());
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertEquals((Object)"12pqr3ABC", (Object)seqDoc.getLine(0).get((Object)"sequence"));
        SeqDocTest.assertEquals((Object)"XYZDEF", (Object)seqDoc.getLine(1).get((Object)"sequence"));
        SeqDocTest.assertFalse((boolean)seqDoc.insert(0, 3, "PQR"));
        SeqDocTest.assertEquals((int)2, (int)seqDoc.getLineCount());
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertEquals((Object)"12pqr3ABC", (Object)seqDoc.getLine(0).get((Object)"sequence"));
        SeqDocTest.assertEquals((Object)"XYZDEF", (Object)seqDoc.getLine(1).get((Object)"sequence"));
        SeqDocTest.assertTrue((boolean)seqDoc.insert(3, 1, "456"));
        SeqDocTest.assertEquals((int)2, (int)seqDoc.getLineCount());
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNotNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertEquals((Object)"12pqr3ABC", (Object)seqDoc.getLine(0).get((Object)"sequence"));
        SeqDocTest.assertEquals((Object)"XYZ456DEF", (Object)seqDoc.getLine(1).get((Object)"sequence"));
    }

    public void testDeleteXYW() {
        SeqDoc seqDoc = new SeqDoc();
        SeqDoc seqDoc2 = new SeqDoc(new Sequence[]{this.stuvwxyz});
        SeqDoc seqDoc3 = new SeqDoc(new Sequence[]{this.stuvwxyz, this.abc, this.def, this.ghi, this.mnopqr});
        SeqDocTest.assertEquals((int)0, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertTrue((boolean)seqDoc.delete(0, 0, 0));
        SeqDocTest.assertFalse((boolean)seqDoc.delete(-1, 0, 0));
        SeqDocTest.assertFalse((boolean)seqDoc.delete(0, -1, 0));
        SeqDocTest.assertFalse((boolean)seqDoc.delete(0, 0, -1));
        SeqDocTest.assertFalse((boolean)seqDoc.delete(-1, -1, -1));
        SeqDocTest.assertEquals((int)0, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertTrue((boolean)seqDoc2.delete(2, 0, 0));
        SeqDocTest.assertTrue((boolean)seqDoc2.delete(2, 0, 2));
        SeqDocTest.assertTrue((boolean)seqDoc2.delete(3, 0, 1));
        SeqDocTest.assertEquals((int)1, (int)seqDoc2.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc2.getLine(-1));
        SeqDocTest.assertNotNull((Object)seqDoc2.getLine(0));
        SeqDocTest.assertNull((Object)seqDoc2.getLine(1));
        SeqDocTest.assertEquals((Object)"STWYZ", (Object)seqDoc2.getLine(0).get((Object)"sequence"));
    }

    public void testDeleteXYWH() {
        SeqDoc seqDoc = new SeqDoc();
        SeqDoc seqDoc2 = new SeqDoc(new Sequence[]{this.stuvwxyz});
        SeqDoc seqDoc3 = new SeqDoc(new Sequence[]{this.stuvwxyz, this.abc, this.def, this.ghi, this.mnopqr});
        SeqDocTest.assertEquals((int)0, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertFalse((boolean)seqDoc.delete(0, 0, 0, 0));
        SeqDocTest.assertFalse((boolean)seqDoc.delete(-1, 0, 0, 0));
        SeqDocTest.assertFalse((boolean)seqDoc.delete(0, -1, 0, 0));
        SeqDocTest.assertFalse((boolean)seqDoc.delete(0, 0, -1, 0));
        SeqDocTest.assertFalse((boolean)seqDoc.delete(0, 0, 0, -1));
        SeqDocTest.assertFalse((boolean)seqDoc.delete(-1, -1, -1, -1));
        SeqDocTest.assertEquals((int)0, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertTrue((boolean)seqDoc2.delete(2, 0, 0, 0));
        SeqDocTest.assertTrue((boolean)seqDoc2.delete(2, 0, 2, 0));
        SeqDocTest.assertTrue((boolean)seqDoc2.delete(3, 0, 1, 0));
        SeqDocTest.assertEquals((int)1, (int)seqDoc2.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc2.getLine(-1));
        SeqDocTest.assertNotNull((Object)seqDoc2.getLine(0));
        SeqDocTest.assertNull((Object)seqDoc2.getLine(1));
        SeqDocTest.assertEquals((Object)"STWYZ", (Object)seqDoc2.getLine(0).get((Object)"sequence"));
    }

    public void testAddSequence() {
        SeqDoc seqDoc = new SeqDoc();
        SeqDocTest.assertFalse((boolean)seqDoc.addSequence(-1, this.abc));
        SeqDocTest.assertEquals((int)0, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertTrue((boolean)seqDoc.addSequence(0, this.abc));
        SeqDocTest.assertEquals((int)1, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertEquals((Object)this.abc, (Object)seqDoc.getLine(0));
        SeqDocTest.assertNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertTrue((boolean)seqDoc.addSequence(0, this.def));
        SeqDocTest.assertEquals((int)2, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertEquals((Object)this.def, (Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((Object)this.abc, (Object)seqDoc.getLine(1));
        SeqDocTest.assertNull((Object)seqDoc.getLine(2));
        SeqDocTest.assertFalse((boolean)seqDoc.addSequence(-1, this.ghi));
        SeqDocTest.assertEquals((int)2, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertEquals((Object)this.def, (Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((Object)this.abc, (Object)seqDoc.getLine(1));
        SeqDocTest.assertNull((Object)seqDoc.getLine(2));
        SeqDocTest.assertTrue((boolean)seqDoc.addSequence(2, this.ghi));
        SeqDocTest.assertEquals((int)3, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertEquals((Object)this.def, (Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((Object)this.abc, (Object)seqDoc.getLine(1));
        SeqDocTest.assertEquals((Object)this.ghi, (Object)seqDoc.getLine(2));
        SeqDocTest.assertNull((Object)seqDoc.getLine(3));
        SeqDocTest.assertFalse((boolean)seqDoc.addSequence(6, this.jkl));
        SeqDocTest.assertEquals((int)3, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertEquals((Object)this.def, (Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((Object)this.abc, (Object)seqDoc.getLine(1));
        SeqDocTest.assertEquals((Object)this.ghi, (Object)seqDoc.getLine(2));
        SeqDocTest.assertNull((Object)seqDoc.getLine(3));
        SeqDocTest.assertTrue((boolean)seqDoc.addSequence(2, this.jkl));
        SeqDocTest.assertEquals((int)4, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertEquals((Object)this.def, (Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((Object)this.abc, (Object)seqDoc.getLine(1));
        SeqDocTest.assertEquals((Object)this.jkl, (Object)seqDoc.getLine(2));
        SeqDocTest.assertEquals((Object)this.ghi, (Object)seqDoc.getLine(3));
        SeqDocTest.assertNull((Object)seqDoc.getLine(4));
    }

    public void testRemoveSequence() {
        SeqDoc seqDoc = new SeqDoc(new Sequence[]{this.def, this.abc, this.jkl, this.ghi});
        SeqDocTest.assertEquals((int)4, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertEquals((Object)this.def, (Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((Object)this.abc, (Object)seqDoc.getLine(1));
        SeqDocTest.assertEquals((Object)this.jkl, (Object)seqDoc.getLine(2));
        SeqDocTest.assertEquals((Object)this.ghi, (Object)seqDoc.getLine(3));
        SeqDocTest.assertNull((Object)seqDoc.getLine(4));
        SeqDocTest.assertFalse((boolean)seqDoc.removeSequence(-1));
        SeqDocTest.assertEquals((int)4, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertEquals((Object)this.def, (Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((Object)this.abc, (Object)seqDoc.getLine(1));
        SeqDocTest.assertEquals((Object)this.jkl, (Object)seqDoc.getLine(2));
        SeqDocTest.assertEquals((Object)this.ghi, (Object)seqDoc.getLine(3));
        SeqDocTest.assertNull((Object)seqDoc.getLine(4));
        SeqDocTest.assertFalse((boolean)seqDoc.removeSequence(100));
        SeqDocTest.assertEquals((int)4, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertEquals((Object)this.def, (Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((Object)this.abc, (Object)seqDoc.getLine(1));
        SeqDocTest.assertEquals((Object)this.jkl, (Object)seqDoc.getLine(2));
        SeqDocTest.assertEquals((Object)this.ghi, (Object)seqDoc.getLine(3));
        SeqDocTest.assertNull((Object)seqDoc.getLine(4));
        SeqDocTest.assertTrue((boolean)seqDoc.removeSequence(1));
        SeqDocTest.assertEquals((int)3, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertEquals((Object)this.def, (Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((Object)this.jkl, (Object)seqDoc.getLine(1));
        SeqDocTest.assertEquals((Object)this.ghi, (Object)seqDoc.getLine(2));
        SeqDocTest.assertNull((Object)seqDoc.getLine(3));
        SeqDocTest.assertTrue((boolean)seqDoc.removeSequence(0));
        SeqDocTest.assertEquals((int)2, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertEquals((Object)this.jkl, (Object)seqDoc.getLine(0));
        SeqDocTest.assertEquals((Object)this.ghi, (Object)seqDoc.getLine(1));
        SeqDocTest.assertNull((Object)seqDoc.getLine(2));
        SeqDocTest.assertTrue((boolean)seqDoc.removeSequence(1));
        SeqDocTest.assertEquals((int)1, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertEquals((Object)this.jkl, (Object)seqDoc.getLine(0));
        SeqDocTest.assertNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertTrue((boolean)seqDoc.removeSequence(0));
        SeqDocTest.assertEquals((int)0, (int)seqDoc.getLineCount());
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNull((Object)seqDoc.getLine(1));
    }

    public void testGetLine() {
        SeqDoc seqDoc = new SeqDoc();
        SeqDoc seqDoc2 = new SeqDoc(new Sequence[]{this.abc, this.def, this.ghi});
        SeqDocTest.assertNull((Object)seqDoc.getLine(-1));
        SeqDocTest.assertNull((Object)seqDoc.getLine(0));
        SeqDocTest.assertNull((Object)seqDoc.getLine(1));
        SeqDocTest.assertNull((Object)seqDoc2.getLine(-1));
        SeqDocTest.assertEquals((Object)this.abc, (Object)seqDoc2.getLine(0));
        SeqDocTest.assertEquals((Object)this.def, (Object)seqDoc2.getLine(1));
        SeqDocTest.assertEquals((Object)this.ghi, (Object)seqDoc2.getLine(2));
        SeqDocTest.assertNull((Object)seqDoc2.getLine(3));
    }

    public void testGetLineLength() {
        SeqDoc seqDoc = new SeqDoc();
        SeqDoc seqDoc2 = new SeqDoc(new Sequence[]{this.abc});
        SeqDoc seqDoc3 = new SeqDoc(new Sequence[]{this.stuvwxyz, this.abc, this.mnopqr, this.def, this.ghi, this.jkl});
        SeqDoc seqDoc4 = new SeqDoc(new Sequence[]{this.abc, this.mnopqr, this.def, this.stuvwxyz, this.ghi, this.jkl});
        SeqDocTest.assertEquals((int)0, (int)seqDoc.getLineLength(-1));
        SeqDocTest.assertEquals((int)0, (int)seqDoc.getLineLength(0));
        SeqDocTest.assertEquals((int)0, (int)seqDoc.getLineLength(1));
        SeqDocTest.assertEquals((int)0, (int)seqDoc2.getLineLength(-1));
        SeqDocTest.assertEquals((int)3, (int)seqDoc2.getLineLength(0));
        SeqDocTest.assertEquals((int)0, (int)seqDoc2.getLineLength(1));
        SeqDocTest.assertEquals((int)0, (int)seqDoc3.getLineLength(-1));
        SeqDocTest.assertEquals((int)8, (int)seqDoc3.getLineLength(0));
        SeqDocTest.assertEquals((int)3, (int)seqDoc3.getLineLength(1));
        SeqDocTest.assertEquals((int)6, (int)seqDoc3.getLineLength(2));
        SeqDocTest.assertEquals((int)3, (int)seqDoc3.getLineLength(3));
        SeqDocTest.assertEquals((int)3, (int)seqDoc3.getLineLength(4));
        SeqDocTest.assertEquals((int)3, (int)seqDoc3.getLineLength(5));
        SeqDocTest.assertEquals((int)0, (int)seqDoc3.getLineLength(6));
        SeqDocTest.assertEquals((int)0, (int)seqDoc4.getLineLength(-1));
        SeqDocTest.assertEquals((int)3, (int)seqDoc4.getLineLength(0));
        SeqDocTest.assertEquals((int)6, (int)seqDoc4.getLineLength(1));
        SeqDocTest.assertEquals((int)3, (int)seqDoc4.getLineLength(2));
        SeqDocTest.assertEquals((int)8, (int)seqDoc4.getLineLength(3));
        SeqDocTest.assertEquals((int)3, (int)seqDoc4.getLineLength(4));
        SeqDocTest.assertEquals((int)3, (int)seqDoc4.getLineLength(5));
        SeqDocTest.assertEquals((int)0, (int)seqDoc4.getLineLength(6));
    }

    public void testGetLineCount() {
        System.out.println("getLineCount");
        SeqDoc seqDoc = new SeqDoc();
        SeqDoc seqDoc2 = new SeqDoc(new Sequence[]{this.abc});
        SeqDoc seqDoc3 = new SeqDoc(new Sequence[]{this.abc, this.def});
        SeqDoc seqDoc4 = new SeqDoc(new Sequence[]{this.abc, this.def, this.ghi});
        SeqDocTest.assertEquals((int)0, (int)seqDoc.getLineCount());
        SeqDocTest.assertEquals((int)1, (int)seqDoc2.getLineCount());
        SeqDocTest.assertEquals((int)2, (int)seqDoc3.getLineCount());
        SeqDocTest.assertEquals((int)3, (int)seqDoc4.getLineCount());
    }

    public void testGetLongestLine() {
        SeqDoc seqDoc = new SeqDoc();
        SeqDoc seqDoc2 = new SeqDoc(new Sequence[]{this.abc});
        SeqDoc seqDoc3 = new SeqDoc(new Sequence[]{this.abc, this.mnopqr, this.def, this.ghi, this.jkl});
        SeqDoc seqDoc4 = new SeqDoc(new Sequence[]{this.abc, this.mnopqr, this.def, this.stuvwxyz, this.ghi, this.jkl});
        SeqDoc seqDoc5 = new SeqDoc(new Sequence[]{this.mnopqr, this.def, this.ghi, this.jkl, this.stuvwxyz});
        SeqDoc seqDoc6 = new SeqDoc(new Sequence[]{this.stuvwxyz, this.def, this.ghi, this.jkl, this.mnopqr});
        SeqDoc seqDoc7 = new SeqDoc(new Sequence[]{this.stuvwxyz});
        SeqDocTest.assertEquals((int)0, (int)seqDoc.getLongestLine());
        SeqDocTest.assertEquals((int)3, (int)seqDoc2.getLongestLine());
        SeqDocTest.assertEquals((int)6, (int)seqDoc3.getLongestLine());
        SeqDocTest.assertEquals((int)8, (int)seqDoc4.getLongestLine());
        SeqDocTest.assertEquals((int)8, (int)seqDoc5.getLongestLine());
        SeqDocTest.assertEquals((int)8, (int)seqDoc6.getLongestLine());
        SeqDocTest.assertEquals((int)8, (int)seqDoc7.getLongestLine());
    }

    public void testIndexOf() {
        SeqDoc seqDoc = new SeqDoc(new Sequence[0]);
        SeqDoc seqDoc2 = new SeqDoc(new Sequence[]{this.abc});
        SeqDoc seqDoc3 = new SeqDoc(new Sequence[]{this.abc, this.mnopqr, this.def, this.ghi, this.jkl});
        SeqDoc seqDoc4 = new SeqDoc(new Sequence[]{this.mnopqr, this.def, this.stuvwxyz, this.ghi, this.jkl});
        SeqDoc seqDoc5 = new SeqDoc(new Sequence[]{this.mnopqr, this.ghi, this.jkl, this.abc, this.stuvwxyz, this.def});
        SeqDoc seqDoc6 = new SeqDoc(new Sequence[]{this.abc, this.stuvwxyz, this.def, this.ghi, this.jkl, this.mnopqr});
        SeqDoc seqDoc7 = new SeqDoc(new Sequence[]{this.stuvwxyz});
        SeqDocTest.assertEquals((int)-1, (int)seqDoc.indexOf(this.abc));
        SeqDocTest.assertEquals((int)-1, (int)seqDoc.indexOf(this.def));
        SeqDocTest.assertEquals((int)0, (int)seqDoc2.indexOf(this.abc));
        SeqDocTest.assertEquals((int)-1, (int)seqDoc2.indexOf(this.def));
        SeqDocTest.assertEquals((int)0, (int)seqDoc3.indexOf(this.abc));
        SeqDocTest.assertEquals((int)2, (int)seqDoc3.indexOf(this.def));
        SeqDocTest.assertEquals((int)-1, (int)seqDoc4.indexOf(this.abc));
        SeqDocTest.assertEquals((int)1, (int)seqDoc4.indexOf(this.def));
        SeqDocTest.assertEquals((int)3, (int)seqDoc5.indexOf(this.abc));
        SeqDocTest.assertEquals((int)5, (int)seqDoc5.indexOf(this.def));
        SeqDocTest.assertEquals((int)0, (int)seqDoc6.indexOf(this.abc));
        SeqDocTest.assertEquals((int)2, (int)seqDoc6.indexOf(this.def));
        SeqDocTest.assertEquals((int)-1, (int)seqDoc7.indexOf(this.abc));
        SeqDocTest.assertEquals((int)-1, (int)seqDoc7.indexOf(this.def));
    }

    public void testTransferDataFlavors() throws UnsupportedFlavorException, IOException {
        SeqDoc seqDoc = new SeqDoc();
        SeqDocTest.assertTrue((boolean)seqDoc.isDataFlavorSupported(DataFlavor.stringFlavor));
        SeqDocTest.assertTrue((boolean)seqDoc.isDataFlavorSupported(SeqDoc.seqDocFlavour));
        SeqDocTest.assertEquals((Object)seqDoc, (Object)seqDoc.getTransferData(SeqDoc.seqDocFlavour));
        SeqDocTest.assertEquals((Object)seqDoc.toString(), (Object)seqDoc.getTransferData(DataFlavor.stringFlavor));
    }

    public void testToArray() {
        Sequence[] sequenceArray = new Sequence[]{this.abc, this.def, this.ghi, this.jkl};
        Sequence[] sequenceArray2 = new SeqDoc(sequenceArray).toArray();
        SeqDocTest.assertEquals((int)sequenceArray.length, (int)sequenceArray2.length);
        for (int i = 0; i < sequenceArray.length; ++i) {
            SeqDocTest.assertEquals((Object)sequenceArray[i], (Object)sequenceArray2[i]);
        }
    }
}

