/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BookmarkInfo
implements Transferable,
Serializable {
    public static final DataFlavor INFO_FLAVOR = new DataFlavor(BookmarkInfo.class, "Bookmark Information");
    static DataFlavor[] flavors = new DataFlavor[]{INFO_FLAVOR};
    public static final boolean MALE = true;
    public static final boolean FEMALE = false;
    private String Name = null;
    private String Url = null;
    private boolean Gender = true;
    private BookmarkInfo Parent = null;
    private Vector Children = new Vector();
    private static Logger logger = Logger.getLogger(BookmarkInfo.class);

    public BookmarkInfo(String string) {
        this.Name = string;
        this.Gender = false;
        this.Url = "";
    }

    public BookmarkInfo(String string, String string2) {
        this.Name = string;
        this.Gender = true;
        this.Url = string2;
    }

    public boolean isMale() {
        return this.Gender;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String string) {
        this.Name = string;
    }

    public String getURL() {
        return this.Url;
    }

    public void setURL(String string) {
        this.Url = string;
    }

    public void add(BookmarkInfo bookmarkInfo) {
        bookmarkInfo.setParent(this);
        this.Children.add(bookmarkInfo);
    }

    public void remove(BookmarkInfo bookmarkInfo) {
        bookmarkInfo.setParent(null);
        this.Children.remove(bookmarkInfo);
    }

    public BookmarkInfo getParent() {
        return this.Parent;
    }

    public void setParent(BookmarkInfo bookmarkInfo) {
        this.Parent = bookmarkInfo;
    }

    public Vector getChildren() {
        return this.Children;
    }

    public Object clone() {
        if (!this.Gender) {
            return new BookmarkInfo(this.Name);
        }
        return new BookmarkInfo(this.Name, this.Url);
    }

    public String toString() {
        return this.Name;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(INFO_FLAVOR);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(INFO_FLAVOR)) {
            return this;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

