/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.gui.BookmarkInfo;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class BookmarkNode
extends DefaultMutableTreeNode {
    private boolean isMale;
    private String description;
    private String url;
    private BookmarkInfo bmInfo;
    private static Logger logger = Logger.getLogger(BookmarkNode.class);

    public BookmarkNode(BookmarkInfo bookmarkInfo) {
        super(bookmarkInfo);
        this.description = bookmarkInfo.getName();
        this.url = bookmarkInfo.getURL();
        this.isMale = bookmarkInfo.isMale();
        this.bmInfo = bookmarkInfo;
    }

    public boolean isLeaf() {
        return this.isMale;
    }

    public boolean getAllowsChildren() {
        return !this.isMale;
    }

    public void add(DefaultMutableTreeNode defaultMutableTreeNode) {
        super.add(defaultMutableTreeNode);
        BookmarkInfo bookmarkInfo = ((BookmarkNode)defaultMutableTreeNode).getBookmarkInfo();
        BookmarkInfo bookmarkInfo2 = bookmarkInfo.getParent();
        BookmarkInfo bookmarkInfo3 = this.getBookmarkInfo();
        bookmarkInfo3.add(bookmarkInfo);
    }

    public void remove(DefaultMutableTreeNode defaultMutableTreeNode) {
        super.remove(defaultMutableTreeNode);
        BookmarkInfo bookmarkInfo = ((BookmarkNode)defaultMutableTreeNode).getBookmarkInfo();
        BookmarkInfo bookmarkInfo2 = this.getBookmarkInfo();
        if (this.parent != null) {
            bookmarkInfo2.remove(bookmarkInfo);
        }
    }

    public String getDescription() {
        if (this.getUserObject() instanceof String) {
            this.description = new String((String)this.getUserObject());
        }
        return new String(this.description);
    }

    public String getURL() {
        return new String(this.url);
    }

    public BookmarkInfo getBookmarkInfo() {
        logger.info("BookmarkNode.getBookmarkInfo()");
        return this.bmInfo;
    }

    public void setName(String string) {
        this.description = string;
        this.bmInfo.setName(string);
    }

    public Object clone() {
        logger.info("BookmarkNode:clone()");
        BookmarkNode bookmarkNode = new BookmarkNode(this.bmInfo);
        if (!this.isLeaf() && this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                bookmarkNode.add((DefaultMutableTreeNode)((BookmarkNode)this.children.get(i)).clone());
            }
        }
        return bookmarkNode;
    }
}

