/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.LinearTarget;
import ca.ucalgary.bluejay.client.XPointerResolver;
import ca.ucalgary.bluejay.client.impl.BluejayDTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayAbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.FeatureRangeGUI;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.comparison.ComparisonPool;
import ca.ucalgary.bluejay.gui.painter.AbstractLinearPainter;
import ca.ucalgary.bluejay.gui.painter.AbstractSequencePainter;
import ca.ucalgary.bluejay.gui.painter.AbstractTargetPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.util.RadixExchangeSort;
import com.simonstl.sax.xlink.Link;
import com.simonstl.sax.xlink.LinkSet;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.List;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class MaskPainter {
    private static JProgressBar progressBar = null;
    private static final int PROGRESS_UPDATE_INTERVAL = 100;
    private static final int INSANELY_LARGE_NUMBER = Integer.MAX_VALUE;
    private DTDElementInstance[] drawableElementsByStart;
    private DTDElementInstance[] alwaysDrawnElements;
    private DTDElementInstance docRoot;
    private DTDElementInstance sequenceElement;
    private int[] elementStarts;
    private int[] elementEnds;
    private byte[] elementPriorities;
    private List visibleRanges;
    private int[] extRange = new int[2];
    private int[] featureIndex = new int[2];
    private int targetNum;
    private VisibilityManager vizMgr;
    private int targetMinPos;
    private int targetMaxPos;
    private int largeElementThreshold;
    private int largestRange;
    private int numSmallElements;
    private int oldNumSmallElements;
    private int numLargeElements;
    public final double largeElementProportion = 0.6;
    public final int mainArrayChunkSize = 10000;
    public final int alwaysDrawnArrayChunkSize = 50;
    public static final int VALUE_NOT_FOUND = -1;
    public static final int LOWER_BOUND = -2;
    public static final int UPPER_BOUND = -3;
    private static Logger logger = Logger.getLogger(MaskPainter.class);

    public MaskPainter(int n, VisibilityManager visibilityManager, int n2, int n3) {
        this.targetNum = n;
        this.vizMgr = visibilityManager;
        this.setTargetSize(n2, n3);
    }

    public static void setJProgressBar(JProgressBar jProgressBar) {
        progressBar = jProgressBar;
    }

    public int getNumFeaturesVisible(int n, int n2) {
        int n3;
        int n4 = MaskPainter.findIndexFromValue(this.elementStarts, n, -3);
        if (n4 <= (n3 = MaskPainter.findIndexFromValue(this.elementStarts, n2, -2))) {
            return n3 - n4 + 1;
        }
        return 0;
    }

    public void addFeatures(FeatureRangeGUI featureRangeGUI, int n, int n2) {
        int n3 = MaskPainter.findIndexFromValue(this.elementStarts, n, -2);
        int n4 = MaskPainter.findIndexFromValue(this.elementStarts, n2, -3);
        int n5 = this.targetMinPos;
        int n6 = this.targetMaxPos;
        for (int i = n3; i <= n4; ++i) {
            AbstractLinearPainter abstractLinearPainter = this.drawableElementsByStart[i].getPainter();
            featureRangeGUI.addFeature(this.drawableElementsByStart[i], abstractLinearPainter.getToolTip(this.drawableElementsByStart[i]), this.elementStarts[i], this.elementEnds[i], n5, n6);
        }
    }

    public int getTargetStart() {
        return this.targetMinPos;
    }

    public int getTargetStop() {
        return this.targetMaxPos;
    }

    public void setTargetSize(int n, int n2) {
        this.targetMinPos = n;
        this.targetMaxPos = n2;
        this.largeElementThreshold = (int)((double)(this.targetMaxPos - this.targetMinPos + 1) * 0.6);
    }

    public void setRootNode(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) {
        this.largestRange = 0;
        this.numSmallElements = 0;
        this.numLargeElements = 0;
        this.docRoot = dTDElementInstance;
        if (this.docRoot == null) {
            this.drawableElementsByStart = null;
            this.alwaysDrawnElements = null;
            return;
        }
        this.drawableElementsByStart = new DTDElementInstance[10000];
        this.elementStarts = new int[10000];
        this.initializeArray(this.elementStarts, 0, Integer.MAX_VALUE);
        this.elementEnds = new int[10000];
        this.alwaysDrawnElements = new DTDElementInstance[50];
        dTDElementInstance.getPainter().preProcess(abstractLinearGraphics, this, dTDElementInstance);
        RadixExchangeSort.sort(this.elementStarts, this.elementEnds, this.drawableElementsByStart, this.targetMaxPos);
    }

    public DTDElementInstance getRootNode() {
        return this.docRoot;
    }

    public DTDElementInstance[] getLargeElements() {
        return this.alwaysDrawnElements;
    }

    public DTDElementInstance[] getSmallElements() {
        return this.drawableElementsByStart;
    }

    public void addFeature(DTDElementInstance dTDElementInstance, int n, int n2) {
        int n3 = Math.abs(n2 - n + 1);
        if (n3 < this.largeElementThreshold) {
            if (n3 > this.largestRange) {
                this.largestRange = n3;
            }
            ++this.numSmallElements;
            if (this.numSmallElements > this.drawableElementsByStart.length) {
                int[] nArray = new int[this.drawableElementsByStart.length + 10000];
                System.arraycopy(this.elementStarts, 0, nArray, 0, this.elementStarts.length);
                this.elementStarts = nArray;
                this.initializeArray(this.elementStarts, this.numSmallElements, Integer.MAX_VALUE);
                nArray = new int[this.drawableElementsByStart.length + 10000];
                System.arraycopy(this.elementEnds, 0, nArray, 0, this.elementEnds.length);
                this.elementEnds = nArray;
                DTDElementInstance[] dTDElementInstanceArray = new DTDElementInstance[this.drawableElementsByStart.length + 10000];
                System.arraycopy(this.drawableElementsByStart, 0, dTDElementInstanceArray, 0, this.drawableElementsByStart.length);
                this.drawableElementsByStart = dTDElementInstanceArray;
            }
            this.drawableElementsByStart[this.numSmallElements - 1] = dTDElementInstance;
            this.elementStarts[this.numSmallElements - 1] = n;
            this.elementEnds[this.numSmallElements - 1] = n2;
        } else {
            ++this.numLargeElements;
            if (this.numLargeElements > this.alwaysDrawnElements.length) {
                DTDElementInstance[] dTDElementInstanceArray = new DTDElementInstance[this.alwaysDrawnElements.length + 50];
                System.arraycopy(this.alwaysDrawnElements, 0, dTDElementInstanceArray, 0, this.alwaysDrawnElements.length);
                this.alwaysDrawnElements = dTDElementInstanceArray;
            }
            this.alwaysDrawnElements[this.numLargeElements - 1] = dTDElementInstance;
        }
        if (dTDElementInstance.getPainter() instanceof AbstractSequencePainter) {
            this.sequenceElement = dTDElementInstance;
        }
        ((BluejayDTDElementInstance)dTDElementInstance).setStart(n);
        ((BluejayDTDElementInstance)dTDElementInstance).setEnd(n2);
    }

    public DTDElementInstance getSequenceElement() {
        return this.sequenceElement;
    }

    private void initializeArray(int[] nArray, int n, int n2) {
        for (int i = n; i < nArray.length; ++i) {
            nArray[i] = n2;
        }
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics) {
        int[] nArray = this.vizMgr.getDrawnRange();
        this.paint(abstractLinearGraphics, nArray[0], nArray[1]);
    }

    private void findElementIndices(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2;
        int n3 = this.drawableElementsByStart[0].getSlaveNum();
        nArray2[n3] = 0;
        nArray[0] = n3;
        int n4 = 1;
        for (n2 = 0; n2 < this.numSmallElements; ++n2) {
            if (this.drawableElementsByStart[n2].getSlaveNum() == n3) continue;
            nArray3[n3] = n2 - 1;
            n3 = this.drawableElementsByStart[n2].getSlaveNum();
            nArray[n4++] = n3;
            nArray2[n3] = n2;
        }
        nArray3[n3] = this.numSmallElements - 1;
        if (n4 != n) {
            System.err.printf(">MaskPainter.findElementIndices(): Found %d sequence(s), but was supposed to find %d.\n", n4, n);
            for (n2 = 0; n2 < n; ++n2) {
                n3 = nArray[n2];
            }
        }
    }

    private void sortElementsPerSequence(int[] nArray, int[] nArray2, int[] nArray3, int n, ComparisonPool comparisonPool) {
        for (int i = 1; i < n; ++i) {
            int n2 = nArray[i];
            RadixExchangeSort.sort(this.elementStarts, this.elementEnds, this.drawableElementsByStart, comparisonPool.getMasterLen(), nArray2[n2], nArray3[n2]);
        }
    }

    protected void paint(AbstractLinearGraphics abstractLinearGraphics, int n, int n2) {
        int n3;
        int n4;
        abstractLinearGraphics.setPaintAllowed(true);
        ComparisonPool comparisonPool = this.getDList().getComparisonPool();
        int n5 = comparisonPool.getPoolSize();
        int n6 = n5 == 0 ? n5 + 1 : n5;
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        int[] nArray3 = new int[n6];
        int[] nArray4 = new int[n6];
        int[] nArray5 = new int[n6];
        boolean[] blArray = new boolean[n6];
        if (n6 > 1) {
            this.findElementIndices(nArray, nArray2, nArray3, n6);
            this.sortElementsPerSequence(nArray, nArray2, nArray3, n6, comparisonPool);
        } else {
            nArray[0] = 0;
            nArray2[0] = 0;
            nArray3[0] = this.numSmallElements - 1;
        }
        if (this.vizMgr.getScale() == -5.898) {
            n = this.targetMinPos;
            n2 = this.targetMaxPos;
        }
        int n7 = this.targetMaxPos;
        if (n6 > 1) {
            n7 = comparisonPool.getMasterLen();
        }
        int n8 = n - this.largestRange < this.targetMinPos ? this.targetMinPos : n - this.largestRange;
        int n9 = n2 + this.largestRange > n7 ? n7 : n2 + this.largestRange;
        for (n4 = 0; n4 < n6; ++n4) {
            boolean bl;
            n3 = nArray[n4];
            nArray4[n3] = MaskPainter.findIndexFromValue(this.elementStarts, nArray2[n3], nArray3[n3], n8, -2);
            nArray5[n3] = MaskPainter.findIndexFromValue(this.elementStarts, nArray2[n3], nArray3[n3], n9, -3);
            boolean bl2 = bl = n > n2 || n8 > n9 || nArray4[n3] > nArray5[n3];
            if (bl && nArray4[n3] <= nArray5[n3]) {
                nArray4[n3] = nArray2[n3];
                nArray5[n3] = nArray3[n3];
                n = n8 = this.targetMinPos;
                n2 = n9 = n7;
                bl = false;
            }
            if (progressBar != null) {
                progressBar.setMinimum(0);
                int n10 = 2 * (nArray5[n3] - nArray4[n3] + 1 + this.numLargeElements);
                if (bl) {
                    n10 += 2 * (nArray3[n3] - nArray2[n3] + 1);
                }
                progressBar.setMaximum(n10);
                progressBar.setValue(0);
            }
            if (abstractLinearGraphics.getLOD() <= 60) {
                try {
                    if (n4 == 0) {
                        this.clearLayout();
                    }
                    abstractLinearGraphics.getLegend().setAddingItems(true);
                    this.updateMajorFeatures(abstractLinearGraphics, n, n2, n8, n9, nArray4[n3], nArray5[n3], nArray2[n3], nArray3[n3]);
                    abstractLinearGraphics.getLegend().setAddingItems(false);
                }
                catch (Exception exception) {
                    logger.error("AD::<<MaskPainter>> paint major" + exception.getMessage());
                    exception.printStackTrace();
                }
                continue;
            }
            try {
                this.oldNumSmallElements = this.numSmallElements;
                blArray[n3] = this.isEmbeddingDetails(abstractLinearGraphics, nArray4[n3], nArray5[n3]);
                abstractLinearGraphics.getLegend().setAddingItems(true);
                this.updateMinorFeatures(abstractLinearGraphics, n, n2, n8, n9, nArray4[n3], nArray5[n3], nArray2[n3], nArray3[n3], blArray[n3]);
                abstractLinearGraphics.getLegend().setAddingItems(false);
                continue;
            }
            catch (Exception exception) {
                new Exception("AD::<<MaskPainter>> paint minor").printStackTrace();
            }
        }
        this.createVisibleTarget(abstractLinearGraphics, n, n2);
        if (n6 > 1) {
            ((BluejayAbstractLinearGraphics)abstractLinearGraphics).getLLPainter().setLinkingLine();
        }
        for (n4 = 0; n4 < n6; ++n4) {
            n3 = nArray[n4];
            if (abstractLinearGraphics.getLOD() <= 60) {
                try {
                    this.paintMajorFeatures(abstractLinearGraphics, n, n2, n8, n9, nArray4[n3], nArray5[n3], nArray2[n3], nArray3[n3]);
                }
                catch (Exception exception) {
                    logger.error("AD::<<MaskPainter>> paint major" + exception.getMessage());
                    exception.printStackTrace();
                }
                continue;
            }
            try {
                this.paintMinorFeatures(abstractLinearGraphics, n, n2, n8, n9, nArray4[n3], nArray5[n3], nArray2[n3], nArray3[n3], blArray[n3]);
                continue;
            }
            catch (Exception exception) {
                new Exception("AD::<<MaskPainter>> paint minor").printStackTrace();
            }
        }
    }

    public void updateMajorFeatures(AbstractLinearGraphics abstractLinearGraphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws Exception {
        int n9;
        boolean bl = n5 > n6;
        int n10 = 0;
        try {
            for (n9 = 0; n9 < this.numLargeElements; ++n9) {
                if (this.alwaysDrawnElements[n9] == null || this.alwaysDrawnElements[n9].getPainter().getPriority() > 60) continue;
                if (progressBar != null && n10++ % 100 == 0) {
                    progressBar.setValue(n10);
                }
                this.alwaysDrawnElements[n9].getPainter().updateLegendItem(abstractLinearGraphics, this.alwaysDrawnElements[n9]);
            }
        }
        catch (Exception exception) {
            logger.error("Error drawing large features of the document: " + exception);
            exception.printStackTrace();
        }
        n9 = n5;
        while (n7 <= n8 && n9 != n6 + 1 && this.elementStarts[n9] < n) {
            if (this.drawableElementsByStart[n9].getPainter().getPriority() <= 60) {
                if (progressBar != null && n10++ % 100 == 0) {
                    progressBar.setValue(n10);
                }
                if (this.elementEnds[n9] >= n) {
                    this.drawableElementsByStart[n9].getPainter().updateLegendItem(abstractLinearGraphics, this.drawableElementsByStart[n9]);
                }
            }
            n9 = bl && n9 + 1 > n8 ? (n9 + 1) % (n8 + 1) + n7 : n9 + 1;
        }
        while (n7 <= n8 && n9 != n6 + 1 && this.elementStarts[n9] <= n2) {
            if (progressBar != null && n10++ % 100 == 0) {
                progressBar.setValue(n10);
            }
            if (this.drawableElementsByStart[n9].getPainter().getPriority() <= 60) {
                this.drawableElementsByStart[n9].getPainter().updateLegendItem(abstractLinearGraphics, this.drawableElementsByStart[n9]);
            }
            n9 = bl && n9 + 1 > n8 ? (n9 + 1) % (n8 + 1) + n7 : n9 + 1;
        }
        while (n7 <= n8 && n9 != n6 + 1) {
            if (progressBar != null && n10++ % 100 == 0) {
                progressBar.setValue(n10);
            }
            if (this.drawableElementsByStart[n9].getPainter().getPriority() <= 60) {
                this.drawableElementsByStart[n9].getPainter().updateLegendItem(abstractLinearGraphics, this.drawableElementsByStart[n9]);
            }
            n9 = bl && n9 + 1 > n8 ? (n9 + 1) % (n8 + 1) + n7 : n9 + 1;
        }
    }

    private void paintMajorFeatures(AbstractLinearGraphics abstractLinearGraphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws Exception {
        boolean bl = n6 < n5;
        int n9 = progressBar.getValue();
        double d = (double)(n6 - n5 + 1) / ((double)n4 - (double)n3) * abstractLinearGraphics.getScale();
        boolean bl2 = d > 2.0;
        try {
            for (int i = 0; i < this.numLargeElements; ++i) {
                if (this.alwaysDrawnElements[i] == null || this.alwaysDrawnElements[i] == this.docRoot) continue;
                if (progressBar != null && n9++ % 100 == 0) {
                    progressBar.setValue(n9);
                }
                if (this.alwaysDrawnElements[i].getPainter().getPriority() > 60) continue;
                this.alwaysDrawnElements[i].paint(abstractLinearGraphics);
            }
        }
        catch (Exception exception) {
            logger.error("Error drawing large features of the document: " + exception);
            exception.printStackTrace();
        }
        double d2 = this.vizMgr.getScale();
        int n10 = -1;
        int n11 = -1;
        int n12 = n5;
        while (n7 <= n8 && n12 != n6 + 1 && !(!bl ? this.elementStarts[n12] >= n : this.elementStarts[n12] < n2)) {
            if (progressBar != null && n9++ % 100 == 0) {
                progressBar.setValue(n9);
            }
            if (this.drawableElementsByStart[n12].getPainter().getPriority() <= 60 && this.elementEnds[n12] >= n) {
                if (!bl2 || (double)Math.abs(this.elementEnds[n12] - this.elementStarts[n12]) > d2) {
                    this.drawableElementsByStart[n12].paint(abstractLinearGraphics);
                } else if (this.elementStarts[n12] <= this.elementEnds[n12]) {
                    if (n10 != (int)((double)this.elementStarts[n12] / d2)) {
                        this.drawableElementsByStart[n12].paint(abstractLinearGraphics);
                        n10 = (int)((double)this.elementStarts[n12] / d2);
                    }
                } else if (n11 != (int)((double)this.elementStarts[n12] / d2)) {
                    this.drawableElementsByStart[n12].paint(abstractLinearGraphics);
                    n11 = (int)((double)this.elementStarts[n12] / d2);
                }
            }
            n12 = bl && n12 + 1 > n8 ? (n12 + 1) % (n8 + 1) + n7 : n12 + 1;
        }
        while (n7 <= n8 && n12 != n6 + 1 && this.elementStarts[n12] <= n2) {
            if (progressBar != null && n9++ % 100 == 0) {
                progressBar.setValue(n9);
            }
            if (this.drawableElementsByStart[n12].getPainter().getPriority() <= 60) {
                if (!bl2 || (double)Math.abs(this.elementEnds[n12] - this.elementStarts[n12]) > d2) {
                    this.drawableElementsByStart[n12].paint(abstractLinearGraphics);
                } else if (this.elementStarts[n12] <= this.elementEnds[n12]) {
                    if (n10 != (int)((double)this.elementStarts[n12] / d2)) {
                        this.drawableElementsByStart[n12].paint(abstractLinearGraphics);
                        n10 = (int)((double)this.elementStarts[n12] / d2);
                    }
                } else if (n11 != (int)((double)this.elementStarts[n12] / d2)) {
                    this.drawableElementsByStart[n12].paint(abstractLinearGraphics);
                    n11 = (int)((double)this.elementStarts[n12] / d2);
                }
            }
            n12 = bl && n12 + 1 > n8 ? (n12 + 1) % (n8 + 1) + n7 : n12 + 1;
        }
        while (n7 <= n8 && n12 != n6 + 1) {
            if (progressBar != null && n9++ % 100 == 0) {
                progressBar.setValue(n9);
            }
            if (this.drawableElementsByStart[n12].getPainter().getPriority() <= 60) {
                if (!bl2 || (double)Math.abs(this.elementStarts[n12] - this.elementEnds[n12]) > d2) {
                    this.drawableElementsByStart[n12].paint(abstractLinearGraphics);
                } else if (this.elementStarts[n12] <= this.elementEnds[n12]) {
                    if (n10 != (int)((double)this.elementStarts[n12] / d2)) {
                        this.drawableElementsByStart[n12].paint(abstractLinearGraphics);
                        n10 = (int)((double)this.elementStarts[n12] / d2);
                    }
                } else if (n11 != (int)((double)this.elementStarts[n12] / d2)) {
                    this.drawableElementsByStart[n12].paint(abstractLinearGraphics);
                    n11 = (int)((double)this.elementStarts[n12] / d2);
                }
            }
            n12 = bl && n12 + 1 > n8 ? (n12 + 1) % (n8 + 1) + n7 : n12 + 1;
        }
    }

    private boolean isEmbeddingDetails(AbstractLinearGraphics abstractLinearGraphics, int n, int n2) {
        boolean bl = false;
        if (abstractLinearGraphics.getLOD() >= 80) {
            HashMap<DTDElementInstance, Integer> hashMap = new HashMap<DTDElementInstance, Integer>();
            LinkSet linkSet = abstractLinearGraphics.getLinkSet();
            if (linkSet != null) {
                Object object;
                linkSet = linkSet.getByRole("http://www.bioxml.info/roles/feature-elucidation");
                LinkSet linkSet2 = new LinkSet();
                for (int i = n; this.numSmallElements != 0 && i != -1 && i <= n2; ++i) {
                    object = this.drawableElementsByStart[i].getXPointer();
                    LinkSet linkSet3 = linkSet.getByFromFragment((String)object);
                    if (linkSet3 == null) continue;
                    Object object2 = linkSet3.toList().iterator();
                    while (object2 != null && object2.hasNext()) {
                        hashMap.put(this.drawableElementsByStart[i], new Integer(i));
                        linkSet2.addLink((Link)object2.next());
                    }
                }
                Document document = null;
                if (this.numLargeElements > 0) {
                    document = this.alwaysDrawnElements[0].getOwnerDocument();
                }
                if (document == null && this.numSmallElements > 0) {
                    document = this.drawableElementsByStart[0].getOwnerDocument();
                }
                object = null;
                if (document != null) {
                    object = XPointerResolver.embedLinkSetEndPoints(document, linkSet2, hashMap.keySet());
                } else {
                    logger.warn("Warning: cannot find document root to embed links, skipping link expansion");
                }
                if (object != null) {
                    for (Object object2 : hashMap.keySet()) {
                        if (!object.containsKey(object2)) continue;
                        if (!bl) {
                            bl = true;
                        }
                        DTDElementInstance dTDElementInstance = (DTDElementInstance)object.get(object2);
                        int n3 = (Integer)hashMap.get(object2);
                        this.drawableElementsByStart[n3] = dTDElementInstance;
                        dTDElementInstance.getPainter().preProcess(abstractLinearGraphics, this, dTDElementInstance);
                    }
                }
            }
        }
        return bl;
    }

    private void updateMinorFeatures(AbstractLinearGraphics abstractLinearGraphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        int n9;
        boolean bl2 = n6 < n5;
        int n10 = 0;
        try {
            for (n9 = 0; n9 < this.numLargeElements; ++n9) {
                if (this.alwaysDrawnElements[n9] == null) continue;
                if (progressBar != null && n10++ % 100 == 0) {
                    progressBar.setValue(n10);
                }
                this.alwaysDrawnElements[n9].getPainter().updateLegendItem(abstractLinearGraphics, this.alwaysDrawnElements[n9]);
            }
        }
        catch (Exception exception) {
            logger.error("Error drawing large features of the document: " + exception);
            exception.printStackTrace();
        }
        try {
            n9 = n5;
            while (n7 <= n8 && n9 != n6 + 1 && this.elementStarts[n9] < n) {
                if (progressBar != null && n10++ % 100 == 0) {
                    progressBar.setValue(n10);
                }
                if (this.elementEnds[n9] >= n) {
                    this.drawableElementsByStart[n9].getPainter().updateLegendItem(abstractLinearGraphics, this.drawableElementsByStart[n9]);
                }
                n9 = bl2 && n9 + 1 > n8 ? (n9 + 1) % (n8 + 1) + n7 : n9 + 1;
            }
            while (n7 <= n8 && n9 != n6 + 1 && this.elementStarts[n9] <= n2) {
                if (progressBar != null && n10++ % 100 == 0) {
                    progressBar.setValue(n10);
                }
                this.drawableElementsByStart[n9].getPainter().updateLegendItem(abstractLinearGraphics, this.drawableElementsByStart[n9]);
                n9 = bl2 && n9 + 1 > n8 ? (n9 + 1) % (n8 + 1) + n7 : n9 + 1;
            }
            if (bl) {
                for (int i = this.oldNumSmallElements; i < this.numSmallElements; ++i) {
                    this.drawableElementsByStart[i].getPainter().updateLegendItem(abstractLinearGraphics, this.drawableElementsByStart[i]);
                }
            }
            while (n7 <= n8 && n9 != n6 + 1) {
                if (progressBar != null && n10++ % 100 == 0) {
                    progressBar.setValue(n10);
                }
                this.drawableElementsByStart[n9].getPainter().updateLegendItem(abstractLinearGraphics, this.drawableElementsByStart[n9]);
                n9 = bl2 && n9 + 1 > n8 ? (n9 + 1) % (n8 + 1) + n7 : n9 + 1;
            }
        }
        catch (Exception exception) {
            logger.error("While drawing small features of the document, got exception: " + exception);
            exception.printStackTrace();
        }
    }

    private void paintMinorFeatures(AbstractLinearGraphics abstractLinearGraphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        int n9;
        boolean bl2 = n6 < n5;
        int n10 = progressBar.getValue();
        try {
            for (n9 = 0; n9 < this.numLargeElements; ++n9) {
                if (this.alwaysDrawnElements[n9] == null || this.alwaysDrawnElements[n9] == this.docRoot) continue;
                if (progressBar != null && n10++ % 100 == 0) {
                    progressBar.setValue(n10);
                }
                this.alwaysDrawnElements[n9].getPainter().paint(abstractLinearGraphics, this.alwaysDrawnElements[n9]);
            }
        }
        catch (Exception exception) {
            logger.error("Error drawing large features of the document: " + exception);
            exception.printStackTrace();
        }
        try {
            n9 = n5;
            while (n7 <= n8 && n9 != n6 + 1 && !(!bl2 ? this.elementStarts[n9] >= n : this.elementStarts[n9] < n2)) {
                if (progressBar != null && n10++ % 100 == 0) {
                    progressBar.setValue(n10);
                }
                if (this.elementEnds[n9] >= n) {
                    this.drawableElementsByStart[n9].paint(abstractLinearGraphics);
                }
                n9 = bl2 && n9 + 1 > n8 ? (n9 + 1) % (n8 + 1) + n7 : n9 + 1;
            }
            while (n7 <= n8 && n9 != n6 + 1 && this.elementStarts[n9] <= n2) {
                if (progressBar != null && n10++ % 100 == 0) {
                    progressBar.setValue(n10);
                }
                this.drawableElementsByStart[n9].paint(abstractLinearGraphics);
                n9 = bl2 && n9 + 1 > n8 ? (n9 + 1) % (n8 + 1) + n7 : n9 + 1;
            }
            if (bl) {
                for (int i = this.oldNumSmallElements; i < this.numSmallElements; ++i) {
                    this.drawableElementsByStart[i].paint(abstractLinearGraphics);
                }
            }
            while (n7 <= n8 && n9 != n6 + 1) {
                if (progressBar != null && n10++ % 100 == 0) {
                    progressBar.setValue(n10);
                }
                this.drawableElementsByStart[n9].paint(abstractLinearGraphics);
                n9 = bl2 && n9 + 1 > n8 ? (n9 + 1) % (n8 + 1) + n7 : n9 + 1;
            }
        }
        catch (Exception exception) {
            logger.error("While drawing small features of the document, got exception: " + exception);
            exception.printStackTrace();
        }
        if (bl) {
            RadixExchangeSort.sort(this.elementStarts, this.elementEnds, this.drawableElementsByStart, this.targetMaxPos);
        }
    }

    private void clearLayout() {
        try {
            AbstractLinearPainter abstractLinearPainter = this.docRoot.getPainter();
            if (abstractLinearPainter instanceof AbstractTargetPainter) {
                ((AbstractTargetPainter)abstractLinearPainter).clearLayout();
            }
        }
        catch (Exception exception) {
            logger.error("Could not clear layout: " + exception);
        }
    }

    public LaneManager getLaneManager() {
        AbstractLinearPainter abstractLinearPainter = this.docRoot.getPainter();
        return ((AbstractTargetPainter)abstractLinearPainter).getLaneManager();
    }

    private void createVisibleTarget(AbstractLinearGraphics abstractLinearGraphics, int n, int n2) {
        try {
            AbstractLinearPainter abstractLinearPainter = this.docRoot.getPainter();
            if (abstractLinearPainter instanceof AbstractTargetPainter) {
                AbstractTargetPainter abstractTargetPainter = (AbstractTargetPainter)abstractLinearPainter;
                LinearTarget linearTarget = abstractTargetPainter.createTarget(abstractLinearGraphics, this.docRoot);
                double d = this.vizMgr.getScale();
                if (d == -5.898) {
                    Dimension dimension = abstractLinearGraphics.getVisibleSize();
                    LaneManager laneManager = abstractTargetPainter.getLaneManager();
                    int n3 = 10;
                    double d2 = linearTarget.calculateIdealScale(n2 - n + 1, dimension, laneManager, n3);
                    int n4 = 101;
                    if (dimension.height < n4) {
                        double d3 = d2 * 12.0;
                        abstractLinearGraphics.setScale(d3);
                    } else {
                        abstractLinearGraphics.setScale(d2);
                    }
                    linearTarget = abstractTargetPainter.createTarget(abstractLinearGraphics, this.docRoot);
                    this.vizMgr.setPropagation(false);
                    this.vizMgr.setVisibleRange(0, n, n2);
                    this.vizMgr.setPropagation(true);
                }
                int n5 = abstractLinearGraphics.addTarget(linearTarget, this.docRoot, 20);
                abstractTargetPainter.setTargetNumber(n5);
                abstractTargetPainter.paintPostTarget(abstractLinearGraphics, this.docRoot);
            }
        }
        catch (Exception exception) {
            logger.error("Could not add target: " + exception);
            exception.printStackTrace();
        }
    }

    public static int findIndexFromValue(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = n - 1;
        int n6 = n2 - n + 1;
        float f = (float)n6 / 2.0f;
        int n7 = n + Math.round(f) - 1;
        while (n7 != n5) {
            f /= 2.0f;
            int n8 = n7;
            if (nArray[n7] == n3) break;
            n7 = nArray[n7] > n3 ? Math.round((float)n7 - f) : Math.round((float)n7 + f);
            n5 = n8;
        }
        if (n4 == -2) {
            if (nArray[n7] == n3) {
                while (n7 > n && nArray[n7 - 1] >= n3) {
                    --n7;
                }
            } else if (n7 != n2 && nArray[n7] < n3) {
                ++n7;
            }
        } else if (nArray[n7] == n3) {
            while (n7 < n2 && nArray[n7 + 1] <= n3) {
                ++n7;
            }
        } else if (n7 != n && nArray[n7] > n3) {
            --n7;
        }
        return n7;
    }

    public static int findIndexFromValue(int[] nArray, int n, int n2) {
        int n3 = -1;
        float f = (float)nArray.length / 2.0f;
        int n4 = Math.round(f) - 1;
        while (n4 != n3) {
            f /= 2.0f;
            int n5 = n4;
            if (nArray[n4] == n) break;
            n4 = nArray[n4] > n ? Math.round((float)n4 - f) : Math.round((float)n4 + f);
            n3 = n5;
        }
        if (n2 == -2) {
            if (nArray[n4] == n) {
                while (n4 >= 1 && nArray[n4 - 1] >= n) {
                    --n4;
                }
            } else if (n4 != nArray.length - 1 && nArray[n4] < n) {
                ++n4;
            }
        } else if (nArray[n4] == n) {
            while (n4 < nArray.length - 1 && nArray[n4 + 1] <= n) {
                ++n4;
            }
        } else if (n4 != 0 && nArray[n4] > n) {
            --n4;
        }
        return n4;
    }

    public DTDElementInstance[] getDrawableElements() {
        return this.drawableElementsByStart;
    }

    public DTDElementInstance[] getAlwaysDrawnElements() {
        return this.alwaysDrawnElements;
    }

    public void setElements(DTDElementInstance[] dTDElementInstanceArray, DTDElementInstance[] dTDElementInstanceArray2) {
        this.drawableElementsByStart = dTDElementInstanceArray;
        this.alwaysDrawnElements = dTDElementInstanceArray2;
    }

    public int[] getExtRange() {
        return this.extRange;
    }

    public void setExtRange(int n, int n2) {
        this.extRange[0] = n;
        this.extRange[1] = n2;
    }

    public void setFeatureIndex(int n, int n2) {
        this.featureIndex[0] = n;
        this.featureIndex[1] = n2;
    }

    public int[] getFeatureIndex() {
        return this.featureIndex;
    }

    public int[] getNumElements() {
        int[] nArray = new int[]{this.numLargeElements, this.numSmallElements};
        return nArray;
    }

    public void setNumElements(int[] nArray) {
        this.numLargeElements = nArray[0];
        this.numSmallElements = nArray[1];
    }

    public int[] getStartIndex() {
        return this.elementStarts;
    }

    public int[] getEndIndex() {
        return this.elementEnds;
    }

    public void setIndex(int[] nArray, int[] nArray2) {
        this.elementStarts = nArray;
        this.elementEnds = nArray2;
    }

    public BluejayDObjectList getDList() {
        return this.vizMgr.getDList();
    }
}

