/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PreviewPanel
extends JPanel
implements ChangeListener,
ActionListener {
    protected JColorChooser chooser;
    protected JLabel previewLabel;
    protected JToggleButton backButton;
    protected JToggleButton foreButton;
    protected Font thisFont;
    private static Logger logger = Logger.getLogger(PreviewPanel.class);

    public PreviewPanel(JColorChooser jColorChooser) {
        this(jColorChooser, Color.white, Color.black, new Font("Dialog", 0, 12));
    }

    public PreviewPanel(JColorChooser jColorChooser, Color color, Color color2, Font font) {
        this.chooser = jColorChooser;
        this.thisFont = font;
        this.chooser.getSelectionModel().addChangeListener(this);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        EmptyBorder emptyBorder = new EmptyBorder(10, 10, 10, 10);
        this.setBorder(emptyBorder);
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        jPanel.setPreferredSize(new Dimension(200, 200));
        jPanel.setMaximumSize(new Dimension(200, 200));
        jPanel.setMinimumSize(new Dimension(200, 200));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.backButton = new JToggleButton("Background");
        this.backButton.setSelected(true);
        this.backButton.addActionListener(this);
        buttonGroup.add(this.backButton);
        jPanel.add(this.backButton);
        this.foreButton = new JToggleButton("Foreground");
        this.foreButton.addActionListener(this);
        buttonGroup.add(this.foreButton);
        jPanel.add(this.foreButton);
        this.add((Component)jPanel, "West");
        this.previewLabel = new JLabel("The quick brown fox jumps over the lazy dog.", 0);
        this.previewLabel.setFont(this.thisFont);
        this.previewLabel.setBackground(color);
        this.previewLabel.setForeground(color2);
        this.previewLabel.setOpaque(true);
        JScrollPane jScrollPane = new JScrollPane(this.previewLabel);
        this.add((Component)jScrollPane, "Center");
        this.chooser.setColor(color);
    }

    public void setTextBackground(Color color) {
        this.previewLabel.setBackground(color);
    }

    public Color getTextBackground() {
        return this.previewLabel.getBackground();
    }

    public void setTextForeground(Color color) {
        this.previewLabel.setForeground(color);
    }

    public Color getTextForeground() {
        return this.previewLabel.getForeground();
    }

    public void changeFont(String string, int n, int n2) {
        this.thisFont = new Font(string, n, n2);
        this.previewLabel.setFont(this.thisFont);
    }

    public void setTextFont(Font font) {
        this.thisFont = font;
        this.previewLabel.setFont(font);
    }

    public Font getTextFont() {
        return this.thisFont;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Color color = this.chooser.getColor();
        if (color != null) {
            if (this.backButton.isSelected()) {
                this.previewLabel.setBackground(color);
            } else {
                this.previewLabel.setForeground(color);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.backButton) {
            this.chooser.setColor(this.getTextBackground());
            this.chooser.setBorder(BorderFactory.createTitledBorder("Choose Background Colour"));
        } else if (actionEvent.getSource() == this.foreButton) {
            this.chooser.setColor(this.getTextForeground());
            this.chooser.setBorder(BorderFactory.createTitledBorder("Choose Text Colour"));
        }
    }
}

