/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class RotateListWidget
extends JPanel {
    private DefaultComboBoxModel model;
    private JComboBox backbones;
    private double old;
    private RotatePanel rotate;
    private JButton apply;
    private static Logger logger = Logger.getLogger(RotateListWidget.class);

    public RotateListWidget() {
        this.setLayout(new BoxLayout(this, 1));
        this.setPreferredSize(new Dimension(150, 150));
        this.addRotatePanel("All Backbones");
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Rotate:"));
        this.model = new DefaultComboBoxModel();
        this.backbones = new JComboBox(this.model);
        jPanel.add(this.backbones);
        this.add(jPanel);
        jPanel = new JPanel();
        jPanel.add(new JLabel("by:"));
        jPanel.add(new JLabel("degrees"));
        this.add(jPanel);
        this.apply = new JButton("Apply");
        this.add(this.apply);
    }

    public void setEnabledAll(boolean bl) {
        this.rotate.setEnabled(bl);
        this.apply.setEnabled(bl);
        this.backbones.setEnabled(bl);
    }

    public JButton getApplyButton() {
        return this.apply;
    }

    public void updateModel(DefaultComboBoxModel defaultComboBoxModel) {
        this.model = defaultComboBoxModel;
        this.backbones.setModel(this.model);
        this.backbones.repaint();
    }

    public double getRotationAngle() {
        return Math.abs(this.rotate.getExtent());
    }

    public void addRotatePanel(String string) {
        RotatePanel rotatePanel = new RotatePanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(100, 50));
        this.old = rotatePanel.getExtent();
        jPanel.add((Component)new JLabel(string), "West");
        jPanel.add((Component)rotatePanel, "Center");
        JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(rotatePanel.getExtent(), 0.0, 360.0, 15.0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setMaximumSize(new Dimension(20, 20));
        jSpinner.setMaximumSize(new Dimension(50, 30));
        jPanel2.add((Component)jSpinner, "South");
        jPanel.add((Component)jPanel2, "East");
        jSpinner.addChangeListener(rotatePanel);
        this.add(jPanel);
    }

    public DefaultComboBoxModel getModel() {
        return this.model;
    }

    private class RotatePanel
    extends JPanel
    implements ChangeListener {
        private double x;
        private double y;
        private double width;
        private double height;
        private double start;
        private double extent;
        private Ellipse2D.Double circle;

        public RotatePanel() {
            super(new BorderLayout());
            this.x = 5.0;
            this.y = 5.0;
            this.width = 50.0;
            this.height = 50.0;
            this.start = 90.0;
            this.extent = 0.0;
            this.setPreferredSize(new Dimension(60, 60));
            this.setBorder(null);
            this.circle = new Ellipse2D.Double(this.x, this.y, this.width, this.height);
        }

        public double getExtent() {
            return this.extent;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(new Color(196, 191, 204));
            graphics2D.fill(this.circle);
            graphics2D.setColor(new Color(171, 173, 208));
            Arc2D.Double double_ = new Arc2D.Double(this.x, this.y, this.width, this.height, this.start, this.extent, 2);
            graphics2D.fill(double_);
            graphics2D.setColor(Color.black);
            Line2D.Double double_2 = new Line2D.Double(this.x + this.width / 2.0, this.y + this.height / 2.0, this.x + this.width / 2.0, this.y);
            graphics2D.draw(double_2);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() instanceof JSpinner) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                if (((Number)jSpinner.getValue()).doubleValue() == 360.0) {
                    jSpinner.setValue(new Double(0.0));
                    this.extent = 0.0;
                } else {
                    this.extent = -((Number)jSpinner.getValue()).doubleValue();
                }
                logger.debug("got here in rotate panel change of: " + this.extent);
                this.repaint();
            }
        }
    }
}

