/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.PersonalizedSearchResultsTable;
import ca.ucalgary.bluejay.gui.Selector;
import ca.ucalgary.bluejay.gui.StarRater;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.comparison.ComparisonPool;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import ca.ucalgary.bluejay.gui.painter.AbstractLinearPainter;
import ca.ucalgary.bluejay.gui.util.TableSorter;
import ca.ucalgary.bluejay.session.PersonalizationController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Searcher
implements ActionListener,
ListSelectionListener,
FocusListener {
    public static final String RATED_0 = "0 - No Rating";
    public static final String RATED_1 = "1 - Not Useful";
    public static final String RATED_2 = "2 - Slightly Useful";
    public static final String RATED_3 = "3 - Useful";
    public static final String RATED_4 = "4 - Quite Useful";
    public static final String RATED_5 = "5 - Very Useful";
    public String INITIAL_TEXT = "in document";
    public String LABEL = "Find:";
    public String NO_TALLY_LABEL = "No search is active";
    public String PREFIX_TALLY_LABEL = "Number of matches: ";
    public String CASE_ACTION_CMD = "Case Sensitivity Change";
    public String CLOSE_ACTION_CMD = "Close Tab";
    public int SEARCHBOX_WIDTH = 12;
    public static final char FOCUS_SHORTCUT_KEY = 'f';
    public static final char SEARCH_AGAIN_SHORTCUT_KEY = 'g';
    private static final Icon NO_ICON = null;
    private static final String NO_TOOL_TIP = null;
    private static boolean NO_REDRAW = false;
    private static boolean REDRAW = true;
    private Selector selector;
    private PersonalizedSearchResultsTable dataModel;
    private JPanel guiPanel;
    private JTextField searchBox;
    private BluejayDObjectList dlist;
    private JPanel resultsPanel;
    private JTabbedPane tabbedSidebarPane;
    private JLabel textLabel;
    private JLabel tallyLabel;
    private JButton closeButton;
    private JButton findButton;
    private JToggleButton caseButton;
    private Vector<DTDElementInstance> resultElements;
    private PersonalizationController personalController;
    private static Logger logger = Logger.getLogger(Searcher.class);

    public Searcher(BluejayDObjectList bluejayDObjectList, Selector selector, JTabbedPane jTabbedPane, PersonalizationController personalizationController) {
        this.dlist = bluejayDObjectList;
        this.selector = selector;
        this.tabbedSidebarPane = jTabbedPane;
        this.personalController = personalizationController;
        this.searchBox = new JTextField(this.INITIAL_TEXT, this.SEARCHBOX_WIDTH);
        this.searchBox.setFocusAccelerator('f');
        this.searchBox.addActionListener(this);
        this.searchBox.addFocusListener(this);
        this.createSearchBoxPanel();
        this.createSearchResultsPanel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(this.CASE_ACTION_CMD)) {
            this.updateCaseSensitivity();
        } else if (actionEvent.getActionCommand().equals(this.CLOSE_ACTION_CMD)) {
            this.closeSearchTab();
        } else {
            this.runSearch();
        }
    }

    private void closeSearchTab() {
        this.setResultsTabVisible(false);
    }

    private void updateCaseSensitivity() {
        this.runSearch();
    }

    private void runSearch() {
        Document document = this.dlist.getDocument();
        String string = this.searchBox.getText();
        if (string.length() == 0) {
            return;
        }
        if (document == null) {
            return;
        }
        Vector vector = new Vector();
        ComparisonPool comparisonPool = this.dlist.getComparisonPool();
        Vector<Genome> vector2 = comparisonPool.getSeqsFromPool();
        if (vector2 == null || vector2.isEmpty()) {
            Searcher.findText(document.getDocumentElement(), string, vector, this.caseButton.isSelected());
        } else {
            for (Genome genome : vector2) {
                Searcher.findText(genome.getRootNode(), string, vector, this.caseButton.isSelected());
            }
        }
        this.createResultsTable(vector, string);
        this.setResultsTabVisible(true);
    }

    private void createResultsTable(Vector vector, String string) {
        this.textLabel.setText('\"' + string + '\"');
        this.tallyLabel.setText(this.PREFIX_TALLY_LABEL + vector.size());
        this.clearResults();
        for (DTDElementInstance dTDElementInstance : vector) {
            double d = this.personalController.getRelevance(string, vector, dTDElementInstance);
            this.addResult(dTDElementInstance, d);
        }
    }

    public void clearResults() {
        this.resultElements.clear();
        this.dataModel.setRowCount(0);
    }

    public void addResult(DTDElementInstance dTDElementInstance, double d) {
        AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
        String string = "n/a";
        int n = 0;
        int n2 = 0;
        if (abstractLinearPainter != null) {
            int n3 = dTDElementInstance.getSlaveNum();
            string = (n3 == 0 ? "" : "[s" + n3 + "] ") + abstractLinearPainter.getDescription(dTDElementInstance);
            int[] nArray = abstractLinearPainter.getFeatureRange(dTDElementInstance);
            if (nArray != null) {
                n = nArray[0];
                n2 = nArray[1];
            }
        }
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(string);
        vector.add(new Double(d));
        vector.add(new Integer(n));
        vector.add(new Integer(n2));
        int n4 = this.personalController.getRankIfExists(abstractLinearPainter.getPrimaryID(dTDElementInstance));
        if (n4 >= 0) {
            vector.add(new StarRater(dTDElementInstance, n4));
        } else {
            vector.add(new StarRater(dTDElementInstance));
        }
        this.dataModel.addRow(vector);
        this.resultElements.add(dTDElementInstance);
    }

    public Vector getResults() {
        return this.resultElements;
    }

    public void setResultsTabVisible(boolean bl) {
        if (bl) {
            if (this.tabbedSidebarPane.indexOfComponent(this.resultsPanel) == -1) {
                this.tabbedSidebarPane.insertTab("Search Results", NO_ICON, this.resultsPanel, NO_TOOL_TIP, 0);
                this.tabbedSidebarPane.setSelectedIndex(0);
            }
        } else {
            this.tabbedSidebarPane.remove(this.resultsPanel);
        }
    }

    public static void findText(Node node, String string, Vector vector, boolean bl) {
        Node node2;
        AbstractLinearPainter abstractLinearPainter;
        if (node instanceof DTDElementInstance && (abstractLinearPainter = (node2 = (DTDElementInstance)node).getPainter()) != null) {
            String string2 = abstractLinearPainter.getDescription((DTDElementInstance)node2);
            if (Searcher.containsTerm(string, string2, bl)) {
                vector.add(node2);
                return;
            }
            String[] stringArray = abstractLinearPainter.getIDs((DTDElementInstance)node2);
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                if (!Searcher.containsTerm(string, stringArray[i], bl)) continue;
                vector.add(node2);
                break;
            }
        }
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!(node2 instanceof DTDElementInstance)) continue;
            Searcher.findText(node2, string, vector, bl);
        }
    }

    public static boolean containsTerm(String string, String string2, boolean bl) {
        String string3;
        return string2 != null && (bl ? string2.indexOf(string) != -1 : (string3 = string2.toLowerCase()) != null && string3.indexOf(string.toLowerCase()) != -1);
    }

    public boolean requestFocusInWindow() {
        return this.searchBox.requestFocusInWindow();
    }

    public void focusGained(FocusEvent focusEvent) {
        String string = this.searchBox.getText();
        if (string.equals(this.INITIAL_TEXT)) {
            this.searchBox.setText("");
        } else {
            this.searchBox.setSelectionStart(0);
            this.searchBox.setSelectionEnd(string.length());
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void setUpRatingsColumn(TableColumn tableColumn) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(RATED_0);
        jComboBox.addItem(RATED_1);
        jComboBox.addItem(RATED_2);
        jComboBox.addItem(RATED_3);
        jComboBox.addItem(RATED_4);
        jComboBox.addItem(RATED_5);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
    }

    private void createSearchResultsPanel() {
        this.textLabel = new JLabel();
        this.tallyLabel = new JLabel(this.NO_TALLY_LABEL);
        this.closeButton = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("images/ToolbarIcons/close_x.jpg")));
        this.closeButton.setActionCommand(this.CLOSE_ACTION_CMD);
        this.closeButton.addActionListener(this);
        this.closeButton.setBorderPainted(false);
        this.closeButton.setMargin(new Insets(1, 1, 1, 1));
        this.closeButton.setToolTipText("Close this tab");
        this.resultElements = new Vector();
        this.dataModel = new PersonalizedSearchResultsTable(this.personalController);
        TableSorter tableSorter = new TableSorter(this.dataModel);
        JTable jTable = new JTable(tableSorter);
        this.setUpRatingsColumn(jTable.getColumnModel().getColumn(4));
        jTable.getTableHeader().setToolTipText("Click to sort; Shift-Click to sort in reverse order");
        jTable.setPreferredScrollableViewportSize(new Dimension(200, 200));
        jTable.setAutoResizeMode(4);
        jTable.setSelectionMode(0);
        jTable.getSelectionModel().addListSelectionListener(this);
        tableSorter.setTableHeader(jTable.getTableHeader());
        JScrollPane jScrollPane = new JScrollPane(jTable);
        Dimension dimension = new Dimension(10, 10);
        JScrollBar jScrollBar = new JScrollBar(0);
        JScrollBar jScrollBar2 = new JScrollBar(1);
        jScrollBar.setMinimumSize(dimension);
        jScrollBar2.setMinimumSize(dimension);
        jScrollBar.setUnitIncrement(0);
        jScrollBar2.setUnitIncrement(0);
        jScrollPane.setHorizontalScrollBar(jScrollBar);
        jScrollPane.setVerticalScrollBar(jScrollBar2);
        Border border = BorderFactory.createEtchedBorder();
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), border));
        this.resultsPanel = new JPanel(new BorderLayout());
        Box box = new Box(2);
        box.add(this.textLabel);
        box.add(this.tallyLabel);
        box.add(this.closeButton);
        this.resultsPanel.add((Component)box, "North");
        this.resultsPanel.add((Component)jScrollPane, "Center");
    }

    public JPanel getSearchResultsPanel() {
        return this.resultsPanel;
    }

    private void createSearchBoxPanel() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.caseButton = new JToggleButton(new ImageIcon(classLoader.getResource("images/ToolbarIcons/case_insensitive.png")));
        this.caseButton.setSelectedIcon(new ImageIcon(classLoader.getResource("images/ToolbarIcons/case_sensitive.png")));
        this.caseButton.setActionCommand(this.CASE_ACTION_CMD);
        this.caseButton.addActionListener(this);
        this.caseButton.setEnabled(true);
        this.caseButton.setSelected(false);
        this.caseButton.setToolTipText("Change case sensitivity of the search");
        this.caseButton.setMargin(new Insets(1, 1, 1, 1));
        this.findButton = new JButton(new ImageIcon(classLoader.getResource("images/ToolbarIcons/search.gif")));
        this.findButton.setActionCommand("Search");
        this.findButton.addActionListener(this);
        this.findButton.setToolTipText("Search (Shortcut Alt+f)");
        this.findButton.setMargin(new Insets(1, 1, 1, 1));
        this.guiPanel = new JPanel();
        this.guiPanel.add(this.caseButton);
        this.guiPanel.add(this.findButton);
        this.guiPanel.add(this.searchBox);
    }

    public JPanel getGUIPanel() {
        return this.guiPanel;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object object = listSelectionEvent.getSource();
        if (object instanceof ListSelectionModel && !((ListSelectionModel)object).isSelectionEmpty()) {
            DTDElementInstance dTDElementInstance = this.resultElements.elementAt(((ListSelectionModel)object).getMinSelectionIndex());
            AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
            if (abstractLinearPainter == null) {
                logger.warn("Feature has no painter, could not refocus canvas");
                return;
            }
            int[] nArray = abstractLinearPainter.getFeatureRange(dTDElementInstance);
            if (nArray == null) {
                logger.warn("Feature has no position range, could not refocus canvas");
                return;
            }
            int n = (nArray[0] + nArray[1]) / 2;
            this.selector.setSelection(dTDElementInstance, false);
            VisibilityManager visibilityManager = this.dlist.getVisibilityManager();
            if (visibilityManager.isCompleteTargetDrawn(dTDElementInstance.getTarget()) && visibilityManager.getScale() >= 100.0) {
                visibilityManager.setPropagation(false);
                visibilityManager.setFocusPosition(dTDElementInstance.getTarget(), n);
                visibilityManager.setPropagation(true);
                visibilityManager.setScale(100.0);
            } else {
                if (visibilityManager.isPositionDrawn(dTDElementInstance.getTarget(), nArray[0])) {
                    this.dlist.repaint(true);
                }
                visibilityManager.setFocusPosition(dTDElementInstance.getTarget(), n);
            }
        }
    }
}

