/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.TargetAppearance;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class TargetDialog
extends JDialog {
    private static TargetDialog dialog;
    private static Logger logger;

    private TargetDialog() {
    }

    private TargetDialog(Frame frame, Vector vector) {
        super(frame, "Linear Target Appearance", true);
        Container container = this.getContentPane();
        container.add(this.createTargetDialogPanel(vector));
        this.pack();
    }

    public static void initialize(Component component, Vector vector) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        dialog = new TargetDialog(frame, vector);
    }

    public static boolean showDialog(Component component) {
        if (dialog != null) {
            dialog.setLocationRelativeTo(component);
            dialog.setVisible(true);
        } else {
            logger.warn("TargetDialog requires you to call initialize before calling showDialog.");
        }
        return true;
    }

    private static void resetAppearances(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((DTDElementInstance)vector.elementAt(i)).getTargetAppearance().reset();
        }
    }

    public JPanel createTargetDialogPanel(Vector vector) {
        JPanel jPanel = this.createDialogBox(vector);
        Border border = BorderFactory.createEmptyBorder(20, 20, 20, 20);
        jPanel.setBorder(border);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        return jPanel;
    }

    private JPanel createColPane(Vector vector, JRadioButton[] jRadioButtonArray, JTextField[] jTextFieldArray, JButton jButton, JButton jButton2, JButton jButton3) {
        int n = vector.size();
        JPanel jPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(1 + n, 6);
        gridLayout.setHgap(3);
        gridLayout.setVgap(5);
        jPanel.setLayout(gridLayout);
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel("Straight"));
        jPanel.add(new JLabel("Circular"));
        jPanel.add(new JLabel("12 O'Clock"));
        jPanel.add(new JLabel("Position"));
        for (int i = 0; i < n; ++i) {
            JLabel jLabel = new JLabel("Target " + (i + 1) + " :");
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(jLabel);
            DTDElementInstance dTDElementInstance = (DTDElementInstance)vector.elementAt(i);
            JLabel jLabel2 = new JLabel(dTDElementInstance.getLocalName());
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(jLabel2);
            jPanel.add(jRadioButtonArray[2 * i]);
            jPanel.add(jRadioButtonArray[2 * i + 1]);
            jPanel.add(jTextFieldArray[i]);
            TargetAppearance targetAppearance = dTDElementInstance.getTargetAppearance();
            jPanel.add(new JLabel("" + targetAppearance.getMinPosition() + " to " + targetAppearance.getMaxPosition()));
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel2.add(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        jPanel3.add((Component)jButton, "West");
        jPanel3.add((Component)jButton2, "West");
        jPanel3.add((Component)jButton3, "East");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel2, "North");
        jPanel4.add((Component)jPanel3, "South");
        return jPanel4;
    }

    private JPanel createDialogBox(final Vector vector) {
        final int n = vector.size();
        JRadioButton[] jRadioButtonArray = new JRadioButton[2 * n];
        final ButtonGroup[] buttonGroupArray = new ButtonGroup[n];
        final JTextField[] jTextFieldArray = new JTextField[n];
        for (int i = 0; i < n; ++i) {
            TargetAppearance targetAppearance = ((DTDElementInstance)vector.elementAt(i)).getTargetAppearance();
            String string = "" + i;
            jRadioButtonArray[2 * i] = new JRadioButton("");
            jRadioButtonArray[2 * i].setActionCommand("straight_" + string);
            jRadioButtonArray[2 * i + 1] = new JRadioButton("");
            jRadioButtonArray[2 * i + 1].setActionCommand("circular_" + string);
            buttonGroupArray[i] = new ButtonGroup();
            buttonGroupArray[i].add(jRadioButtonArray[2 * i]);
            buttonGroupArray[i].add(jRadioButtonArray[2 * i + 1]);
            jRadioButtonArray[111 == targetAppearance.getShape() ? 2 * i : 2 * i + 1].setSelected(true);
            jTextFieldArray[i] = new JTextField();
            jTextFieldArray[i].setText("" + targetAppearance.getTopPosition());
            jTextFieldArray[i].setEditable(true);
        }
        Dimension dimension = new Dimension(100, 30);
        JButton jButton = new JButton("OK");
        jButton.setPreferredSize(dimension);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < n; ++i) {
                    TargetAppearance targetAppearance = ((DTDElementInstance)vector.elementAt(i)).getTargetAppearance();
                    String string = buttonGroupArray[i].getSelection().getActionCommand();
                    if (string.equals("straight_" + i)) {
                        targetAppearance.setShape(111);
                        continue;
                    }
                    if (!string.equals("circular_" + i)) continue;
                    targetAppearance.setShape(112);
                    targetAppearance.setTopPosition(Integer.valueOf(jTextFieldArray[i].getText().trim()));
                }
                dialog.setVisible(false);
            }
        });
        JButton jButton2 = new JButton("Default");
        jButton2.setPreferredSize(dimension);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TargetDialog.resetAppearances(vector);
                dialog.setVisible(false);
            }
        });
        JButton jButton3 = new JButton("Cancel");
        jButton3.setPreferredSize(dimension);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dialog.setVisible(false);
            }
        });
        return this.createColPane(vector, jRadioButtonArray, jTextFieldArray, jButton, jButton2, jButton3);
    }

    static {
        logger = Logger.getLogger(TargetDialog.class);
    }
}

