/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class WaypointsTab
extends JPanel
implements ActionListener,
ItemListener,
MouseListener {
    public static final String WAYPOINT_CHANGE_PROPERTY = "Add/remove waypoint";
    private Vector waypoints;
    private Vector selectedWaypoints;
    private Vector listeners;
    private JComboBox opList;
    private JPanel waypointsPanel;
    private Frame mainframe;
    private TreeMap elementIDtoWaypoint;
    private BluejayDObjectList dlist;
    private Vector waypointElementIds;
    private Vector waypointNames;
    private Vector waypointWIDs;
    private VisibilityManager vizMgr;
    private JToggleButton currentButton;
    private JPanel iconPanel;
    private static Logger logger = Logger.getLogger(WaypointsTab.class);
    private static final int MAX_WAYPOINT_NAME_LENGTH = 100;
    private static final int MAX_GENE_NAME_DISPLAY_LENGTH = 47;
    private static final int VERTICAL_SPACE = 10;

    public WaypointsTab(Frame frame, BluejayDObjectList bluejayDObjectList) {
        this.mainframe = frame;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setPreferredSize(new Dimension(150, 150));
        this.waypoints = new Vector();
        this.listeners = new Vector();
        this.selectedWaypoints = new Vector();
        this.elementIDtoWaypoint = new TreeMap();
        this.waypointElementIds = new Vector();
        this.waypointsPanel = new JPanel();
        this.waypointsPanel.setLayout(new BoxLayout(this.waypointsPanel, 1));
        this.waypointsPanel.setPreferredSize(new Dimension(150, 150));
        this.testForWaypoints();
        this.dlist = bluejayDObjectList;
        this.add(this.waypointsPanel);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        String string = jLabel.getText();
        WaypointRow waypointRow = null;
        for (int i = 0; i < this.waypoints.size() && !(waypointRow = (WaypointRow)this.waypoints.elementAt(i)).getWaypointName().equals(string); ++i) {
        }
        if (waypointRow != null) {
            this.goToWaypoint(waypointRow.getTarget(), waypointRow.getPosition(), waypointRow.getElementID());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void loadElementIds(Vector vector) {
        this.waypointElementIds = vector;
    }

    public void loadNames(Vector vector) {
        this.waypointNames = vector;
    }

    public void loadIDs(Vector vector) {
        this.waypointWIDs = vector;
    }

    public String getWaypointNameFromVector(String string) {
        int n = this.waypointElementIds.indexOf(string);
        return (String)this.waypointNames.elementAt(n);
    }

    public String getWaypointNameFromWaypoint(String string) {
        WaypointRow waypointRow = (WaypointRow)this.elementIDtoWaypoint.get(string);
        return waypointRow.getWaypointName();
    }

    public boolean isDuplicateWaypointName(String string, int n) {
        boolean bl = false;
        for (int i = 0; i < this.waypoints.size(); ++i) {
            WaypointRow waypointRow = (WaypointRow)this.waypoints.elementAt(i);
            if (!waypointRow.getWaypointName().equals(string) || waypointRow.getGenomeNum() != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public int getWaypointID(String string) {
        int n = this.waypointElementIds.indexOf(string);
        if (n == -1) {
            return -1;
        }
        if (n >= this.waypointWIDs.size()) {
            return 992872;
        }
        return new Integer(this.waypointWIDs.elementAt(n).toString());
    }

    public void setVisibilityManager(VisibilityManager visibilityManager) {
        this.vizMgr = visibilityManager;
    }

    private void testForWaypoints() {
        this.waypointsPanel.removeAll();
        if (this.waypoints.size() > 0) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setMaximumSize(new Dimension(1000, 400));
            JSeparator jSeparator = new JSeparator();
            jSeparator.setMaximumSize(new Dimension(400, 1));
            jPanel.removeAll();
            jPanel.add(this.getHeader());
            jPanel.add(jSeparator);
            for (int i = 0; i < this.waypoints.size(); ++i) {
                jPanel.add((JPanel)this.waypoints.elementAt(i));
            }
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setPreferredSize(new Dimension(150, 400));
            jScrollPane.setAlignmentX(0.0f);
            this.opList = new JComboBox();
            this.opList.addActionListener(this);
            this.opList.setAlignmentX(0.0f);
            if (this.selectedWaypoints.size() == 1) {
                this.setCBOneWaypoint();
            } else if (this.selectedWaypoints.size() > 1) {
                this.setCBManyWaypoints();
            } else if (this.selectedWaypoints.size() == 0) {
                this.setCBNoWaypoints();
            }
            this.waypointsPanel.add(jScrollPane);
            this.waypointsPanel.add(Box.createRigidArea(new Dimension(0, 10)));
            this.waypointsPanel.add(this.opList);
            this.waypointsPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        } else {
            JTextArea jTextArea = new JTextArea("\nYou have no waypoints defined.\n\nTo define a waypoint, right click on a gene and select 'Create Waypoint'.");
            jTextArea.setPreferredSize(new Dimension(150, 150));
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            this.waypointsPanel.add(jTextArea);
        }
        this.waypointsPanel.revalidate();
        this.waypointsPanel.repaint();
        this.removeAll();
        this.add(this.waypointsPanel);
    }

    private void setCBNoWaypoints() {
        this.opList.removeAllItems();
        this.opList.addItem("Select waypoint(s):");
        this.opList.addItem("Select All");
    }

    private void setCBOneWaypoint() {
        this.opList.removeAllItems();
        this.opList.addItem("Select operation:");
        if (this.dlist.getComparisonPool().getPoolSize() > 1) {
            this.opList.addItem("Align at Waypoint");
        }
        this.opList.addItem("Edit Waypoint");
        this.opList.addItem("Go to Waypoint");
        this.opList.addItem("Cut at Waypoint");
        this.opList.addItem("Remove Waypoint");
        this.opList.addItem("Deselect Waypoint");
        if (this.waypoints.size() > 1) {
            this.opList.addItem("Select All");
        }
    }

    private void setCBManyWaypoints() {
        this.opList.removeAllItems();
        this.opList.addItem("Select operation:");
        this.opList.addItem("Remove Waypoints");
        if (this.selectedWaypoints.size() < this.waypoints.size()) {
            this.opList.addItem("Select All");
        }
        this.opList.addItem("Deselect All");
    }

    private JPanel getHeader() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(3, 0, 0));
        jPanel.setMaximumSize(new Dimension(400, 20));
        JLabel jLabel = new JLabel("Waypoint Name", 2);
        jLabel.setToolTipText("Waypoint Name");
        jLabel.setPreferredSize(new Dimension(100, 12));
        JLabel jLabel2 = new JLabel("Gene Name", 2);
        jLabel2.setToolTipText("Gene Name");
        jPanel.add(Box.createRigidArea(new Dimension(20, 20)));
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        return jPanel;
    }

    public void addWaypoint(String string, String string2, String string3, int n, int n2, int n3, int n4, int n5, double d, String string4, int n6) {
        this.addWaypoint(string, string2, string3, n, n2, n3, n4, n5, d, string4, n6, true);
    }

    public void addWaypoint(String string, String string2, String string3, int n, int n2, int n3, int n4, int n5, double d, String string4, int n6, boolean bl) {
        this.addWaypoint(string, string2, string3, n, n2, n3, n4, n5, d, string4, bl);
        this.setWID(string4, n6);
    }

    public synchronized void addWaypoint(String string, String string2, String string3, int n, int n2, int n3, int n4, int n5, double d, String string4) {
        this.addWaypoint(string, string2, string3, n, n2, n3, n4, n5, d, string4, true);
    }

    public synchronized void addWaypoint(String string, String string2, String string3, int n, int n2, int n3, int n4, int n5, double d, String string4, boolean bl) {
        WaypointRow waypointRow = new WaypointRow(string, string2, string3, n, n2, n3, n4, n5, d, string4);
        waypointRow.addItemListener(this);
        waypointRow.addMouseListener(this);
        this.waypoints.add(waypointRow);
        this.elementIDtoWaypoint.put(string4, waypointRow);
        if (!this.waypointElementIds.contains(string4)) {
            this.waypointElementIds.add(string4);
        }
        if (bl) {
            this.testForWaypoints();
            this.goToWaypoint(n, n4, string4);
        }
    }

    public void setWID(String string, int n) {
        WaypointRow waypointRow = (WaypointRow)this.elementIDtoWaypoint.get(string);
        waypointRow.setWID(n);
    }

    public synchronized void removeWaypoint(String string) {
        int n = JOptionPane.showConfirmDialog(null, "Do you want to remove \"" + this.getWaypointNameFromWaypoint(string) + "\"?", "Remove Waypoint", 0);
        if (n == 0) {
            this.removeWaypoint(string, true);
        }
    }

    public synchronized void removeWaypoint(String string, boolean bl) {
        WaypointRow waypointRow = (WaypointRow)this.elementIDtoWaypoint.get(string);
        int n = this.dlist.getAbstractLinearGraphics().isInTextMode() ? waypointRow.getPosition() : (int)((double)waypointRow.getPosition() / waypointRow.getLenRatio());
        this.waypointElementIds.remove(string);
        this.elementIDtoWaypoint.remove(string);
        this.waypoints.remove(waypointRow);
        this.selectedWaypoints.remove(waypointRow);
        if (bl) {
            this.testForWaypoints();
            this.vizMgr.setPropagation(false);
            this.vizMgr.setFocusPosition(waypointRow.getTarget(), n);
            this.vizMgr.setPropagation(true);
            this.dlist.repaint(true);
        }
    }

    public synchronized void removeSelectedWaypoints() {
        int n = JOptionPane.showConfirmDialog(null, "Do you want to remove the selected waypoint(s)?", "Remove Selected Waypoint(s)", 0);
        if (n == 0) {
            this.removeSelectedWaypoints(true);
        }
    }

    public synchronized void removeSelectedWaypoints(boolean bl) {
        int n = this.selectedWaypoints.size();
        for (int i = 0; i < n; ++i) {
            String string = ((WaypointRow)this.selectedWaypoints.firstElement()).getElementID();
            if (bl && i == n - 1) {
                this.removeWaypoint(string, true);
                continue;
            }
            this.removeWaypoint(string, false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox;
        String string;
        if (actionEvent.getSource() instanceof JComboBox && (string = (String)(jComboBox = (JComboBox)actionEvent.getSource()).getSelectedItem()) != null) {
            if (this.selectedWaypoints.size() == 1) {
                WaypointRow waypointRow = (WaypointRow)this.selectedWaypoints.elementAt(0);
                if (string.equals("Remove Waypoint")) {
                    this.removeWaypoint(waypointRow.getElementID());
                } else if (string.equals("Align at Waypoint")) {
                    this.alignWaypoint(waypointRow.getTarget(), waypointRow.getElementID());
                } else if (string.equals("Edit Waypoint")) {
                    this.editWaypoint(waypointRow.getElementID());
                } else if (string.equals("Go to Waypoint")) {
                    this.goToWaypoint(waypointRow.getTarget(), waypointRow.getPosition(), waypointRow.getElementID());
                } else if (string.equals("Cut at Waypoint")) {
                    this.cutAtWaypoint(waypointRow.getPosition(), waypointRow.getElementID());
                } else if (string.equals("Deselect Waypoint")) {
                    this.selectWaypoint(waypointRow.getElementID());
                }
            } else if (this.selectedWaypoints.size() > 1) {
                if (string.equals("Deselect All")) {
                    this.selectAllWaypoints(false);
                } else if (string.equals("Remove Waypoints")) {
                    this.removeSelectedWaypoints();
                }
            }
            if (string.equals("Select All")) {
                this.selectAllWaypoints(true);
            }
        }
        if (actionEvent.getSource() instanceof JToggleButton) {
            this.currentButton = (JToggleButton)actionEvent.getSource();
        }
    }

    public JPanel getIconPanel(ActionListener actionListener, String string) {
        String[] stringArray = new String[]{"images/waypointIcons/bindingsite.png", "images/waypointIcons/bindingsite2.png", "images/waypointIcons/deletionmutation.png", "images/waypointIcons/deletionmutation2.png", "images/waypointIcons/exon.png", "images/waypointIcons/framemutation.png", "images/waypointIcons/gene.png", "images/waypointIcons/insertionmutation.png", "images/waypointIcons/insertionmutation2.png", "images/waypointIcons/intron.png", "images/waypointIcons/inversionmutation.png", "images/waypointIcons/inversionmutation2.png", "images/waypointIcons/missensemutation.png", "images/waypointIcons/missensemutation2.png", "images/waypointIcons/nonsensemutation.png", "images/waypointIcons/nonsensemutation2.png", "images/waypointIcons/pointmutation.png", "images/waypointIcons/pointmutation2.png", "images/waypointIcons/promoter.png", "images/waypointIcons/terminator.png", "images/waypointIcons/transposable.png", "images/waypointIcons/usercomment.png"};
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 5));
        JToggleButton jToggleButton = new JToggleButton(new ImageIcon());
        jToggleButton.setPreferredSize(new Dimension(20, 20));
        jToggleButton.addActionListener(actionListener);
        if (string == null || string.equals("")) {
            jToggleButton.doClick();
        }
        buttonGroup.add(jToggleButton);
        jPanel.add(jToggleButton);
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (int i = 0; i < stringArray.length; ++i) {
            ImageIcon imageIcon = new ImageIcon(classLoader.getResource(stringArray[i]));
            imageIcon.setDescription(stringArray[i]);
            jToggleButton = new JToggleButton(imageIcon);
            jToggleButton.setPreferredSize(new Dimension(20, 20));
            jToggleButton.addActionListener(actionListener);
            if (imageIcon.getDescription().equals(string)) {
                jToggleButton.doClick();
            }
            buttonGroup.add(jToggleButton);
            jPanel.add(jToggleButton);
        }
        return jPanel;
    }

    public void alignWaypoint(int n, String string) {
        WaypointRow waypointRow = (WaypointRow)this.elementIDtoWaypoint.get(string);
        String string2 = waypointRow.getWaypointName();
        int n2 = waypointRow.getGenomeNum();
        boolean bl = false;
        boolean bl2 = false;
        Vector<Genome> vector = this.dlist.getComparisonPool().getSeqsFromPool();
        for (int i = 0; i < this.waypoints.size(); ++i) {
            Genome genome;
            WaypointRow waypointRow2 = (WaypointRow)this.waypoints.elementAt(i);
            if (!waypointRow2.getWaypointName().equals(string2) || waypointRow2.getGenomeNum() == n2) continue;
            double d = 0.0;
            if (!bl) {
                bl = true;
                genome = vector.elementAt(waypointRow.getGenomeNum());
                d = 360.0 * (double)waypointRow.getPosition() / (double)genome.getGenomeLen();
                if (genome.getStartAngle() != 270.0) {
                    bl2 = true;
                    genome.resetStartAngle();
                }
            }
            genome = vector.elementAt(waypointRow2.getGenomeNum());
            double d2 = 360.0 * (double)waypointRow2.getPosition() / (double)genome.getGenomeLen();
            double d3 = d > d2 ? d - d2 : (d < d2 ? 360.0 - d2 + d : 0.0);
            if (genome.getStartAngle() == (270.0 + d3) % 360.0) continue;
            bl2 = true;
            genome.setStartAngle(d3);
        }
        if (bl && bl2) {
            this.dlist.repaint(true);
        }
    }

    public void cutAtWaypoint(int n, String string) {
        int n2 = this.dlist.getAbstractLinearGraphics().isInTextMode() ? n : (int)((double)n / ((WaypointRow)this.elementIDtoWaypoint.get(string)).getLenRatio());
        this.dlist.shift(n2);
    }

    public void goToWaypoint(int n, String string) {
        this.goToWaypoint(n, ((WaypointRow)this.elementIDtoWaypoint.get(string)).getPosition(), string);
    }

    public void goToWaypoint(int n, int n2, String string) {
        int n3 = this.dlist.getAbstractLinearGraphics().isInTextMode() ? n2 : (int)((double)n2 / ((WaypointRow)this.elementIDtoWaypoint.get(string)).getLenRatio());
        this.vizMgr.setPropagation(false);
        this.vizMgr.setFocusPosition(n, n3);
        this.vizMgr.setPropagation(true);
        this.dlist.repaint(true);
    }

    public void editWaypoint(String string) {
        WaypointRow waypointRow = (WaypointRow)this.elementIDtoWaypoint.get(string);
        waypointRow.editWaypoint(this.getIconPanel(this, this.getDescription(string)), string);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof WaypointRow) {
            WaypointRow waypointRow = (WaypointRow)itemEvent.getSource();
            if (itemEvent.getStateChange() == 1) {
                this.selectedWaypoints.add(waypointRow);
                if (this.selectedWaypoints.size() == 1) {
                    this.setCBOneWaypoint();
                } else if (this.selectedWaypoints.size() > 1) {
                    this.setCBManyWaypoints();
                } else {
                    System.err.println("WaypointsTab.itemStateChanged.changed to SELECTED:selected #waypoints was < 1");
                }
            } else {
                this.selectedWaypoints.remove(waypointRow);
                if (this.selectedWaypoints.size() == 1) {
                    this.setCBOneWaypoint();
                } else if (this.selectedWaypoints.size() > 1) {
                    this.setCBManyWaypoints();
                } else if (this.selectedWaypoints.size() == 0) {
                    this.setCBNoWaypoints();
                }
            }
        }
    }

    public int getNumWaypoints() {
        return this.waypoints.size();
    }

    public void resetWaypoints() {
        this.waypoints = new Vector();
        this.selectedWaypoints = new Vector();
        this.elementIDtoWaypoint = new TreeMap();
        this.waypointElementIds = new Vector();
        this.testForWaypoints();
    }

    public TreeMap getElementIDtoWaypoint() {
        return (TreeMap)this.elementIDtoWaypoint.clone();
    }

    public Vector getWaypointElementIds() {
        return (Vector)this.waypointElementIds.clone();
    }

    public void selectWaypoint(String string) {
        WaypointRow waypointRow = (WaypointRow)this.elementIDtoWaypoint.get(string);
        waypointRow.select();
    }

    public boolean isSelectedWaypoint(String string) {
        boolean bl = false;
        for (int i = 0; i < this.selectedWaypoints.size(); ++i) {
            WaypointRow waypointRow = (WaypointRow)this.selectedWaypoints.elementAt(i);
            if (!waypointRow.getElementID().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void selectAllWaypoints(boolean bl) {
        for (int i = 0; i < this.waypoints.size(); ++i) {
            WaypointRow waypointRow = (WaypointRow)this.waypoints.elementAt(i);
            if (bl) {
                if (this.isSelectedWaypoint(waypointRow.getElementID())) continue;
                waypointRow.select();
                continue;
            }
            if (!this.isSelectedWaypoint(waypointRow.getElementID())) continue;
            waypointRow.select();
        }
    }

    public Image getImage(String string) {
        WaypointRow waypointRow = (WaypointRow)this.elementIDtoWaypoint.get(string);
        return waypointRow.getImage();
    }

    public String getDescription(String string) {
        WaypointRow waypointRow = (WaypointRow)this.elementIDtoWaypoint.get(string);
        return waypointRow.getDescription();
    }

    public int getPosition(String string) {
        WaypointRow waypointRow = (WaypointRow)this.elementIDtoWaypoint.get(string);
        return waypointRow.getPosition();
    }

    public double getLenRatio(String string) {
        WaypointRow waypointRow = (WaypointRow)this.elementIDtoWaypoint.get(string);
        return waypointRow.getLenRatio();
    }

    public int getStartPosition(String string) {
        WaypointRow waypointRow = (WaypointRow)this.elementIDtoWaypoint.get(string);
        return waypointRow.getStartPosition();
    }

    public int getEndPosition(String string) {
        WaypointRow waypointRow = (WaypointRow)this.elementIDtoWaypoint.get(string);
        return waypointRow.getEndPosition();
    }

    public void setImage(String string, Image image) {
        WaypointRow waypointRow = (WaypointRow)this.elementIDtoWaypoint.get(string);
        waypointRow.setImage(image);
    }

    public void setDescription(String string, String string2) {
        WaypointRow waypointRow = (WaypointRow)this.elementIDtoWaypoint.get(string);
        waypointRow.setDescription(string2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
    }

    public boolean existsWaypoint(String string) {
        return this.elementIDtoWaypoint.containsKey(string);
    }

    private class WaypointRow
    extends JPanel
    implements ItemListener,
    ItemSelectable,
    MouseListener {
        private JLabel label;
        private JCheckBox check;
        private JLabel gene;
        private Vector check_listeners;
        private Vector mouse_listeners;
        private String xptr;
        private int target;
        private int start;
        private int end;
        private int position;
        private double lenRatio;
        private int genomeNum;
        private String elementID;
        private int wID;
        private Image image;
        private String desc;
        private JPanel iconPanel;

        public WaypointRow(String string, String string2, String string3, int n, int n2, int n3, int n4, int n5, double d, String string4) {
            if (this.check_listeners == null) {
                this.check_listeners = new Vector(1);
            }
            if (this.mouse_listeners == null) {
                this.mouse_listeners = new Vector(1);
            }
            this.xptr = string3;
            this.target = n;
            this.start = n2;
            this.end = n3;
            this.position = n4;
            this.genomeNum = n5;
            this.lenRatio = d;
            this.elementID = string4;
            this.setLayout(new FlowLayout(3, 0, 0));
            this.check = new JCheckBox("", false);
            this.check.setMargin(new Insets(3, 3, 3, 3));
            JLabel jLabel = null;
            if (this.image != null) {
                ImageIcon imageIcon = new ImageIcon(this.image);
                jLabel = new JLabel(imageIcon);
            } else {
                jLabel = new JLabel("");
                jLabel.setPreferredSize(new Dimension(16, 16));
            }
            this.label = new JLabel(string, 2);
            this.label.setToolTipText(string);
            this.label.setPreferredSize(new Dimension(100, 12));
            this.gene = new JLabel(string2, 2);
            this.gene.setToolTipText(string2);
            this.gene.setPreferredSize(new Dimension(300, 12));
            this.add(this.check);
            this.add(jLabel);
            this.add(this.label);
            this.add(this.gene);
        }

        public void addMouseListener(MouseListener mouseListener) {
            this.label.addMouseListener(mouseListener);
            this.mouse_listeners.add(mouseListener);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                for (int i = 0; i < this.mouse_listeners.size(); ++i) {
                    ((MouseListener)this.mouse_listeners.elementAt(i)).mouseClicked(mouseEvent);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void setWID(int n) {
            this.wID = n;
        }

        public int getWID() {
            return this.wID;
        }

        public int getTarget() {
            return this.target;
        }

        public int getStartPosition() {
            return this.start;
        }

        public void setStartPosition(int n) {
            this.start = n;
        }

        public int getEndPosition() {
            return this.end;
        }

        public void setEndPosition(int n) {
            this.end = n;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int n) {
            this.position = n;
        }

        public int getGenomeNum() {
            return this.genomeNum;
        }

        public void setGenomeNum(int n) {
            this.genomeNum = n;
        }

        public double getLenRatio() {
            return this.lenRatio;
        }

        public void setLenRatio(double d) {
            this.lenRatio = d;
        }

        public String getWaypointName() {
            return this.label.getText();
        }

        public String getXptr() {
            return this.xptr;
        }

        public String getElementID() {
            return this.elementID;
        }

        public void setWaypointName(String string) {
            this.label.setText(string);
        }

        public String getGeneName() {
            return this.gene.getText();
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public void setDescription(String string) {
            this.desc = string;
        }

        public String getDescription() {
            return this.desc;
        }

        public void addItemListener(ItemListener itemListener) {
            if (this.check_listeners.size() == 0) {
                this.check.addItemListener(this);
            }
            this.check_listeners.add(itemListener);
        }

        public void removeItemListener(ItemListener itemListener) {
            this.check_listeners.removeElement(itemListener);
            if (this.check_listeners.size() == 0) {
                this.check.removeItemListener(this);
            }
        }

        public Object[] getSelectedObjects() {
            if (this.check.isSelected()) {
                Object[] objectArray = new Object[]{this.check};
                return objectArray;
            }
            return new Object[0];
        }

        public void select() {
            this.check.doClick();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() instanceof JCheckBox) {
                for (int i = 0; i < this.check_listeners.size(); ++i) {
                    ((ItemListener)this.check_listeners.elementAt(i)).itemStateChanged(new ItemEvent(this, itemEvent.getID(), itemEvent.getItem(), itemEvent.getStateChange()));
                }
            } else {
                System.err.println("WaypointsTab.WaypointRow: weird instance in itemStateChanged");
            }
        }

        public void editWaypoint(JPanel jPanel, String string) {
            int n;
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            JLabel jLabel = new JLabel("Waypoint Name:");
            jLabel.setAlignmentX(0.0f);
            JTextField jTextField = new JTextField(this.getWaypointName());
            jTextField.setAlignmentX(0.0f);
            jPanel2.add(jLabel);
            jPanel2.add(jTextField);
            jPanel2.add(Box.createVerticalStrut(10));
            JLabel jLabel2 = new JLabel("Gene Name:");
            jLabel2.setAlignmentX(0.0f);
            String string2 = this.getGeneName();
            JTextField jTextField2 = string2.length() > 47 ? new JTextField(string2.substring(0, 47).concat("...")) : new JTextField(string2);
            jTextField2.setToolTipText(string2);
            jTextField2.setEditable(false);
            jTextField2.setAlignmentX(0.0f);
            jPanel2.add(jLabel2);
            jPanel2.add(jTextField2);
            jPanel2.add(Box.createVerticalStrut(10));
            JLabel jLabel3 = new JLabel("Gene Position:");
            jLabel3.setAlignmentX(0.0f);
            JTextField jTextField3 = new JTextField("start = " + this.getStartPosition() + ", end = " + this.getEndPosition());
            jTextField3.setAlignmentX(0.0f);
            jTextField3.setEditable(false);
            jPanel2.add(jLabel3);
            jPanel2.add(jTextField3);
            jPanel2.add(Box.createVerticalStrut(10));
            JLabel jLabel4 = new JLabel("Waypoint Position:");
            jLabel4.setAlignmentX(0.0f);
            JTextField jTextField4 = null;
            jTextField4 = new JTextField(Integer.toString(this.getPosition()));
            jTextField4.setAlignmentX(0.0f);
            jPanel2.add(jLabel4);
            jPanel2.add(jTextField4);
            jPanel2.add(Box.createVerticalStrut(10));
            JLabel jLabel5 = new JLabel("Waypoint Icon:");
            jLabel5.setAlignmentX(0.0f);
            jPanel.setAlignmentX(0.0f);
            jPanel2.add(jLabel5);
            jPanel2.add(jPanel);
            jPanel2.add(Box.createVerticalStrut(10));
            JLabel jLabel6 = new JLabel("");
            jLabel6.setAlignmentX(0.0f);
            jLabel6.setForeground(Color.RED);
            jPanel2.add(jLabel6);
            while ((n = JOptionPane.showOptionDialog(WaypointsTab.this.mainframe, jPanel2, "Edit Waypoint", 2, -1, null, new String[]{"Okay", "Cancel"}, "Okay")) == 0) {
                if (jTextField.getText().length() < 100) {
                    int n2;
                    this.setWaypointName(jTextField.getText());
                    try {
                        n2 = Integer.parseInt(jTextField4.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        jLabel6.setText("Waypoint position must be an integer.");
                        continue;
                    }
                    if (n2 < this.getStartPosition() || n2 > this.getEndPosition()) {
                        jLabel6.setText("Waypoint position must be within the gene.");
                        continue;
                    }
                    this.setPosition(n2);
                    if (WaypointsTab.this.currentButton != null) {
                        ImageIcon imageIcon = (ImageIcon)WaypointsTab.this.currentButton.getIcon();
                        this.setImage(imageIcon.getImage());
                        this.setDescription(imageIcon.getDescription());
                    }
                    WaypointsTab.this.goToWaypoint(this.target, this.position, string);
                    break;
                }
                jLabel6.setText("Waypoint name must be less than 100 characters.");
            }
        }
    }
}

