/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.comparison;

import ca.ucalgary.bluejay.gui.comparison.Genome;
import java.awt.Color;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonPool {
    private Vector<Genome> seq_pool = new Vector();
    private Color[] colorPool;
    private int targetNum;

    public ComparisonPool() {
        this.initColorPool();
        this.setTargetNum(-1);
    }

    public void addSeqToPool(Genome genome) {
        this.seq_pool.add(genome);
    }

    public void removeSeqFromPool(int n) {
        this.seq_pool.remove(n);
    }

    public void removeSeqFromPool(Genome genome) {
        this.seq_pool.remove(genome);
    }

    public Vector<Genome> getSeqsFromPool() {
        return this.seq_pool;
    }

    public int getPoolSize() {
        return this.seq_pool.size();
    }

    public boolean isPoolEmpty() {
        return this.seq_pool.isEmpty();
    }

    public void emptyPool() {
        this.seq_pool.removeAllElements();
    }

    public Color[] getColorPool() {
        return this.colorPool;
    }

    public void setTargetNum(int n) {
        this.targetNum = n;
    }

    public int getTargetNum() {
        return this.targetNum;
    }

    public void initColorPool() {
        this.colorPool = new Color[]{Color.orange, Color.cyan, Color.magenta, Color.pink, Color.blue, Color.green, Color.gray, Color.yellow};
    }

    public void updateGenomeColor() {
        int n = this.seq_pool.size();
        int n2 = this.colorPool.length;
        this.seq_pool.firstElement().setGenomeColor(Color.red);
        for (int i = 1; i < n; ++i) {
            Genome genome = this.seq_pool.elementAt(i);
            int n3 = genome.getGenomeNum();
            genome.setGenomeColor(this.colorPool[(n3 - 1) % n2]);
        }
    }

    public int getMasterLen() {
        int n = -1;
        for (int i = 0; i < this.seq_pool.size(); ++i) {
            if (this.seq_pool.elementAt(i).getGenomeNum() != 0) continue;
            n = this.seq_pool.elementAt(i).getGenomeLen();
        }
        if (n < 0) {
            System.err.printf("ComparisonPool.getMasterLen(): master genome not found\n", new Object[0]);
        }
        return n;
    }
}

