/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.comparison;

import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.comparison.ComparisonPool;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JPanel;

public class GenomeLabelPainter
extends JPanel {
    private Insets insets;
    private BluejayDObjectList bjDlist;
    private FontMetrics fm;
    private int text_height;
    private int text_width;
    private int gap = 4;

    public GenomeLabelPainter(BluejayDObjectList bluejayDObjectList) {
        this.setDList(bluejayDObjectList);
        this.insets = this.getInsets();
        this.adjustPreferredSize();
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        this.bjDlist = bluejayDObjectList;
    }

    public void paint(Graphics graphics) {
        graphics.setFont(this.getFont());
        this.fm = this.getFontMetrics(this.getFont());
        this.text_height = this.fm.getHeight();
        int n = this.fm.getHeight() / 2;
        this.text_width = this.fm.stringWidth("(m)  ");
        ComparisonPool comparisonPool = this.bjDlist.getComparisonPool();
        Vector<Genome> vector = comparisonPool.getSeqsFromPool();
        int n2 = comparisonPool.getPoolSize();
        for (int i = 0; i < n2; ++i) {
            Genome genome = vector.elementAt(i);
            String string = "  " + genome.getGenomeName();
            Color color = genome.getGenomeColor();
            String string2 = null;
            string2 = i == 0 ? "(m) " : "(s" + i + ") ";
            graphics.setColor(Color.black);
            graphics.drawString(string2, 0, (n2 - i - 1) * (n + this.gap));
            graphics.setColor(color);
            if (genome.isCompleteSequence()) {
                graphics.fillOval(this.text_width, (n2 - i - 1) * (n + this.gap) - n, n, n);
            } else {
                graphics.drawOval(this.text_width, (n2 - i - 1) * (n + this.gap) - n, n, n);
            }
            graphics.setColor(Color.black);
            graphics.drawString(string, this.text_width + n, (n2 - i - 1) * (n + this.gap));
        }
    }

    protected void adjustPreferredSize() {
    }
}

