/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.menu;

import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.menu.ListTransferHandler;
import ca.ucalgary.bluejay.gui.painter.BasicSequencePainter;
import ca.ucalgary.bluejay.gui.util.REBASEParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CleavagePanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    private JList list;
    private DefaultListModel listModel = null;
    private static final int INIT_LIST_SIZE = 15;
    private static final String okString = "OK";
    private static final String cancelString = "Cancel";
    private static final String commonString = "Common";
    private static final String commercialString = "Commercially available";
    private static final String allString = "All";
    private static final String clearString = "Clear";
    private JButton cancelButton;
    private JTextField copiedLaneName;
    private static JFrame frame;
    private static BluejayDObjectList dlist;

    public CleavagePanel(BluejayDObjectList bluejayDObjectList) {
        super(new BorderLayout());
        dlist = bluejayDObjectList;
    }

    private void init() {
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(2);
        this.populateEnzymeList(this.list, this.listModel, 1705);
        int n = this.listModel.getSize() < 15 ? this.listModel.getSize() : 15;
        this.list.addListSelectionListener(this);
        this.list.setVisibleRowCount(n);
        this.list.setDragEnabled(true);
        this.list.setTransferHandler(new ListTransferHandler());
        JScrollPane jScrollPane = new JScrollPane(this.list);
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(commonString);
        jRadioButton.setSelected(true);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        JRadioButton jRadioButton2 = new JRadioButton(commercialString);
        jRadioButton2.addActionListener(this);
        buttonGroup.add(jRadioButton2);
        JRadioButton jRadioButton3 = new JRadioButton(allString);
        jRadioButton3.addActionListener(this);
        buttonGroup.add(jRadioButton3);
        JButton jButton = new JButton(clearString);
        jButton.setActionCommand(clearString);
        jButton.addActionListener(this);
        jButton.setEnabled(true);
        JButton jButton2 = new JButton(okString);
        OKListener oKListener = new OKListener(jButton2);
        jButton2.setActionCommand(okString);
        jButton2.addActionListener(oKListener);
        jButton2.setEnabled(true);
        this.cancelButton = new JButton(cancelString);
        this.cancelButton.setActionCommand(cancelString);
        this.cancelButton.addActionListener(new CancelListener());
        Dimension dimension = new Dimension(120, 30);
        jButton2.setPreferredSize(dimension);
        this.cancelButton.setPreferredSize(dimension);
        this.copiedLaneName = new JTextField(10);
        this.copiedLaneName.addActionListener(oKListener);
        this.copiedLaneName.getDocument().addDocumentListener(oKListener);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(jRadioButton);
        jPanel.add(jRadioButton2);
        jPanel.add(jRadioButton3);
        jPanel.add(Box.createHorizontalStrut(n));
        jPanel.add(jButton2);
        jPanel.add(jButton);
        jPanel.add(this.cancelButton);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "Last");
    }

    private void populateEnzymeList(JList jList, DefaultListModel defaultListModel, int n) {
        defaultListModel.clear();
        String[] stringArray = BasicSequencePainter.getRestrictionEnzymes(n);
        String[] stringArray2 = BasicSequencePainter.getShownRestrictionEnzymes();
        int[] nArray = new int[stringArray2.length];
        Hashtable hashtable = null;
        try {
            hashtable = REBASEParser.getEnzymes();
        }
        catch (Exception exception) {
            System.err.println("While trying to populate restriction enzyme list (class CleavagePanel)");
            exception.printStackTrace();
            return;
        }
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            defaultListModel.addElement(stringArray[i] + "     [" + hashtable.get(stringArray[i]) + "]");
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray2[j].equals(stringArray[i])) continue;
                nArray[n2++] = i;
            }
        }
        jList.setSelectedIndices(nArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (this.listModel == null) {
            this.init();
        }
        if (string.equals(commonString)) {
            this.populateEnzymeList(this.list, this.listModel, 1705);
        } else if (string.equals(commercialString)) {
            this.populateEnzymeList(this.list, this.listModel, 46487);
        } else if (string.equals(allString)) {
            this.populateEnzymeList(this.list, this.listModel, 278);
        } else if (string.equals(clearString)) {
            this.list.clearSelection();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.cancelButton.setEnabled(false);
            } else {
                this.cancelButton.setEnabled(true);
            }
        }
    }

    public static void createAndShowGUI(BluejayDObjectList bluejayDObjectList) {
        frame = new JFrame("Restriction Enzymes");
        CleavagePanel cleavagePanel = new CleavagePanel(bluejayDObjectList);
        cleavagePanel.init();
        cleavagePanel.setOpaque(true);
        frame.setContentPane(cleavagePanel);
        frame.pack();
        frame.setVisible(true);
    }

    class OKListener
    implements ActionListener,
    DocumentListener {
        private boolean alreadyEnabled = false;
        private JButton button;

        public OKListener(JButton jButton) {
            this.button = jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = BasicSequencePainter.getShownRestrictionEnzymes();
            boolean bl = true;
            Object[] objectArray = CleavagePanel.this.list.getSelectedValues();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                string = string.substring(0, string.indexOf(" "));
                vector.add(string);
            }
            dlist.repaint(bl);
            BasicSequencePainter.setShownRestrictionEnzymes(vector);
            frame.setVisible(false);
        }

        protected boolean alreadyInList(String string) {
            return CleavagePanel.this.listModel.contains(string);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.enableButton();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.handleEmptyTextField(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (!this.handleEmptyTextField(documentEvent)) {
                this.enableButton();
            }
        }

        private void enableButton() {
            if (!this.alreadyEnabled) {
                this.button.setEnabled(true);
            }
        }

        private boolean handleEmptyTextField(DocumentEvent documentEvent) {
            if (documentEvent.getDocument().getLength() <= 0) {
                this.button.setEnabled(false);
                this.alreadyEnabled = false;
                return true;
            }
            return false;
        }
    }

    class CancelListener
    implements ActionListener {
        CancelListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            frame.setVisible(false);
        }
    }
}

