/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.menu;

import ca.ucalgary.bluejay.client.URLLoader;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.menu.BluejayMenuManager;
import ca.ucalgary.bluejay.gui.menu.BookmarksMenuManager;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.menu.ViewMenuManager;
import ca.ucalgary.bluejay.gui.microarray.CustomClusterGenerator;
import ca.ucalgary.bluejay.gui.microarray.MicroArrayHTMLWriter;
import ca.ucalgary.bluejay.gui.microarray.MicroArrayOpenProjectGUI;
import ca.ucalgary.bluejay.gui.microarray.MicroArrayRatioGUI;
import ca.ucalgary.bluejay.session.SessionManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.tigr.microarray.mev.MultipleArrayViewer;

public class MicroArrayMenuManager
implements BluejayMenuManager,
ActionListener {
    private static SessionManager sessionManager;
    private static BookmarksMenuManager bookmarksManager;
    private static ComparisonMenuManager comparisonManager;
    private static ViewMenuManager viewManager;
    private static MultipleArrayViewer arrayViewer;
    private static BluejayDObjectList dlist;
    private static URLLoader urlLoader;
    private static JTabbedPane tabbedPane;
    private JMenuItem unloadData;
    private JMenuItem createCustomCluster;
    private JMenuItem saveRatio;
    private JMenuItem saveRatio2;
    private JMenuItem loadData;
    private static JMenu adjustDataMenu;
    private static JMenu normalizeMenu;
    private static JMenu distanceMenu;
    private static JMenu displayMenu;
    private static JMenu sortMenu;
    private static JMenu m;
    private static final Icon NO_ICON;
    private static final String NO_TOOL_TIP;

    public JMenu createMenu() {
        m = new JMenu("Microarray");
        m.setMnemonic(77);
        JMenuItem jMenuItem = new JMenuItem("Open Project");
        jMenuItem.setMnemonic(79);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control M"));
        jMenuItem.setActionCommand("Open_Project");
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(true);
        m.add(jMenuItem);
        m.add(arrayViewer.getMenuBar().getJMenuItem("File", "command-load"));
        ImageIcon imageIcon = new ImageIcon("images/addfromfilereverse.gif");
        this.unloadData = new JMenuItem("Unload All Data", imageIcon);
        this.unloadData.setMnemonic(85);
        this.unloadData.setActionCommand("Unload_Data");
        this.unloadData.addActionListener(this);
        this.unloadData.setEnabled(false);
        m.add(this.unloadData);
        m.addSeparator();
        adjustDataMenu = arrayViewer.getMenuBar().getJMenu("Adjust Data");
        adjustDataMenu.setEnabled(false);
        m.add(adjustDataMenu);
        normalizeMenu = arrayViewer.getMenuBar().getJMenu("Normalization");
        normalizeMenu.setEnabled(false);
        m.add(normalizeMenu);
        distanceMenu = arrayViewer.getMenuBar().getJMenu("Distance");
        distanceMenu.setEnabled(false);
        m.add(distanceMenu);
        arrayViewer.getMenuBar().getJMenuItem("Display", "display-green-red-cmd").setEnabled(false);
        displayMenu = arrayViewer.getMenuBar().getJMenu("Display");
        displayMenu.setEnabled(false);
        m.add(displayMenu);
        sortMenu = arrayViewer.getMenuBar().getJMenu("Sort");
        sortMenu.setEnabled(false);
        m.add(sortMenu);
        JMenu jMenu = arrayViewer.getMenuBar().getJMenu("Analysis");
        jMenu.setEnabled(false);
        m.add(jMenu);
        m.addSeparator();
        this.createCustomCluster = new JMenuItem("Generate Custom Cluster");
        this.createCustomCluster.setMnemonic(67);
        this.createCustomCluster.setEnabled(false);
        this.createCustomCluster.setActionCommand("Custom_Cluster");
        this.createCustomCluster.addActionListener(this);
        m.add(this.createCustomCluster);
        this.saveRatio = new JMenuItem("Expression Ratio List");
        this.saveRatio.setMnemonic(82);
        this.saveRatio.setEnabled(false);
        this.saveRatio.setActionCommand("Expression Ratio List");
        this.saveRatio.addActionListener(this);
        m.add(this.saveRatio);
        return m;
    }

    public void enableAll() {
        for (int i = 1; i < m.getItemCount(); ++i) {
            if (!(m.getItem(i) instanceof JMenuItem)) continue;
            m.getItem(i).setEnabled(true);
        }
        adjustDataMenu.setEnabled(false);
        normalizeMenu.setEnabled(false);
        displayMenu.setEnabled(false);
        sortMenu.setEnabled(false);
    }

    public void disableAll() {
        adjustDataMenu.setEnabled(false);
        for (int i = 2; i < m.getItemCount(); ++i) {
            if (!(m.getItem(i) instanceof JMenuItem)) continue;
            m.getItem(i).setEnabled(false);
        }
    }

    public void setMultipleArrayViewer(MultipleArrayViewer multipleArrayViewer) {
        arrayViewer = multipleArrayViewer;
    }

    public void setTabbedPane(JTabbedPane jTabbedPane) {
        tabbedPane = jTabbedPane;
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        dlist = bluejayDObjectList;
    }

    public void setURLLoader(URLLoader uRLLoader) {
        urlLoader = uRLLoader;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Unload_Data")) {
            arrayViewer.unloadAllData();
            this.disableAll();
            dlist.setIsMicro(false);
            dlist.repaint(true);
        } else if (actionEvent.getActionCommand().equals("Open_Project")) {
            MicroArrayOpenProjectGUI microArrayOpenProjectGUI = new MicroArrayOpenProjectGUI(bookmarksManager);
            microArrayOpenProjectGUI.setDList(dlist);
            microArrayOpenProjectGUI.setURLLoader(urlLoader);
            microArrayOpenProjectGUI.setSessionManager(sessionManager);
            microArrayOpenProjectGUI.setComparisonManager(comparisonManager);
            microArrayOpenProjectGUI.setViewManager(viewManager);
            dlist.setIsMicro(true);
        } else if (actionEvent.getActionCommand().equals("Custom_Cluster")) {
            CustomClusterGenerator customClusterGenerator = new CustomClusterGenerator(dlist, arrayViewer);
            customClusterGenerator.setVisible(true);
        } else if (actionEvent.getActionCommand().equals("Expression Ratio List")) {
            MicroArrayHTMLWriter microArrayHTMLWriter = new MicroArrayHTMLWriter();
            MicroArrayRatioGUI microArrayRatioGUI = new MicroArrayRatioGUI(microArrayHTMLWriter, dlist);
            microArrayHTMLWriter.setDList(dlist);
            URI uRI = microArrayHTMLWriter.createHTMLFile();
            if (uRI != null) {
                microArrayRatioGUI.displayPage(uRI);
                microArrayRatioGUI.setVisible(true);
            }
        }
    }

    public void setSessionManager(SessionManager sessionManager) {
        MicroArrayMenuManager.sessionManager = sessionManager;
    }

    public JMenuItem getSaveRatioItem() {
        return this.saveRatio;
    }

    public void setBookmarkMenuManager(BookmarksMenuManager bookmarksMenuManager) {
        bookmarksManager = bookmarksMenuManager;
    }

    public void setComparisonManager(ComparisonMenuManager comparisonMenuManager) {
        comparisonManager = comparisonMenuManager;
    }

    public void setViewManager(ViewMenuManager viewMenuManager) {
        viewManager = viewMenuManager;
    }

    static {
        NO_ICON = null;
        NO_TOOL_TIP = null;
    }
}

