/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.microarray.player;

import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.microarray.MicroarrayFunctions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.batik.gvt.GraphicsNode;

public class PlayerGUI
extends JPanel
implements ActionListener,
MouseListener,
ChangeListener {
    private static final int BUTTON_WIDTH = 40;
    private static final int BUTTON_HEIGHT = 30;
    private static final int FRAME_DELAY = 2000;
    private static Timer sliderTimer;
    private static JSlider slider;
    private static JButton backButton;
    private static JButton forwardButton;
    private static JButton fastBackButton;
    private static JButton fastForwardButton;
    private static BluejayDObjectList dlist;
    private static AbstractLinearGraphics alg;
    private static MicroarrayFunctions microArrayFunctions;

    public PlayerGUI() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (slider.getValue() != slider.getMaximum()) {
                    PlayerGUI.this.refreshScreen(slider.getValue());
                    slider.setValue(slider.getValue() + 1);
                } else {
                    sliderTimer.stop();
                }
            }
        };
        sliderTimer = new Timer(2000, abstractAction);
        this.setPreferredSize(new Dimension(200, 150));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        ClassLoader classLoader = this.getClass().getClassLoader();
        ImageIcon imageIcon = new ImageIcon(classLoader.getResource("images/play.gif"));
        ImageIcon imageIcon2 = new ImageIcon(classLoader.getResource("images/stop.gif"));
        ImageIcon imageIcon3 = new ImageIcon(classLoader.getResource("images/pause.gif"));
        ImageIcon imageIcon4 = new ImageIcon(classLoader.getResource("images/forward.gif"));
        ImageIcon imageIcon5 = new ImageIcon(classLoader.getResource("images/back.gif"));
        ImageIcon imageIcon6 = new ImageIcon(classLoader.getResource("images/fastback.gif"));
        ImageIcon imageIcon7 = new ImageIcon(classLoader.getResource("images/fastforward.gif"));
        slider = new JSlider(1, 10);
        slider.setValue(0);
        slider.setMajorTickSpacing(1);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.setSnapToTicks(true);
        slider.addChangeListener(this);
        slider.addMouseListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        this.add((Component)slider, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints.gridy = 1;
        jPanel.setPreferredSize(new Dimension(210, 20));
        jPanel.setMinimumSize(new Dimension(210, 20));
        this.add((Component)jPanel, gridBagConstraints);
        fastBackButton = new JButton("", imageIcon6);
        fastBackButton.setPreferredSize(new Dimension(40, 30));
        fastBackButton.setMinimumSize(new Dimension(40, 30));
        fastBackButton.setActionCommand("Fast_Back_Button");
        fastBackButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)fastBackButton, gridBagConstraints);
        backButton = new JButton("", imageIcon5);
        backButton.setPreferredSize(new Dimension(40, 30));
        backButton.setMinimumSize(new Dimension(40, 30));
        backButton.setActionCommand("Back_Button");
        backButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)backButton, gridBagConstraints);
        JButton jButton = new JButton("", imageIcon);
        jButton.setPreferredSize(new Dimension(40, 30));
        jButton.setMinimumSize(new Dimension(40, 30));
        jButton.setActionCommand("Play_Button");
        jButton.addActionListener(this);
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton("", imageIcon2);
        jButton2.setPreferredSize(new Dimension(40, 30));
        jButton2.setMinimumSize(new Dimension(40, 30));
        jButton2.setActionCommand("Stop_Button");
        jButton2.addActionListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)jButton2, gridBagConstraints);
        forwardButton = new JButton("", imageIcon4);
        forwardButton.setPreferredSize(new Dimension(40, 30));
        forwardButton.setMinimumSize(new Dimension(40, 30));
        forwardButton.setActionCommand("Forward_Button");
        forwardButton.addActionListener(this);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)forwardButton, gridBagConstraints);
        fastForwardButton = new JButton("", imageIcon7);
        fastForwardButton.setPreferredSize(new Dimension(40, 30));
        fastForwardButton.setMinimumSize(new Dimension(40, 30));
        fastForwardButton.setActionCommand("Fast_Forward_Button");
        fastForwardButton.addActionListener(this);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)fastForwardButton, gridBagConstraints);
    }

    public JSlider getSlider() {
        return slider;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton && actionEvent.getActionCommand() == "Fast_Back_Button") {
            slider.setValue(1);
            this.refreshScreen(slider.getValue() - 1);
        } else if (actionEvent.getSource() instanceof JButton && actionEvent.getActionCommand() == "Fast_Forward_Button") {
            slider.setValue(slider.getMaximum());
            this.refreshScreen(slider.getValue() - 1);
        } else if (actionEvent.getSource() instanceof JButton && actionEvent.getActionCommand() == "Play_Button") {
            if (sliderTimer.isRunning()) {
                sliderTimer.stop();
            } else {
                sliderTimer.start();
            }
        } else if (actionEvent.getSource() instanceof JButton && actionEvent.getActionCommand() == "Stop_Button") {
            sliderTimer.stop();
            slider.setValue(0);
            this.refreshScreen(slider.getValue() - 1);
        } else if (actionEvent.getSource() instanceof JButton && actionEvent.getActionCommand() == "Forward_Button") {
            slider.setValue(slider.getValue() + 1);
            this.refreshScreen(slider.getValue() - 1);
        } else if (actionEvent.getSource() instanceof JButton && actionEvent.getActionCommand() == "Back_Button") {
            slider.setValue(slider.getValue() - 1);
            this.refreshScreen(slider.getValue() - 1);
        }
    }

    public void refreshScreen(int n) {
        dlist.getAbstractLinearGraphics().setDoubleBuffering(true);
        for (int i = 0; i <= dlist.getArrayViewer().getNumSlides(); ++i) {
            Map map = (Map)alg.getSlideToXPtrMap().get(new Integer(i));
            if (map == null) continue;
            for (String string : map.keySet()) {
                Vector vector = (Vector)dlist.getDataManager().getXPtrToGVTMapValue(string);
                if (vector == null) continue;
                int n2 = vector.size();
                for (int j = 0; j < n2; ++j) {
                    GraphicsNode graphicsNode = (GraphicsNode)vector.elementAt(j);
                    if (i == n) {
                        boolean bl = alg.getAnalysisMonitor().isMicroArrayElementPaintable(string, i);
                        if (!bl) {
                            graphicsNode.setDataVisibility(113);
                            continue;
                        }
                        graphicsNode.setDataVisibility(112);
                        continue;
                    }
                    graphicsNode.setDataVisibility(114);
                }
            }
        }
        dlist.refreshDisplay();
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        dlist = bluejayDObjectList;
    }

    public void setALG(AbstractLinearGraphics abstractLinearGraphics) {
        alg = abstractLinearGraphics;
    }

    public void setMicroArrayFunctions(MicroarrayFunctions microarrayFunctions) {
        microArrayFunctions = microarrayFunctions;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        dlist.getArrayViewer().setCurrentSlide(slider.getValue() - 1);
        this.refreshScreen(slider.getValue() - 1);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof JSlider) {
            if (slider.getValue() == 1) {
                backButton.setEnabled(false);
                fastBackButton.setEnabled(false);
            } else {
                backButton.setEnabled(true);
                fastBackButton.setEnabled(true);
            }
            if (slider.getValue() == slider.getMaximum()) {
                forwardButton.setEnabled(false);
                fastForwardButton.setEnabled(false);
            } else {
                forwardButton.setEnabled(true);
                fastForwardButton.setEnabled(true);
            }
        }
    }

    public void diableGUI() {
        slider.setEnabled(false);
        backButton.setEnabled(false);
        forwardButton.setEnabled(false);
        fastBackButton.setEnabled(false);
        fastForwardButton.setEnabled(false);
    }

    public void enableGUI(int n) {
        slider.setEnabled(true);
        slider.setMaximum(n);
        backButton.setEnabled(true);
        forwardButton.setEnabled(true);
        fastBackButton.setEnabled(true);
        fastForwardButton.setEnabled(true);
    }

    public void resetGUI() {
        slider.setValue(0);
    }
}

