/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.impl.BluejayDTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.comparison.ComparisonPool;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.painter.AGAVEPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.util.Debug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class AGAVERepeatPainter
extends AGAVEPainter {
    private LaneManager laneMgr;
    private boolean laneDrawn;

    public AGAVERepeatPainter(LaneManager laneManager) {
        this.laneMgr = laneManager;
    }

    public int getPriority() {
        return 60;
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        Object object;
        int n = dTDElementInstance.getTarget();
        if (n == -1) {
            System.err.println("Ooops.  parent of " + dTDElementInstance.getLocalName() + "was not a target");
            return;
        }
        Color color = abstractLinearGraphics.getColor();
        int n2 = ((BluejayDTDElementInstance)dTDElementInstance).getSlaveNum();
        double[] dArray = n2 != 0 ? this.laneMgr.getLane("slave_repeat" + Integer.toString(n2), abstractLinearGraphics.getLOD()) : this.laneMgr.getLane("AGAVE repeat lane", abstractLinearGraphics.getLOD());
        ComparisonPool comparisonPool = abstractLinearGraphics.getVisibilityManager().getDList().getComparisonPool();
        if (n2 != 0) {
            object = comparisonPool.getSeqsFromPool().elementAt(n2);
            if (!((Genome)object).isRepeatLaneDrawn() && dArray != null) {
                abstractLinearGraphics.setColor(Color.black);
                double d = (dArray[0] + dArray[1]) / 2.0;
                this.drawLaneLine(abstractLinearGraphics, n, d);
                ((Genome)object).setRepeatLaneDrawn(true);
            }
        } else if (!this.laneDrawn && dArray != null) {
            abstractLinearGraphics.setColor(Color.black);
            double d = (dArray[0] + dArray[1]) / 2.0;
            this.drawLaneLine(abstractLinearGraphics, n, d);
            this.laneDrawn = true;
        }
        object = abstractLinearGraphics.isInTextMode() ? this.getOrigFeatureRange(dTDElementInstance) : this.getFeatureRange(dTDElementInstance);
        boolean bl = object[1] < object[0];
        Object object2 = bl ? object[1] : object[0];
        Object object3 = bl ? object[0] : object[1];
        Color color2 = Color.green;
        String string = dTDElementInstance.getLocalName();
        abstractLinearGraphics.startHyperlink(dTDElementInstance, true);
        if (dArray != null) {
            abstractLinearGraphics.setColor(color2);
            abstractLinearGraphics.fillRect(n, (int)object2, (int)object3, dArray[0], dArray[1]);
            double d = dArray[0] > 0.0 ? dArray[0] : dArray[1];
            abstractLinearGraphics.updateHyperlink(abstractLinearGraphics.getPoint(n, (int)object2, d));
        }
        abstractLinearGraphics.endHyperlink();
        abstractLinearGraphics.setColor(color);
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        Object object;
        Object object2;
        Object object3;
        this.laneDrawn = false;
        ComparisonPool comparisonPool = abstractLinearGraphics.getVisibilityManager().getDList().getComparisonPool();
        if (ComparisonMenuManager.isComparison && comparisonPool.getPoolSize() > 1) {
            for (int i = 1; i < comparisonPool.getPoolSize(); ++i) {
                object3 = comparisonPool.getSeqsFromPool().elementAt(i);
                ((Genome)object3).setRepeatLaneDrawn(false);
            }
        }
        String string = null;
        object3 = null;
        for (object2 = dTDElementInstance.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
            if (!(object2 instanceof DTDElementInstance) || !((DTDElementInstance)object2).getLocalName().equals("seq_location")) continue;
            string = ((DTDElementInstance)object2).getAttribute("least_start");
            object3 = ((DTDElementInstance)object2).getAttribute("greatest_end");
        }
        if (string == null || string.length() == 0) {
            System.err.println("Cannot paint rna: attribute 'start' is missing");
            return;
        }
        if (object3 == null || string.length() == 0) {
            System.err.println("Cannot paint rna: attribute 'end' is missing");
            return;
        }
        object2 = Color.green;
        String string2 = dTDElementInstance.getLocalName();
        if (Debug.legend && abstractLinearGraphics.getLegend().isAddingItems()) {
            Image image = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
            object = image.getGraphics();
            ((Graphics)object).setColor((Color)object2);
            ((Graphics)object).fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
            abstractLinearGraphics.getLegend().addItem(image, string2, "//agave:repeat_region", dTDElementInstance.getXPointer(), (Color)object2);
        }
        int n = abstractLinearGraphics.getLOD();
        object = new String[]{"AGAVE repeat lane"};
        AGAVERepeatPainter.requestLanes(this.laneMgr, this, n, (String[])object);
        int n2 = abstractLinearGraphics.getVisibilityManager().getDList().getComparisonPool().getPoolSize();
        if (ComparisonMenuManager.isComparison && n2 > 1) {
            for (int i = 1; i < n2; ++i) {
                String[] stringArray = new String[]{"slave_repeat" + Integer.toString(i)};
                AGAVERepeatPainter.requestLanes(this.laneMgr, this, n, stringArray);
            }
        }
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        return dTDElementInstance.getLocalName();
    }
}

