/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.TargetAppearance;
import ca.ucalgary.bluejay.client.impl.BluejayDTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.painter.AGAVEPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.image.BufferedImage;

public class AGAVETranscriptPainter
extends AGAVEPainter {
    private static final Color transcriptColor = Color.red;
    private static final String DEFAULT_LEGEND_LABEL = "Transcript";
    private Polygon arrowHead;
    private Image legendImage;
    private LaneManager laneMgr;
    private boolean laneDrawn;

    public int getPriority() {
        return 60;
    }

    public AGAVETranscriptPainter(LaneManager laneManager) {
        this.laneMgr = laneManager;
        this.arrowHead = new Polygon();
        this.legendImage = new BufferedImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT, 1);
        Graphics graphics = this.legendImage.getGraphics();
        graphics.setColor(transcriptColor);
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        String string;
        int n = dTDElementInstance.getTarget();
        int n2 = abstractLinearGraphics.getLOD();
        if (n == -1) {
            System.err.println("Ooops.  parent of " + dTDElementInstance.getLocalName() + "was not a target");
            return;
        }
        int[] nArray = abstractLinearGraphics.isInTextMode() ? this.getOrigFeatureRange(dTDElementInstance) : this.getFeatureRange(dTDElementInstance);
        boolean bl = this.isFeatureComplemented(dTDElementInstance);
        int n3 = nArray[0];
        int n4 = nArray[1];
        boolean bl2 = ((TargetAppearance)abstractLinearGraphics.getTargetAppearances().elementAt(n)).isReverseComplement();
        Color color = abstractLinearGraphics.getColor();
        Object var11_11 = null;
        String string2 = DEFAULT_LEGEND_LABEL;
        double d = abstractLinearGraphics.getTarget(n).getScale();
        abstractLinearGraphics.setColor(transcriptColor);
        boolean bl3 = bl == bl2;
        int n5 = ((BluejayDTDElementInstance)dTDElementInstance).getSlaveNum();
        if (bl) {
            double[] dArray = ComparisonMenuManager.isComparison ? (n5 != 0 ? this.laneMgr.getLane("slave_negative_tr" + Integer.toString(n5), n2) : this.laneMgr.getLane("Negative transcript lane", n2)) : this.laneMgr.getLane("Negative transcript lane", n2, n3, n4);
            abstractLinearGraphics.drawRect(n, n4, n3, dArray[0], dArray[1]);
        } else {
            double[] dArray = ComparisonMenuManager.isComparison ? (n5 != 0 ? this.laneMgr.getLane("slave_positive_tr" + Integer.toString(n5), n2) : this.laneMgr.getLane("Positive transcript lane", n2)) : this.laneMgr.getLane("Positive transcript lane", n2, n3, n4);
            abstractLinearGraphics.drawRect(n, n3, n4, dArray[0], dArray[1]);
        }
        if (n2 >= 70 && (string = dTDElementInstance.getAttribute("label")) != null && string.length() != 0) {
            int n6;
            double[] dArray;
            if (bl3) {
                dArray = n5 != 0 ? this.laneMgr.getLane("slave_positive_tr_label" + Integer.toString(n5), n2) : this.laneMgr.getLane("Positive transcript label lane", n2);
                n6 = 30;
            } else {
                dArray = n5 != 0 ? this.laneMgr.getLane("slave_negative_tr_label" + Integer.toString(n5), n2) : this.laneMgr.getLane("Negative transcript label lane", n2);
                n6 = 40;
            }
            abstractLinearGraphics.drawString(n, string, null, (n3 + n4) / 2, dArray[0], dArray[1], n6);
        }
        abstractLinearGraphics.setColor(color);
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        int n = abstractLinearGraphics.getLOD();
        int[] nArray = abstractLinearGraphics.isInTextMode() ? this.getOrigFeatureRange(dTDElementInstance) : this.getFeatureRange(dTDElementInstance);
        boolean bl = this.isFeatureComplemented(dTDElementInstance);
        int n2 = ((BluejayDTDElementInstance)dTDElementInstance).getSlaveNum();
        if (n >= 70) {
            if (bl) {
                if (n2 != 0) {
                    if (this.laneMgr.getLane("slave_negative_tr_label" + Integer.toString(n2)) == null) {
                        this.laneMgr.addLane("slave_negative_tr_label" + Integer.toString(n2), n, AGAVETranscriptPainter.getLane(n, "slave_negative_tr_label" + Integer.toString(n2)));
                    }
                } else if (this.laneMgr.getLane("Negative transcript label lane") == null) {
                    this.laneMgr.addLane("Negative transcript label lane", n, AGAVETranscriptPainter.getLane(n, "Negative transcript label lane"));
                }
            } else if (n2 != 0) {
                if (this.laneMgr.getLane("slave_positive_tr_label" + Integer.toString(n2)) == null) {
                    this.laneMgr.addLane("slave_positive_tr_label" + Integer.toString(n2), n, AGAVETranscriptPainter.getLane(n, "slave_positive_tr_label" + Integer.toString(n2)));
                }
            } else if (this.laneMgr.getLane("Positive transcript label lane") == null) {
                this.laneMgr.addLane("Positive transcript label lane", n, AGAVETranscriptPainter.getLane(n, "Positive transcript label lane"));
            }
        }
        if (bl) {
            if (ComparisonMenuManager.isComparison) {
                String string = n2 != 0 ? "slave_negative_tr" + Integer.toString(n2) : "Negative transcript lane";
                String[] stringArray = new String[]{string};
                AGAVETranscriptPainter.requestLanes(this.laneMgr, this, n, stringArray);
            } else {
                this.laneMgr.addLane("Negative transcript lane", n, AGAVETranscriptPainter.getLane(n, "Negative transcript lane"), nArray[0], nArray[1]);
            }
        } else if (ComparisonMenuManager.isComparison) {
            String string = n2 != 0 ? "slave_positive_tr" + Integer.toString(n2) : "Positive transcript lane";
            String[] stringArray = new String[]{string};
            AGAVETranscriptPainter.requestLanes(this.laneMgr, this, n, stringArray);
        } else {
            this.laneMgr.addLane("Positive transcript lane", n, AGAVETranscriptPainter.getLane(n, "Positive transcript lane"), nArray[0], nArray[1]);
        }
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        return DEFAULT_LEGEND_LABEL;
    }
}

